/*
 * ambhw/crypto.h
 *
 * History:
 *	2009/02/27 - [Jack Huang] created file
 *
 * Copyright (C) 2006-2007, Ambarella, Inc.
 */

#ifndef __AMBHW__CRYPT_H__
#define __AMBHW__CRYPT_H__

#include <asm/arch/ambhw/chip.h>
#include <asm/arch/ambhw/busaddr.h>

/****************************************************/
/* Capabilities based on chip revision              */
/****************************************************/
#if (CHIP_REV == A7)
#define	CRYPT_SUPPORT_NON_BINARY	1
#define CRYPT_SUPPORT_MD5_SHA1		1
#define CRYPT_NO_OP_MODE		1
#define CRYPT_BYTE_SWAP			0
#elif (CHIP_REV == I1)
#define	CRYPT_SUPPORT_NON_BINARY	0
#define CRYPT_SUPPORT_MD5_SHA1		1
#define CRYPT_NO_OP_MODE		1
#define CRYPT_BYTE_SWAP			1
#else
#define	CRYPT_SUPPORT_NON_BINARY	0
#define CRYPT_SUPPORT_MD5_SHA1		0
#define CRYPT_NO_OP_MODE		0
#define CRYPT_BYTE_SWAP			0
#endif

/****************************************************/
/* Controller registers definitions                 */
/****************************************************/

#if (CRYPT_SUPPORT_NON_BINARY == 1)
#if (CHIP_REV == A7)
#define DES_OFFSET(x)			(x << 2)
#define AES_OFFSET(x)			((1 << 9) | (x << 2))
#define SHA1_MD5_OFFSET(x)		((2 << 9) | (x << 2))
#define BINARY_COMP_OFFSET(x)		((7 << 9) | (x << 2))

#define DES_REG(x)			CRYPT_UNIT_REG(DES_OFFSET(x))
#define AES_REG(x)			CRYPT_UNIT_REG(AES_OFFSET(x))
#define SHA1_MD5_REG(x)			CRYPT_UNIT_REG(SHA1_MD5_OFFSET(x))
#define BINARY_COMP_REG(x)		CRYPT_UNIT_REG(BINARY_COMP_OFFSET(x))
#endif
#else /* (CRYPT_SUPPORT_NON_BINARY == 0)*/
#if (CHIP_REV == I1)
#define DES_OFFSET(x)			(x)
#define AES_OFFSET(x)			((1 << 9) | (x))
#define SHA1_MD5_OFFSET(x)		((2 << 9) | (x))

#define DES_REG(x)			CRYPT_UNIT_REG(DES_OFFSET(x))
#define AES_REG(x)			CRYPT_UNIT_REG(AES_OFFSET(x))
#define SHA1_MD5_REG(x)			CRYPT_UNIT_REG(SHA1_MD5_OFFSET(x))
#define BINARY_COMP_REG(x)		CRYPT_UNIT_REG(BINARY_COMP_OFFSET(x))
#endif
#endif /* (CRYPT_SUPPORT_NON_BINARY == 0)*/

#if (CRYPT_SUPPORT_NON_BINARY == 0)
#if (CHIP_REV == I1)
#define CRYPT_D_HI_OFFSET			0x00
#define CRYPT_D_LO_OFFSET			0x04
#define CRYPT_D_INPUT_ENC_HI_OFFSET		0x08
#define CRYPT_D_INPUT_ENC_LO_OFFSET		0x0c
#define CRYPT_D_INPUT_DEC_HI_OFFSET		0x10
#define CRYPT_D_INPUT_DEC_LO_OFFSET		0x14
#define CRYPT_D_OUTPUT_HI_OFFSET		0x18
#define CRYPT_D_OUTPUT_LO_OFFSET		0x1c
#define CRYPT_D_OUTPUT_READY_OFFSET		0x20
#define CRYPT_D_INT_EN_OFFSET			0x28

#define CRYPT_A_256_224_OFFSET			0x00
#define CRYPT_A_256_192_OFFSET			0x04
#define CRYPT_A_256_160_OFFSET			0x08
#define CRYPT_A_256_128_OFFSET			0x0c
#define CRYPT_A_256_96_OFFSET			0x10
#define CRYPT_A_256_64_OFFSET			0x14
#define CRYPT_A_256_32_OFFSET			0x18
#define CRYPT_A_256_0_OFFSET			0x1c
#define CRYPT_A_192_160_OFFSET			0x20
#define CRYPT_A_192_128_OFFSET			0x24
#define CRYPT_A_192_96_OFFSET			0x28
#define CRYPT_A_192_64_OFFSET			0x2c
#define CRYPT_A_192_32_OFFSET			0x30
#define CRYPT_A_192_0_OFFSET			0x34
#define CRYPT_A_128_96_OFFSET			0x38
#define CRYPT_A_128_64_OFFSET			0x3c
#define CRYPT_A_128_32_OFFSET			0x40
#define CRYPT_A_128_0_OFFSET			0x44

#define CRYPT_A_INPUT_ENC_96_OFFSET		0x48
#define CRYPT_A_INPUT_ENC_64_OFFSET		0x4c
#define CRYPT_A_INPUT_ENC_32_OFFSET		0x50
#define CRYPT_A_INPUT_ENC_0_OFFSET		0x54
#define CRYPT_A_INPUT_DEC_96_OFFSET		0x58
#define CRYPT_A_INPUT_DEC_64_OFFSET		0x5c
#define CRYPT_A_INPUT_DEC_32_OFFSET		0x60
#define CRYPT_A_INPUT_DEC_0_OFFSET		0x64
#define CRYPT_A_OUTPUT_96_OFFSET		0x68
#define CRYPT_A_OUTPUT_64_OFFSET		0x6c
#define CRYPT_A_OUTPUT_32_OFFSET		0x70
#define CRYPT_A_OUTPUT_0_OFFSET			0x74
#define CRYPT_A_OUTPUT_READY_OFFSET		0x78
#define CRYPT_A_INT_EN_OFFSET			0x80

#define CRYPT_D_HI_REG				DES_REG(0x00)
#define CRYPT_D_LO_REG				DES_REG(0x04)
#define CRYPT_D_INPUT_ENC_HI_REG		DES_REG(0x08)
#define CRYPT_D_INPUT_ENC_LO_REG		DES_REG(0x0c)
#define CRYPT_D_INPUT_DEC_HI_REG		DES_REG(0x10)
#define CRYPT_D_INPUT_DEC_LO_REG		DES_REG(0x14)
#define CRYPT_D_OUTPUT_HI_REG			DES_REG(0x18)
#define CRYPT_D_OUTPUT_LO_REG			DES_REG(0x1c)
#define CRYPT_D_OUTPUT_READY_REG		DES_REG(0x20)
#define CRYPT_D_INT_EN_REG			DES_REG(0x28)

#define CRYPT_A_256_224_REG			AES_REG(0x00)
#define CRYPT_A_256_192_REG			AES_REG(0x04)
#define CRYPT_A_256_160_REG			AES_REG(0x08)
#define CRYPT_A_256_128_REG			AES_REG(0x0c)
#define CRYPT_A_256_96_REG			AES_REG(0x10)
#define CRYPT_A_256_64_REG			AES_REG(0x14)
#define CRYPT_A_256_32_REG			AES_REG(0x18)
#define CRYPT_A_256_0_REG			AES_REG(0x1c)
#define CRYPT_A_192_160_REG			AES_REG(0x20)
#define CRYPT_A_192_128_REG			AES_REG(0x24)
#define CRYPT_A_192_96_REG			AES_REG(0x28)
#define CRYPT_A_192_64_REG			AES_REG(0x2c)
#define CRYPT_A_192_32_REG			AES_REG(0x30)
#define CRYPT_A_192_0_REG			AES_REG(0x34)
#define CRYPT_A_128_96_REG			AES_REG(0x38)
#define CRYPT_A_128_64_REG			AES_REG(0x3c)
#define CRYPT_A_128_32_REG			AES_REG(0x40)
#define CRYPT_A_128_0_REG			AES_REG(0x44)

#define CRYPT_A_INPUT_ENC_96_REG		AES_REG(0x48)
#define CRYPT_A_INPUT_ENC_64_REG		AES_REG(0x4c)
#define CRYPT_A_INPUT_ENC_32_REG		AES_REG(0x50)
#define CRYPT_A_INPUT_ENC_0_REG			AES_REG(0x54)
#define CRYPT_A_INPUT_DEC_96_REG		AES_REG(0x58)
#define CRYPT_A_INPUT_DEC_64_REG		AES_REG(0x5c)
#define CRYPT_A_INPUT_DEC_32_REG		AES_REG(0x60)
#define CRYPT_A_INPUT_DEC_0_REG			AES_REG(0x64)
#define CRYPT_A_OUTPUT_96_REG			AES_REG(0x68)
#define CRYPT_A_OUTPUT_64_REG			AES_REG(0x6c)
#define CRYPT_A_OUTPUT_32_REG			AES_REG(0x70)
#define CRYPT_A_OUTPUT_0_REG			AES_REG(0x74)
#define CRYPT_A_OUTPUT_READY_REG		AES_REG(0x78)
#define CRYPT_A_INT_EN_REG			AES_REG(0x80)

#else	//#if (CHIP_REV != I1)
#define CRYPT_D_HI_OFFSET			0x00
#define CRYPT_D_LO_OFFSET			0x04
#define CRYPT_D_INPUT_HI_OFFSET			0x08
#define CRYPT_D_INPUT_LO_OFFSET			0x0c
#define CRYPT_D_OPCODE_OFFSET			0x10
#define CRYPT_D_OUTPUT_READY_OFFSET		0x14
#define CRYPT_D_OUTPUT_HI_OFFSET		0x18
#define CRYPT_D_OUTPUT_LO_OFFSET		0x1c
#define CRYPT_D_INT_EN_OFFSET			0x20
#define CRYPT_A_128_96_OFFSET			0x24
#define CRYPT_A_128_64_OFFSET			0x28
#define CRYPT_A_128_32_OFFSET			0x2c
#define CRYPT_A_128_0_OFFSET			0x30
#define CRYPT_A_192_160_OFFSET			0x34
#define CRYPT_A_192_128_OFFSET			0x38
#define CRYPT_A_192_96_OFFSET			0x3c
#define CRYPT_A_192_64_OFFSET			0x40
#define CRYPT_A_192_32_OFFSET			0x44
#define CRYPT_A_192_0_OFFSET			0x48
#define CRYPT_A_256_224_OFFSET			0x4c
#define CRYPT_A_256_192_OFFSET			0x50
#define CRYPT_A_256_160_OFFSET			0x54
#define CRYPT_A_256_128_OFFSET			0x58
#define CRYPT_A_256_96_OFFSET			0x5c
#define CRYPT_A_256_64_OFFSET			0x60
#define CRYPT_A_256_32_OFFSET			0x64
#define CRYPT_A_256_0_OFFSET			0x68
#define CRYPT_A_INPUT_96_OFFSET			0x6c
#define CRYPT_A_INPUT_64_OFFSET			0x70
#define CRYPT_A_INPUT_32_OFFSET			0x74
#define CRYPT_A_INPUT_0_OFFSET			0x78
#define CRYPT_A_OPCODE_OFFSET			0x7c
#define CRYPT_A_OUTPUT_READY_OFFSET		0x80
#define CRYPT_A_OUTPUT_96_OFFSET		0x84
#define CRYPT_A_OUTPUT_64_OFFSET		0x88
#define CRYPT_A_OUTPUT_32_OFFSET		0x8c
#define CRYPT_A_OUTPUT_0_OFFSET			0x90
#define CRYPT_A_INT_EN_OFFSET			0x94

#define CRYPT_D_HI_REG				CRYPT_UNIT_REG(0x00)
#define CRYPT_D_LO_REG				CRYPT_UNIT_REG(0x04)
#define CRYPT_D_INPUT_HI_REG			CRYPT_UNIT_REG(0x08)
#define CRYPT_D_INPUT_LO_REG			CRYPT_UNIT_REG(0x0c)
#define CRYPT_D_OPCODE_REG			CRYPT_UNIT_REG(0x10)
#define CRYPT_D_OUTPUT_READY_REG		CRYPT_UNIT_REG(0x14)
#define CRYPT_D_OUTPUT_HI_REG			CRYPT_UNIT_REG(0x18)
#define CRYPT_D_OUTPUT_LO_REG			CRYPT_UNIT_REG(0x1c)
#define CRYPT_D_INT_EN_REG			CRYPT_UNIT_REG(0x20)
#define CRYPT_A_128_96_REG			CRYPT_UNIT_REG(0x24)
#define CRYPT_A_128_64_REG			CRYPT_UNIT_REG(0x28)
#define CRYPT_A_128_32_REG			CRYPT_UNIT_REG(0x2c)
#define CRYPT_A_128_0_REG			CRYPT_UNIT_REG(0x30)
#define CRYPT_A_192_160_REG			CRYPT_UNIT_REG(0x34)
#define CRYPT_A_192_128_REG			CRYPT_UNIT_REG(0x38)
#define CRYPT_A_192_96_REG			CRYPT_UNIT_REG(0x3c)
#define CRYPT_A_192_64_REG			CRYPT_UNIT_REG(0x40)
#define CRYPT_A_192_32_REG			CRYPT_UNIT_REG(0x44)
#define CRYPT_A_192_0_REG			CRYPT_UNIT_REG(0x48)
#define CRYPT_A_256_224_REG			CRYPT_UNIT_REG(0x4c)
#define CRYPT_A_256_192_REG			CRYPT_UNIT_REG(0x50)
#define CRYPT_A_256_160_REG			CRYPT_UNIT_REG(0x54)
#define CRYPT_A_256_128_REG			CRYPT_UNIT_REG(0x58)
#define CRYPT_A_256_96_REG			CRYPT_UNIT_REG(0x5c)
#define CRYPT_A_256_64_REG			CRYPT_UNIT_REG(0x60)
#define CRYPT_A_256_32_REG			CRYPT_UNIT_REG(0x64)
#define CRYPT_A_256_0_REG			CRYPT_UNIT_REG(0x68)
#define CRYPT_A_INPUT_96_REG			CRYPT_UNIT_REG(0x6c)
#define CRYPT_A_INPUT_64_REG			CRYPT_UNIT_REG(0x70)
#define CRYPT_A_INPUT_32_REG			CRYPT_UNIT_REG(0x74)
#define CRYPT_A_INPUT_0_REG			CRYPT_UNIT_REG(0x78)
#define CRYPT_A_OPCODE_REG			CRYPT_UNIT_REG(0x7c)
#define CRYPT_A_OUTPUT_READY_REG		CRYPT_UNIT_REG(0x80)
#define CRYPT_A_OUTPUT_96_REG			CRYPT_UNIT_REG(0x84)
#define CRYPT_A_OUTPUT_64_REG			CRYPT_UNIT_REG(0x88)
#define CRYPT_A_OUTPUT_32_REG			CRYPT_UNIT_REG(0x8c)
#define CRYPT_A_OUTPUT_0_REG			CRYPT_UNIT_REG(0x90)
#define CRYPT_A_INT_EN_REG			CRYPT_UNIT_REG(0x94)
#endif	//#if (CHIP_REV != I1)
#elif (CRYPT_SUPPORT_NON_BINARY == 1)

#define CRYPT_D_HI_OFFSET			0x00
#define CRYPT_D_LO_OFFSET			0x01
#define CRYPT_D_INPUT_ENC_HI_OFFSET		0x02
#define CRYPT_D_INPUT_ENC_LO_OFFSET		0x03
#define CRYPT_D_INPUT_DEC_HI_OFFSET		0x04
#define CRYPT_D_INPUT_DEC_LO_OFFSET		0x05
#define CRYPT_D_OUTPUT_HI_OFFSET		0x06
#define CRYPT_D_OUTPUT_LO_OFFSET		0x07
#define CRYPT_D_OUTPUT_READY_OFFSET		0x08
#define CRYPT_D_INT_EN_OFFSET			0x09
#define CRYPT_A_256_224_OFFSET			0x00
#define CRYPT_A_256_192_OFFSET			0x01
#define CRYPT_A_256_160_OFFSET			0x02
#define CRYPT_A_256_128_OFFSET			0x03
#define CRYPT_A_256_96_OFFSET			0x04
#define CRYPT_A_256_64_OFFSET			0x05
#define CRYPT_A_256_32_OFFSET			0x06
#define CRYPT_A_256_0_OFFSET			0x07
#define CRYPT_A_192_160_OFFSET			0x08
#define CRYPT_A_192_128_OFFSET			0x09
#define CRYPT_A_192_96_OFFSET			0x0a
#define CRYPT_A_192_64_OFFSET			0x0b
#define CRYPT_A_192_32_OFFSET			0x0c
#define CRYPT_A_192_0_OFFSET			0x0d
#define CRYPT_A_128_96_OFFSET			0x0e
#define CRYPT_A_128_64_OFFSET			0x0f
#define CRYPT_A_128_32_OFFSET			0x10
#define CRYPT_A_128_0_OFFSET			0x11
#define CRYPT_A_INPUT_ENC_96_OFFSET		0x12
#define CRYPT_A_INPUT_ENC_64_OFFSET		0x13
#define CRYPT_A_INPUT_ENC_32_OFFSET		0x14
#define CRYPT_A_INPUT_ENC_0_OFFSET		0x15
#define CRYPT_A_INPUT_DEC_96_OFFSET		0x16
#define CRYPT_A_INPUT_DEC_64_OFFSET		0x17
#define CRYPT_A_INPUT_DEC_32_OFFSET		0x18
#define CRYPT_A_INPUT_DEC_0_OFFSET		0x19
#define CRYPT_A_OUTPUT_96_OFFSET		0x1a
#define CRYPT_A_OUTPUT_64_OFFSET		0x1b
#define CRYPT_A_OUTPUT_32_OFFSET		0x1c
#define CRYPT_A_OUTPUT_0_OFFSET			0x1d
#define CRYPT_A_OUTPUT_READY_OFFSET		0x1e
#define CRYPT_A_INT_EN_OFFSET			0x1f

#define CRYPT_D_HI_REG				DES_REG(0x00)
#define CRYPT_D_LO_REG				DES_REG(0x01)
#define CRYPT_D_INPUT_ENC_HI_REG		DES_REG(0x02)
#define CRYPT_D_INPUT_ENC_LO_REG		DES_REG(0x03)
#define CRYPT_D_INPUT_DEC_HI_REG		DES_REG(0x04)
#define CRYPT_D_INPUT_DEC_LO_REG		DES_REG(0x05)
#define CRYPT_D_OUTPUT_HI_REG			DES_REG(0x06)
#define CRYPT_D_OUTPUT_LO_REG			DES_REG(0x07)
#define CRYPT_D_OUTPUT_READY_REG		DES_REG(0x08)
#define CRYPT_D_INT_EN_REG			DES_REG(0x09)
#define CRYPT_A_256_224_REG			AES_REG(0x00)
#define CRYPT_A_256_192_REG			AES_REG(0x01)
#define CRYPT_A_256_160_REG			AES_REG(0x02)
#define CRYPT_A_256_128_REG			AES_REG(0x03)
#define CRYPT_A_256_96_REG			AES_REG(0x04)
#define CRYPT_A_256_64_REG			AES_REG(0x05)
#define CRYPT_A_256_32_REG			AES_REG(0x06)
#define CRYPT_A_256_0_REG			AES_REG(0x07)
#define CRYPT_A_192_160_REG			AES_REG(0x08)
#define CRYPT_A_192_128_REG			AES_REG(0x09)
#define CRYPT_A_192_96_REG			AES_REG(0x0a)
#define CRYPT_A_192_64_REG			AES_REG(0x0b)
#define CRYPT_A_192_32_REG			AES_REG(0x0c)
#define CRYPT_A_192_0_REG			AES_REG(0x0d)
#define CRYPT_A_128_96_REG			AES_REG(0x0e)
#define CRYPT_A_128_64_REG			AES_REG(0x0f)
#define CRYPT_A_128_32_REG			AES_REG(0x10)
#define CRYPT_A_128_0_REG			AES_REG(0x11)
#define CRYPT_A_INPUT_ENC_96_REG		AES_REG(0x12)
#define CRYPT_A_INPUT_ENC_64_REG		AES_REG(0x13)
#define CRYPT_A_INPUT_ENC_32_REG		AES_REG(0x14)
#define CRYPT_A_INPUT_ENC_0_REG			AES_REG(0x15)
#define CRYPT_A_INPUT_DEC_96_REG		AES_REG(0x16)
#define CRYPT_A_INPUT_DEC_64_REG		AES_REG(0x17)
#define CRYPT_A_INPUT_DEC_32_REG		AES_REG(0x18)
#define CRYPT_A_INPUT_DEC_0_REG			AES_REG(0x19)
#define CRYPT_A_OUTPUT_96_REG			AES_REG(0x1a)
#define CRYPT_A_OUTPUT_64_REG			AES_REG(0x1b)
#define CRYPT_A_OUTPUT_32_REG			AES_REG(0x1c)
#define CRYPT_A_OUTPUT_0_REG			AES_REG(0x1d)
#define CRYPT_A_OUTPUT_READY_REG		AES_REG(0x1e)
#define CRYPT_A_INT_EN_REG			AES_REG(0x1f)

#endif


#if (CRYPT_SUPPORT_MD5_SHA1 == 1)
#if (CHIP_REV == A7)
#define CRYPT_SHA1_INIT_31_0_OFFSET		SHA1_MD5_OFFSET(0x0)
#define CRYPT_SHA1_INIT_63_32_OFFSET		SHA1_MD5_OFFSET(0x1)
#define CRYPT_SHA1_INIT_95_64_OFFSET		SHA1_MD5_OFFSET(0x2)
#define CRYPT_SHA1_INIT_127_96_OFFSET		SHA1_MD5_OFFSET(0x3)
#define CRYPT_SHA1_INIT_159_128_OFFSET		SHA1_MD5_OFFSET(0x4)
#define CRYPT_SHA1_INPUT_31_0_OFFSET		SHA1_MD5_OFFSET(0x5)
#define CRYPT_SHA1_INPUT_63_32_OFFSET		SHA1_MD5_OFFSET(0x6)
#define CRYPT_SHA1_INPUT_95_64_OFFSET		SHA1_MD5_OFFSET(0x7)
#define CRYPT_SHA1_INPUT_127_96_OFFSET		SHA1_MD5_OFFSET(0x8)
#define CRYPT_SHA1_INPUT_159_128_OFFSET		SHA1_MD5_OFFSET(0x9)
#define CRYPT_SHA1_INPUT_191_160_OFFSET		SHA1_MD5_OFFSET(0xa)
#define CRYPT_SHA1_INPUT_223_192_OFFSET		SHA1_MD5_OFFSET(0xb)
#define CRYPT_SHA1_INPUT_255_224_OFFSET		SHA1_MD5_OFFSET(0xc)
#define CRYPT_SHA1_INPUT_287_256_OFFSET		SHA1_MD5_OFFSET(0xd)
#define CRYPT_SHA1_INPUT_319_288_OFFSET		SHA1_MD5_OFFSET(0xe)
#define CRYPT_SHA1_INPUT_351_320_OFFSET		SHA1_MD5_OFFSET(0xf)
#define CRYPT_SHA1_INPUT_383_352_OFFSET		SHA1_MD5_OFFSET(0x10)
#define CRYPT_SHA1_INPUT_415_384_OFFSET		SHA1_MD5_OFFSET(0x11)
#define CRYPT_SHA1_INPUT_447_416_OFFSET		SHA1_MD5_OFFSET(0x12)
#define CRYPT_SHA1_INPUT_479_448_OFFSET		SHA1_MD5_OFFSET(0x13)
#define CRYPT_SHA1_INPUT_511_480_OFFSET		SHA1_MD5_OFFSET(0x14)
#define CRYPT_SHA1_OUTPUT_31_0_OFFSET		SHA1_MD5_OFFSET(0x15)
#define CRYPT_SHA1_OUTPUT_63_32_OFFSET		SHA1_MD5_OFFSET(0x16)
#define CRYPT_SHA1_OUTPUT_95_64_OFFSET		SHA1_MD5_OFFSET(0x17)
#define CRYPT_SHA1_OUTPUT_127_96_OFFSET		SHA1_MD5_OFFSET(0x18)
#define CRYPT_SHA1_OUTPUT_159_128_OFFSET	SHA1_MD5_OFFSET(0x19)
#define CRYPT_SHA1_OUTPUT_READY_OFFSET		SHA1_MD5_OFFSET(0x1a)
#define CRYPT_SHA1_INT_EN_OFFSET		SHA1_MD5_OFFSET(0x1b)

#define CRYPT_MD5_INIT_31_0_OFFSET		SHA1_MD5_OFFSET(0x20)
#define CRYPT_MD5_INIT_63_32_OFFSET		SHA1_MD5_OFFSET(0x21)
#define CRYPT_MD5_INIT_95_64_OFFSET		SHA1_MD5_OFFSET(0x22)
#define CRYPT_MD5_INIT_127_96_OFFSET		SHA1_MD5_OFFSET(0x23)
#define CRYPT_MD5_INPUT_31_0_OFFSET		SHA1_MD5_OFFSET(0x24)
#define CRYPT_MD5_INPUT_63_32_OFFSET		SHA1_MD5_OFFSET(0x25)
#define CRYPT_MD5_INPUT_95_64_OFFSET		SHA1_MD5_OFFSET(0x26)
#define CRYPT_MD5_INPUT_127_96_OFFSET		SHA1_MD5_OFFSET(0x27)
#define CRYPT_MD5_INPUT_159_128_OFFSET		SHA1_MD5_OFFSET(0x28)
#define CRYPT_MD5_INPUT_191_160_OFFSET		SHA1_MD5_OFFSET(0x29)
#define CRYPT_MD5_INPUT_223_192_OFFSET		SHA1_MD5_OFFSET(0x2a)
#define CRYPT_MD5_INPUT_255_224_OFFSET		SHA1_MD5_OFFSET(0x2b)
#define CRYPT_MD5_INPUT_287_256_OFFSET		SHA1_MD5_OFFSET(0x2c)
#define CRYPT_MD5_INPUT_319_288_OFFSET		SHA1_MD5_OFFSET(0x2d)
#define CRYPT_MD5_INPUT_351_320_OFFSET		SHA1_MD5_OFFSET(0x2e)
#define CRYPT_MD5_INPUT_383_352_OFFSET		SHA1_MD5_OFFSET(0x2f)
#define CRYPT_MD5_INPUT_415_384_OFFSET		SHA1_MD5_OFFSET(0x30)
#define CRYPT_MD5_INPUT_447_416_OFFSET		SHA1_MD5_OFFSET(0x31)
#define CRYPT_MD5_INPUT_479_448_OFFSET		SHA1_MD5_OFFSET(0x32)
#define CRYPT_MD5_INPUT_511_480_OFFSET		SHA1_MD5_OFFSET(0x33)
#define CRYPT_MD5_OUTPUT_31_0_OFFSET		SHA1_MD5_OFFSET(0x34)
#define CRYPT_MD5_OUTPUT_63_32_OFFSET		SHA1_MD5_OFFSET(0x35)
#define CRYPT_MD5_OUTPUT_95_64_OFFSET		SHA1_MD5_OFFSET(0x36)
#define CRYPT_MD5_OUTPUT_127_96_OFFSET		SHA1_MD5_OFFSET(0x37)
#define CRYPT_MD5_OUTPUT_READY_OFFSET		SHA1_MD5_OFFSET(0x38)
#define CRYPT_MD5_INT_EN_OFFSET			SHA1_MD5_OFFSET(0x39)
#define CRYPT_MD5_SHA1_READY_INPUT_OFFSET	SHA1_MD5_OFFSET(0x3a)
#define CRYPT_BINARY_COMP_OFFSET		BINARY_COMP_OFFSET(0x7f)

#define CRYPT_SHA1_INIT_31_0_REG		SHA1_MD5_REG(0x0)
#define CRYPT_SHA1_INIT_63_32_REG		SHA1_MD5_REG(0x1)
#define CRYPT_SHA1_INIT_95_64_REG		SHA1_MD5_REG(0x2)
#define CRYPT_SHA1_INIT_127_96_REG		SHA1_MD5_REG(0x3)
#define CRYPT_SHA1_INIT_159_128_REG		SHA1_MD5_REG(0x4)
#define CRYPT_SHA1_INPUT_31_0_REG		SHA1_MD5_REG(0x5)
#define CRYPT_SHA1_INPUT_63_32_REG		SHA1_MD5_REG(0x6)
#define CRYPT_SHA1_INPUT_95_64_REG		SHA1_MD5_REG(0x7)
#define CRYPT_SHA1_INPUT_127_96_REG		SHA1_MD5_REG(0x8)
#define CRYPT_SHA1_INPUT_159_128_REG		SHA1_MD5_REG(0x9)
#define CRYPT_SHA1_INPUT_191_160_REG		SHA1_MD5_REG(0xa)
#define CRYPT_SHA1_INPUT_223_192_REG		SHA1_MD5_REG(0xb)
#define CRYPT_SHA1_INPUT_255_224_REG		SHA1_MD5_REG(0xc)
#define CRYPT_SHA1_INPUT_287_256_REG		SHA1_MD5_REG(0xd)
#define CRYPT_SHA1_INPUT_319_288_REG		SHA1_MD5_REG(0xe)
#define CRYPT_SHA1_INPUT_351_320_REG		SHA1_MD5_REG(0xf)
#define CRYPT_SHA1_INPUT_383_352_REG		SHA1_MD5_REG(0x10)
#define CRYPT_SHA1_INPUT_415_384_REG		SHA1_MD5_REG(0x11)
#define CRYPT_SHA1_INPUT_447_416_REG		SHA1_MD5_REG(0x12)
#define CRYPT_SHA1_INPUT_479_448_REG		SHA1_MD5_REG(0x13)
#define CRYPT_SHA1_INPUT_511_480_REG		SHA1_MD5_REG(0x14)
#define CRYPT_SHA1_OUTPUT_31_0_REG		SHA1_MD5_REG(0x15)
#define CRYPT_SHA1_OUTPUT_63_32_REG		SHA1_MD5_REG(0x16)
#define CRYPT_SHA1_OUTPUT_95_64_REG		SHA1_MD5_REG(0x17)
#define CRYPT_SHA1_OUTPUT_127_96_REG		SHA1_MD5_REG(0x18)
#define CRYPT_SHA1_OUTPUT_159_128_REG		SHA1_MD5_REG(0x19)
#define CRYPT_SHA1_OUTPUT_READY_REG		SHA1_MD5_REG(0x1a)
#define CRYPT_SHA1_INT_EN_REG			SHA1_MD5_REG(0x1b)
#define CRYPT_MD5_INIT_31_0_REG			SHA1_MD5_REG(0x20)
#define CRYPT_MD5_INIT_63_32_REG		SHA1_MD5_REG(0x21)
#define CRYPT_MD5_INIT_95_64_REG		SHA1_MD5_REG(0x22)
#define CRYPT_MD5_INIT_127_96_REG		SHA1_MD5_REG(0x23)
#define CRYPT_MD5_INPUT_31_0_REG		SHA1_MD5_REG(0x24)
#define CRYPT_MD5_INPUT_63_32_REG		SHA1_MD5_REG(0x25)
#define CRYPT_MD5_INPUT_95_64_REG		SHA1_MD5_REG(0x26)
#define CRYPT_MD5_INPUT_127_96_REG		SHA1_MD5_REG(0x27)
#define CRYPT_MD5_INPUT_159_128_REG		SHA1_MD5_REG(0x28)
#define CRYPT_MD5_INPUT_191_160_REG		SHA1_MD5_REG(0x29)
#define CRYPT_MD5_INPUT_223_192_REG		SHA1_MD5_REG(0x2a)
#define CRYPT_MD5_INPUT_255_224_REG		SHA1_MD5_REG(0x2b)
#define CRYPT_MD5_INPUT_287_256_REG		SHA1_MD5_REG(0x2c)
#define CRYPT_MD5_INPUT_319_288_REG		SHA1_MD5_REG(0x2d)
#define CRYPT_MD5_INPUT_351_320_REG		SHA1_MD5_REG(0x2e)
#define CRYPT_MD5_INPUT_383_352_REG		SHA1_MD5_REG(0x2f)
#define CRYPT_MD5_INPUT_415_384_REG		SHA1_MD5_REG(0x30)
#define CRYPT_MD5_INPUT_447_416_REG		SHA1_MD5_REG(0x31)
#define CRYPT_MD5_INPUT_479_448_REG		SHA1_MD5_REG(0x32)
#define CRYPT_MD5_INPUT_511_480_REG		SHA1_MD5_REG(0x33)
#define CRYPT_MD5_OUTPUT_31_0_REG		SHA1_MD5_REG(0x34)
#define CRYPT_MD5_OUTPUT_63_32_REG		SHA1_MD5_REG(0x35)
#define CRYPT_MD5_OUTPUT_95_64_REG		SHA1_MD5_REG(0x36)
#define CRYPT_MD5_OUTPUT_127_96_REG		SHA1_MD5_REG(0x37)
#define CRYPT_MD5_OUTPUT_READY_REG		SHA1_MD5_REG(0x38)
#define CRYPT_MD5_INT_EN_REG			SHA1_MD5_REG(0x39)
#define CRYPT_MD5_SHA1_READY_INPUT_REG		SHA1_MD5_REG(0x3a)
#define CRYPT_BINARY_COMP_REG			BINARY_COMP_REG(0x7f)
#endif

#if (CHIP_REV == I1)
#define CRYPT_SHA1_INIT_31_0_OFFSET		SHA1_MD5_OFFSET(0x0)
#define CRYPT_SHA1_INIT_63_32_OFFSET		SHA1_MD5_OFFSET(0x4)
#define CRYPT_SHA1_INIT_95_64_OFFSET		SHA1_MD5_OFFSET(0x8)
#define CRYPT_SHA1_INIT_127_96_OFFSET		SHA1_MD5_OFFSET(0xc)
#define CRYPT_SHA1_INIT_159_128_OFFSET		SHA1_MD5_OFFSET(0x10)
#define CRYPT_SHA1_INPUT_31_0_OFFSET		SHA1_MD5_OFFSET(0x18)
#define CRYPT_SHA1_INPUT_63_32_OFFSET		SHA1_MD5_OFFSET(0x1c)
#define CRYPT_SHA1_INPUT_95_64_OFFSET		SHA1_MD5_OFFSET(0x20)
#define CRYPT_SHA1_INPUT_127_96_OFFSET		SHA1_MD5_OFFSET(0x24)
#define CRYPT_SHA1_INPUT_159_128_OFFSET		SHA1_MD5_OFFSET(0x28)
#define CRYPT_SHA1_INPUT_191_160_OFFSET		SHA1_MD5_OFFSET(0x2c)
#define CRYPT_SHA1_INPUT_223_192_OFFSET		SHA1_MD5_OFFSET(0x30)
#define CRYPT_SHA1_INPUT_255_224_OFFSET		SHA1_MD5_OFFSET(0x34)
#define CRYPT_SHA1_INPUT_287_256_OFFSET		SHA1_MD5_OFFSET(0x38)
#define CRYPT_SHA1_INPUT_319_288_OFFSET		SHA1_MD5_OFFSET(0x3c)
#define CRYPT_SHA1_INPUT_351_320_OFFSET		SHA1_MD5_OFFSET(0x40)
#define CRYPT_SHA1_INPUT_383_352_OFFSET		SHA1_MD5_OFFSET(0x44)
#define CRYPT_SHA1_INPUT_415_384_OFFSET		SHA1_MD5_OFFSET(0x48)
#define CRYPT_SHA1_INPUT_447_416_OFFSET		SHA1_MD5_OFFSET(0x4c)
#define CRYPT_SHA1_INPUT_479_448_OFFSET		SHA1_MD5_OFFSET(0x50)
#define CRYPT_SHA1_INPUT_511_480_OFFSET		SHA1_MD5_OFFSET(0x54)
#define CRYPT_SHA1_OUTPUT_31_0_OFFSET		SHA1_MD5_OFFSET(0x58)
#define CRYPT_SHA1_OUTPUT_63_32_OFFSET		SHA1_MD5_OFFSET(0x5c)
#define CRYPT_SHA1_OUTPUT_95_64_OFFSET		SHA1_MD5_OFFSET(0x60)
#define CRYPT_SHA1_OUTPUT_127_96_OFFSET		SHA1_MD5_OFFSET(0x64)
#define CRYPT_SHA1_OUTPUT_159_128_OFFSET	SHA1_MD5_OFFSET(0x68)
#define CRYPT_SHA1_OUTPUT_READY_OFFSET		SHA1_MD5_OFFSET(0x70)
#define CRYPT_SHA1_INT_EN_OFFSET		SHA1_MD5_OFFSET(0x78)
#define CRYPT_MD5_INIT_31_0_OFFSET		SHA1_MD5_OFFSET(0x80)
#define CRYPT_MD5_INIT_63_32_OFFSET		SHA1_MD5_OFFSET(0x84)
#define CRYPT_MD5_INIT_95_64_OFFSET		SHA1_MD5_OFFSET(0x88)
#define CRYPT_MD5_INIT_127_96_OFFSET		SHA1_MD5_OFFSET(0x8c)
#define CRYPT_MD5_INPUT_31_0_OFFSET		SHA1_MD5_OFFSET(0x90)
#define CRYPT_MD5_INPUT_63_32_OFFSET		SHA1_MD5_OFFSET(0x94)
#define CRYPT_MD5_INPUT_95_64_OFFSET		SHA1_MD5_OFFSET(0x98)
#define CRYPT_MD5_INPUT_127_96_OFFSET		SHA1_MD5_OFFSET(0x9c)
#define CRYPT_MD5_INPUT_159_128_OFFSET		SHA1_MD5_OFFSET(0xa0)
#define CRYPT_MD5_INPUT_191_160_OFFSET		SHA1_MD5_OFFSET(0xa4)
#define CRYPT_MD5_INPUT_223_192_OFFSET		SHA1_MD5_OFFSET(0xa8)
#define CRYPT_MD5_INPUT_255_224_OFFSET		SHA1_MD5_OFFSET(0xac)
#define CRYPT_MD5_INPUT_287_256_OFFSET		SHA1_MD5_OFFSET(0xb0)
#define CRYPT_MD5_INPUT_319_288_OFFSET		SHA1_MD5_OFFSET(0xb4)
#define CRYPT_MD5_INPUT_351_320_OFFSET		SHA1_MD5_OFFSET(0xb8)
#define CRYPT_MD5_INPUT_383_352_OFFSET		SHA1_MD5_OFFSET(0xbc)
#define CRYPT_MD5_INPUT_415_384_OFFSET		SHA1_MD5_OFFSET(0xc0)
#define CRYPT_MD5_INPUT_447_416_OFFSET		SHA1_MD5_OFFSET(0xc4)
#define CRYPT_MD5_INPUT_479_448_OFFSET		SHA1_MD5_OFFSET(0xc8)
#define CRYPT_MD5_INPUT_511_480_OFFSET		SHA1_MD5_OFFSET(0xcc)
#define CRYPT_MD5_OUTPUT_31_0_OFFSET		SHA1_MD5_OFFSET(0xd0)
#define CRYPT_MD5_OUTPUT_63_32_OFFSET		SHA1_MD5_OFFSET(0xd4)
#define CRYPT_MD5_OUTPUT_95_64_OFFSET		SHA1_MD5_OFFSET(0xd8)
#define CRYPT_MD5_OUTPUT_127_96_OFFSET		SHA1_MD5_OFFSET(0xdc)
#define CRYPT_MD5_OUTPUT_READY_OFFSET		SHA1_MD5_OFFSET(0xe0)
#define CRYPT_MD5_INT_EN_OFFSET			SHA1_MD5_OFFSET(0xe8)
#define CRYPT_MD5_SHA1_READY_INPUT_OFFSET	SHA1_MD5_OFFSET(0xf0)

#define CRYPT_SHA1_INIT_31_0_REG		SHA1_MD5_REG(0x0)
#define CRYPT_SHA1_INIT_63_32_REG		SHA1_MD5_REG(0x4)
#define CRYPT_SHA1_INIT_95_64_REG		SHA1_MD5_REG(0x8)
#define CRYPT_SHA1_INIT_127_96_REG		SHA1_MD5_REG(0xc)
#define CRYPT_SHA1_INIT_159_128_REG		SHA1_MD5_REG(0x10)
#define CRYPT_SHA1_INPUT_31_0_REG		SHA1_MD5_REG(0x18)
#define CRYPT_SHA1_INPUT_63_32_REG		SHA1_MD5_REG(0x1c)
#define CRYPT_SHA1_INPUT_95_64_REG		SHA1_MD5_REG(0x20)
#define CRYPT_SHA1_INPUT_127_96_REG		SHA1_MD5_REG(0x24)
#define CRYPT_SHA1_INPUT_159_128_REG		SHA1_MD5_REG(0x28)
#define CRYPT_SHA1_INPUT_191_160_REG		SHA1_MD5_REG(0x2c)
#define CRYPT_SHA1_INPUT_223_192_REG		SHA1_MD5_REG(0x30)
#define CRYPT_SHA1_INPUT_255_224_REG		SHA1_MD5_REG(0x34)
#define CRYPT_SHA1_INPUT_287_256_REG		SHA1_MD5_REG(0x38)
#define CRYPT_SHA1_INPUT_319_288_REG		SHA1_MD5_REG(0x3c)
#define CRYPT_SHA1_INPUT_351_320_REG		SHA1_MD5_REG(0x40)
#define CRYPT_SHA1_INPUT_383_352_REG		SHA1_MD5_REG(0x44)
#define CRYPT_SHA1_INPUT_415_384_REG		SHA1_MD5_REG(0x48)
#define CRYPT_SHA1_INPUT_447_416_REG		SHA1_MD5_REG(0x4c)
#define CRYPT_SHA1_INPUT_479_448_REG		SHA1_MD5_REG(0x50)
#define CRYPT_SHA1_INPUT_511_480_REG		SHA1_MD5_REG(0x54)
#define CRYPT_SHA1_OUTPUT_31_0_REG		SHA1_MD5_REG(0x58)
#define CRYPT_SHA1_OUTPUT_63_32_REG		SHA1_MD5_REG(0x5c)
#define CRYPT_SHA1_OUTPUT_95_64_REG		SHA1_MD5_REG(0x60)
#define CRYPT_SHA1_OUTPUT_127_96_REG		SHA1_MD5_REG(0x64)
#define CRYPT_SHA1_OUTPUT_159_128_REG		SHA1_MD5_REG(0x68)
#define CRYPT_SHA1_OUTPUT_READY_REG		SHA1_MD5_REG(0x70)
#define CRYPT_SHA1_INT_EN_REG			SHA1_MD5_REG(0x78)
#define CRYPT_MD5_INIT_31_0_REG			SHA1_MD5_REG(0x80)
#define CRYPT_MD5_INIT_63_32_REG		SHA1_MD5_REG(0x84)
#define CRYPT_MD5_INIT_95_64_REG		SHA1_MD5_REG(0x88)
#define CRYPT_MD5_INIT_127_96_REG		SHA1_MD5_REG(0x8c)
#define CRYPT_MD5_INPUT_31_0_REG		SHA1_MD5_REG(0x90)
#define CRYPT_MD5_INPUT_63_32_REG		SHA1_MD5_REG(0x94)
#define CRYPT_MD5_INPUT_95_64_REG		SHA1_MD5_REG(0x98)
#define CRYPT_MD5_INPUT_127_96_REG		SHA1_MD5_REG(0x9c)
#define CRYPT_MD5_INPUT_159_128_REG		SHA1_MD5_REG(0xa0)
#define CRYPT_MD5_INPUT_191_160_REG		SHA1_MD5_REG(0xa4)
#define CRYPT_MD5_INPUT_223_192_REG		SHA1_MD5_REG(0xa8)
#define CRYPT_MD5_INPUT_255_224_REG		SHA1_MD5_REG(0xac)
#define CRYPT_MD5_INPUT_287_256_REG		SHA1_MD5_REG(0xb0)
#define CRYPT_MD5_INPUT_319_288_REG		SHA1_MD5_REG(0xb4)
#define CRYPT_MD5_INPUT_351_320_REG		SHA1_MD5_REG(0xb8)
#define CRYPT_MD5_INPUT_383_352_REG		SHA1_MD5_REG(0xbc)
#define CRYPT_MD5_INPUT_415_384_REG		SHA1_MD5_REG(0xc0)
#define CRYPT_MD5_INPUT_447_416_REG		SHA1_MD5_REG(0xc4)
#define CRYPT_MD5_INPUT_479_448_REG		SHA1_MD5_REG(0xc8)
#define CRYPT_MD5_INPUT_511_480_REG		SHA1_MD5_REG(0xcc)
#define CRYPT_MD5_OUTPUT_31_0_REG		SHA1_MD5_REG(0xd0)
#define CRYPT_MD5_OUTPUT_63_32_REG		SHA1_MD5_REG(0xd4)
#define CRYPT_MD5_OUTPUT_95_64_REG		SHA1_MD5_REG(0xd8)
#define CRYPT_MD5_OUTPUT_127_96_REG		SHA1_MD5_REG(0xdc)
#define CRYPT_MD5_OUTPUT_READY_REG		SHA1_MD5_REG(0xe0)
#define CRYPT_MD5_INT_EN_REG			SHA1_MD5_REG(0xe8)
#define CRYPT_MD5_SHA1_READY_INPUT_REG		SHA1_MD5_REG(0xf0)
#endif
#endif /* (CRYPT_SUPPORT_MD5_SHA1 == 1)*/

#endif
