/*
 * ambhw/stepper.h
 *
 * History:
 *	2006/12/27 - [Charles Chiou] created file
 *
 * Copyright (C) 2006-2007, Ambarella, Inc.
 */

#ifndef __AMBHW__STEPPTER_H__
#define __AMBHW__STEPPTER_H__

#include <asm/arch/ambhw/chip.h>
#include <asm/arch/ambhw/busaddr.h>

/****************************************************/
/* Capabilities based on chip revision              */
/****************************************************/
#if ((CHIP_REV == A5)  || (CHIP_REV == A2S) || (CHIP_REV == A6)	 || \
     (CHIP_REV == A5S) || (CHIP_REV == A7)  || (CHIP_REV == A5L) || \
     (CHIP_REV == I1)  || (CHIP_REV == A7L))
#define ST_CONFIG_LAST_POL	1
#define	ST_SUPPORT_PRECOUNT	1
#define	ST_SUPPORT_ACC_MODE	1
#else
#define ST_CONFIG_LAST_POL	0
#define	ST_SUPPORT_PRECOUNT	0
#define	ST_SUPPORT_ACC_MODE	0
#endif

#if (CHIP_REV == A7) 
#define ST_INSTANCES		4
#elif (CHIP_REV == A5L)
#define ST_INSTANCES		2
#else
#define ST_INSTANCES		3
#endif

#if (CHIP_REV == A5S) || (CHIP_REV == A7) || (CHIP_REV == A5L)	|| \
    (CHIP_REV == I1)  || (CHIP_REV == A7L)
#define	ST_SUPPORT_MICROST	1
#else
#define	ST_SUPPORT_MICROST	0
#endif

#if (CHIP_REV == A7L)
#define MS_CLK_REF_MULTI_AHB_CLK	2
#else
#define MS_CLK_REF_MULTI_AHB_CLK	1
#endif

#define ST_TOTAL_PIN		5

/****************************************************/
/* Controller registers definitions                 */
/****************************************************/

#if (CHIP_REV == A7)
#define ST_A_OFFSET		0x0
#define ST_B_OFFSET		0x80
#define ST_C_OFFSET		0x100
#define ST_D_OFFSET		0x180
#else
#define ST_A_OFFSET		0x0
#define ST_B_OFFSET		0x100
#if (ST_INSTANCES >= 3)
#define ST_C_OFFSET		0x200
#endif
#endif

#define	ST_CONTROL_OFFSET		0x000
#define ST_PATTERN0_0_OFFSET		0x004
#define ST_PATTERN1_0_OFFSET		0x008
#define ST_PATTERN0_1_OFFSET		0x00c
#define ST_PATTERN1_1_OFFSET		0x010
#define ST_PATTERN0_2_OFFSET		0x014
#define ST_PATTERN1_2_OFFSET		0x018
#define ST_PATTERN0_3_OFFSET		0x01c
#define ST_PATTERN1_3_OFFSET		0x020
#define ST_PATTERN0_4_OFFSET		0x024
#define ST_PATTERN1_4_OFFSET		0x028
#define ST_COUNT_OFFSET			0x02c
#define ST_STATUS_OFFSET		0x030
#define ST_ACC_COUNT_OFFSET		0x034
#define ST_ACC_CLKDIV_0_OFFSET		0x038
#define ST_ACC_CLKDIV_1_OFFSET		0x03c
#define ST_PRE_COUNTER_OFFSET		0x040

#if (ST_INSTANCES >= 2)
#define	ST_CONTROL_A_OFFSET		(ST_A_OFFSET + ST_CONTROL_OFFSET)
#define ST_PATTERN0_0A_OFFSET		(ST_A_OFFSET + ST_PATTERN0_0_OFFSET)
#define ST_PATTERN1_0A_OFFSET		(ST_A_OFFSET + ST_PATTERN1_0_OFFSET)
#define ST_PATTERN0_1A_OFFSET		(ST_A_OFFSET + ST_PATTERN0_1_OFFSET)
#define ST_PATTERN1_1A_OFFSET		(ST_A_OFFSET + ST_PATTERN1_1_OFFSET)
#define ST_PATTERN0_2A_OFFSET		(ST_A_OFFSET + ST_PATTERN0_2_OFFSET)
#define ST_PATTERN1_2A_OFFSET		(ST_A_OFFSET + ST_PATTERN1_2_OFFSET)
#define ST_PATTERN0_3A_OFFSET		(ST_A_OFFSET + ST_PATTERN0_3_OFFSET)
#define ST_PATTERN1_3A_OFFSET		(ST_A_OFFSET + ST_PATTERN1_3_OFFSET)
#define ST_PATTERN0_4A_OFFSET		(ST_A_OFFSET + ST_PATTERN0_4_OFFSET)
#define ST_PATTERN1_4A_OFFSET		(ST_A_OFFSET + ST_PATTERN1_4_OFFSET)
#define ST_COUNT_A_OFFSET		(ST_A_OFFSET + ST_COUNT_OFFSET)
#define ST_STATUS_A_OFFSET		(ST_A_OFFSET + ST_STATUS_OFFSET)
#define ST_ACC_COUNT_A_OFFSET		(ST_A_OFFSET + ST_ACC_COUNT_OFFSET)
#define ST_ACC_CLKDIV_0A_OFFSET		(ST_A_OFFSET + ST_ACC_CLKDIV_0_OFFSET)
#define ST_ACC_CLKDIV_1A_OFFSET		(ST_A_OFFSET + ST_ACC_CLKDIV_1_OFFSET)
#define ST_PRE_COUNTER_A_OFFSET		(ST_A_OFFSET + ST_PRE_COUNTER_OFFSET)
#define ST_CONTROL_B_OFFSET		(ST_B_OFFSET + ST_CONTROL_OFFSET)
#define ST_PATTERN0_0B_OFFSET		(ST_B_OFFSET + ST_PATTERN0_0_OFFSET)
#define ST_PATTERN1_0B_OFFSET		(ST_B_OFFSET + ST_PATTERN1_0_OFFSET)
#define ST_PATTERN0_1B_OFFSET		(ST_B_OFFSET + ST_PATTERN0_1_OFFSET)
#define ST_PATTERN1_1B_OFFSET		(ST_B_OFFSET + ST_PATTERN1_1_OFFSET)
#define ST_PATTERN0_2B_OFFSET		(ST_B_OFFSET + ST_PATTERN0_2_OFFSET)
#define ST_PATTERN1_2B_OFFSET		(ST_B_OFFSET + ST_PATTERN1_2_OFFSET)
#define ST_PATTERN0_3B_OFFSET		(ST_B_OFFSET + ST_PATTERN0_3_OFFSET)
#define ST_PATTERN1_3B_OFFSET		(ST_B_OFFSET + ST_PATTERN1_3_OFFSET)
#define ST_PATTERN0_4B_OFFSET		(ST_B_OFFSET + ST_PATTERN0_4_OFFSET)
#define ST_PATTERN1_4B_OFFSET		(ST_B_OFFSET + ST_PATTERN1_4_OFFSET)
#define ST_COUNT_B_OFFSET		(ST_B_OFFSET + ST_COUNT_OFFSET)
#define ST_STATUS_B_OFFSET		(ST_B_OFFSET + ST_STATUS_OFFSET)
#define ST_ACC_COUNT_B_OFFSET		(ST_B_OFFSET + ST_ACC_COUNT_OFFSET)
#define ST_ACC_CLKDIV_0B_OFFSET		(ST_B_OFFSET + ST_ACC_CLKDIV_0_OFFSET)
#define ST_ACC_CLKDIV_1B_OFFSET		(ST_B_OFFSET + ST_ACC_CLKDIV_1_OFFSET)
#define ST_PRE_COUNTER_B_OFFSET		(ST_B_OFFSET + ST_PRE_COUNTER_OFFSET)
#endif

#if (ST_INSTANCES >= 3)
#define ST_CONTROL_C_OFFSET		(ST_C_OFFSET + ST_CONTROL_OFFSET)
#define ST_PATTERN0_0C_OFFSET		(ST_C_OFFSET + ST_PATTERN0_0_OFFSET)
#define ST_PATTERN1_0C_OFFSET		(ST_C_OFFSET + ST_PATTERN1_0_OFFSET)
#define ST_PATTERN0_1C_OFFSET		(ST_C_OFFSET + ST_PATTERN0_1_OFFSET)
#define ST_PATTERN1_1C_OFFSET		(ST_C_OFFSET + ST_PATTERN1_1_OFFSET)
#define ST_PATTERN0_2C_OFFSET		(ST_C_OFFSET + ST_PATTERN0_2_OFFSET) 
#define ST_PATTERN1_2C_OFFSET		(ST_C_OFFSET + ST_PATTERN1_2_OFFSET) 
#define ST_PATTERN0_3C_OFFSET		(ST_C_OFFSET + ST_PATTERN0_3_OFFSET) 
#define ST_PATTERN1_3C_OFFSET		(ST_C_OFFSET + ST_PATTERN1_3_OFFSET) 
#define ST_PATTERN0_4C_OFFSET		(ST_C_OFFSET + ST_PATTERN0_4_OFFSET) 
#define ST_PATTERN1_4C_OFFSET		(ST_C_OFFSET + ST_PATTERN1_4_OFFSET) 
#define ST_COUNT_C_OFFSET		(ST_C_OFFSET + ST_COUNT_OFFSET)
#define ST_STATUS_C_OFFSET		(ST_C_OFFSET + ST_STATUS_OFFSET)
#define ST_ACC_COUNT_C_OFFSET		(ST_C_OFFSET + ST_ACC_COUNT_OFFSET)
#define ST_ACC_CLKDIV_0C_OFFSET		(ST_C_OFFSET + ST_ACC_CLKDIV_0_OFFSET)
#define ST_ACC_CLKDIV_1C_OFFSET		(ST_C_OFFSET + ST_ACC_CLKDIV_1_OFFSET)
#define ST_PRE_COUNTER_C_OFFSET		(ST_C_OFFSET + ST_PRE_COUNTER_OFFSET)
#endif 

#if (ST_INSTANCES >= 4)
#define ST_CONTROL_D_OFFSET		(ST_D_OFFSET + ST_CONTROL_OFFSET)
#define ST_PATTERN0_0D_OFFSET		(ST_D_OFFSET + ST_PATTERN0_0_OFFSET)
#define ST_PATTERN1_0D_OFFSET		(ST_D_OFFSET + ST_PATTERN1_0_OFFSET)
#define ST_PATTERN0_1D_OFFSET		(ST_D_OFFSET + ST_PATTERN0_1_OFFSET)
#define ST_PATTERN1_1D_OFFSET		(ST_D_OFFSET + ST_PATTERN1_1_OFFSET)
#define ST_PATTERN0_2D_OFFSET		(ST_D_OFFSET + ST_PATTERN0_2_OFFSET) 
#define ST_PATTERN1_2D_OFFSET		(ST_D_OFFSET + ST_PATTERN1_2_OFFSET) 
#define ST_PATTERN0_3D_OFFSET		(ST_D_OFFSET + ST_PATTERN0_3_OFFSET) 
#define ST_PATTERN1_3D_OFFSET		(ST_D_OFFSET + ST_PATTERN1_3_OFFSET) 
#define ST_PATTERN0_4D_OFFSET		(ST_D_OFFSET + ST_PATTERN0_4_OFFSET) 
#define ST_PATTERN1_4D_OFFSET		(ST_D_OFFSET + ST_PATTERN1_4_OFFSET) 
#define ST_COUNT_D_OFFSET		(ST_D_OFFSET + ST_COUNT_OFFSET)
#define ST_STATUS_D_OFFSET		(ST_D_OFFSET + ST_STATUS_OFFSET)
#define ST_ACC_COUNT_D_OFFSET		(ST_D_OFFSET + ST_ACC_COUNT_OFFSET)
#define ST_ACC_CLKDIV_0D_OFFSET		(ST_D_OFFSET + ST_ACC_CLKDIV_0_OFFSET)
#define ST_ACC_CLKDIV_1D_OFFSET		(ST_D_OFFSET + ST_ACC_CLKDIV_1_OFFSET)
#define ST_PRE_COUNTER_D_OFFSET		(ST_D_OFFSET + ST_PRE_COUNTER_OFFSET)
#endif

#define ST_INTERRUPT_OFFSET		0x280
#define ST_INTERRUPT_EN_OFFSET		0x284

#if (ST_INSTANCES >= 2)
#define MST_CONTROL_A_OFFSET		0x400
#define MST_PWM_A_OFFSET		0x404
#define MST_COUNT0_A_OFFSET		0x408
#define MST_COUNT1_A_OFFSET		0x40c
#define MST_STATUS_A_OFFSET		0x410
#define MST_PRE_COUNT_A_OFFSET		0x414
#define MST_CONTROL_B_OFFSET		0x500
#define MST_PWM_B_OFFSET		0x504
#define MST_COUNT0_B_OFFSET		0x508
#define MST_COUNT1_B_OFFSET		0x50c
#define MST_STATUS_B_OFFSET		0x510
#define MST_PRE_COUNT_B_OFFSET		0x514
#endif

#if (ST_INSTANCES >= 3)
#define MST_CONTROL_C_OFFSET		0x600
#define MST_PWM_C_OFFSET		0x604
#define MST_COUNT0_C_OFFSET		0x608
#define MST_COUNT1_C_OFFSET		0x60c
#define MST_STATUS_C_OFFSET		0x610
#define MST_PRE_COUNT_C_OFFSET		0x614
#endif

#if (ST_INSTANCES >= 4)
#define MST_CONTROL_D_OFFSET		0x700
#define MST_PWM_D_OFFSET		0x704
#define MST_COUNT0_D_OFFSET		0x708
#define MST_COUNT1_D_OFFSET		0x70c
#define MST_STATUS_D_OFFSET		0x710
#define MST_PRE_COUNT_D_OFFSET		0x714
#endif

#if (ST_INSTANCES >= 2)
#define MST_WAVE_A1_OFFSET		0x800
#define MST_WAVE_A2_OFFSET		0x880
#define MST_WAVE_A3_OFFSET		0x900
#define MST_WAVE_A4_OFFSET		0x980
#define MST_WAVE_B1_OFFSET		0xa00
#define MST_WAVE_B2_OFFSET		0xa80
#define MST_WAVE_B3_OFFSET		0xb00
#define MST_WAVE_B4_OFFSET		0xb80
#endif

#if (ST_INSTANCES >= 3)
#define MST_WAVE_C1_OFFSET		0xc00
#define MST_WAVE_C2_OFFSET		0xc80
#define MST_WAVE_C3_OFFSET		0xd00
#define MST_WAVE_C4_OFFSET		0xd80
#endif

#if (ST_INSTANCES >= 4)
#define MST_WAVE_D1_OFFSET		0xe00
#define MST_WAVE_D2_OFFSET		0xe80
#define MST_WAVE_D3_OFFSET		0xf00
#define MST_WAVE_D4_OFFSET		0xf80
#endif

#if (ST_INSTANCES >= 2)
#define	ST_CONTROL_A_REG		ST_REG(ST_CONTROL_A_OFFSET)
#define ST_PATTERN0_0A_REG		ST_REG(ST_PATTERN0_0A_OFFSET)
#define ST_PATTERN1_0A_REG		ST_REG(ST_PATTERN1_0A_OFFSET)
#define ST_PATTERN0_1A_REG		ST_REG(ST_PATTERN0_1A_OFFSET)
#define ST_PATTERN1_1A_REG		ST_REG(ST_PATTERN1_1A_OFFSET)
#define ST_PATTERN0_2A_REG		ST_REG(ST_PATTERN0_2A_OFFSET)
#define ST_PATTERN1_2A_REG		ST_REG(ST_PATTERN1_2A_OFFSET)
#define ST_PATTERN0_3A_REG		ST_REG(ST_PATTERN0_3A_OFFSET)
#define ST_PATTERN1_3A_REG		ST_REG(ST_PATTERN1_3A_OFFSET)
#define ST_PATTERN0_4A_REG		ST_REG(ST_PATTERN0_4A_OFFSET)
#define ST_PATTERN1_4A_REG		ST_REG(ST_PATTERN1_4A_OFFSET)
#define ST_COUNT_A_REG			ST_REG(ST_COUNT_A_OFFSET)
#define ST_STATUS_A_REG			ST_REG(ST_STATUS_A_OFFSET)
#define ST_ACC_COUNT_A_REG		ST_REG(ST_ACC_COUNT_A_OFFSET)
#define ST_ACC_CLKDIV_0A_REG		ST_REG(ST_ACC_CLKDIV_0A_OFFSET)
#define ST_ACC_CLKDIV_1A_REG		ST_REG(ST_ACC_CLKDIV_1A_OFFSET)
#define ST_PRE_COUNTER_A_REG		ST_REG(ST_PRE_COUNTER_A_OFFSET)

#define ST_CONTROL_B_REG		ST_REG(ST_CONTROL_B_OFFSET)
#define ST_PATTERN0_0B_REG		ST_REG(ST_PATTERN0_0B_OFFSET)
#define ST_PATTERN1_0B_REG		ST_REG(ST_PATTERN1_0B_OFFSET)
#define ST_PATTERN0_1B_REG		ST_REG(ST_PATTERN0_1B_OFFSET)
#define ST_PATTERN1_1B_REG		ST_REG(ST_PATTERN1_1B_OFFSET)
#define ST_PATTERN0_2B_REG		ST_REG(ST_PATTERN0_2B_OFFSET)
#define ST_PATTERN1_2B_REG		ST_REG(ST_PATTERN1_2B_OFFSET)
#define ST_PATTERN0_3B_REG		ST_REG(ST_PATTERN0_3B_OFFSET)
#define ST_PATTERN1_3B_REG		ST_REG(ST_PATTERN1_3B_OFFSET)
#define ST_PATTERN0_4B_REG		ST_REG(ST_PATTERN0_4B_OFFSET)
#define ST_PATTERN1_4B_REG		ST_REG(ST_PATTERN1_4B_OFFSET)
#define ST_COUNT_B_REG			ST_REG(ST_COUNT_B_OFFSET)
#define ST_STATUS_B_REG			ST_REG(ST_STATUS_B_OFFSET)
#define ST_ACC_COUNT_B_REG		ST_REG(ST_ACC_COUNT_B_OFFSET)
#define ST_ACC_CLKDIV_0B_REG		ST_REG(ST_ACC_CLKDIV_0B_OFFSET)
#define ST_ACC_CLKDIV_1B_REG		ST_REG(ST_ACC_CLKDIV_1B_OFFSET)
#define ST_PRE_COUNTER_B_REG		ST_REG(ST_PRE_COUNTER_B_OFFSET)
#endif

#if (ST_INSTANCES >= 3)
#define ST_CONTROL_C_REG		ST_REG(ST_CONTROL_C_OFFSET)
#define ST_PATTERN0_0C_REG		ST_REG(ST_PATTERN0_0C_OFFSET)
#define ST_PATTERN1_0C_REG		ST_REG(ST_PATTERN1_0C_OFFSET)
#define ST_PATTERN0_1C_REG		ST_REG(ST_PATTERN0_1C_OFFSET)
#define ST_PATTERN1_1C_REG		ST_REG(ST_PATTERN1_1C_OFFSET)
#define ST_PATTERN0_2C_REG		ST_REG(ST_PATTERN0_2C_OFFSET)
#define ST_PATTERN1_2C_REG		ST_REG(ST_PATTERN1_2C_OFFSET)
#define ST_PATTERN0_3C_REG		ST_REG(ST_PATTERN0_3C_OFFSET)
#define ST_PATTERN1_3C_REG		ST_REG(ST_PATTERN1_3C_OFFSET)
#define ST_PATTERN0_4C_REG		ST_REG(ST_PATTERN0_4C_OFFSET)
#define ST_PATTERN1_4C_REG		ST_REG(ST_PATTERN1_4C_OFFSET)
#define ST_COUNT_C_REG			ST_REG(ST_COUNT_C_OFFSET)
#define ST_STATUS_C_REG			ST_REG(ST_STATUS_C_OFFSET)
#define ST_ACC_COUNT_C_REG		ST_REG(ST_ACC_COUNT_C_OFFSET)
#define ST_ACC_CLKDIV_0C_REG		ST_REG(ST_ACC_CLKDIV_0C_OFFSET)
#define ST_ACC_CLKDIV_1C_REG		ST_REG(ST_ACC_CLKDIV_1C_OFFSET)
#define ST_PRE_COUNTER_C_REG		ST_REG(ST_PRE_COUNTER_C_OFFSET)
#endif

#if (ST_INSTANCES >= 4)
#define ST_CONTROL_D_REG		ST_REG(ST_CONTROL_D_OFFSET)
#define ST_PATTERN0_0D_REG		ST_REG(ST_PATTERN0_0D_OFFSET)
#define ST_PATTERN1_0D_REG		ST_REG(ST_PATTERN1_0D_OFFSET)
#define ST_PATTERN0_1D_REG		ST_REG(ST_PATTERN0_1D_OFFSET)
#define ST_PATTERN1_1D_REG		ST_REG(ST_PATTERN1_1D_OFFSET)
#define ST_PATTERN0_2D_REG		ST_REG(ST_PATTERN0_2D_OFFSET)
#define ST_PATTERN1_2D_REG		ST_REG(ST_PATTERN1_2D_OFFSET)
#define ST_PATTERN0_3D_REG		ST_REG(ST_PATTERN0_3D_OFFSET)
#define ST_PATTERN1_3D_REG		ST_REG(ST_PATTERN1_3D_OFFSET)
#define ST_PATTERN0_4D_REG		ST_REG(ST_PATTERN0_4D_OFFSET)
#define ST_PATTERN1_4D_REG		ST_REG(ST_PATTERN1_4D_OFFSET)
#define ST_COUNT_D_REG			ST_REG(ST_COUNT_D_OFFSET)
#define ST_STATUS_D_REG			ST_REG(ST_STATUS_D_OFFSET)
#define ST_ACC_COUNT_D_REG		ST_REG(ST_ACC_COUNT_D_OFFSET)
#define ST_ACC_CLKDIV_0D_REG		ST_REG(ST_ACC_CLKDIV_0D_OFFSET)
#define ST_ACC_CLKDIV_1D_REG		ST_REG(ST_ACC_CLKDIV_1D_OFFSET)
#define ST_PRE_COUNTER_D_REG		ST_REG(ST_PRE_COUNTER_D_OFFSET)
#endif

#define ST_INTERRUPT_REG		ST_REG(ST_INTERRUPT_OFFSET)
#define ST_INTERRUPT_EN_REG		ST_REG(ST_INTERRUPT_EN_OFFSET)

#if (ST_INSTANCES >= 2)
#define MST_CONTROL_A_REG		ST_REG(MST_CONTROL_A_OFFSET)
#define MST_PWM_A_REG			ST_REG(MST_PWM_A_OFFSET)
#define MST_COUNT0_A_REG		ST_REG(MST_COUNT0_A_OFFSET)
#define MST_COUNT1_A_REG		ST_REG(MST_COUNT1_A_OFFSET)
#define MST_STATUS_A_REG		ST_REG(MST_STATUS_A_OFFSET)
#define MST_PRE_COUNT_A_REG		ST_REG(MST_PRE_COUNT_A_OFFSET)
#define MST_CONTROL_B_REG		ST_REG(MST_CONTROL_B_OFFSET)
#define MST_PWM_B_REG			ST_REG(MST_PWM_B_OFFSET)
#define MST_COUNT0_B_REG		ST_REG(MST_COUNT0_B_OFFSET)
#define MST_COUNT1_B_REG		ST_REG(MST_COUNT1_B_OFFSET)
#define MST_STATUS_B_REG		ST_REG(MST_STATUS_B_OFFSET)
#define MST_PRE_COUNT_B_REG		ST_REG(MST_PRE_COUNT_B_OFFSET)
#endif

#if (ST_INSTANCES >= 3)
#define MST_CONTROL_C_REG		ST_REG(MST_CONTROL_C_OFFSET)
#define MST_PWM_C_REG			ST_REG(MST_PWM_C_OFFSET)
#define MST_COUNT0_C_REG		ST_REG(MST_COUNT0_C_OFFSET)
#define MST_COUNT1_C_REG		ST_REG(MST_COUNT1_C_OFFSET)
#define MST_STATUS_C_REG		ST_REG(MST_STATUS_C_OFFSET)
#define MST_PRE_COUNT_C_REG		ST_REG(MST_PRE_COUNT_C_OFFSET)
#endif

#if (ST_INSTANCES >= 4)
#define MST_CONTROL_D_REG		ST_REG(MST_CONTROL_D_OFFSET)
#define MST_PWM_D_REG			ST_REG(MST_PWM_D_OFFSET)
#define MST_COUNT0_D_REG		ST_REG(MST_COUNT0_D_OFFSET)
#define MST_COUNT1_D_REG		ST_REG(MST_COUNT1_D_OFFSET)
#define MST_STATUS_D_REG		ST_REG(MST_STATUS_D_OFFSET)
#define MST_PRE_COUNT_D_REG		ST_REG(MST_PRE_COUNT_D_OFFSET)
#endif

#if (ST_INSTANCES >= 2)
#define MST_WAVE_A1_REG			ST_REG(MST_WAVE_A1_OFFSET)
#define MST_WAVE_A2_REG			ST_REG(MST_WAVE_A2_OFFSET)
#define MST_WAVE_A3_REG			ST_REG(MST_WAVE_A3_OFFSET)
#define MST_WAVE_A4_REG			ST_REG(MST_WAVE_A4_OFFSET)
#define MST_WAVE_B1_REG			ST_REG(MST_WAVE_B1_OFFSET)
#define MST_WAVE_B2_REG			ST_REG(MST_WAVE_B2_OFFSET)
#define MST_WAVE_B3_REG			ST_REG(MST_WAVE_B3_OFFSET)
#define MST_WAVE_B4_REG			ST_REG(MST_WAVE_B4_OFFSET)
#endif

#if (ST_INSTANCES >= 3)
#define MST_WAVE_C1_REG			ST_REG(MST_WAVE_C1_OFFSET)
#define MST_WAVE_C2_REG			ST_REG(MST_WAVE_C2_OFFSET)
#define MST_WAVE_C3_REG			ST_REG(MST_WAVE_C3_OFFSET)
#define MST_WAVE_C4_REG			ST_REG(MST_WAVE_C4_OFFSET)
#endif

#if (ST_INSTANCES >= 4)
#define MST_WAVE_D1_REG			ST_REG(MST_WAVE_D1_OFFSET)
#define MST_WAVE_D2_REG			ST_REG(MST_WAVE_D2_OFFSET)
#define MST_WAVE_D3_REG			ST_REG(MST_WAVE_D3_OFFSET)
#define MST_WAVE_D4_REG			ST_REG(MST_WAVE_D4_OFFSET)
#endif

#if (CHIP_REV == A7)
#define ST_MOTOR_ID_OFFSET(x)		((u32) ((x) << 7))
#else
#define ST_MOTOR_ID_OFFSET(x)		((u32) ((x) << 8))
#endif
#define MST_MOTOR_ID_OFFSET(x)		((u32) ((x) << 8))
#endif
