/**
 * boards/a5sipcam/bsp/bsp.h
 *
 * Author: Anthony Ginger <hfjiang@ambarella.com>
 *
 * Copyright (C) 2004-2010, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#include <config.h>

#ifndef __BSP_H__
#define __BSP_H__

#if defined(CONFIG_BOARD_VERSION_A5SIPCAM_V12)
#define AMBOOT_BOARD_ID		AMBARELLA_BOARD_VERSION(A5S, AMBARELLA_BOARD_TYPE_IPCAM, 12)
#elif defined(CONFIG_BOARD_VERSION_A5SIPCAM_V13)
#define AMBOOT_BOARD_ID		AMBARELLA_BOARD_VERSION(A5S, AMBARELLA_BOARD_TYPE_IPCAM, 13)
#elif defined(CONFIG_BOARD_VERSION_A5SIPCAM_V17B)
#define AMBOOT_BOARD_ID		AMBARELLA_BOARD_VERSION(A5S, AMBARELLA_BOARD_TYPE_IPCAM, 17)
#else
#define AMBOOT_BOARD_ID		AMBARELLA_BOARD_VERSION(A5S, AMBARELLA_BOARD_TYPE_IPCAM, 10)
#endif

#define AMBOOT_BST_SIZE		AMBOOT_BST_FIXED_SIZE
#ifdef BUILD_AMBPROM
#define AMBOOT_PTB_SIZE		(MAX_SLCNAND_ERASE_BLOCK_SIZE * 1)
#define AMBOOT_BLD_SIZE 	(MAX_SLCNAND_ERASE_BLOCK_SIZE * 1)
#define AMBOOT_HAL_SIZE 	(MAX_SLCNAND_ERASE_BLOCK_SIZE * 1)
#else
#define AMBOOT_PTB_SIZE		(MAX_SLCNAND_ERASE_BLOCK_SIZE * 20)
#define AMBOOT_BLD_SIZE 	(MAX_SLCNAND_ERASE_BLOCK_SIZE * 20)
#define AMBOOT_HAL_SIZE 	(MAX_SLCNAND_ERASE_BLOCK_SIZE * 20)
#endif

#if defined(CONFIG_BOARD_VERSION_A5SIPCAM_V10A) || defined(CONFIG_BOARD_VERSION_A5SIPCAM_AUTO)
#define AMBOOT_PBA_SIZE 	0
#define AMBOOT_PRI_SIZE 	(8 * 1024 * 1024)			/* 8MB */
#define AMBOOT_SEC_SIZE		0
#define AMBOOT_BAK_SIZE		0
#define AMBOOT_RMD_SIZE		(1 * 1024 * 1024)			/* 1MB */
#define AMBOOT_ROM_SIZE		0
#define AMBOOT_DSP_SIZE		(3 * 1024 * 1024)			/* 3MB */
#define AMBOOT_LNX_SIZE		(70 * 1024 * 1024)			/* 72MB */
#define AMBOOT_SWP_SIZE		0
#define AMBOOT_ADD_SIZE		(40 * 1024 * 1024)			/* 40MB */
#define AMBOOT_ADC_SIZE		(5 * 1024 * 1024)			/* 8MB */
#define MP_RAW_SIZE		0
#define MP_STG2_SIZE		0
#define MP_PRF_SIZE		0
#define MP_CAL_SIZE		0
#else
#define AMBOOT_PBA_SIZE 	(16 * 1024 * 1024)			/* 16MB */
#define AMBOOT_PRI_SIZE 	(16 * 1024 * 1024)			/* 16MB */
#define AMBOOT_SEC_SIZE		0
#define AMBOOT_BAK_SIZE		0
#define AMBOOT_RMD_SIZE		(32 * 1024 * 1024)			/* 32MB */
#define AMBOOT_ROM_SIZE		0
#define AMBOOT_DSP_SIZE		(3 * 1024 * 1024)			/* 3MB */
#define AMBOOT_LNX_SIZE		(96 * 1024 * 1024)			/* 96MB */
#define AMBOOT_SWP_SIZE		(64 * 1024 * 1024)			/* 64MB */
#define AMBOOT_ADD_SIZE		(128 * 1024 * 1024)			/* 128MB */
#define AMBOOT_ADC_SIZE		(32 * 1024 * 1024)			/* 32MB */
#define MP_RAW_SIZE		0
#define MP_STG2_SIZE		0
#define MP_PRF_SIZE		0
#define MP_CAL_SIZE		0
#endif


#define DRAM_SIZE		PHYS_DRAM_1_SIZE

#define DEFAULT_GPIO0_AFSEL 0x000EC703
#define DEFAULT_GPIO0_DIR   0x3F31201C
#define DEFAULT_GPIO0_MASK  0xFFF138FC
#define DEFAULT_GPIO0_DATA  0x0030201C
#define DEFAULT_GPIO1_AFSEL 0xFB97BF8a
#define DEFAULT_GPIO1_DIR   0x04684016
#define DEFAULT_GPIO1_MASK  0x04684077
#define DEFAULT_GPIO1_DATA  0x04400010
#define DEFAULT_GPIO2_AFSEL 0x0F03EFEE
#define DEFAULT_GPIO2_DIR   0x50EC1001
#define DEFAULT_GPIO2_MASK  0xF0FC1011
#define DEFAULT_GPIO2_DATA  0x40C41001
#define DEFAULT_GPIO3_AFSEL 0x00000000
#define DEFAULT_GPIO3_DIR	0x00000000
#define DEFAULT_GPIO3_MASK  0x00000000
#define DEFAULT_GPIO3_DATA  0x00000000

#define DEAFULT_PHY_ID		(5)

#define DRAMARB_PRIORITY_VAL	AMB_DRAM_ARBITER_DSP_VERY_LOW_PRIORITY

#endif

