/**
 * @file system/include/flash/slcnand/k9f2g08.h
 *
 * History:
 *    2007/05/08 - [Dragon Chiang] created file
 *
 * Copyright (C) 2004-2007, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __DEFAULT_H__
#define __DEFAULT_H__

/**
 * nand control register initial setting
 */
#define __NAND_DEFAULT_CONTROL						  \
	(NAND_CTR_C2		|				  \
	 NAND_CTR_P3		|				  \
	 NAND_CTR_I4		|				  \
	 NAND_CTR_RC		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_IE		|				  \
	 NAND_CTR_SZ_1G		|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_DEFAULT_MANID		0x0
#define NAND_DEFAULT_DEVID		0x0
#define NAND_DEFAULT_ID3		0x0
#define NAND_DEFAULT_ID4		0x0

/**
 * define for device info
 */
#define NAND_DEFAULT_MAIN_SIZE		2048
#define NAND_DEFAULT_SPARE_SIZE		64
#define NAND_DEFAULT_PAGE_SIZE		2112
#define NAND_DEFAULT_PAGES_PER_BLOCK	64
#define NAND_DEFAULT_BLOCKS_PER_PLANE	1024
#define NAND_DEFAULT_BLOCKS_PER_ZONE	1024
#define NAND_DEFAULT_BLOCKS_PER_BANK	2048
#define NAND_DEFAULT_PLANES_PER_BANK	(NAND_DEFAULT_BLOCKS_PER_BANK / NAND_DEFAULT_BLOCKS_PER_PLANE)
#define NAND_DEFAULT_BANKS_PER_DEVICE	1
#define NAND_DEFAULT_TOTAL_BLOCKS	(NAND_DEFAULT_BLOCKS_PER_BANK * NAND_DEFAULT_BANKS_PER_DEVICE)
#define NAND_DEFAULT_TOTAL_ZONES	(NAND_DEFAULT_TOTAL_BLOCKS / NAND_DEFAULT_BLOCKS_PER_ZONE)
#define NAND_DEFAULT_TOTAL_PLANES	(NAND_DEFAULT_TOTAL_BLOCKS / NAND_DEFAULT_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_DEFAULT_BLOCK_ADDR_BIT	18
#define NAND_DEFAULT_PLANE_ADDR_BIT	18 /* A18 must be the same for copyback */
#define NAND_DEFAULT_PLANE_MASK		0x1
/* Used to mask the plane address according to block address in the same bank */
#define NAND_DEFAULT_PLANE_ADDR_MASK	(NAND_DEFAULT_PLANE_MASK << (NAND_DEFAULT_PLANE_ADDR_BIT - \
						     NAND_DEFAULT_BLOCK_ADDR_BIT))

#define NAND_DEFAULT_PLANE_MAP		NAND_PLANE_MAP_1
#define NAND_DEFAULT_COLUMN_CYCLES	2
#define NAND_DEFAULT_PAGE_CYCLES	3
#define NAND_DEFAULT_ID_CYCLES		4
#define NAND_DEFAULT_CHIP_WIDTH		8
#define NAND_DEFAULT_CHIP_SIZE_MB	256
#define NAND_DEFAULT_BUS_WIDTH		8

#define NAND_DEFAULT_NAME	"UNKNOW NAND FLASH"

#if defined(CONFIG_NAND_1DEVICE)
#define NAND_DEVICES		1
#elif defined(CONFIG_NAND_DEFAULT_2DEVICE)
#define NAND_DEFAULT_DEVICES		2
#elif defined(CONFIG_NAND_DEFAULT_4DEVICE)
#define NAND_DEFAULT_DEVICES		4
#endif

#define NAND_DEFAULT_TOTAL_BANKS	(NAND_DEVICES * NAND_DEFAULT_BANKS_PER_DEVICE)

#if (NAND_DEFAULT_TOTAL_BANKS == 1)
#define NAND_DEFAULT_CONTROL		(__NAND_DEFAULT_CONTROL | NAND_CTR_1BANK)
#elif (NAND_DEFAULT_TOTAL_BANKS == 2)
#define NAND_DEFAULT_CONTROL		(__NAND_DEFAULT_CONTROL | NAND_CTR_2BANK)
#elif (NAND_DEFAULT_TOTAL_BANKS == 4)
#define NAND_DEFAULT_CONTROL		(__NAND_DEFAULT_CONTROL | NAND_CTR_4BANK)
#elif (NAND_DEFAULT_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_DEFAULT_BB_MARKER_OFFSET	0	/* bad block information */

/**
 * define for partition info
 */
#define NAND_DEFAULT_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_DEFAULT_TCLS		25
#define NAND_DEFAULT_TALS		25
#define NAND_DEFAULT_TCS		35
#define NAND_DEFAULT_TDS		20
#define NAND_DEFAULT_TCLH		10
#define NAND_DEFAULT_TALH		10
#define NAND_DEFAULT_TCH		10
#define NAND_DEFAULT_TDH		10
#define NAND_DEFAULT_TWP		25
#define NAND_DEFAULT_TWH		15
#define NAND_DEFAULT_TWB		100
#define NAND_DEFAULT_TRR		20
#define NAND_DEFAULT_TRP		25
#define NAND_DEFAULT_TREH		15
#define NAND_DEFAULT_TRB		100	/* not in spec, use the same as TWB */
#define NAND_DEFAULT_TCEH		70	/* TRHZ - TCHZ = 100 - 30 = 70 */
#define NAND_DEFAULT_TRDELAY		30	/* tREA */
#define NAND_DEFAULT_TCLR		10
#define NAND_DEFAULT_TWHR		60
#define NAND_DEFAULT_TIR		0
#define NAND_DEFAULT_TWW		20	/* not in spec, use the same as TRR */
#define NAND_DEFAULT_TRHZ		100
#define NAND_DEFAULT_TAR		10

#endif


