/**
 * @file system/include/flash/slcnand/hy27u1g8f2b.h
 *
 * History:
 *    2009/02/21 - [Evan(Kuan-Fu) Chen] created file
 *
 * Copyright (C) 2004-2006, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */


#ifndef __HY27U1G8F2B_H__
#define __HY27U1G8F2B_H__

#define __NAND_HY27U1G8F2B_CONTROL						  \
	(NAND_CTR_C2		|				  \
	 NAND_CTR_RC		|				  \
	 NAND_CTR_I4		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_IE		|				  \
	 NAND_CTR_SZ_1G		|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_HY27U1G8F2B_MANID		0xad
#define NAND_HY27U1G8F2B_DEVID		0xf1
#define NAND_HY27U1G8F2B_ID3		0x00
#define NAND_HY27U1G8F2B_ID4		0x1d

/**
 * define for device info
 */
#define NAND_HY27U1G8F2B_MAIN_SIZE		2048
#define NAND_HY27U1G8F2B_SPARE_SIZE		64
#define NAND_HY27U1G8F2B_PAGE_SIZE		2112
#define NAND_HY27U1G8F2B_PAGES_PER_BLOCK	64
#define NAND_HY27U1G8F2B_BLOCKS_PER_PLANE	1024
#define NAND_HY27U1G8F2B_BLOCKS_PER_ZONE	1024
#define NAND_HY27U1G8F2B_BLOCKS_PER_BANK	1024
#define NAND_HY27U1G8F2B_PLANES_PER_BANK	(NAND_HY27U1G8F2B_BLOCKS_PER_BANK / NAND_HY27U1G8F2B_BLOCKS_PER_PLANE)
#define NAND_HY27U1G8F2B_BANKS_PER_DEVICE	1
#define NAND_HY27U1G8F2B_TOTAL_BLOCKS	(NAND_HY27U1G8F2B_BLOCKS_PER_BANK * NAND_HY27U1G8F2B_BANKS_PER_DEVICE)
#define NAND_HY27U1G8F2B_TOTAL_ZONES	(NAND_HY27U1G8F2B_TOTAL_BLOCKS / NAND_HY27U1G8F2B_BLOCKS_PER_ZONE)
#define NAND_HY27U1G8F2B_TOTAL_PLANES	(NAND_HY27U1G8F2B_TOTAL_BLOCKS / NAND_HY27U1G8F2B_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_HY27U1G8F2B_BLOCK_ADDR_BIT	18
#define NAND_HY27U1G8F2B_PLANE_ADDR_BIT	27
#define NAND_HY27U1G8F2B_PLANE_MASK		0x1

/* Used to mask the plane address according to block address in the same bank */
#define NAND_HY27U1G8F2B_PLANE_ADDR_MASK	(NAND_HY27U1G8F2B_PLANE_MASK << (NAND_HY27U1G8F2B_PLANE_ADDR_BIT - \
						     NAND_HY27U1G8F2B_BLOCK_ADDR_BIT))

#define NAND_HY27U1G8F2B_PLANE_MAP		NAND_PLANE_MAP_2
#define NAND_HY27U1G8F2B_COLUMN_CYCLES	2
#define NAND_HY27U1G8F2B_PAGE_CYCLES	2
#define NAND_HY27U1G8F2B_ID_CYCLES		4
#define NAND_HY27U1G8F2B_CHIP_WIDTH		8
#define NAND_HY27U1G8F2B_CHIP_SIZE_MB	128
#define NAND_HY27U1G8F2B_BUS_WIDTH		8

#define NAND_HY27U1G8F2B	"HYNIX HY27U1G8F2B_128MB_PG2K"
 
#define NAND_HY27U1G8F2B_TOTAL_BANKS	(NAND_HY27U1G8F2B_BANKS_PER_DEVICE)

#if (NAND_HY27U1G8F2B_TOTAL_BANKS == 1)
#define NAND_CONTROL		(__NAND_HY27U1G8F2B_CONTROL | NAND_CTR_1BANK)
#elif (NAND_HY27U1G8F2B_TOTAL_BANKS == 2)
#define NAND_CONTROL		(__NAND_HY27U1G8F2B_CONTROL | NAND_CTR_2BANK)
#elif (NAND_HY27U1G8F2B_TOTAL_BANKS == 4)
#define NAND_CONTROL		(__NAND_HY27U1G8F2B_CONTROL | NAND_CTR_4BANK)
#elif (NAND_HY27U1G8F2B_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_HY27U1G8F2B_BB_MARKER_OFFSET	0	/* bad block information */

/**
 * define for partition info
 */
#define NAND_HY27U1G8F2B_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_HY27U1G8F2B_TCLS		12
#define NAND_HY27U1G8F2B_TALS		12
#define NAND_HY27U1G8F2B_TCS		20
#define NAND_HY27U1G8F2B_TDS		12
#define NAND_HY27U1G8F2B_TCLH		5
#define NAND_HY27U1G8F2B_TALH		5
#define NAND_HY27U1G8F2B_TCH		5
#define NAND_HY27U1G8F2B_TDH		5
#define NAND_HY27U1G8F2B_TWP		12
#define NAND_HY27U1G8F2B_TWH		10
#define NAND_HY27U1G8F2B_TWB		100
#define NAND_HY27U1G8F2B_TRR		20
#define NAND_HY27U1G8F2B_TRP		12
#define NAND_HY27U1G8F2B_TREH		10
#define NAND_HY27U1G8F2B_TRB		100 /* not define in spec, use the same twb */
#define NAND_HY27U1G8F2B_TCEH		15
#define NAND_HY27U1G8F2B_TRDELAY	20 /* tREA */
#define NAND_HY27U1G8F2B_TCLR		10
#define NAND_HY27U1G8F2B_TWHR		60
#define NAND_HY27U1G8F2B_TIR		0
#define NAND_HY27U1G8F2B_TWW		100 /* not define */
#define NAND_HY27U1G8F2B_TRHZ		30 /* min 15, max 30*/
#define NAND_HY27U1G8F2B_TAR		10

#endif

