/**
 * @file system/include/flash/slcnand/hy27ua081g1m.h
 *
 * History:
 *    2007/12/05 - [Dragon Chiang] created file
 *
 * Copyright (C) 2004-2007, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __HY27UA081G1M_H__
#define __HY27UA081G1M_H__

#define __NAND_HY27UA081G1M_CONTROL						  \
	(NAND_CTR_P3		|				  \
	 NAND_CTR_IE		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_SZ_1G		|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_HY27UA081G1M_MANID		0xad
#define NAND_HY27UA081G1M_DEVID		0x79
#define NAND_HY27UA081G1M_ID3		0x00
#define NAND_HY27UA081G1M_ID4		0x00

/**
 * define for device info
 */
#define NAND_HY27UA081G1M_MAIN_SIZE		512
#define NAND_HY27UA081G1M_SPARE_SIZE		16
#define NAND_HY27UA081G1M_PAGE_SIZE		528
#define NAND_HY27UA081G1M_PAGES_PER_BLOCK	32
#define NAND_HY27UA081G1M_BLOCKS_PER_PLANE	2048
#define NAND_HY27UA081G1M_BLOCKS_PER_ZONE	1024
#define NAND_HY27UA081G1M_BLOCKS_PER_BANK	8192
#define NAND_HY27UA081G1M_PLANES_PER_BANK	(NAND_HY27UA081G1M_BLOCKS_PER_BANK / NAND_HY27UA081G1M_BLOCKS_PER_PLANE)
#define NAND_HY27UA081G1M_BANKS_PER_DEVICE	1
#define NAND_HY27UA081G1M_TOTAL_BLOCKS	(NAND_HY27UA081G1M_BLOCKS_PER_BANK * NAND_HY27UA081G1M_BANKS_PER_DEVICE)
#define NAND_HY27UA081G1M_TOTAL_ZONES	(NAND_HY27UA081G1M_TOTAL_BLOCKS / NAND_HY27UA081G1M_BLOCKS_PER_ZONE)
#define NAND_HY27UA081G1M_TOTAL_PLANES	(NAND_HY27UA081G1M_TOTAL_BLOCKS / NAND_HY27UA081G1M_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_HY27UA081G1M_BLOCK_ADDR_BIT	14
/* A26 and A25 are the plane address, so set A25 as plane start address. */
#define NAND_HY27UA081G1M_PLANE_ADDR_BIT	(26 - 1)
#define NAND_HY27UA081G1M_PLANE_MASK		0x3
/* Used to mask the plane address according to block address in the same bank */
#define NAND_HY27UA081G1M_PLANE_ADDR_MASK	(NAND_HY27UA081G1M_PLANE_MASK << (NAND_HY27UA081G1M_PLANE_ADDR_BIT - \
						     NAND_HY27UA081G1M_BLOCK_ADDR_BIT))

#define NAND_HY27UA081G1M_PLANE_MAP		NAND_PLANE_MAP_2
#define NAND_HY27UA081G1M_COLUMN_CYCLES	1
#define NAND_HY27UA081G1M_PAGE_CYCLES	3
#define NAND_HY27UA081G1M_ID_CYCLES		2
#define NAND_HY27UA081G1M_CHIP_WIDTH		8
#define NAND_HY27UA081G1M_CHIP_SIZE_MB	128
#define NAND_HY27UA081G1M_BUS_WIDTH		8

#define NAND_HY27UA081G1M	"HYNIX HY27UA081G1M_128MB_PG512"

#if defined(CONFIG_NAND_1DEVICE)
#define NAND_DEVICES		1
#elif defined(CONFIG_NAND_2DEVICE)
#define NAND_DEVICES		2
#elif defined(CONFIG_NAND_4DEVICE)
#define NAND_DEVICES		4
#endif

#define NAND_HY27UA081G1M_TOTAL_BANKS	(NAND_DEVICES * NAND_HY27UA081G1M_BANKS_PER_DEVICE)

#if (NAND_TOTAL_BANKS == 1)
#define NAND_HY27UA081G1M_CONTROL		(__NAND_HY27UA081G1M_CONTROL | NAND_CTR_1BANK)
#elif (NAND_HY27UA081G1M_TOTAL_BANKS == 2)
#define NAND_HY27UA081G1M_CONTROL		(__NAND_HY27UA081G1M_CONTROL | NAND_CTR_2BANK)
#elif (NAND_HY27UA081G1M_TOTAL_BANKS == 4)
#define NAND_HY27UA081G1M_CONTROL		(__NAND_HY27UA081G1M_CONTROL | NAND_CTR_4BANK)
#elif (NAND_HY27UA081G1M_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_HY27UA081G1M_BB_MARKER_OFFSET	5	/* bad block information */

/**
 * define for partition info
 */
#define NAND_HY27UA081G1M_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_HY27UA081G1M_TCLS		0
#define NAND_HY27UA081G1M_TALS		0
#define NAND_HY27UA081G1M_TCS		0
#define NAND_HY27UA081G1M_TDS		20
#define NAND_HY27UA081G1M_TCLH		10
#define NAND_HY27UA081G1M_TALH		10
#define NAND_HY27UA081G1M_TCH		10
#define NAND_HY27UA081G1M_TDH		10
#define NAND_HY27UA081G1M_TWP		40
#define NAND_HY27UA081G1M_TWH		15
#define NAND_HY27UA081G1M_TWB		100
#define NAND_HY27UA081G1M_TRR		20
#define NAND_HY27UA081G1M_TRP		40
#define NAND_HY27UA081G1M_TREH		15
#define NAND_HY27UA081G1M_TRB		100
#define NAND_HY27UA081G1M_TCEH		100
#define NAND_HY27UA081G1M_TRDELAY		35	/* tREA*/
#define NAND_HY27UA081G1M_TCLR		10
#define NAND_HY27UA081G1M_TWHR		60
#define NAND_HY27UA081G1M_TIR		0
#define NAND_HY27UA081G1M_TWW		25	/* not define */
#define NAND_HY27UA081G1M_TRHZ		30	/* use max value */
#define NAND_HY27UA081G1M_TAR		50

#endif

