/**
 * @file system/include/flash/hy27uf082g2a.h
 *
 * History:
 *    2009/08/05 - [Anthony Ginger] created file
 *
 * Copyright (C) 2004-2005, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __HY27UF082G2A_H__
#define __HY27UF082G2A_H__

#define __NAND_HY27UF082G2A__CONTROL						  \
	(NAND_CTR_C2		|				  \
	 NAND_CTR_P3		|				  \
	 NAND_CTR_I4		|				  \
	 NAND_CTR_RC		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_IE		|				  \
	 NAND_CTR_SZ_2G		|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_HY27UF082G2A__MANID		0xad
#define NAND_HY27UF082G2A__DEVID		0xda
#define NAND_HY27UF082G2A__ID3		0x80
#define NAND_HY27UF082G2A__ID4		0x1d

/**
 * define for device info
 */
#define NAND_HY27UF082G2A__MAIN_SIZE		2048
#define NAND_HY27UF082G2A__SPARE_SIZE		64
#define NAND_HY27UF082G2A__PAGE_SIZE		2112
#define NAND_HY27UF082G2A__PAGES_PER_BLOCK	64
#define NAND_HY27UF082G2A__BLOCKS_PER_PLANE	1024
#define NAND_HY27UF082G2A__BLOCKS_PER_ZONE	1024
#define NAND_HY27UF082G2A__BLOCKS_PER_BANK	2048
#define NAND_HY27UF082G2A__PLANES_PER_BANK	(NAND_HY27UF082G2A__BLOCKS_PER_BANK / NAND_HY27UF082G2A__BLOCKS_PER_PLANE)
#define NAND_HY27UF082G2A__BANKS_PER_DEVICE	1
#define NAND_HY27UF082G2A__TOTAL_BLOCKS	(NAND_HY27UF082G2A__BLOCKS_PER_BANK * NAND_HY27UF082G2A__BANKS_PER_DEVICE)
#define NAND_HY27UF082G2A__TOTAL_ZONES	(NAND_HY27UF082G2A__TOTAL_BLOCKS / NAND_HY27UF082G2A__BLOCKS_PER_ZONE)
#define NAND_HY27UF082G2A__TOTAL_PLANES	(NAND_HY27UF082G2A__TOTAL_BLOCKS / NAND_HY27UF082G2A__BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_HY27UF082G2A__BLOCK_ADDR_BIT	18
#define NAND_HY27UF082G2A__PLANE_ADDR_BIT	28
#define NAND_HY27UF082G2A__PLANE_MASK		0x1
/* Used to mask the plane address according to block address in the same bank */
#define NAND_HY27UF082G2A__PLANE_ADDR_MASK	(NAND_HY27UF082G2A__PLANE_MASK << (NAND_HY27UF082G2A__PLANE_ADDR_BIT - \
						     NAND_HY27UF082G2A__BLOCK_ADDR_BIT))

#define NAND_HY27UF082G2A__PLANE_MAP		NAND_PLANE_MAP_2
#define NAND_HY27UF082G2A__COLUMN_CYCLES	2
#define NAND_HY27UF082G2A__PAGE_CYCLES	3
#define NAND_HY27UF082G2A__ID_CYCLES		4
#define NAND_HY27UF082G2A__CHIP_WIDTH		8
#define NAND_HY27UF082G2A__CHIP_SIZE_MB	256
#define NAND_HY27UF082G2A__BUS_WIDTH		8

#define NAND_HY27UF082G2A	"HYNIX HY27UF082G2A_256MB_PG2K"

#if defined(CONFIG_NAND_1DEVICE)
#define NAND_DEVICES		1
#elif defined(CONFIG_NAND_2DEVICE)
#define NAND_DEVICES		2
#elif defined(CONFIG_NAND_4DEVICE)
#define NAND_DEVICES		4
#endif

#define NAND_HY27UF082G2A__TOTAL_BANKS	(NAND_DEVICES * NAND_HY27UF082G2A__BANKS_PER_DEVICE)

#if (NAND_HY27UF082G2A__TOTAL_BANKS == 1)
#define NAND_HY27UF082G2A__CONTROL		(__NAND_HY27UF082G2A__CONTROL | NAND_CTR_1BANK)
#elif (NAND_HY27UF082G2A__TOTAL_BANKS == 2)
#define NAND_HY27UF082G2A__CONTROL		(__NAND_HY27UF082G2A__CONTROL | NAND_CTR_2BANK)
#elif (NAND_HY27UF082G2A__TOTAL_BANKS == 4)
#define NAND_HY27UF082G2A__CONTROL		(__NAND_HY27UF082G2A__CONTROL | NAND_CTR_4BANK)
#elif (NAND_HY27UF082G2A__TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_HY27UF082G2A__BB_MARKER_OFFSET	0	/* bad block information */

/**
 * define for partition info
 */
#define NAND_HY27UF082G2A__RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_HY27UF082G2A__TCLS		15
#define NAND_HY27UF082G2A__TALS		15
#define NAND_HY27UF082G2A__TCS		25
#define NAND_HY27UF082G2A__TDS		15
#define NAND_HY27UF082G2A__TCLH		5
#define NAND_HY27UF082G2A__TALH		5
#define NAND_HY27UF082G2A__TCH		5
#define NAND_HY27UF082G2A__TDH		5
#define NAND_HY27UF082G2A__TWP		15
#define NAND_HY27UF082G2A__TWH		10
#define NAND_HY27UF082G2A__TWB		100
#define NAND_HY27UF082G2A__TRR		20
#define NAND_HY27UF082G2A__TRP		15
#define NAND_HY27UF082G2A__TREH		10
#define NAND_HY27UF082G2A__TRB		100
#define NAND_HY27UF082G2A__TCEH		30
#define NAND_HY27UF082G2A__TRDELAY		25	/* trea*/
#define NAND_HY27UF082G2A__TCLR		15
#define NAND_HY27UF082G2A__TWHR		60
#define NAND_HY27UF082G2A__TIR		0
#define NAND_HY27UF082G2A__TWW		100	/* not define */
#define NAND_HY27UF082G2A__TRHZ		50	/* use max value */
#define NAND_HY27UF082G2A__TAR		15

#endif

