/**
 * @file system/include/flash/slcnand/hy27uf084g2m.h
 *
 * History:
 *    2009/04/01 - [Evan(Kuan-Fu) Chen] created file
 *
 * Copyright (C) 2004-2005, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __HY27UF084G2M_H__
#define __HY27UF084G2M_H__

#define __NAND_HY27UF084G2M_CONTROL						  \
	(NAND_CTR_P3		|				  \
	 NAND_CTR_C2		|				  \
	 NAND_CTR_RC		|				  \
	 NAND_CTR_I4		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_IE		|				  \
	 NAND_CTR_SZ_4G		|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_HY27UF084G2M_MANID		0xad
#define NAND_HY27UF084G2M_DEVID		0xdc
#define NAND_HY27UF084G2M_ID3		0x80
#define NAND_HY27UF084G2M_ID4		0x95

/**
 * define for device info
 */
#define NAND_HY27UF084G2M_MAIN_SIZE		2048
#define NAND_HY27UF084G2M_SPARE_SIZE		64
#define NAND_HY27UF084G2M_PAGE_SIZE		2112
#define NAND_HY27UF084G2M_PAGES_PER_BLOCK	64
#define NAND_HY27UF084G2M_BLOCKS_PER_PLANE	2048
#define NAND_HY27UF084G2M_BLOCKS_PER_ZONE	1024
#define NAND_HY27UF084G2M_BLOCKS_PER_BANK	4096
#define NAND_HY27UF084G2M_PLANES_PER_BANK	(NAND_HY27UF084G2M_BLOCKS_PER_BANK / NAND_HY27UF084G2M_BLOCKS_PER_PLANE)
#define NAND_HY27UF084G2M_BANKS_PER_DEVICE	1
#define NAND_HY27UF084G2M_TOTAL_BLOCKS	(NAND_HY27UF084G2M_BLOCKS_PER_BANK * NAND_HY27UF084G2M_BANKS_PER_DEVICE)
#define NAND_HY27UF084G2M_TOTAL_ZONES	(NAND_HY27UF084G2M_TOTAL_BLOCKS / NAND_HY27UF084G2M_BLOCKS_PER_ZONE)
#define NAND_HY27UF084G2M_TOTAL_PLANES	(NAND_HY27UF084G2M_TOTAL_BLOCKS / NAND_HY27UF084G2M_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_HY27UF084G2M_BLOCK_ADDR_BIT	18
#define NAND_HY27UF084G2M_PLANE_ADDR_BIT	29
#define NAND_HY27UF084G2M_PLANE_MASK		0x1
/* Used to mask the plane address according to block address in the same bank */
#define NAND_HY27UF084G2M_PLANE_ADDR_MASK	(NAND_HY27UF084G2M_PLANE_MASK << (NAND_HY27UF084G2M_PLANE_ADDR_BIT - \
						     NAND_HY27UF084G2M_BLOCK_ADDR_BIT))

#define NAND_HY27UF084G2M_PLANE_MAP		NAND_PLANE_MAP_2
#define NAND_HY27UF084G2M_COLUMN_CYCLES	2
#define NAND_HY27UF084G2M_PAGE_CYCLES	3
#define NAND_HY27UF084G2M_ID_CYCLES		4
#define NAND_HY27UF084G2M_CHIP_WIDTH		8
#define NAND_HY27UF084G2M_CHIP_SIZE_MB	512
#define NAND_HY27UF084G2M_BUS_WIDTH		8

#define NAND_HY27UF084G2M	"HYNIX HY27UF084G2M_512MB_PG2K"

#if defined(CONFIG_NAND_1DEVICE)
#define NAND_DEVICES		1
#elif defined(CONFIG_NAND_2DEVICE)
#define NAND_DEVICES		2
#elif defined(CONFIG_NAND_4DEVICE)
#define NAND_DEVICES		4
#endif

#define NAND_HY27UF084G2M_TOTAL_BANKS	(NAND_DEVICES * NAND_HY27UF084G2M_BANKS_PER_DEVICE)

#if (NAND_HY27UF084G2M_TOTAL_BANKS == 1)
#define NAND_HY27UF084G2M_CONTROL		(__NAND_HY27UF084G2M_CONTROL | NAND_CTR_1BANK)
#elif (NAND_HY27UF084G2M_TOTAL_BANKS == 2)
#define NAND_HY27UF084G2M_CONTROL		(__NAND_HY27UF084G2M_CONTROL | NAND_CTR_2BANK)
#elif (NAND_HY27UF084G2M_TOTAL_BANKS == 4)
#define NAND_HY27UF084G2M_CONTROL		(__NAND_HY27UF084G2M_CONTROL | NAND_CTR_4BANK)
#elif (NAND_HY27UF084G2M_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_HY27UF084G2M_BB_MARKER_OFFSET	0	/* bad block information */

/**
 * define for partition info
 */
#define NAND_HY27UF084G2M_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_HY27UF084G2M_TCLS		15
#define NAND_HY27UF084G2M_TALS		15
#define NAND_HY27UF084G2M_TCS		25
#define NAND_HY27UF084G2M_TDS		15
#define NAND_HY27UF084G2M_TCLH		5
#define NAND_HY27UF084G2M_TALH		5
#define NAND_HY27UF084G2M_TCH		5
#define NAND_HY27UF084G2M_TDH		5
#define NAND_HY27UF084G2M_TWP		15
#define NAND_HY27UF084G2M_TWH		10
#define NAND_HY27UF084G2M_TWB		100
#define NAND_HY27UF084G2M_TRR		20
#define NAND_HY27UF084G2M_TRP		15
#define NAND_HY27UF084G2M_TREH		10
#define NAND_HY27UF084G2M_TRB		100
#define NAND_HY27UF084G2M_TCEH		30
#define NAND_HY27UF084G2M_TRDELAY		25	/* trea*/
#define NAND_HY27UF084G2M_TCLR		15
#define NAND_HY27UF084G2M_TWHR		60
#define NAND_HY27UF084G2M_TIR		0
#define NAND_HY27UF084G2M_TWW		100	/* not define */
#define NAND_HY27UF084G2M_TRHZ		50	/* use max value */
#define NAND_HY27UF084G2M_TAR		15

#endif

