/**
 * @file system/include/flash/slcnand/hy27us08561a.h
 *
 * History:
 *    2007/08/15 - [Dragon Chiang] created file
 *
 * Copyright (C) 2004-2007, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __HY27US08561A_H__
#define __HY27US08561A_H__

#define __NAND_HY27US08561A_NAND_HY27US08561A_DEVICES_CONTROL						  \
	(NAND_CTR_IE		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_SZ_256M	|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_HY27US08561A_MANID		0xad
#define NAND_HY27US08561A_DEVID		0x75
#define NAND_HY27US08561A_ID3		0x00
#define NAND_HY27US08561A_ID4		0x00

/**
 * define for device info
 */
#define NAND_HY27US08561A_MAIN_SIZE		512
#define NAND_HY27US08561A_SPARE_SIZE		16
#define NAND_HY27US08561A_PAGE_SIZE		528
#define NAND_HY27US08561A_PAGES_PER_BLOCK	32
#define NAND_HY27US08561A_BLOCKS_PER_PLANE	1024
#define NAND_HY27US08561A_BLOCKS_PER_ZONE	1024
#define NAND_HY27US08561A_BLOCKS_PER_BANK	2048
#define NAND_HY27US08561A_PLANES_PER_BANK	(NAND_HY27US08561A_BLOCKS_PER_BANK / NAND_HY27US08561A_BLOCKS_PER_PLANE)
#define NAND_HY27US08561A_BANKS_PER_DEVICE	1
#define NAND_HY27US08561A_TOTAL_BLOCKS	(NAND_HY27US08561A_BLOCKS_PER_BANK * NAND_HY27US08561A_BANKS_PER_DEVICE)
#define NAND_HY27US08561A_TOTAL_ZONES	(NAND_HY27US08561A_TOTAL_BLOCKS / NAND_HY27US08561A_BLOCKS_PER_ZONE)
#define NAND_HY27US08561A_TOTAL_PLANES	(NAND_HY27US08561A_TOTAL_BLOCKS / NAND_HY27US08561A_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_HY27US08561A_BLOCK_ADDR_BIT	14
#define NAND_HY27US08561A_PLANE_ADDR_BIT	24
#define NAND_HY27US08561A_PLANE_MASK		0x1
/* Used to mask the plane address according to block address in the same bank */
#define NAND_HY27US08561A_PLANE_ADDR_MASK	(NAND_HY27US08561A_PLANE_MASK << (NAND_HY27US08561A_PLANE_ADDR_BIT - \
						     NAND_HY27US08561A_BLOCK_ADDR_BIT))

#define NAND_HY27US08561A_PLANE_MAP		NAND_HY27US08561A_PLANE_MAP_2
#define NAND_HY27US08561A_COLUMN_CYCLES	1
#define NAND_HY27US08561A_PAGE_CYCLES	2
#define NAND_HY27US08561A_ID_CYCLES		2
#define NAND_HY27US08561A_CHIP_WIDTH		8
#define NAND_HY27US08561A_CHIP_SIZE_MB	32
#define NAND_HY27US08561A_BUS_WIDTH		8

#if defined(CONFIG_NAND_1DEVICE)
#define NAND_DEVICES		1
#elif defined(CONFIG_NAND_2DEVICE)
#define NAND_DEVICES		2
#elif defined(CONFIG_NAND_4DEVICE)
#define NAND_DEVICES		4
#endif

#define NAND_HY27US08561A	"HYNIX HY27US08561A_32MB_PG512"

#define NAND_HY27US08561A_TOTAL_BANKS	(NAND_DEVICES * NAND_HY27US08561A_BANKS_PER_DEVICE)

#if (NAND_HY27US08561A_TOTAL_BANKS == 1)
#define NAND_HY27US08561A_CONTROL		(__NAND_HY27US08561A_CONTROL | NAND_CTR_1BANK)
#elif (NAND_HY27US08561A_TOTAL_BANKS == 2)
#define NAND_HY27US08561A_CONTROL		(__NAND_HY27US08561A_CONTROL | NAND_CTR_2BANK)
#elif (NAND_HY27US08561A_TOTAL_BANKS == 4)
#define NAND_HY27US08561A_CONTROL		(__NAND_HY27US08561A_CONTROL | NAND_CTR_4BANK)
#elif (NAND_HY27US08561A_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_HY27US08561A_BB_MARKER_OFFSET	5	/* bad block information */

/**
 * define for partition info
 */
#define NAND_HY27US08561A_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_HY27US08561A_TCLS		0
#define NAND_HY27US08561A_TALS		0
#define NAND_HY27US08561A_TCS		0
#define NAND_HY27US08561A_TDS		20
#define NAND_HY27US08561A_TCLH		10
#define NAND_HY27US08561A_TALH		10
#define NAND_HY27US08561A_TCH		10
#define NAND_HY27US08561A_TDH		10
#define NAND_HY27US08561A_TWP		25
#define NAND_HY27US08561A_TWH		15
#define NAND_HY27US08561A_TWB		100
#define NAND_HY27US08561A_TRR		20
#define NAND_HY27US08561A_TRP		25
#define NAND_HY27US08561A_TREH		15
#define NAND_HY27US08561A_TRB		100
#define NAND_HY27US08561A_TCEH		100
#define NAND_HY27US08561A_TRDELAY		30	/* trea*/
#define NAND_HY27US08561A_TCLR		10
#define NAND_HY27US08561A_TWHR		50
#define NAND_HY27US08561A_TIR		0
#define NAND_HY27US08561A_TWW		100	/* not define */
#define NAND_HY27US08561A_TRHZ		30	/* use max value */
#define NAND_HY27US08561A_TAR		10	/* for 3.3V device */

#endif

