/**
 * @file system/include/flash/slcnand/hy27us08561m.h
 *
 * History:
 *    2005/11/8 - [Chien Yang] created file
 *
 * Copyright (C) 2004-2005, Ambarella, Inc.
 *
 * All rights reserved. No Part of this file may be reproduced, stored
 * in a retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Ambarella, Inc.
 */

#ifndef __HY27US08561M_H__
#define __HY27US08561M_H__

#define __NAND_HY27US08561M_CONTROL						  \
	(NAND_CTR_IE		|				  \
	 NAND_CTR_CC		|				  \
	 NAND_CTR_SZ_256M	|				  \
	 NAND_CTR_WD_8BIT)

#define NAND_HY27US08561M_MANID		0xad
#define NAND_HY27US08561M_DEVID		0x75
#define NAND_HY27US08561M_ID3		0x00
#define NAND_HY27US08561M_ID4		0x00

/**
 * define for device info
 */
#define NAND_HY27US08561M_MAIN_SIZE		512
#define NAND_HY27US08561M_SPARE_SIZE		16
#define NAND_HY27US08561M_PAGE_SIZE		528
#define NAND_HY27US08561M_PAGES_PER_BLOCK	32
#define NAND_HY27US08561M_BLOCKS_PER_PLANE	1024
#define NAND_HY27US08561M_BLOCKS_PER_ZONE	1024
#define NAND_HY27US08561M_BLOCKS_PER_BANK	2048
#define NAND_HY27US08561M_PLANES_PER_BANK	(NAND_HY27US08561M_BLOCKS_PER_BANK / NAND_HY27US08561M_BLOCKS_PER_PLANE)
#define NAND_HY27US08561M_BANKS_PER_DEVICE	1
#define NAND_HY27US08561M_TOTAL_BLOCKS	(NAND_HY27US08561M_BLOCKS_PER_BANK * NAND_HY27US08561M_BANKS_PER_DEVICE)
#define NAND_HY27US08561M_TOTAL_ZONES	(NAND_HY27US08561M_TOTAL_BLOCKS / NAND_HY27US08561M_BLOCKS_PER_ZONE)
#define NAND_HY27US08561M_TOTAL_PLANES	(NAND_HY27US08561M_TOTAL_BLOCKS / NAND_HY27US08561M_BLOCKS_PER_PLANE)

/* Copyback must be in the same plane, so we have to know the plane address */
#define NAND_HY27US08561M_BLOCK_ADDR_BIT	14
#define NAND_HY27US08561M_PLANE_ADDR_BIT	24
#define NAND_HY27US08561M_PLANE_MASK		0x1
/* Used to mask the plane address according to block address in the same bank */
#define NAND_HY27US08561M_PLANE_ADDR_MASK	(NAND_HY27US08561M_PLANE_MASK << (NAND_HY27US08561M_PLANE_ADDR_BIT - \
						     NAND_HY27US08561M_BLOCK_ADDR_BIT))

#define NAND_HY27US08561M_PLANE_MAP		NAND_HY27US08561M_PLANE_MAP_2
#define NAND_HY27US08561M_COLUMN_CYCLES	1
#define NAND_HY27US08561M_PAGE_CYCLES	2
#define NAND_HY27US08561M_ID_CYCLES		2
#define NAND_HY27US08561M_CHIP_WIDTH		8
#define NAND_HY27US08561M_CHIP_SIZE_MB	32
#define NAND_HY27US08561M_BUS_WIDTH		8

#define NAND_HY27US08561M	"HYNIX HY27US08561M_32MB_PG512"

#if defined(CONFIG_NAND__1DEVICE)
#define NAND__DEVICES		1
#elif defined(CONFIG_NAND__2DEVICE)
#define NAND__DEVICES		2
#elif defined(CONFIG_NAND__4DEVICE)
#define NAND__DEVICES		4
#endif

#define NAND_HY27US08561M_TOTAL_BANKS	(NAND__DEVICES * NAND_HY27US08561M_BANKS_PER_DEVICE)

#if (NAND_HY27US08561M_TOTAL_BANKS == 1)
#define NAND_HY27US08561M_CONTROL		(__NAND_HY27US08561M_CONTROL | NAND_CTR_1BANK)
#elif (NAND_HY27US08561M_TOTAL_BANKS == 2)
#define NAND_HY27US08561M_CONTROL		(__NAND_HY27US08561M_CONTROL | NAND_CTR_2BANK)
#elif (NAND_HY27US08561M_TOTAL_BANKS == 4)
#define NAND_HY27US08561M_CONTROL		(__NAND_HY27US08561M_CONTROL | NAND_CTR_4BANK)
#elif (NAND_HY27US08561M_TOTAL_BANKS > 4)
#error Unsupport nand flash banks
#endif

#define NAND_HY27US08561M_BB_MARKER_OFFSET	5	/* bad block information */

/**
 * define for partition info
 */
#define NAND_HY27US08561M_RSV_BLKS_PER_ZONE	24

/**
 * timing parameter in ns
 */
#define NAND_HY27US08561M_TCLS		0
#define NAND_HY27US08561M_TALS		0
#define NAND_HY27US08561M_TCS		0
#define NAND_HY27US08561M_TDS		20
#define NAND_HY27US08561M_TCLH		10
#define NAND_HY27US08561M_TALH		10
#define NAND_HY27US08561M_TCH		10
#define NAND_HY27US08561M_TDH		10
#define NAND_HY27US08561M_TWP		25
#define NAND_HY27US08561M_TWH		15
#define NAND_HY27US08561M_TWB		100
#define NAND_HY27US08561M_TRR		20
#define NAND_HY27US08561M_TRP		30
#define NAND_HY27US08561M_TREH		15
#define NAND_HY27US08561M_TRB		100
#define NAND_HY27US08561M_TCEH		100
#define NAND_HY27US08561M_TRDELAY		35	/* trea*/
#define NAND_HY27US08561M_TCLR		10
#define NAND_HY27US08561M_TWHR		60
#define NAND_HY27US08561M_TIR		0
#define NAND_HY27US08561M_TWW		25	/* not define */
#define NAND_HY27US08561M_TRHZ		30	/* use max value */
#define NAND_HY27US08561M_TAR		50

#endif

