/*
 * Copyright (c) 2009 Wind River Systems, Inc.
 * Tom Rix <Tom.Rix@windriver.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * This work is derived from the linux 2.6.27 kernel source
 * To fetch, use the kernel repository
 * git://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux-2.6.git
 * Use the v2.6.27 tag.
 *
 * Below is the original's header including its copyright
 *
 *  linux/arch/arm/plat-omap/gpio.c
 *
 * Support functions for OMAP GPIO
 *
 * Copyright (C) 2003-2005 Nokia Corporation
 * Written by Juha Yrjölä <juha.yrjola@nokia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef _GPIO_H
#define _GPIO_H

#define DM814X_GPIO_REVISION		0x0000
#define DM814X_GPIO_SYSCONFIG		0x0010
#define DM814X_GPIO_MODCTRL		0x0130
#define DM814X_GPIO_OE				0x0134
#define DM814X_GPIO_DATAIN		0x0138
#define DM814X_GPIO_DATAOUT		0x013c
#define DM814X_GPIO_LEVELDETECT0	0x0140
#define DM814X_GPIO_LEVELDETECT1	0x0144
#define DM814X_GPIO_RISINGDETECT	0x0148
#define DM814X_GPIO_FALLINGDETECT	0x014c
#define DM814X_GPIO_DEBOUNCE_EN	0x0150
#define DM814X_GPIO_DEBOUNCE_VAL	0x0154
#define DM814X_GPIO_CLEARIRQENABLE1	0x0160
#define DM814X_GPIO_SETIRQENABLE1	0x0164
#define DM814X_GPIO_CLEARWKUENA	0x0180
#define DM814X_GPIO_SETWKUENA		0x0184
#define DM814X_GPIO_CLEARDATAOUT	0x0190
#define DM814X_GPIO_SETDATAOUT	0x0194

#define DM814X_GPIO0_BASE		0x48032000
#define DM814X_GPIO1_BASE		0x4804C000
#define DM814X_GPIO2_BASE		0x481AC000
#define DM814X_GPIO3_BASE		0x481AE000


struct gpio_bank {
	void *base;
	int method;
};

#define METHOD_GPIO_44XX	5

/* This is the interface */

/* Request a gpio before using it */
int omap_request_gpio(int gpio);
/* Reset and free a gpio after using it */
void omap_free_gpio(int gpio);
/* Sets the gpio as input or output */
void omap_set_gpio_direction(int gpio, int is_input);
/* Set or clear a gpio output */
void omap_set_gpio_dataout(int gpio, int enable);
/* Get the value of a gpio input */
int omap_get_gpio_datain(int gpio);

#endif /* _GPIO_H_ */
