/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * Copyright (C) 2001  Erik Mouw (J.A.K.Mouw@its.tudelft.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307	 USA
 *
 */

#include <common.h>
#include <command.h>
#include <image.h>
#include <u-boot/zlib.h>
#include <asm/byteorder.h>
#include <exports.h>
#include <osa_types.h>
DECLARE_GLOBAL_DATA_PTR;

extern LOG_SysPara gLogParam;
#if defined (CONFIG_SETUP_MEMORY_TAGS) || \
    defined (CONFIG_CMDLINE_TAG) || \
    defined (CONFIG_INITRD_TAG) || \
    defined (CONFIG_SERIAL_TAG) || \
    defined (CONFIG_REVISION_TAG)
static void setup_start_tag (bd_t *bd);

# ifdef CONFIG_SETUP_MEMORY_TAGS
static void setup_memory_tags (bd_t *bd);
# endif

# ifdef CONFIG_BOOTPARA_TAGS
static void setup_bootpara_tag(bd_t * bd);
# endif

static void setup_commandline_tag (bd_t *bd, char *commandline);

# ifdef CONFIG_INITRD_TAG
static void setup_initrd_tag (bd_t *bd, ulong initrd_start,
			      ulong initrd_end);
# endif
static void setup_end_tag (bd_t *bd);

void setup_mtd_partition_tag(bd_t *bd);

#ifdef CONFIG_PLAT_AMBARELLA_A5S
static void setup_bsb_mem_tag(bd_t *bd);
static void setup_dsp_mem_tag(bd_t *bd);
static void setup_tag_revision(u32 rev);
static void setup_hal_tag(u32 pstart, u32 size, u32 vstart);
static int  UBOOT_getDspMemMap(const char *pCmdLine);
#endif

static struct tag *params;
#endif /* CONFIG_SETUP_MEMORY_TAGS || CONFIG_CMDLINE_TAG || CONFIG_INITRD_TAG */

extern int fpga_start(void);
extern int get_partinfo(struct boot_mtd_partition *mtd_parts, u32 offset);
static int LOG_setupTag(bd_t *bd);
extern Int32 LOG_drvRamParaGet(void);

int do_bootm_linux(int flag, int argc, char *argv[], bootm_headers_t *images)
{
	bd_t	*bd = gd->bd;
	char	*s;
	int	machid = bd->bi_arch_number;
	void	(*theKernel)(int zero, int arch, uint params);
#ifdef CONFIG_TI8148_IPNC
    unsigned char mac_addr[6];
	fpga_start();//add by rdb
	if (eth_getenv_enetaddr("ethaddr", mac_addr)) {
		cpsw_set_mac1_regs(mac_addr);
	}//liu_hc
#endif

#ifdef CONFIG_CMDLINE_TAG
	char *commandline = getenv ("bootargs");
#endif

	if ((flag != 0) && (flag != BOOTM_STATE_OS_GO))
		return 1;

	theKernel = (void (*)(int, int, uint))images->ep;

	s = getenv ("machid");
	if (s) {
		machid = simple_strtoul (s, NULL, 16);
		printf ("Using machid 0x%x from environment\n", machid);
	}

#ifdef CONFIG_PARTS
	/* ӷϢжȡϢ󱣻gt->mtd_parts */
    gd->mtd_parts = malloc(sizeof(struct boot_mtd_partition) * PART_NUM);
    if (gd->mtd_parts == NULL)
    {
        printf("fail to malloc mte_parts\n");
        return 1;
    }
    memset(gd->mtd_parts, 0, sizeof(sizeof(struct boot_mtd_partition) * PART_NUM));
    if (get_partinfo(gd->mtd_parts, PARTITION_DATA_OFFSET))
    {
        printf("fail to get partinfo\n");
    }
#endif

	show_boot_progress (15);

	debug ("## Transferring control to Linux (at address %08lx) ...\n",
	       (ulong) theKernel);

#if defined (CONFIG_SETUP_MEMORY_TAGS) || \
    defined (CONFIG_CMDLINE_TAG) || \
    defined (CONFIG_INITRD_TAG) || \
    defined (CONFIG_SERIAL_TAG) || \
    defined (CONFIG_REVISION_TAG)
	setup_start_tag (bd);
#ifdef CONFIG_SERIAL_TAG
	setup_serial_tag (&params);
#endif
#ifdef CONFIG_REVISION_TAG
	setup_revision_tag (&params);
#endif
#ifdef CONFIG_SETUP_MEMORY_TAGS
	setup_memory_tags (bd);
#endif
#ifdef CONFIG_BOOTPARA_TAGS
	setup_bootpara_tag(bd);
#endif
#ifdef CONFIG_CMDLINE_TAG
	setup_commandline_tag (bd, commandline);
#endif
#ifdef CONFIG_INITRD_TAG
	if (images->rd_start && images->rd_end)
		setup_initrd_tag (bd, images->rd_start, images->rd_end);
#endif

#ifdef CONFIG_PARTS	
    setup_mtd_partition_tag(bd);
#endif

#ifdef CONFIG_PLAT_AMBARELLA_A5S
    s = getenv("DspMem");
    if (s)
    {
        UBOOT_getDspMemMap(s);
    }
    setup_bsb_mem_tag(bd);
	setup_dsp_mem_tag(bd);
	setup_tag_revision(0x13ec300a);
	setup_hal_tag(0xc00a0000,0x0000e708, 0xfee00000);
#endif

    LOG_drvRamParaGet();
    LOG_setupTag(bd);
	setup_end_tag (bd);
#endif

	/* we assume that the kernel is in place */
	printf ("\nStarting kernel ... \n");

#ifdef CONFIG_USB_DEVICE
	{
		extern void udc_disconnect (void);
		udc_disconnect ();
	}
#endif

	cleanup_before_linux ();

	theKernel (0, machid, bd->bi_boot_params);
	/* does not return */

	return 1;
}

#ifdef CONFIG_PARTS	
/* ϢתtagϢ */
void setup_mtd_partition_tag(bd_t *bd)
{
    int i = 0;
    struct boot_mtd_partition *mtd_parts;
    
    params->hdr.tag = ATAG_MTD_PARTITION;
    params->hdr.size = tag_size (tag_mtd_partition);
        
    mtd_parts = gd->mtd_parts;

    for (i=0; i<PART_NUM; i++)
    {
        if (!mtd_parts[i].name[0])
        {
            break;
        }

        memcpy(&params->u.mtd_part.parts[i], &mtd_parts[i], 
            sizeof(struct boot_mtd_partition));
    }
    params->u.mtd_part.part_num = i;
    
    params = tag_next (params);
}
#endif
/*******************************************************************************
*   : LOG_setupTag
*     : ڴݸں˵LOGʼַС
*     : - bd:
*     : 
* ֵ  : OSA_SOK  : ɹ
*           OSA_EFAIL: ʧ
*******************************************************************************/
static int LOG_setupTag(bd_t *bd)
{

    params->hdr.tag         = ATAG_LOG;
    params->hdr.size        = (sizeof(LOG_SysPara) 
                              + sizeof(struct tag_header)) >> 2;
    params->u.logPara.start = gLogParam.start;
    params->u.logPara.size  = gLogParam.size;
    params = tag_next(params);

    return OSA_SOK;
}

#if defined (CONFIG_SETUP_MEMORY_TAGS) || \
    defined (CONFIG_CMDLINE_TAG) || \
    defined (CONFIG_INITRD_TAG) || \
    defined (CONFIG_SERIAL_TAG) || \
    defined (CONFIG_REVISION_TAG)
static void setup_start_tag (bd_t *bd)
{
	params = (struct tag *) bd->bi_boot_params;

    memset(params, 0, 4096);
	params->hdr.tag = ATAG_CORE;
	params->hdr.size = tag_size (tag_core);

	params->u.core.flags = 0;
	params->u.core.pagesize = 0;
	params->u.core.rootdev = 0;

	params = tag_next (params);
}


#ifdef CONFIG_SETUP_MEMORY_TAGS
static void setup_memory_tags (bd_t *bd)
{
	int i;

	for (i = 0; i < CONFIG_NR_DRAM_BANKS; i++) {
		params->hdr.tag = ATAG_MEM;
		params->hdr.size = tag_size (tag_mem32);

		params->u.mem.start = bd->bi_dram[i].start;
		params->u.mem.size = bd->bi_dram[i].size;

		params = tag_next (params);
	}
}
#endif /* CONFIG_SETUP_MEMORY_TAGS */

#ifdef CONFIG_BOOTPARA_TAGS

static int string_to_hex(const unsigned char *s,unsigned char *out,int base,int num)
{
	int i;
	char *end;
	for (i = 0; i < num; ++i) {	/* turn string into mac value */
			out[i]= s ? simple_strtoul (s, &end, base) : 0;
			if (s)
				s = (*end) ? end + 1 : end;
		}
	return 0;
}

static void setup_bootpara_tag(bd_t *bd)
{
	char *env;
	int len;
	
	params->hdr.tag = ATAG_BOOTPARA;
	memset(&params->u.bootpara,0,sizeof(params->u.bootpara));
	params->hdr.size = tag_size (tag_bootpara);
	env = getenv("appauto");
	if (env)
		params->u.bootpara.appauto = simple_strtoul(env,NULL,10);
	env = getenv("dh_keyboard");
	if (env)
		params->u.bootpara.dh_keyboard = simple_strtoul(env,NULL,10);

	env = getenv("ethaddr");
	if (env){
		string_to_hex(env,params->u.bootpara.ethaddr0,16,6);
	}

	env = getenv("ethaddr1");
	if (env){
		string_to_hex(env,params->u.bootpara.ethaddr1,16,6);
	}

	env = getenv("ipaddr");
	if (env){
		string_to_hex(env,params->u.bootpara.lip0,10,4);
	}

	env = getenv("ipaddr1");
	if (env){
		string_to_hex(env,params->u.bootpara.lip1,10,4);
	}
	
	env = getenv("ID");
	if (env)
		strncpy((char *)&params->u.bootpara.id,env,32);//bootpara.id is unsigned char *

	/*husj @2012-hwid*/
	env = getenv("HWID");
	if(env){
		len = strlen(env);
		if(len > sizeof(params->u.bootpara.hwid))
			len = sizeof(params->u.bootpara.hwid);

		strncpy((char *)&params->u.bootpara.hwid, env, len);
	}
	
	/*hujg@2012.05.22*/
	env = getenv("loglevel");
	if(env){
		len = strlen(env);
		if(len > sizeof(params->u.bootpara.loglevel))
			len = sizeof(params->u.bootpara.loglevel);

		strncpy((char *)&params->u.bootpara.loglevel, env, len);
	}

	env = getenv("wifiaddr");
	if (env)
	{
        string_to_hex(env,params->u.bootpara.wifiAddr,16,6);
	}
	params = tag_next (params);
}
#endif

static void setup_commandline_tag (bd_t *bd, char *commandline)
{
	char *p;
    char *pEnv;
    char *pMemStart;
    char *pMemEnd = NULL;
    char *pTmp;

	if (!commandline)
		return;

	/* eat leading white space */
	for (p = commandline; *p == ' '; p++);

	/* skip non-existent command lines so the kernel will still
	 * use its default command line.
	 */
	if (*p == '\0')
		return;

    pEnv = getenv("SysMem");
    if (pEnv)
    {        
        pTmp = params->u.cmdline.cmdline;
        pMemStart = strstr(commandline, "mem=");
        if (pMemStart)
        {
            pMemEnd = strstr(pMemStart, " ");
        }

        if (pMemEnd)
        {
            strncpy(pTmp, p, pMemStart - p);
            pTmp[pMemStart - p] = '\0';
            strcat(pTmp, pMemEnd + 1);
        }
        else
        {
            strcpy(pTmp, p);
        }

        strcat(pTmp, " mem=");
        strcat(pTmp, pEnv);
        /* printf("cmdline:%s\n",params->u.cmdline.cmdline); */
    }
    else
    {
        strcpy (params->u.cmdline.cmdline, p);
    }
    
	params->hdr.tag = ATAG_CMDLINE;
	params->hdr.size = (sizeof (struct tag_header) 
		               + strlen (params->u.cmdline.cmdline) + 1 + 4) >> 2;
	params = tag_next (params);
}


#ifdef CONFIG_INITRD_TAG
static void setup_initrd_tag (bd_t *bd, ulong initrd_start, ulong initrd_end)
{
	/* an ATAG_INITRD node tells the kernel where the compressed
	 * ramdisk can be found. ATAG_RDIMG is a better name, actually.
	 */
	params->hdr.tag = ATAG_INITRD2;
	params->hdr.size = tag_size (tag_initrd);

	params->u.initrd.start = initrd_start;
	params->u.initrd.size = initrd_end - initrd_start;

	params = tag_next (params);
}
#endif /* CONFIG_INITRD_TAG */

#ifdef CONFIG_SERIAL_TAG
void setup_serial_tag (struct tag **tmp)
{
	struct tag *params = *tmp;
	struct tag_serialnr serialnr;
	void get_board_serial(struct tag_serialnr *serialnr);

	get_board_serial(&serialnr);
	params->hdr.tag = ATAG_SERIAL;
	params->hdr.size = tag_size (tag_serialnr);
	params->u.serialnr.low = serialnr.low;
	params->u.serialnr.high= serialnr.high;
	params = tag_next (params);
	*tmp = params;
}
#endif

#ifdef CONFIG_REVISION_TAG
void setup_revision_tag(struct tag **in_params)
{
	u32 rev = 0;
	u32 get_board_rev(void);

	rev = get_board_rev();
	params->hdr.tag = ATAG_REVISION;
	params->hdr.size = tag_size (tag_revision);
	params->u.revision.rev = rev;
	params = tag_next (params);
}
#endif  /* CONFIG_REVISION_TAG */


static void setup_end_tag (bd_t *bd)
{
	params->hdr.tag = ATAG_NONE;
	params->hdr.size = 0;
}

#endif /* CONFIG_SETUP_MEMORY_TAGS || CONFIG_CMDLINE_TAG || CONFIG_INITRD_TAG */


#ifdef CONFIG_PLAT_AMBARELLA_A5S

/*******************************************************************************
*   : UBOOT_getDspMemMap
*     : ȡDSPڴֲ
*     : - pCmdLine:bootargs
*     : 
* ֵ  : OSA_SOK  : ɹ
*           OSA_EFAIL: ʧ
*******************************************************************************/
static int UBOOT_getDspMemMap(const char *pCmdLine)
{
    char         *pDsp;
    char         *pBsb;
    char         *pEnd;
    unsigned int dspMemStart;
    unsigned int dspMemSize = 0;
    unsigned int bsbMemStart;
    unsigned int bsbMemSize = 0;

    pDsp = strstr(pCmdLine, "DSP=");
    pBsb = strstr(pCmdLine, "BSB=");

    /* ҲزʹĬֵ */
    if ( !pDsp || !pBsb)
    {
        return 0;
    }

    pDsp += strlen("DSP=");
    pBsb += strlen("BSB=");
    dspMemStart = simple_strtoul(pDsp, &pEnd, 16);
    if ( pEnd && '\0' != pEnd[0] )
    {
        pDsp        = pEnd + 1;
        dspMemSize  = simple_strtoul(pDsp, &pEnd, 16);
    }

    
    bsbMemStart = simple_strtoul(pBsb, &pEnd, 16);
    if ( pEnd && '\0' != pEnd[0] )
    {
        pBsb        = pEnd + 1;
        bsbMemSize  = simple_strtoul(pBsb, &pEnd, 16);
    }

    if ( !dspMemStart || !dspMemSize || !bsbMemStart || !bsbMemSize )
    {
        printf("param error\n");
        return -1;
    }
    
    gd->bd->bi_dsp_ram[0].start = dspMemStart;
    gd->bd->bi_dsp_ram[0].size  = dspMemSize;
    gd->bd->bi_bsb_ram[0].start = bsbMemStart;
    gd->bd->bi_bsb_ram[0].size  = bsbMemSize;

    return 0;
    
}

static void setup_bsb_mem_tag(bd_t *bd)
{
	params->hdr.tag = ATAG_AMBARELLA_BSB;
	params->hdr.size = tag_size(tag_mem32);

	params->u.mem.start = gd->bd->bi_bsb_ram[0].start;
	params->u.mem.size = gd->bd->bi_bsb_ram[0].size;

	params = tag_next(params);
}

static void setup_dsp_mem_tag(bd_t *bd)
{
	params->hdr.tag = ATAG_AMBARELLA_DSP;
	params->hdr.size = tag_size(tag_mem32);

	params->u.mem.start = gd->bd->bi_dsp_ram[0].start;
	params->u.mem.size = gd->bd->bi_dsp_ram[0].size;

	params = tag_next(params);
}


static void setup_hal_tag(u32 pstart, u32 size, u32 vstart)
{
	params->hdr.tag = ATAG_AMBARELLA_HAL;
	params->hdr.size = tag_size(tag_ramdisk);

	params->u.ramdisk.start = pstart;
	params->u.ramdisk.size = size;
	params->u.ramdisk.flags = vstart;

	params = tag_next(params);
}

static void setup_tag_revision(u32 rev)
{
	params->hdr.tag = ATAG_REVISION;
	params->hdr.size = tag_size(tag_revision);

	params->u.revision.rev = rev;

	params = tag_next(params);
}
#endif

