/*
 * Copyright (C) 2009, Texas Instruments, Incorporated
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#include <common.h>
#include <net.h>
#include <miiphy.h>
#include <netdev.h>
#include <asm/io.h>
#include <configs/ambarella_a5s_ipc.h>

#include <config.h>
#include <asm/arch/ambhw/chip.h>
#include <asm/arch/basedef.h>
#include <asm/arch/ambhw/eth.h>
#include <asm/arch/ambhw/intvec.h>
#include <asm/arch/ambhw/uart.h>
#include <asm/arch/ambhw/wdog.h>
#include <asm/arch/hal/hal.h>
#include <asm/arch/bldfunc.h>
#include <asm/arch/ambhw/rct/a5s.h>
 
extern void rct_reset_chip(void);
extern int a5s_base_init(void);
extern int amb_eth_register(struct amb_eth_platform_data * data);
extern int load_run_boot(void);
extern int amb_gpio_direction_input(int gpio);
extern int amb_gpio_direction_output(int gpio, int value);
extern int amb_gpio_get_value(int gpio);
extern int amb_gpio_set_value(int gpio, int value);
extern int amb_gpio_set(int gpio);
extern int amb_gpio_clear(int gpio);
extern int miiphy_link (char *devname, unsigned char addr);
void hw_watchdog_init(void);

DECLARE_GLOBAL_DATA_PTR;

/* TODO : Check for the board specific PHY */
static int amb_phy_init(char *name, int addr)
{  
    unsigned short reg;
    int retry = 30;
    u16 phy_id1, phy_id2;  

    if (!miiphy_link(name,addr))
    {
        amb_gpio_direction_output(PHY_RESET_PIN,0);
        udelay(5*1000);
        amb_gpio_direction_output(PHY_RESET_PIN,1);
        miiphy_read (name, addr, PHY_BMCR, &reg);
        reg &= ~(PHY_BMCR_ISO);
        miiphy_write (name, addr, PHY_BMCR, reg |PHY_BMCR_RESET | PHY_BMCR_POWD);
        while(retry--)
        {
            miiphy_read (name, addr, PHY_BMCR, &reg);
            if (!(reg & PHY_BMCR_RESET))
            {
                break;
            }
            udelay(10*1000);
        }
        
        reg &= ~(PHY_BMCR_POWD | PHY_BMCR_ISO);
        miiphy_write (name, addr, PHY_BMCR, reg);  
    }

    /* ֻreg2=0x22reg3[4~9] = 0x11, Ψһʾphy 8041
      *޸0x16ĴԼСѹͷѹԽʹðֵ߳Ķ
      */
    miiphy_read (name, addr, PHY_PHYIDR1, &phy_id1);
    miiphy_read (name, addr, PHY_PHYIDR2, &phy_id2);
    if((phy_id1 == 0x22) &&
        (((phy_id2 >> 4) & 0x3F) == 0x11))
    {
        miiphy_read (name, addr, PHY_PCSR, &reg);
        reg |= 1 << 7;
        miiphy_write (name, addr, PHY_PCSR, reg);           
    } 
    
    return 0;
}

void reset_cpu(unsigned long addr)
{
    amb_gpio_clear(GPIO_RESET);
    udelay(50);
    rct_reset_chip();
    while(1);
    return;
}

int board_init(void)
{
    gd->bd->bi_boot_params = 0xc0000000 + 0x00200100; 
    gd->bd->bi_arch_number = MACH_TYPE_COCONUT;
    a5s_base_init();
    //if(readl(WDOG_TIMEOUT_REG) && 0x01)
    //    reset_cpu(0);
    load_run_boot();
    icache_enable();
 
#ifdef ENABLE_FAST_BOOT
    u32 delay = 50;
    timer_init();
    while(--delay){
        if ((*((unsigned char *)0x70005014) &0x01))
        {
            break; 
        }
        udelay(1000);
    }
    if (!delay)
        a5s_nand_boot(0,1);
#endif
	return 0;
}

int print_cpuinfo(void)
{
	return 0;
}

int dram_init (void)
{
    gd->bd->bi_dram[0].start = PHYS_DRAM_1 + 0x200000;
    gd->bd->bi_dram[0].size = PHYS_DRAM_1_SIZE - 0x200000;

    gd->bd->bi_dsp_ram[0].start = PHYS_DSP_1;
    gd->bd->bi_dsp_ram[0].size = PHYS_DSP_1_SIZE;
    gd->bd->bi_bsb_ram[0].start = PHYS_BSB_1;
    gd->bd->bi_bsb_ram[0].size = PHYS_BSB_1_SIZE;
	return 0;
}

static struct amb_eth_platform_data amb_eth_data = {
	.mac_base		= ETH_BASE,
	.irq            = ETH_IRQ,
	.mac_addr       = {0x00,0x12,0x34,0x56,0x78,0x9A},
	.phy_init		= amb_phy_init,
	.host_port_num		= 0,
};

int board_eth_init(bd_t *bis)
{
    u8 macAddr[6];
    u8 macString[18];

    if (eth_getenv_enetaddr("ethaddr", macAddr))
    {
        memcpy(&amb_eth_data.mac_addr,macAddr,sizeof(macAddr));
    }
    else
    {
        printf("Caution:using static MACID!! Set <ethaddr> variable\n");
        /*⵽macַǷûãͽеĬmacַȥ*/
        sprintf(macString, "%02x:%02x:%02x:%02x:%02x:%02x",
            amb_eth_data.mac_addr[0], amb_eth_data.mac_addr[1], 
            amb_eth_data.mac_addr[2], amb_eth_data.mac_addr[3],
            amb_eth_data.mac_addr[4], amb_eth_data.mac_addr[5]);
        setenv("ethaddr", macString);
    }

    printf("Detected MACID:%02x:%02x:%02x:%02x:%02x:%02x\n",
        amb_eth_data.mac_addr[0], amb_eth_data.mac_addr[1], 
        amb_eth_data.mac_addr[2], amb_eth_data.mac_addr[3],
        amb_eth_data.mac_addr[4], amb_eth_data.mac_addr[5]);
    return amb_eth_register(&amb_eth_data);
}

static int do_hal_init(cmd_tbl_t * cmdtp,int flag, int argc, char *argv[])
{ 
    amb_gpio_clear(GPIO_RESET);
    a5s_base_init();
    return 0;
}

int do_gpio(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    int dir;
    int count = 0;
    int delay = 200*1000;
    int gio_num;
    int value;
    if(argc <3){
        printf("usage:gpio num value");
        return -1;
    }

    dir = argv[1][0];  

    gio_num = simple_strtoul(argv[2],NULL,10);

    if (dir == 'r')
    {
        if (argc >=4)
        {
            count = simple_strtoul(argv[3],NULL,10);
        }

        if (argc >=5)
        {
            delay = simple_strtoul(argv[4],NULL,10) * 1000;
        }    
        amb_gpio_direction_input(gio_num);
        delay = delay << 1;
        do
        {        	
            printf("gpio%d:%d\n",gio_num,amb_gpio_get_value(gio_num));
            udelay(delay);
        }while((--count) > 0);
        return 0;
    }

    if (argc >=5)
    {
        count = simple_strtoul(argv[4],NULL,10);
    }

    if (argc >=6)
    {
        delay = simple_strtoul(argv[5],NULL,10) * 1000;
    }    
    value = simple_strtoul(argv[3],NULL,10);

    amb_gpio_direction_output(gio_num, value);
    while(count)
    {
        amb_gpio_clear(gio_num); 
        udelay(delay); 
        amb_gpio_set(gio_num);
        udelay(delay);
        count--;
    }
    amb_gpio_set_value(gio_num, value);
    
    return 0;
};


#if 0
extern void __nand_calculate_ecc(const unsigned char *buf, unsigned int eccsize,
                       unsigned char *code);

int do_ecc(cmd_tbl_t * cmdtp, int flag, int argc, char *argv[])
{
    unsigned char ecc[3];
    int i = simple_strtoul(argv[3],NULL,16);
    int size = simple_strtoul(argv[2],NULL,16);
    unsigned char *buff = (unsigned char *)simple_strtoul(argv[1],NULL,16);
    for (; i ; i--){
        __nand_calculate_ecc(buff,size,ecc);
        printf("ecc:%02x %02x %02x\n",ecc[0] ,ecc[1] ,ecc[2]);
        buff +=size;
    }
    return 0;
}
#endif


U_BOOT_CMD(
	hal, 2, 0,	do_hal_init,
	"Perform RESET of the CPU",
	""
);

U_BOOT_CMD(
	gpio, 6, 1,	do_gpio,
	"gpio test",
	""
);

#if 0
U_BOOT_CMD(
	ecc, 4, 1,	do_ecc,
	"ecc offset",
	""
);
#endif

