/*******************************************************************************
 * cmd_bootLog.c
 *
 * Copyright (C) 2011-2013 ZheJiang Dahua Technology CO.,LTD.
 *
 * Author : fangqipin <fang_qipin@dahuatech.com>
 * Version: V1.0.0  201385 Create
 *
 * Description: 
 *
 *       1. Ӳ˵
 *          ޡ
 *
 *       2. ṹ˵
 *          ޡ
 *
 *       3. ʹ˵
 *          ޡ
 *
 *       4. ˵
 *          ޡ
 *
 *       5. ˵
 *          ޡ
 *
 * Modification: 
 *    Date     : 
 *    Revision :
 *    Author   :
 *    Contents :
 *******************************************************************************/



/* ========================================================================== */
/*                             ͷļ                                       */
/* ========================================================================== */
#include <common.h>
#include <osa_types.h>
#include <linux/string.h>

/* ========================================================================== */
/*                           Ͷ                                   */
/* ========================================================================== */

#define LOGMEMSIZE      (512 * 1024)
#define LOGFLAGSIZE     (4   * 1024)
#define LOGBOOTSIZE     (16  * 1024)
#define LOGKERNELSIZE   (256 * 1024)
#define LOGMSGSIZE      (128)
#define LOGINDEXMAX     (LOGBOOTSIZE / LOGMSGSIZE)

#define LOG_INDEX_MAGIC (0x54410011)
#define CRASH_LOSTPOWER (0x01)

/* ========================================================================== */
/*                          ݽṹ                                    */
/* ========================================================================== */

typedef struct
{
    Uint32 rIndex;
    Uint32 wIndex;
}LOG_BufIndex;


typedef struct
{
    Uint32 crashFlag; /* 쳣־ */
    Uint32 logMagic; /* ڼϵħ */
    LOG_BufIndex bootBufIndex; /* boot־д */
    LOG_BufIndex osBufIndex; /* ϵͳ־д */
    Uint32 reserved[2];
}LOG_Index;



/* ========================================================================== */
/*                                                                  */
/* ========================================================================== */



/* ========================================================================== */ 
/*                          ȫֱ                                    */ 
/* ========================================================================== */ 

LOG_SysPara gLogParam;

DECLARE_GLOBAL_DATA_PTR;

/* ========================================================================== */ 
/*                                                                  */ 
/* ========================================================================== */
 

/*******************************************************************************
*   : LOG_drvRamParaGet
*     : 
*     : - cmdline:
*     : 
* ֵ  : OSA_SOK  : ɹ
*           OSA_EFAIL: ʧ
*******************************************************************************/
Int32 LOG_drvRamParaGet(void)
{   
    LOG_Index *pLogIndex = NULL;

    Char *pCmdline      = NULL;
    Char *pTr           = NULL;
    Char *pAddr         = NULL;
    Char *pMemAddr      = NULL;
    Char *pName         = "mem";
    Char tmpBuf[256];
    Uint32 memSize      = 0;
    struct tag *pTag;
 
    pTag = (struct tag *) gd->bd->bi_boot_params;
    if ( NULL == pTag )
    {
        return OSA_EFAIL;
    }

    for (; pTag && pTag->hdr.size; pTag = tag_next(pTag))
    {
        if (ATAG_CMDLINE == pTag->hdr.tag)
        {
            pCmdline = pTag->u.cmdline.cmdline;
            break;
        }
    }

    if ( pCmdline== NULL )
    {
        return OSA_EFAIL;
    }

    for(pTr = pCmdline; *pTr == ' '; pTr++);

    if(*pTr == '\0')
    {
        return OSA_SOK;
    }

    pAddr = strstr((const char *)pTr ,(const char *)pName);
    if(pAddr == NULL)
    {
        printf("can not find mem in bootargs.\n");
        return OSA_EFAIL;
    }
    
    memset(tmpBuf, 0, sizeof(tmpBuf));
    pAddr = pAddr + 4;
    memcpy(tmpBuf, pTr, (pAddr - pTr));
    memSize= simple_strtoul((const char *)pAddr, NULL, 0) * (1024*1024UL);
    pMemAddr = strstr((const char*)pAddr, "M");
    if(pMemAddr == NULL)
    {
        return OSA_EFAIL;
    }
    pMemAddr = pMemAddr + 1;
    gLogParam.start = gd->bd->bi_dram[0].start + memSize - LOGMEMSIZE;
    gLogParam.size  = LOGMEMSIZE;

    pLogIndex = (LOG_Index *)gLogParam.start;

    if(LOG_INDEX_MAGIC != pLogIndex->logMagic)
    {
        pLogIndex->crashFlag    = CRASH_LOSTPOWER;
        pLogIndex->logMagic     = LOG_INDEX_MAGIC;
        pLogIndex->osBufIndex.rIndex = 0;
        pLogIndex->osBufIndex.wIndex = 0;
        printf("crashflasg:%x, logmagic:%x.\n", 
               pLogIndex->crashFlag,
               pLogIndex->logMagic);
    }
    else
    {
        pLogIndex->crashFlag    &= (~CRASH_LOSTPOWER); 
    }
    
    return OSA_SOK;
}

#if 0
/*******************************************************************************
*   : LOG_drvRamWrite
*     : һЩؼboot logϢд뵽boot log
*     : - printbuf:дboot log; 
*     : 
* ֵ  : OSA_SOK  : ɹ
*           OSA_EFAIL: ʧ
*******************************************************************************/
Int32 LOG_drvRamWrite(Char *printBuf)
{

    Uint32 *pWriteIndex   = NULL;

    if(printBuf == NULL)
    {   
        return OSA_EFAIL;
    }
    
    pWriteIndex = (u32 *)(gLogMemStart + LOGBOOTREAD);
    strcpy((char *)(gLogBootStart + gLogWriteIndex*LOGMSGSIZE), 
           (char *)printBuf);

    gLogWriteIndex++;

    if(gLogWriteIndex == LOGINDEXMAX)
    {
        gLogWriteIndex = 0;
    }
    
    *pWriteIndex = gLogWriteIndex;

    return OSA_SOK;
}
#endif

