/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * Cache support: switch on or off, get status
 */
#include <common.h>
#include <command.h>


#if 0

#define INVERT_CLK_OUT              0x0
#define WR_RATIO 					0x00000018
#define RD_DQS_RATIO				0x00000028
#define DQS_GATE                    0xF8
#define CMD_SLAVE_RATIO             0x80 
#define DDR_START_ADDR 0x80000000
#define LA_EXP 0 /* DDR is the source and OCMC is destination*/
#define ODT_EXP 1
#define NUM_BURST 2016*1
#define MAX_PATTERN 8*NUM_BURST
#define RD_ITER 1
#define DATA_PATTERN 0
#define DATA_ZERO 0


#endif
#define DDR_START_ADDR 0x81000000
//#define NUM_BURST 2016*1
#define NUM_BURST   (2016 * 1)
#define MAX_PATTERN 8*NUM_BURST
#define WR_MEM_32(a, d) (*(volatile int*)(a) = (d))
#define RD_MEM_32(a) (*(volatile int*)(a))

#define FIFO_RST_ERR_CNT0 0x481980c4
#define FIFO_RST_ERR_CLR0 0x481980c0
#define FIFO_RST_ERR_CNT1 0x48198168
#define FIFO_RST_ERR_CLR1 0x48198164
#define FIFO_RST_ERR_CNT2 0x4819820c
#define FIFO_RST_ERR_CLR2 0x48198208
#define FIFO_RST_ERR_CNT3 0x481982b0
#define FIFO_RST_ERR_CLR3 0x481982ac


unsigned long pattern[MAX_PATTERN];
unsigned long sample[MAX_PATTERN];

unsigned err_total, err_b3, err_b2, err_b1, err_b0,z=0, m0=0, m1=0, m2=0, m3=0;
unsigned data0_dll_out_b_wr=0, data1_dll_out_b_wr=0, data2_dll_out_b_wr=0, data3_dll_out_b_wr=0;
unsigned data0_dll_out_a_rd=0, data1_dll_out_a_rd=0, data2_dll_out_a_rd=0, data3_dll_out_a_rd=0;
void dma_configure(unsigned long* start_addr, unsigned long* end_addr, unsigned len);
void DDRMemClr(unsigned int DDR_ADDR);
void EdmaPrcm();
void DdrDataInit();
void dma_configure(unsigned long* start_addr, unsigned long* end_addr, unsigned len)
{
  int read_data;
  int done = 0;

  /*prcm configuration - enable tpcc/tptc*/

  /* DMA configuration */
  WR_MEM_32(0x49000284, 0x00000000);
  WR_MEM_32(0x49000284, 0x00000000);
  WR_MEM_32(0x49000340, 0x00000001);
  WR_MEM_32(0x49000240, 0x00000000);
  WR_MEM_32(0x49000100, 0x00000000);
  WR_MEM_32(0x49004000, 0x00100200);
  WR_MEM_32(0x49004004, (unsigned long)start_addr);
  WR_MEM_32(0x4900400c, (unsigned long)end_addr);
  WR_MEM_32(0x49004008, 0x00010000 | (len * 4)); /* byte len */
  WR_MEM_32(0x4900401c, 0x00000001);
  WR_MEM_32(0x49004010, 0x00000000);
  WR_MEM_32(0x49004018, 0x00000000);
  WR_MEM_32(0x49004014, 0x0000ffff);
  WR_MEM_32(0x49002060, 0x00000001);
  WR_MEM_32(0x49002010, 0x00000001);

  while( (RD_MEM_32(0x49002068)&0x1) !=1 ) {}
  WR_MEM_32(0x49002070, 0x1);  
}

void fill_pattern()
{
	int i;
	unsigned b;
	
	for(i=0; i<MAX_PATTERN; i++){
		b = i & 0xff;
		pattern[i] = (b << 24) | (b << 16) | (b << 8) | (b << 0); 
		//pattern[i]  =0xAAAAAAAA;
		//pattern[i+1]=0x55555555;
		  //pattern[i]=0xFFFFFFFF;
	}

}

void mem_clr(void)
{
	int i;
	
	for(i=0; i<MAX_PATTERN; i++){
		sample[i] = 0x0; 
		//pattern[i]  =0xAAAAAAAA;
		//pattern[i+1]=0x55555555;
		  //pattern[i]=0xFFFFFFFF;
	}

}

void report_err_cnt()
{
	printf("Err Cnt %2d,%2d,%2d,%2d\n", RD_MEM_32(FIFO_RST_ERR_CNT0), RD_MEM_32(FIFO_RST_ERR_CNT1), RD_MEM_32(FIFO_RST_ERR_CNT2),  RD_MEM_32(FIFO_RST_ERR_CNT3));
    	
}

void clear_err_cnt()
{
	WR_MEM_32(FIFO_RST_ERR_CLR3, 1);
	WR_MEM_32(FIFO_RST_ERR_CLR3, 0); 
	WR_MEM_32(FIFO_RST_ERR_CLR2, 1);
	WR_MEM_32(FIFO_RST_ERR_CLR2, 0); 
	WR_MEM_32(FIFO_RST_ERR_CLR1, 1);
	WR_MEM_32(FIFO_RST_ERR_CLR1, 0); 
	WR_MEM_32(FIFO_RST_ERR_CLR0, 1);
	WR_MEM_32(FIFO_RST_ERR_CLR0, 0); 
}

#define ERROR_LOOP(b) \
{ \
	ddr_addr = DDR_START_ADDR + i*4; \
	prev_data = RD_MEM_32(ddr_addr -4); \
	this_data = RD_MEM_32(ddr_addr); \
	next_data = RD_MEM_32(ddr_addr+4); \
	printf("ERR %8x : byte %32d : exp : %8x : got : %8x : prev %8x : this %8x : next %8x\n",  \
	   ddr_addr, b, pattern[i], sample[i], prev_data, this_data, next_data);\
	ddr_addr = DDR_START_ADDR + i*4; \
	next_data = RD_MEM_32(ddr_addr+4); \
	this_data = RD_MEM_32(ddr_addr); \
	prev_data = RD_MEM_32(ddr_addr -4); \
	printf("RPT %8x : byte %32d : exp : %8x : got : %8x : prev %8x : this %8x : next %8x\n",  \
	   ddr_addr, b, pattern[i], sample[i], prev_data, this_data, next_data);\
	report_err_cnt(); \
}

void compare_pattern()
{
	int i;
	unsigned long ddr_addr, prev_data, this_data, next_data;
	z++;
	

	if( (m0==16) || (m1==16) || (m2==16) || (m3==16)) {
      while(1);
	  }

	for(i=0; i<MAX_PATTERN; i++){
		if(sample[i] != pattern[i]){
			err_total++;
			if(((sample[i] >> 24) & 0xff) != ((pattern[i] >> 24) & 0xff)){
				err_b3++;
				z=0;
				    m3++;
					while(1){}
					ERROR_LOOP(3);
				    //WR_MEM_32(0x481980D4, RD_DQS_RATIO+m3);
    				//WR_MEM_32(0x481980D0, 0x00000001);
   
    				/* rd dqs gate */
    				/* dqs gate - byte lane 3 */
    				//WR_MEM_32(0x48198114, DQS_GATE+m3);
    				//WR_MEM_32(0x48198110, 0x00000001);
                    /* break; */
    								
			}
			if(((sample[i] >> 16) & 0xff) != ((pattern[i] >> 16) & 0xff)){
				z=0;
				err_b2++;
				    m2++;
					while(1){}
					ERROR_LOOP(2);
				   // WR_MEM_32(0x48198178, RD_DQS_RATIO+m2);
    				//WR_MEM_32(0x48198174, 0x00000001);

					//WR_MEM_32(0x481981B8, DQS_GATE+m2);
   	 				//WR_MEM_32(0x481981B4, 0x00000001);
					/* break; */
				    			}
			if(((sample[i] >>  8) & 0xff) != ((pattern[i] >>  8) & 0xff)){
				z=0;
				err_b1++;
				    m1++;
					while(1){}
					ERROR_LOOP(1);
				    //WR_MEM_32(0x4819821C, RD_DQS_RATIO+m1);
    				//WR_MEM_32(0x48198218, 0x00000001);
    				
    				//WR_MEM_32(0x4819825C, DQS_GATE+m1);
    				//WR_MEM_32(0x48198258, 0x00000001); 
					/* break; */
			}
			if(((sample[i] >>  0) & 0xff) != ((pattern[i] >>  0) & 0xff)){
				z=0;
				err_b0++;
				    m0++;
					while(1){}
					ERROR_LOOP(0);
					//WR_MEM_32(0x481982C0, RD_DQS_RATIO+m0);
    			    //WR_MEM_32(0x481982BC, 0x00000001);

    				/* dqs gate - byte lane 0 */
    			//	WR_MEM_32(0x48198300, DQS_GATE);
   	 				//WR_MEM_32(0x481982FC, 0x00000001);

					/* break; */
			}
		}
	}
}



void DDRMemClr(unsigned int DDR_ADDR) {
unsigned int i=0;

  for(i=0; i<MAX_PATTERN; i++){
     WR_MEM_32(DDR_ADDR + 4*i, 0x0);
     }


}

void EdmaPrcm() {
  WR_MEM_32(0x481815f4,0x00000002);
  while((RD_MEM_32(0x481815f4)&0x2) !=0x2 ){}

  WR_MEM_32(0x481815f8,0x00000002);
  while((RD_MEM_32(0x481815f8)&0x2) !=0x2 ){}

}

void DdrDataInit() {
unsigned int i=0;
int *ddrval0  = (int *)DDR_START_ADDR;
	   for(i=0; i<MAX_PATTERN; i=i+2) {
	   ddrval0[i]=0xAAAAAAAA;
       ddrval0[i+1]=0x55555555;
	   }

}


/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  main( )                                                                 *
 *                                                                          *
 * ------------------------------------------------------------------------ */
int do_edma_test(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
#if 1
	int i;
       err_total = 0;
	
	EdmaPrcm(); /*Enable TC0, CC*/

	fill_pattern();

	unsigned long addr = DDR_START_ADDR;

	while(1) {
    //  DdrDataInit();
	 // err_b3 = err_b2 = err_b1 = err_b0 = 0;
	//  data0_dll_out_b_wr=RD_MEM_32(0x48198148);
	  //data1_dll_out_b_wr=RD_MEM_32(0x481981EC);
	 // data2_dll_out_b_wr=RD_MEM_32(0x48198290);
	//  data3_dll_out_b_wr=RD_MEM_32(0x48198334);
      dma_configure(pattern, (unsigned long*)addr, MAX_PATTERN);
      dma_configure((unsigned long*)addr, sample, MAX_PATTERN);

	  addr += MAX_PATTERN * 4;
	  if(addr >= 0xa0000000)
	  	addr = DDR_START_ADDR;
	  
	//  data0_dll_out_a_rd=RD_MEM_32(0x48198148);
	 // data1_dll_out_a_rd=RD_MEM_32(0x481981EC);
	//  data2_dll_out_a_rd=RD_MEM_32(0x48198290);
	 // data3_dll_out_a_rd=RD_MEM_32(0x48198334);
	  compare_pattern();
	  DDRMemClr(addr);
	mem_clr();
   	  printf("addr = 0x%x, read %2d : err total %6d b3 %6d b2 %6d b1 %6d b0 %6d  m3=%6d m2=%6d m1=%6d m0=%6d\n", addr, z, err_total, err_b3, err_b2, err_b1, err_b0, m3, m2, m1, m0);
	  }
    
     printf("===== DONE =====\n");

#endif 
    
//    SW_BREAKPOINT;
}




U_BOOT_CMD(
	emtest, 3, 1,	do_edma_test,
	"start application at address 'addr'",
	"addr [arg ...]\n    - start application at address 'addr'\n"
	"      passing 'arg' as arguments"
);


