/*******************************************************************************
 * cmd_smi.c
 *
 * Copyright (C) 2011-2013 ZheJiang Dahua Technology CO.,LTD.
 *
 * Author :  <chen_shibo@dahuatech.com>
 * Version: V1.0.0  2014312 Create
 *
 * Description: ֧SMI
 *
 *       1. Ӳ˵
 *          ޡ
 *
 *       2. ṹ˵
 *          ޡ
 *
 *       3. ʹ˵
 *          ޡ
 *
 *       4. ˵
 *          ޡ
 *
 *       5. ˵
 *          ޡ
 *
 * Modification: 
 *    Date     : 
 *    Revision :
 *    Author   :
 *    Contents :
 *******************************************************************************/
#include <common.h>
#include <command.h>
#include <miiphy.h>

/*******************************************************************************
*   : SMI_cmdProcess
*     : Ӧbootsmi
*     : - cmdtp :
*         : - flag  :
*         : - argc  :
*         : - argv[]:
*     : 
* ֵ  : OSA_SOK  : ɹ
*           OSA_EFAIL: ʧ
*******************************************************************************/
int SMI_cmdProcess (cmd_tbl_t *pCmdTb, int flag, int argc, char *pArgv[])
{
	unsigned char	addr  = 0;
    unsigned char   reg   = 0;
	unsigned short	data  = 0;
    unsigned short  value = 0;
	char		    *pDev = NULL;

	if (argc < 2) 
    {
		cmd_usage(pCmdTb);
		return 1;
	}

    if (argc >= 3)
    {
	    addr = simple_strtoul(pArgv[2], NULL, 16);
    }
    
	if (argc >= 4)
    {   
	    reg = simple_strtoul(pArgv[3], NULL, 16);
    }

    if (argc >= 5)
    {
	    value = simple_strtoul(pArgv[4], NULL, 16);
    }

#if defined(CONFIG_MII_INIT)
	mii_init();
#endif

	

	/* use current device */
	pDev = miiphy_get_current_dev();

    if (0 == strcmp("read", pArgv[1])) 
    {        
		if (SMI_read(pDev, addr, reg, &data) != 0)
        {
			printf("Error read from the PHY addr=%02x reg=%02x\n", addr, reg);
		} 
        else 
		{ 
		    printf("%04X\n", data & 0x0000FFFF);
		}
	} 
    else if (0 == strcmp("write", pArgv[1])) 
    {
        if (0 != SMI_write(pDev, addr, reg, value))
        {
            printf("Write reg fail addr=%02x reg=%02x\n", addr, reg);
        }
	} 
    else if (0 == strcmp("readphy", pArgv[1])) 
    {

        if (0 != SMI_readPhy(pDev, addr, reg, &data))
        {
            printf("Read phy reg fail addr=%02x reg=%02x\n", addr, reg);
        }
        else
        {
            printf("%04X\n", data & 0x0000FFFF);
        }
    }
    else if (0 == strcmp("writephy", pArgv[1])) 
    {
        if (0 != SMI_writePhy(pDev, addr, reg, value))
        {
            printf("Write phy reg fail addr=%02x reg=%02x\n", addr, reg);
        }
    }
    else
    {
        printf("not support\r\n");
    }

	return 0;
}

/***************************************************/

U_BOOT_CMD(
	smi,	5,	1,	SMI_cmdProcess,
	"MII utility commands",
	"device                     - list available devices\n"
	"mii device <devname>           - set current device\n"
	"mii info   <addr>              - display MII PHY info\n"
	"mii read   <addr> <reg>        - read  MII PHY <addr> register <reg>\n"
	"mii write  <addr> <reg> <data> - write MII PHY <addr> register <reg>\n"
	"mii dump   <addr> <reg>        - pretty-print <addr> <reg> (0-5 only)\n"
	"Addr and/or reg may be ranges, e.g. 2-7."
);
