/*
 * (C) Copyright 2008
 * Stuart Wood, Lab X Technologies <stuart.wood@labxtechnologies.com>
 *
 * (C) Copyright 2004
 * Jian Zhang, Texas Instruments, jzhang@ti.com.

 * (C) Copyright 2000-2006
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * (C) Copyright 2001 Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Andreas Heppel <aheppel@sysgo.de>

 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/* #define DEBUG */

#include <common.h>
#include <command.h>
#include <malloc.h>
#include <spi.h>
#include <../tools/tiimage.h>
#include <spi_flash.h>
#include <exports.h>
#include <nand.h>

#define UBOOT_MAGIC ('D'<<24 | 'H'<<16 | 'U'<<8 | 'B' <<0)

struct amb_image_header{
        unsigned int magic;
        unsigned int version; 
        unsigned int size;
        unsigned int entry;
        unsigned int load;
        unsigned int data_crc32; 
        char name[32];
        unsigned int header_crc32; 
        char reserved[4];
}__attribute__ ((__packed__));

struct amb_image{
    struct amb_image_header node[16];
    
    unsigned int node_count;
    unsigned int header_crc32;
    unsigned int data_crc32;
    unsigned int data_size;
    unsigned int version; 
    unsigned int image_magic;
    
    char pad_to_2k[2048 - sizeof(struct amb_image_header)*16 - sizeof(int)*6];
}__attribute__ ((__packed__));

#if 0
static void swap_arry(unsigned int *p,unsigned int len)
{
	int i = 0;
	if ((unsigned int)p&0x03){
		printf("address not valid\n");
		return;
	}
	for (i = 0;i<len;i+=4){
		*p = __swab32(*p);
		p++;
	}
	return;
}
#endif

#ifdef CONFIG_NAND
int do_sync_uboot(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
//    int i;
//    int size;
//    unsigned int head_crc32;
    struct amb_image aimg;
    struct amb_image aimg_bak;
    nand_info_t *nand;
    size_t length;
    loff_t offset;
    unsigned char *data  = (unsigned char *)CONFIG_SYS_LOAD_ADDR;
    unsigned int crc;
    unsigned char *boot_from = (unsigned char *)BOOT_FROM;

    if (nand_curr_device < 0)
    {
        nand_init();
    }
    
    nand = &nand_info[nand_curr_device];
    if (!nand)
    {
        return -1;
    }

    if(((*boot_from)>>4) == 2)
    {
        length = sizeof(aimg);
        nand_read_skip_bad(nand, UBOOT_OFFSET, &length, (u8 *)(&aimg)); 
        length = sizeof(aimg_bak);
        nand_read_skip_bad(nand, UBOOT_BAK_OFFSET, &length, (u8 *)(&aimg_bak));
        crc = aimg.header_crc32;
        aimg.header_crc32 = 0;
        if (aimg.image_magic != UBOOT_MAGIC)
        {
            printf("error magic:%08x\n",aimg.image_magic);
            return -1;
        }
        
        aimg.header_crc32 = crc32(0,(const char *)(&aimg),  sizeof(aimg) );
        if (aimg.header_crc32!= crc)//Ӧ÷Ӳ
        {
            printf("magic:%08x,crc:%08x\n",aimg.image_magic,aimg.header_crc32);
            printf("crc:%08x\n",crc);
            printf("waring u-boot destory\n"); 
            return -1;
        }

        if (likely(memcmp(&aimg,&aimg_bak,sizeof(aimg)) == 0)){//just cmp head
            return 0;
        }
        

        length = aimg.data_size + sizeof(aimg);
        nand_read_skip_bad(nand, UBOOT_OFFSET, &length, data); 
        crc = crc32(0,data + sizeof(aimg), aimg.data_size); 
        if (crc != aimg.data_crc32)
        { 
            printf("waring! crc32:%08x,crc32 calc:%08x\n",aimg.data_crc32,crc);//Ӧ÷ 
            return -1;
        }

        printf("sync....");
        offset = UBOOT_BAK_OFFSET;
        for (;offset < UBOOT_OFFSET;)
        {//erase
            length = nand->erasesize;
            if (nand_block_isbad (nand, offset & ~(nand->erasesize - 1))) {
                //printf ("Skip bad block 0x%08llx\n",offset);
                offset += nand->erasesize; 
                continue;
            } 
            nand_erase(nand,offset,nand->erasesize);
            offset += nand->erasesize;
        }

        offset = UBOOT_BAK_OFFSET;
        length = aimg.data_size + sizeof(aimg);
        memset(data,0xff,sizeof(aimg));
        nand_write_skip_bad(nand, offset, &length, data);
        offset = UBOOT_BAK_OFFSET;
        length = sizeof(aimg);
        nand_write_skip_bad(nand, offset, &length, (u8 *)&aimg);
        //printf("\nupdate uboot-bak  to ver:0x%08x succeed\n",aimg.version);
        printf("end\n");
    }
    return 0;
}
#else
int do_sync_uboot(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	struct spi_flash *flash_cs0 = 0;
	struct uboot_header ubh;
	struct uboot_image *ubm = (struct uboot_image *)0;
	unsigned int *boot_from = (unsigned int *)BOOT_FROM;
	char *buf_uboot;
	char *buf_uboot_bak;
	char buf_ubh[sizeof(struct uboot_header)];
	int ret;
	unsigned int uboot_size;
	int i;

	if (*boot_from != 0x01){
		return 0;
	}
	
	flash_cs0 = spi_flash_probe(0, 0, CONFIG_SF_DEFAULT_SPEED, 3);
	if (!flash_cs0) {
		printf("Failed to initialize SPI flash at %u:%u\n", 0, 0);
		return 1;
	}


	buf_uboot = (char *)_armboot_start;
	buf_uboot_bak = malloc(sizeof(struct uboot));
	
	if (!buf_uboot_bak){
		printf("malloc failed\n");
		free(buf_uboot_bak);
		return 1;
	}
	
	ret = spi_flash_read(flash_cs0, (u32)&ubm->uboot_img[1], sizeof(ubh), &ubh);
	if (ret){
		ret = -1;
		goto err;
	}

	uboot_size = be32_to_cpu(ubh.uboot_size);

	ret = spi_flash_read(flash_cs0,(u32)&ubm->uboot_img[1].uboot_head,sizeof(buf_ubh),buf_ubh);
	ret = spi_flash_read(flash_cs0, (u32)&ubm->uboot_img[0].uboot_head, sizeof(buf_ubh), buf_uboot_bak);
	if (memcmp(buf_ubh,buf_uboot_bak,sizeof(buf_ubh)) == 0){//right?
		ret = 0;
		goto out;
	}
	
	ret = spi_flash_read(flash_cs0, (u32)&ubm->uboot_img[0].uboot_bin, uboot_size, buf_uboot_bak);
	if (ret){
		debug("read uboot_bak fail\n");
		ret = -1;
		goto err;
	}
	
	if (memcmp(buf_uboot,buf_uboot_bak,uboot_size) == 0){
		ret = 0;
		goto out;
	}
	printf("sync.......\n");

    ret = spi_flash_protect(flash_cs0, 0);//un-protect
    if (ret){
		debug("unprotect err\n");
		ret = -1;
		goto err;
	}

	ret = spi_flash_erase(flash_cs0,(u32)&ubm->uboot_img[0],sizeof(ubm->uboot_img[0]));
	if (ret){
		debug("erase err\n");
		ret = -1;
		goto err;
	}
	
	ret = spi_flash_write(flash_cs0,(u32)&ubm->uboot_img[0].uboot_bin,uboot_size,buf_uboot);
	if (ret){
		debug("write uboot_bak fail\n");
		ret = -1;
		goto err;
	}

	ret = spi_flash_write(flash_cs0,(u32)&ubm->uboot_img[0],sizeof(ubh),&ubh);
	if (ret){
		debug("write uboot_bak header fail\n");
		ret = -1;
		goto err;
	}

    //re-protect in protect_boot_sector in board.c
	printf("update uboot-bak  to ver:0x%08x succeed\n",be32_to_cpu(ubh.version));
err:
out:
	free(buf_uboot_bak);
	spi_flash_free(flash_cs0);
	return  ret;
}

/*protect U-Boot-min sector*/
#define BOOT_PROTECT_LEN   0x40000
int protect_boot_sector(void)
{
	struct spi_flash *flash_cs0 = 0;
	int ret;
	
	flash_cs0 = spi_flash_probe(0, 0, CONFIG_SF_DEFAULT_SPEED, 3);
	if (!flash_cs0) {
		printf("Failed to initialize SPI flash at %u:%u\n", 0, 0);
		return -1;
	}
	
	ret = spi_flash_protect(flash_cs0, BOOT_PROTECT_LEN);
	if (ret) {
		printf("SPI flash protect failed\n");
		return -1;
	}
	
	if(flash_cs0)
		spi_flash_free(flash_cs0);

	return 0;
}


#endif

U_BOOT_CMD(
	sync_uboot,	1,	1,	do_sync_uboot,
	"sync_uboot - sync uboot to uboot-bak\n",
);
