/*
 * (C) Copyright 2000-2002
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * (C) Copyright 2001 Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Andreas Heppel <aheppel@sysgo.de>
 *
 * (C) Copyright 2008 Atmel Corporation
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
#include <common.h>
#include <environment.h>
#include <malloc.h>
#include <spi_flash.h>

#ifndef CONFIG_ENV_SPI_BUS
# define CONFIG_ENV_SPI_BUS	0
#endif
#ifndef CONFIG_ENV_SPI_CS
# define CONFIG_ENV_SPI_CS		0
#endif
#ifndef CONFIG_ENV_SPI_MAX_HZ
# define CONFIG_ENV_SPI_MAX_HZ	75000000
#endif
#ifndef CONFIG_ENV_SPI_MODE
# define CONFIG_ENV_SPI_MODE	SPI_MODE_3
#endif

DECLARE_GLOBAL_DATA_PTR;

// --> liu_hongcong 20110810
#ifdef CONFIG_DVR_CMD
extern int default_environment_size;

#define MAC_ADDR_STR_LEN  17  /* length of mac address as string */
typedef struct restore_data
{
     char ethaddr[18];
     char product_id[32];
     char hwid[16];// liu_hongcong@20110121 buffer overflow
	 char sip[16];
	 char lip[16];
 	 char netmask[16];
	 char gateway[16];
     char r_flag[2];
}restore_t;
#endif
// <-- liu_hongcong 20110810


/* references to names in env_common.c */
extern uchar default_environment[];

char * env_name_spec = "SPI Flash";
env_t *env_ptr;

static struct spi_flash *env_flash;

uchar env_get_char_spec(int index)
{
	return *((uchar *)(gd->env_addr + index));
}


/*******************************************************************************
*     : flash_write_check
*       : дFlashУ
*       : pFlash:   FlashоƬƽṹ
*             offset:   дFlashеƫ
*             len   :   дݳ
*             pBuf  :   д
*       : 
*  ֵ   : ~0:   ʧ
*              0:   ɹ
*******************************************************************************/
static int flash_write_check(struct spi_flash *pFlash, u32 offset,
		                     size_t len, const void *pBuf)
{
    int ret = 0;
	char *pReadBuf;

    pReadBuf = malloc(len);
    if (!pReadBuf)
    {
        return -1;
    }

	ret = spi_flash_write(pFlash, offset, len, pBuf);
	if (ret)
	{
        ret = -1;
        goto exit_out;
	}
    
    ret = spi_flash_read(pFlash, offset, len, pReadBuf);
    if (ret)
    {
        ret = -1;
        goto exit_out;
    }

    ret = memcpy(pBuf, pReadBuf, len);
    if (ret)
    {
        ret = -1;
        goto exit_out;
    }

exit_out:
   free(pReadBuf);
   return ret;
}


int saveenv(void)
{
	u32 saved_size, saved_offset;
	char *saved_buffer = NULL;
	u32 sector = 1;
	int ret;

	if (!env_flash) {
		puts("Environment SPI flash not initialized\n");
		return 1;
	}

	/* Is the sector larger than the env (i.e. embedded) */
	if (CONFIG_ENV_SECT_SIZE > CONFIG_ENV_SIZE) {
		saved_size = CONFIG_ENV_SECT_SIZE - CONFIG_ENV_SIZE;
		saved_offset = CONFIG_ENV_OFFSET + CONFIG_ENV_SIZE;
		saved_buffer = malloc(saved_size);
		if (!saved_buffer) {
			ret = 1;
			goto done;
		}
		ret = spi_flash_read(env_flash, saved_offset, saved_size, saved_buffer);
		if (ret)
			goto done;
	}

	if (CONFIG_ENV_SIZE > CONFIG_ENV_SECT_SIZE) {
		sector = CONFIG_ENV_SIZE / CONFIG_ENV_SECT_SIZE;
		if (CONFIG_ENV_SIZE % CONFIG_ENV_SECT_SIZE)
			sector++;
	}

	puts("Erasing SPI flash...\n");
	ret = spi_flash_erase(env_flash, CONFIG_ENV_OFFSET, sector * CONFIG_ENV_SECT_SIZE);
	if (ret)
		goto done;

    /* дFlashУ飬д³쳣ݶʧ */
	puts("Writing to SPI flash...\n");
	ret = flash_write_check(env_flash, CONFIG_ENV_OFFSET, CONFIG_ENV_SIZE, env_ptr);
	if (ret)
		goto done;

	if (CONFIG_ENV_SECT_SIZE > CONFIG_ENV_SIZE) {
		ret = flash_write_check(env_flash, saved_offset, saved_size, saved_buffer);
		if (ret)
			goto done;
	}

	ret = 0;
	puts("done\n");

 done:
	if (saved_buffer)
		free(saved_buffer);
	return ret;
}

void env_relocate_spec(void)
{
	int ret;
//	--> liu_hongcong 20110810
#ifdef CONFIG_DVR_CMD
	char *s;
	restore_t *restore;
	char *id = NULL;
	char *hwid = NULL;
	char *sip = NULL;
	char *lip = NULL;
	char *mac = NULL;
	char *tmp = NULL;
#endif
//	<-- liu_hongcong 20110810

	env_flash = spi_flash_probe(CONFIG_ENV_SPI_BUS, CONFIG_ENV_SPI_CS,
			CONFIG_ENV_SPI_MAX_HZ, CONFIG_ENV_SPI_MODE);
	if (!env_flash)
		goto err_probe;

	ret = spi_flash_read(env_flash, CONFIG_ENV_OFFSET, CONFIG_ENV_SIZE, env_ptr);
	if (ret)
		goto err_read;
	
	if (crc32(0, env_ptr->data, ENV_SIZE) != env_ptr->crc)
		goto err_crc;

	gd->env_valid = 1;
// --> liu_hongcong 20110810
#ifdef CONFIG_DVR_CMD
	DECLARE_GLOBAL_DATA_PTR;
	gd->env_addr = env_ptr->data;


#ifdef CONFIG_IPNC_BOOT
	env_get_fpga_name(NULL);
#endif
	
	s = getenv("restore");
	if (s && strcmp(s, "1") == 0)	// need to restore environment
	{
		if (!(restore = malloc(sizeof(restore_t))))
		{
			printf("malloc restore_t fail\n");
			return;
		}
		memset(restore, 0, sizeof(restore_t));
		
		if ((id = getenv("ID")))
		{
			strncpy(restore->product_id, id, sizeof(restore->product_id) - 1);
		}
		else
		{
			strcpy(restore->product_id, "000000000000000000");
		}

		if ((mac = getenv("ethaddr")))
		{
			strncpy(restore->ethaddr, mac, sizeof(restore->ethaddr) - 1);
		}
		else
		{
			strcpy(restore->ethaddr, "ff:ff:ff:ff:ff:ff");
		}

		if ((hwid = getenv("HWID")))
		{
			strncpy(restore->hwid, hwid, sizeof(restore->hwid) - 1);
		}
		else
		{
			strcpy(restore->hwid, "00000000000000");
		}

		if ((sip = getenv("serverip")))
		{
			strncpy(restore->sip, sip, sizeof(restore->sip) - 1);
		}
		else
		{
			strcpy(restore->sip, "255.255.255.255");
		}
		
		if ((lip = getenv("ipaddr")))
		{
			strncpy(restore->lip, lip, sizeof(restore->lip) - 1);
		}
		else
		{
			strcpy(restore->lip, "255.255.255.255");
		}

		if ((tmp = getenv("gatewayip")))
		{
			strncpy(restore->gateway, tmp, sizeof(restore->gateway) - 1);
		}
		else
		{
			strcpy(restore->gateway, "255.255.255.255");
		}
		
		if ((tmp = getenv("netmask")))
		{
			strncpy(restore->netmask, tmp, sizeof(restore->netmask) - 1);
		}
		else
		{
			strcpy(restore->netmask, "255.255.255.255");
		}
		
		strcpy(restore->r_flag, "0");
		
		// restore the data
		memcpy(env_ptr->data, default_environment, default_environment_size);
		
		setenv("ethaddr", restore->ethaddr);
		setenv("ID", restore->product_id);
		setenv("HWID", restore->hwid);
		setenv("serverip", restore->sip);
		setenv("ipaddr", restore->lip);
		setenv("netmask", restore->netmask);
		setenv("gatewayip", restore->gateway);
		setenv("restore", restore->r_flag);  // clear restore flag
		
		env_crc_update();
		saveenv();
		free(restore);
	}
#endif /* CONFIG_DVR_CMD */
//	<-- liu_hongcong 20110810

	return;

err_read:
	spi_flash_free(env_flash);
	env_flash = NULL;
err_probe:
err_crc:
	puts("*** Warning - bad CRC, using default environment\n\n");

	set_default_env();
}

int env_init(void)
{
	/* SPI flash isn't usable before relocation */
	gd->env_addr = (ulong)&default_environment[0];
	gd->env_valid = 1;

	return 0;
}
