/*******************************************************************************
* crypt.h
*
* Copyright (C) 2011-2013 ZheJiang Dahua Technology CO.,LTD.
*
* Author : Wang Haifeng <wang_haifeng@dahuatech.com>
* Version: V1.0.0  2013-3-2 Create
*
* Description: ṩܿؼܽӿڣڶļܿboot ںˡ
*       1.  Ӳ˵
*           ڼAT88SCоƬ
*
*       2.  ṹ˵
*
*       3.  ʹ˵
*
*       4.  ˵
*
*       5.  ˵
*           ͷļ ܿ⡢BootkernelģС
* 
* Modification:
*    Date    :   2013-3-2
*    Revision:   
*    Author  :   wang haifeng
*    Contents:
*******************************************************************************/

#ifndef __CRYPTO_H__
#define __CRYPTO_H__


#ifdef __cplusplus
extern "C" {
#endif


/* ========================================================================== */
/*                           ͷļ                                         */
/* ========================================================================== */


/* ========================================================================== */
/*                           Ͷ                                   */
/* ========================================================================== */


/* ========================================================================== */
/*                          ݽṹ                                    */
/* ========================================================================== */

typedef struct 
{
	/***************************************************************************
	*  : OpGetChipId
	*    : ȡоƬIDţIDŷΪkey1key2飬ȡʹĬֵ
	*    : -key_len   :key1key2ĳ
	*    : -pKey1     :IDŵһ
	*          -pKey2     :IDŵһ
	* ֵ : -0 : success 
	*          -1 : failed	
	***************************************************************************/
	int (*OpGetChipId)(unsigned char *pKey1, 
	                   unsigned char *pKey2, 
	                   unsigned int   keyLen);
	
	
	/***************************************************************************
	*  : OpInitGpio
	*    : оƬĽӿڳʼ
	*    : -
	*    : -
	* ֵ : -0 : success 
	*          -1 : failed	
	***************************************************************************/
	int  (*OpInitGpio)(void);
	
	
	/***************************************************************************
	*  : OpSetScl
	*    : оƬSCL1
	*    : -
	*    : -
	* ֵ : -
	***************************************************************************/
	void (*OpSetScl)(void);
	
	
	/***************************************************************************
	*  : OpClrScl
	*    : оƬSCL0
	*    : -
	*    : -
	* ֵ : -
	***************************************************************************/
	void (*OpClrScl)(void);
	
	
	/***************************************************************************
	*  : OpSetSda
	*    : оƬSDA1
	*    : -
	*    : -
	* ֵ : -
	***************************************************************************/
	void (*OpSetSda)(void);
	
	
	/***************************************************************************
	*  : OpClrSda
	*    : оƬSDA0
	*    : -
	*    : -
	* ֵ : -
	***************************************************************************/
	void (*OpClrSda)(void);
	
	
	/***************************************************************************
	*  : OpSetSdaIn
	*    : оƬSDAΪ
	*    : -
	*    : -
	* ֵ : -
	***************************************************************************/
	void (*OpSetSdaIn)(void);
	
	
	/***************************************************************************
	*  : OpReadSda
	*    : ȡоƬSDA
	*    : -
	*    : -
	* ֵ : -01
	***************************************************************************/
	int (*OpReadSda)(void);
	
	
	/***************************************************************************
	*  : OpUdelay
	*    : ΢ʱ
	*    : -us  :΢
	*    : -
	* ֵ : -01
	***************************************************************************/
	void (*OpUdelay)(unsigned long us);
	
	
	/***************************************************************************
	*  : OpMalloc
	*    : ڴ
	*    : -len :
	*    : -
	* ֵ : -01
	***************************************************************************/
	void * (*OpMalloc)(unsigned int len);
	
	
	/***************************************************************************
	*  : OpFree
	*    : ͷڴ
	*    : -ptr : Ҫͷŵڴָ
	*    : -
	* ֵ : -01
	***************************************************************************/
	void (*OpFree)(void *pMemPtr);
	
	                         
	void *reserved[21];
} CRYPT_Operations;



/* ========================================================================== */
/*                                                                  */
/* ========================================================================== */


/******************************************************************************
*  : CRYPT_setChipOps
*    : оƬ
* ֵ : -0 : success 
*          -1 : failed	
******************************************************************************/
int CRYPT_setChipOps(CRYPT_Operations* pOps);


/******************************************************************************
*  : CRYPT_fireToChip
*    : dataݽмܣȻдоƬС
*    : -pData    :Ҫд
*          -dataLen  :Ҫдݳ

*    : -
* ֵ : -0 : success 
*          -1 : failed	
******************************************************************************/
int CRYPT_fireToChip(void *pData, unsigned int dataLen);


/******************************************************************************
*  : CRYPT_readFromChip
*    : ӼоƬжȡϢuserеݺͳȡ
*    : -userZone :Ҫܵķ
*    : -pData    :user(ٳҪڵ32ֽ)
*          -pDataLen :userݵʵʳ
* ֵ : -0 : success 
*          -1 : failed	
******************************************************************************/
int CRYPT_readFromChip(unsigned int   userZone, 
                       unsigned char *pData, 
                       unsigned int  *pDataLen);

/******************************************************************************
*  : CRYPT_authenticate
*    : ֤ǷͨоƬ֤
* ֵ : -0 : success 
*          -1 : failed	
******************************************************************************/
int CRYPT_authenticate(void);


#ifdef __cplusplus
}
#endif


#endif	/* __CRYPTO_H__ */

