#ifndef _AMBIMAGE_H_
#define _AMBIMAGE_H_
/* Offset from start of PTB */
#define PTB_BST_MAGIC_OFFSET 24
#define PTB_BLD_LEN_OFFSET   68
#define PTB_BLD_MAGIC_OFFSET 80

/* Offset from start of PTB META */
#define META_BLD_SBLK_OFFSET 32
#define META_BLD_NBLK_OFFSET 36


#define PART_LOAD		0x0		/**< Load partition data */
#define PART_NO_LOAD		0x1		/**< Don't load part data */
#define PART_COMPRESSED		0x2		/**< Data is not compressed */
#define PART_READONLY		0x4		/**< Data is RO */
#define PART_INCLUDE_OOB	0x8		/**< Data include oob info*/
#define PART_ERASE_APARTS	0x10		/**< Erase Android partitions */

#define FLPART_MAGIC	0x8732dfe6
#define PARTHD_MAGIC	0xa324eb90


typedef struct flpart_s
{
	unsigned int	crc32;		/**< CRC32 checksum of image */
	unsigned int	ver_num;	/**< Version number */
	unsigned int	ver_date;	/**< Version date */
	unsigned int	img_len;	/**< Lengh of image in the partition */
	unsigned int	mem_addr;	/**< Starting address to copy to RAM */
	unsigned int	flag;		/**< Special properties of this partition */
	unsigned int	magic;		/**< Magic number */
}__attribute__ ((__packed__)) flpart_t;

#define FLDEV_CMD_LINE_SIZE	1024 

/**
 * The partition table is a region in flash where meta data about
 * different partitions are stored.
 */
#define FW_MODEL_NAME_SIZE	128
#define PART_MAX		20
#define PART_MAX_WITH_RSV	32

#define HAS_IMG_PARTS		15
#define HAS_NO_IMG_PARTS	0
#define TOTAL_FW_PARTS		(HAS_IMG_PARTS + HAS_NO_IMG_PARTS)

#define TOTAL_MP_PARTS		5

#define PTB_SIZE		4096
#define PTB_PAD_SIZE		\
	(PTB_SIZE - PART_MAX_WITH_RSV * sizeof(flpart_t) )
	
typedef struct flpart_table_s
{
	flpart_t	part[PART_MAX_WITH_RSV];/** Partitions */
	/* ------------------------------------------ */ 
	unsigned char		rsv[PTB_PAD_SIZE];	/**< Padding to 2048 bytes */
}__attribute__ ((__packed__)) flpart_table_t;


/**
 * The meta data table is a region in flash after partition table.
 * The data need by dual boot are stored.
 */
#define PTB_META_MAGIC		0x4432a0ce
#define FL_MAIN_SZ_TYPE		4 
#define AMB_PART_NAME_LEN 8

#define PTB_META_ACTURAL_LEN	((sizeof(unsigned int) * 2 + AMB_PART_NAME_LEN + sizeof(unsigned int)) * \
				 PART_MAX + sizeof(unsigned int) + sizeof(unsigned int) + \
				 FW_MODEL_NAME_SIZE + (sizeof(unsigned int) * 4))
#define PTB_META_SIZE		2048
#define PTB_META_PAD_SIZE	(PTB_META_SIZE - PTB_META_ACTURAL_LEN)

typedef struct flpart_meta_s
{
	__attribute__ ((__packed__)) struct {
		unsigned int	sblk;
		unsigned int	nblk;
		char	name[AMB_PART_NAME_LEN];
	} part_info[PART_MAX];
	unsigned int	magic;				/**< Magic number */
	unsigned int	part_dev[PART_MAX];
	unsigned char	model_name[FW_MODEL_NAME_SIZE];
	__attribute__ ((__packed__)) struct {
		unsigned int	sblk;
		unsigned int	nblk;
	} sm_stg[2];
	unsigned char 	rsv[PTB_META_PAD_SIZE];
	/* This meta crc32 doesn't include itself. */
	/* It's only calc data before this field.  */
	unsigned int 	crc32;
}__attribute__ ((__packed__)) flpart_meta_t;

#define UBOOT_MAGIC ('D'<<24 | 'H'<<16 | 'U'<<8 | 'B' <<0)

struct amb_image_header{
        unsigned int magic;
        unsigned int version;
        unsigned int size;
        unsigned int entry;
        unsigned int load;
        unsigned int data_crc32;
        char name[32];
        unsigned int header_crc32;
        char reserved[4];
}__attribute__ ((__packed__));

struct amb_image{
    struct amb_image_header node[16];
    
    unsigned int node_count;
    unsigned int header_crc32;
    unsigned int data_crc32;
    unsigned int data_size;
    unsigned int version; 
    unsigned int image_magic;
    
    char pad_to_2k[2048 - sizeof(struct amb_image_header)*16 - sizeof(int)*6];
}__attribute__ ((__packed__));

#endif

