/*
 * Copyright (C) 2009, Texas Instruments, Incorporated
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation version 2.
 *
 * This program is distributed "as is" WITHOUT ANY WARRANTY of any
 * kind, whether express or implied; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __CONFIG_AMBARELLA_A5S_IPNC_H
#define __CONFIG_AMBARELLA_A5S_IPNC_H

/*usb update*/
#define UBOOT_USB_UPDATE

/* Display CPU info */
#define CONFIG_DISPLAY_CPUINFO		1

#include <config_cmd_default.h>
#define CONFIG_SKIP_LOWLEVEL_INIT 1
#define CONFIG_ENV_SIZE			0x20000
#define CONFIG_ENV_RANGE    0x100000
#define CONFIG_SYS_MALLOC_LEN		(9*512*1024)
#define CONFIG_ENV_OVERWRITE
#define CONFIG_SYS_LONGHELP
#define CONFIG_SYS_PROMPT		">"
#define CONFIG_SYS_HUSH_PARSER		/* Use HUSH parser to allow command parsing */
#define CONFIG_SYS_PROMPT_HUSH_PS2	"> "
#define CONFIG_CMDLINE_TAG        	1	/* enable passing of ATAGs  */
#define CONFIG_SETUP_MEMORY_TAGS  	1
#define CONFIG_CMDLINE_EDITING
//# define CONFIG_INITRD_TAG	  	1	/* Required for ramdisk support */
#define CONFIG_BOOTPARA_TAGS   1
#define CONFIG_BOOTDELAY		3	/* set to negative value for no autoboot */
//#define CONFIG_CMD_AUTOTEST	/* for autotest */
#define CONFIG_NAND			1
#define CONFIG_I2C			1
#define CONFIG_TIMESTAMP
#define CONFIG_SYS_GBL_DATA_SIZE 128	 /* size in bytes reserved for initial data */

//#define CONFIG_MISC_INIT_R		1
#define CONFIG_SYS_AUTOLOAD		"yes"
#define CONFIG_CMD_CACHE
#define CONFIG_CMD_ECHO

/*
 * Miscellaneous configurable options
 */

/* max number of command args */
#define CONFIG_SYS_MAXARGS		32
/* Console I/O Buffer Size */
#define CONFIG_SYS_CBSIZE		512
/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE		(CONFIG_SYS_CBSIZE \
					+ sizeof(CONFIG_SYS_PROMPT) + 16)
/* Boot Argument Buffer Size */
#define CONFIG_SYS_BARGSIZE		CONFIG_SYS_CBSIZE
/* memtest works on 8 MB in DRAM after skipping 32MB from start addr of ram disk*/
#define CONFIG_SYS_MEMTEST_START	(PHYS_DRAM_1 + (64 *1024 *1024))
#define CONFIG_SYS_MEMTEST_END		(CONFIG_SYS_MEMTEST_START \
					+ (8 * 1024 * 1024))
#if defined(CONFIG_CMD_AUTOTEST)
#define CONFIG_SYS_MEMTEST_SIZE 0x10000000	/* autotest memory size*/
#endif
#undef  CONFIG_SYS_CLKS_IN_HZ				/* everything, incl board info, in Hz */
#define CONFIG_SYS_LOAD_ADDR		0xc2000000  	/* Default load address */
#define CONFIG_SYS_HZ			1000        	/* 1ms clock */

/* Hardware related */

/*Physical Memory Map*/
#define CONFIG_NR_DRAM_BANKS		1		/* we have 1 banks of DRAM */
#define PHYS_DRAM_1             0xC0000000  /* DRAM Bank #1 */
#define PHYS_DRAM_1_SIZE		0x10000000	/* 256MB */

#define CONFIG_NR_BSP_RAM_BANKS		(2)		/* we have 2 banks of DRAM */
#define PHYS_DSP_1              0xc9000000
#define PHYS_DSP_1_SIZE		    0x07000000  /* 112MB */
#define PHYS_BSB_1              0xc8c00000
#define PHYS_BSB_1_SIZE         0x00400000  /* 4MB  */ 

/**
 * Platform/Board specific defs
 */ 

/*NS16550 Configuration*/ 
#define CONFIG_SYS_NS16550
#define CONFIG_SYS_NS16550_SERIAL
#define CONFIG_SYS_NS16550_REG_SIZE	(-4)
#define CONFIG_SYS_NS16550_CLK		(24000000)
#define CONFIG_SYS_NS16550_COM1		0x70005000	/* Base EVM has UART0 */

#define CONFIG_BAUDRATE		115200
#define CONFIG_SYS_BAUDRATE_TABLE	{ 110, 300, 600, 1200, 2400, \
4800, 9600, 14400, 19200, 28800, 38400, 56000, 57600, 115200 ,230400}

/*
 * select serial console configuration
 */
#define CONFIG_SERIAL1			1
#define CONFIG_CONS_INDEX		1
#define CONFIG_SYS_CONSOLE_INFO_QUIET

#if defined(CONFIG_NO_ETH)
#undef CONFIG_CMD_NET
#else
#define CONFIG_AMBARELLA_MAC
#define CONFIG_CMD_DHCP
#define CONFIG_CMD_PING
#endif

#if defined(CONFIG_CMD_NET)
# define CONFIG_MII
//# define CONFIG_BOOTP_DEFAULT
//# define CONFIG_BOOTP_DNS
//# define CONFIG_BOOTP_DNS2
//# define CONFIG_BOOTP_SEND_HOSTNAME
//# define CONFIG_BOOTP_GATEWAY
//# define CONFIG_BOOTP_SUBNETMASK
#define CONFIG_ARP_TIMEOUT 300UL 
#define CONFIG_NET_RETRY_COUNT 	10
#define CONFIG_NET_MULTI
#define CONFIG_PHY_GIGE
#define CONFIG_CMD_MII
#endif

#if defined(CONFIG_SYS_NO_FLASH)
#define CONFIG_ENV_IS_NOWHERE
#endif


/* NAND support */
#ifdef CONFIG_NAND
#undef CONFIG_NAND_NONE
#define CONFIG_CMD_NAND
#define CONFIG_NAND_ENV
#define CONFIG_NAND_A5S
#define NAND_BASE                                  (0x08000000)
#define CONFIG_SYS_NAND_ADDR            NAND_BASE  /*physical address to access nand */
#define CONFIG_SYS_NAND_BASE             NAND_BASE   /*physical address to access*/
                                                                                       /*nand at CS0 */
#define CONFIG_SYS_MAX_NAND_DEVICE	1                   /* Max number of NAND devices */
#endif /* NAND support */  


/* ENV in NAND */
#if defined(CONFIG_NAND_ENV)
#undef CONFIG_ENV_IS_NOWHERE
#define CONFIG_ENV_IS_IN_NAND   1
#define CONFIG_SYS_MAX_FLASH_SECT    (520)		/* max number of sectors in a chip */
#define CONFIG_SYS_MAX_FLASH_BANKS   (1)		/* max number of flash banks */
#define CONFIG_SYS_MONITOR_LEN         (256 << 10)	/* Reserve 2 sectors */
#define CONFIG_SYS_FLASH_BASE		 (0)
#define CONFIG_SYS_MONITOR_BASE	 CONFIG_SYS_FLASH_BASE
#define MNAND_ENV_OFFSET                     0x2000000	/* environment starts here */
#define CONFIG_SYS_ENV_SECT_SIZE 	 (128*1024)
#define CONFIG_ENV_OFFSET		        (0x00300000)
#define CONFIG_ENV_ADDR                        MNAND_ENV_OFFSET
#define CONFIG_CMD_FLWRITE
#define CONFIG_ENV_SECT_SIZE                CONFIG_SYS_ENV_SECT_SIZE
#define CONFIG_FLASH_SIZE                      (128*1024*1204) 
#endif


#ifndef __ASSEMBLY__
extern unsigned int boot_flash_base;
extern volatile unsigned int boot_flash_env_addr;
extern unsigned int boot_flash_off;
extern unsigned int boot_flash_sec;
extern unsigned int boot_flash_type;
#endif
 

/* No I2C support in 1st stage */
#ifdef CONFIG_I2C
#define CONFIG_CMD_I2C 
#define CONFIG_I2C_MULTI_BUS 
#define CONFIG_HARD_I2C			1
#define CONFIG_SYS_I2C_SPEED		100000
#define CONFIG_SYS_I2C_SLAVE		1
#define CONFIG_SYS_I2C_BUS		0
#define CONFIG_DRIVER_AMB_I2C	1
#define CONFIG_SYS_I2C_BUS_SELECT 1
#endif
 
/* Unsupported features */
//#undef CONFIG_USE_IRQ

#ifndef CONFIG_A5S_MIN_CONFIG
#define CONFIG_DVR_CMD
#endif

#define CONFIG_AUTO_UPGRADE_IP           192.168.1.108
#define CONFIG_AUTO_UPGRADE_SIP          192.168.254.254
#define CONFIG_AUTO_UPGRADE_GW           192.168.1.1
#define CONFIG_AUTO_UPGRADE_NM           255.255.255.0

#ifdef CONFIG_DVR_CMD
#define CONFIG_LOG_SERVER   127.0.0.1
#define CONFIG_GATEWAYIP    192.168.1.1		/* gateway currently own */
#define CONFIG_NETMASK      255.255.255.0	/* talk on MY local net */ 
#define CONFIG_IPADDR       192.168.1.108	/* static IP I currently own */
#define CONFIG_SERVERIP     192.168.1.1		/* current IP of tftp server ip */
#define CONFIG_ETHADDR      00:12:34:56:78:9A
#define CONFIG_WIFIADDR     00:12:34:56:78:91

#define CONFIG_BOOTCOMMAND	"kload 0xc2000000;bootm 0xc2000000"
#define CONFIG_BOOTARGS "console=ttyS0 mem=138M ubi.mtd=romfs root=ubi0:romfs ro \
rootfstype=ubifs init=/linuxrc video=amb0fb:720x480,720x480,1,0 lpj=2392064"

#define CONFIG_DH_KEYBOARD      "1"
#define CONFIG_APPAUTO          "1"
#define CONFIG_LOADMODULES      "1"
#define CONFIG_LOGLEVEL         "4 "  /*HOST*/
#define CONFIG_PRODUCT_ID       "000000000000000000"
#define CONFIG_SYS_BACKUP       "1"

//#define	CONFIG_UPDATE_DM	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" dhboot-min.bin.img; flwrite"
#define CONFIG_UPDATE_DA	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" dhboot.bin.img; \
flwrite;tftp dhboot-min.bin.img;nand protect off;flwrite"
//#define CONFIG_UPDATE_DB	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" dhboot-bak.bin.img; flwrite"
#define CONFIG_UPDATE_DK	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" kernel.img; flwrite"
#define CONFIG_UPDATE_DC	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" custom-x.ubifs.img; flwrite"
#define CONFIG_UPDATE_DR	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" romfs-x.ubifs.img; flwrite"
#define CONFIG_UPDATE_DW	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" web-x.ubifs.img; flwrite"
#define CONFIG_UPDATE_DU	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" user-x.ubifs.img; flwrite"
#define CONFIG_UPDATE_DD	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" dsp-x.ubifs.img; flwrite"
#define CONFIG_UPDATE_DATA	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" data-x.ubifs.img; flwrite" 

#define CONFIG_UPDATE_FPGA	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" fpga.img; flwrite"
#define CONFIG_UPDATE_UP	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" update.img; flwrite"
#define CONFIG_TEST_KERNEL	"tftp "MK_STR(CONFIG_SYS_LOAD_ADDR)" uImage; bootm"

#define CONFIG_CMD_JFFS2 	1 /* fsload command */
#define CONFIG_CMD_CRAMFS
#define CONFIG_FSLOAD
#define UBOOT_SZ 		(0x00100000)
#define ROOTFS_SZ 		(0x00300000)
#define UBOOT_OFFSET          (0x200000)
#define UBOOT_BAK_OFFSET  (0x100000)
#define PHY_RESET_PIN 		(20)

#define UBOOT_UPDATE 1
#define BOOT_FROM	    0x7000501c
#endif

#define ENABLE_FLASH 1
#define CONFIG_IP_DEFRAG 1
#define CONFIG_SYS_NO_FLASH 1
#define CONFIG_TFTP_TSIZE 1
#define CONFIG_TFTP_BLOCK_SIZE 8192
#define BOARD_ETH_FRAMES_SIZE (1518+18)
#define AMBARELLA_HAL_REMAP  /*ȷѡ,ں˻޷*/
#define CONFIG_NOR_NONE 
#define HAL_NAND_OFFSET (0x2000)
#define CONFIG_PARTS
#define CONFIG_AMB_BOOT
#define CONFIG_CMD_SYNC
#define CONFIG_A5S_I2C
#define GPIO_RESET      (76)
#define CONFIG_BAUDRATE 115200
#define CONFIG_PLAT_AMBARELLA_A5S 1
#define CONFIG_SYS_FAULT_ECHO_LINK_DOWN 1


#define CONFIG_UPDATE_FLAG_OFFSET (0x00400000)
#define CONFIG_UPDATE_FLAG_SIZE (0x00100000)
#define CONFIG_BAKUP_OFFSET (0x03b80000)
#define CONFIG_BAKUP_SIZE (0x3780000)
#define CONFIG_NORMAL_OFFSET (0x00500000)
#define CONFIG_NORMAL_SIZE CONFIG_BAKUP_SIZE
#define RTC_ERR_OFFSET (30)
#define RTC_SRAM_I2C_ADDR (0x57)
#define MAX_ERR_COUNT (0x05)
#define KERNEL_LOAD_CMD   "kload"
#define CONFIG_LZMA
#define CONFIG_CMD_LOADK

//#define CONFIG_USE_IRQ 1
//#define CONFIG_STACKSIZE_IRQ (32*1024)
//#define CONFIG_STACKSIZE_FIQ (32*1024) 

//#define AMBARELLA_LINUX_LAYOUT
#undef CONFIG_CMD_IMLS
//#undef CONFIG_CMD_NFS
#undef CONFIG_CMD_FLASH
#undef CONFIG_CMD_XIMG
#undef CONFIG_USE_IRQ
//#undef CONFIG_CMD_EDITENV
//#undef CONFIG_CMD_LOADS
//#undef CONFIG_CMD_DHCP


#ifdef CONFIG_PARTS	
/* ÷ȡϢغ궨 */
/* ȡcramfsͷϢʱȡϢ */
#define CRAMFS_SUPER_READ_SIZE      (0x00001000)
/* ϢڵSPIߺ */
#define PARTITION_SPI_BUS           (0)
/* ϢFLASHƬֵ */
#define PARTITION_SPI_CS            (0)
/* ϢFLASHʱƵ */
#define PARTITION__SPI_MAX_HZ       (75000000)
/* ϢFLASHĲģʽ */
#define PARTITION_SPI_MODE          SPI_MODE_3
/* ϢFLASHеƫƵַ */
#define PARTITION_DATA_OFFSET       (0x00500000)
#define PARTITION_DATA_BAK_OFFSET   CONFIG_BAKUP_OFFSET
/* ЧϢС */
#define MIN_PARTINFO_LEN    (32)
/* ЧϢ󳤶 */
#define MAX_PARTINFO_LEN    (256)
/* Ϣļ󳤶 */
#define PARTINFO_FILE_SIZE  (0x00001000)
/* Ϣļļϵͳе */
#define PARTINFO_FILE_PATH  "partition.txt"

/* Ϣļļβַ */
#define PARTINFO_FILE_END   "END"


/* ļغ궨 */
/* ļ */
#define SCRIPT_IMG_NAME     "CmdScript"
/* ļβַ */
#define SCRIPT_FILE_END     "SCRIPT_FILE_END"
/* ϢַС */
#define MIN_SCRIPT_LEN    (1)
/* Ϣַ󳤶 */
#define MAX_SCRIPT_LEN    (256)
#endif /**/

/* Ź */
#define CONFIG_A5S_WATCHDOG

/* HD3532C Ͻmarvell switch 6240MDIOߵַ */
#define HD3532C_SW6240_MDIO_ADDR  (2)

#endif	  /* ! __CONFIG_AMBARELLA_A5S_IPNC_H */

