/*
**	********************************************************************************
**                      updater via net, without console
**                          Digital Video Recoder xp
**
**   (c) Copyright 1992-2010, ZheJiang Dahua Information Technology Stock CO.LTD.
**                            All Rights Reserved
**
**	File		: updater.h
**	Description	: 
**	Modify		: 2010/7/27		sheng_jianguo		Create the file
**	********************************************************************************
*/

#ifndef _NET_UP_
#define _NET_UP_

#define UPDATER_PORT 			39999
#define UPDATER_SERVER_PORT 	9999

#define NETUP_TIMEOUT			2.5

#ifdef debug
#undef debug
#endif

#define debug(fmt, args...)
//#define V100
#ifdef V100
#define UP_VERSION	100
enum UPDATE_MODE{
	UP_DA,
	UP_DR,
	UP_DU,
	UP_DW,
	UP_DL,
	UP_DS,
	UP_DC,
	UP_DD,
	UP_ALL,
	UP_UNKNOW = 0xe0,
	UP_NOFILE = 0xf0,
	UP_NOCONNECT,
	UP_FAILD,
	UP_COMPLETE = 0xff
};

struct updater_pkt{
	uchar vn;
	uchar mode;
};

struct updater_rep{
	uchar vn;
	uchar mode;
	short progress;
};
#else
#define UP_VERSION	110

#define	UP_DA			(('d'<<8)+'a')
#define	UP_DR			(('d'<<8)+'r')
#define	UP_DU			(('d'<<8)+'u')
//#define	UP_DD			(('d'<<8)+'d')
#define	UP_DW			(('d'<<8)+'w')
#define	UP_DL			(('d'<<8)+'l')
#define	UP_DS			(('d'<<8)+'s')
#define	UP_DC			(('d'<<8)+'c')
#define	UP_DD			(('d'<<8)+'d')
#define	UP_ALL			(('u'<<8)+'p')
#define	UP_UNKNOW		(('u'<<8)+'k')
#define	UP_NOFILE 	 	(('n'<<8)+'f')
#define	UP_NOCONNECT	(('n'<<8)+'c')
#define	UP_FAILD		(('e'<<8)+'r')
#define	UP_COMPLETE 	(('o'<<8)+'k')

struct updater_pkt
{
	uchar vn;
	uchar resv;
	unsigned short mode;
};

struct updater_rep{
	uchar vn;
	uchar resv;
	unsigned short mode;
	short progress;
};
#endif

#ifdef V100
//extern uchar updater_progress, updater_mode;
void UpdaterSendMode(uchar mode,short progress);
void UpdaterSendProgress(uchar mode,short progress);
#else
void UpdaterSendMode(unsigned short mode,short progress);
void UpdaterSendProgress(unsigned short mode,short progress);
#endif
void UpdaterStart(void);
void UpdaterReport(void);
void UpdaterRunCommand(void);
#endif//_NET_UP_

