/*
**	********************************************************************************
**                      updater via net, without console
**                          Digital Video Recoder xp
**
**   (c) Copyright 1992-2010, ZheJiang Dahua Information Technology Stock CO.LTD.
**                            All Rights Reserved
**
**	File		: updater.c
**	Description	: 
**	Modify		: 2010/7/27		sheng_jianguo		Create the file
**	********************************************************************************
*/

#include <common.h>
#include <command.h>
#include <net.h>

#include <updater.h>

#ifdef V100
uchar  updater_mode = UP_UNKNOW;
#else
unsigned short updater_mode = UP_UNKNOW;
#endif
short updater_progress;

DECLARE_GLOBAL_DATA_PTR;
extern volatile uchar	PktBuf[];
void UpdaterReport()
{
    int sport, reqlen;
    struct updater_rep report;
    //char strtmp[16];

    debug ("%s\n", __FUNCTION__);

    report.vn = UP_VERSION;
    report.mode = updater_mode;
    report.progress = updater_progress;
    reqlen = sizeof(struct updater_rep);

    if(eth_init(gd->bd))
    {
        return;
    }

    if(NULL == NetTxPacket)
    {
        NetTxPacket = &PktBuf[0] + (PKTALIGN - 1);
        NetTxPacket -= (ulong)NetTxPacket % PKTALIGN;
    }
    
    memcpy ((char *)NetTxPacket + NetEthHdrSize() + IP_HDR_SIZE, (char *)&report, reqlen);

    sport = UPDATER_SERVER_PORT;

    //ip_to_string(NetServerIP, strtmp);
    NetSendUDPPacket (NetServerEther, NetServerIP, sport, UPDATER_PORT, reqlen);
    eth_halt();

    NetState = NETLOOP_SUCCESS;
}

static void
UpdaterTimeout (void)
{
//	eth_halt();

	NetState = NETLOOP_FAIL;
	return;
}

extern IPaddr_t	UPNetServerIP;	
uchar g_vn;
static void UpdaterHandler (uchar *pkt, unsigned dest, unsigned src, unsigned len)
{
    struct updater_pkt *rpktp = (struct updater_pkt*)pkt;
    char strtmp[16];

    debug ("%s\n", __FUNCTION__);
    ip_to_string(UPNetServerIP, strtmp);
    debug("from ip:%s\n", strtmp);

    if (dest != UPDATER_PORT || UPNetServerIP == 0){
        debug("The ServerIP is %s, The Port is %d\n", strtmp, dest);
        return;
    }
    NetServerIP = UPNetServerIP;

    debug("len = %d\n",len);
    g_vn = rpktp->vn;
    if(rpktp->vn == UP_VERSION)
    {
        setenv("serverip", strtmp);

        updater_mode = rpktp->mode;
        updater_progress = 0;
        UpdaterReport();

        NetState = NETLOOP_SUCCESS;
    } else {
        //wait for timeout
        return;
    }
}

void UpdaterRunCommand(void)
{
    char cmd[16];
    int ret;

    if(g_vn == UP_VERSION) {
        ret = sprintf(cmd, "run %c%c", updater_mode>>8,updater_mode&0xff);
        cmd[ret] = 0;
        printf("%s\n",cmd);
        run_command(cmd, 0);
    }else{
        return;
    }
    run_command("reset", 0);		
}

void UpdaterStart(void)
{
    debug ("%s\n", __FUNCTION__);

    NetSetTimeout (NETUP_TIMEOUT* CONFIG_SYS_HZ, UpdaterTimeout);
    NetSetHandler(UpdaterHandler);
}

void UpdaterSendMode(unsigned short mode,short progress)
{
    if(mode == UP_UNKNOW) return;

    updater_mode = mode;
    updater_progress = progress;
    debug ("%s,mode=%c%c\n ", __FUNCTION__,mode>>8,mode&0xff);

    UpdaterReport();
}
void UpdaterSendProgress(unsigned short mode,short progress)
{
    
    if(mode == UP_UNKNOW)
    {
        return;
    }

    if (mode != 0xffff)
        updater_mode = mode;
    updater_progress = progress;

    UpdaterReport();
}
