#!/bin/env python

import os, sys, shutil, glob, stat
from Tkinter import *

def on_rmtree_error( func, path, exec_info ) :
	if os.access( path, os.R_OK ) :
		os.chmod( path, stat.S_IWRITE )
		func( path )

def do_rmtree( path ) :
	shutil.rmtree( path, onerror = on_rmtree_error )
	if os.access( path, os.R_OK ) :
		return 1
	return 0

def globcopy( pattern, dst ) :
	for fn in glob.glob( pattern ) :
		shutil.copy( fn, dst )

def endWith(*endstring) :
	ends = endstring
	def run(s) :
		f = map(s.endswith, ends)
		if True in f: return s
	return run
	
def ignoreSvnPath(path, names):
	return ['.svn']   # nothing will be ignored
	
def do_build_pkg( target ) :
	list_file = os.listdir('../../')
	a = endWith('2005.sln')
	f_file = filter(a, list_file)
	modname = []
	for i in f_file: 
		print i, 
		slnName = i[:-8]
		if "test" != slnName.lower() :
			modname.append(slnName)
	print "get module name"
	print modname
	# <1> Set Build Option
	bd_param = "Debug|Win32"
	fn_d = "d"
	libPath = ""
	libSuffix = ".lib"
	if target == "win32-vs2005-debug" :
		bd_param = "StaticDebug|Win32"
		fn_d = "d"
		libPath = "../../Lib/Win32/VS2005Static/"
	elif target == "win32-vs2005-release" :
		bd_param = "StaticRelease|Win32"
		fn_d = ""
		libPath = "../../Lib/Win32/VS2005Static/"
	elif target == "win32-vs2005-debugmd" :
		bd_param = "StaticDebugMD|Win32"
		fn_d = "mdd"
		libPath = "../../Lib/Win32/vs2005Static/"
	elif target == "win32-vs2005-releasemd" :
		bd_param = "StaticReleaseMD|Win32"
		fn_d = "md"
		libPath = "../../Lib/Win32/vs2005Static/"
	elif target == "win32-vs2005-dllrelease" :
		bd_param = "DLLRelease|Win32"
		fn_d = ""
		libPath = "../../Lib/Win32/vs2005Shared/"
		libSuffix = ".dll"
	elif target == "win32-vs2005-dlldebug" :
		bd_param = "DLLDebug|Win32"
		fn_d = "d"
		libPath = "../../Lib/Win32/vs2005Shared/"
		libSuffix = ".dll"
	elif target == "win32-vs2005-dlldebugmd" :
		bd_param = "DLLDebugMD|Win32"
		fn_d = "mdd"
		libPath = "../../Lib/Win32/vs2005Shared/"
		libSuffix = ".dll"
	elif target == "win32-vs2005-dllreleasemd" :
		bd_param = "DLLReleaseMD|Win32"
		fn_d = "md"
		libPath = "../../Lib/Win32/vs2005Shared/"
		libSuffix = ".dll"
	else :
		print "bad target"
		return 1

	if target == "win32-vs2005-dll" :
		dir_d = "dll"
	else :
		dir_d = fn_d
	####################################
	####	Custom Section Begin
	####################################

	dst_dirName = modname[0]
	if libSuffix == ".dll" :
		dst_dirName += "dll"
	dst_dirName = dst_dirName + dir_d
	dst_dir = target + "/" + dst_dirName
	if do_rmtree( dst_dir ) != 0 :
		print "rmtree failed"
		return 1
	if os.access( dst_dir + ".zip", os.R_OK ) :
		os.remove( dst_dir + ".zip" )
	
	# <2> Build Target From Source
	prjs = modname
	for prj in prjs :
		prjFile = "../../" + prj + "2005.sln"
		cmd = "devenv " + prjFile + " /Rebuild \"" + bd_param + "\" /project " + prj 
		print cmd
		if os.system( cmd ) != 0 :
			print "build prj " + prj + " failed"
			return 1

	# <3> Package Target
	# TODO : do rmtree again, should not need. but mkdir may failed without it
	do_rmtree( dst_dir )
	do_rmtree( target )
	os.mkdir(target)
	os.mkdir( dst_dir )

	#globcopy( "../DOAXBase/AX_API/*.h", dst_dir + "/AX_API" )
	#globcopy( "../DOAXBase/AX_API/*.inl", dst_dir + "/AX_API" )
	#globcopy( "../DOAXBase/HTTP/*.h", dst_dir + "/HTTP" )
	#globcopy( "../DOAXBase/RTP/*.h", dst_dir + "/RTP" )
	#globcopy( "../DOAXBase/RTSP/*.h", dst_dir + "/RTSP" )
	#globcopy( "../DOAXBase/tinyxml/*.h", dst_dir + "/tinyxml" )
	#globcopy( "../DOAXBase/TPLayer/*.h", dst_dir + "/TPLayer" )
	#globcopy( "../DOAXBase/Utils/*.h", dst_dir + "/Utils" )
	#globcopy( "../gtestdsl/gtest/*.h", dst_dir + "/gtest" )
	#globcopy( "../libdsl/*.h", dst_dir + "/libdsl" )
	#globcopy( "../dslalien/json/*.h", dst_dir + "/json" )
	#globcopy( "../dslalien/pugixmldsl/*.h*", dst_dir + "/pugixmldsl" )
	#globcopy( "../dslalien/sqlitedsl/*.h", dst_dir + "/sqlitedsl" )
	#globcopy( "../dslalien/zlibdsl/zconf.h", dst_dir + "/zlibdsl" )
	#globcopy( "../dslalien/zlibdsl/zlib.h", dst_dir + "/zlibdsl" )

	#rmfs = [ "/libdsl/StdAfx.h" ]
	#for f in rmfs :
	#	os.remove( dst_dir + f );

	# put these in release package as example for other module
	#globcopy( "../vs2005_dsl_debug.vsprops", dst_dir )
	#globcopy( "../vs2005_dsl_release.vsprops", dst_dir )
	#globcopy( "build_pkg*.*", dst_dir )
	#globcopy( "test_pkg*.*", dst_dir )
	#globcopy( "upload_pkg*.*", dst_dir )
	#globcopy( "../Depend/build_depend*.*", dst_dir )
	#globcopy( "../Depend/update_depend*.*", dst_dir )
	
	shutil.copytree("../../Include/" + modname[0], dst_dir + "/" + modname[0], False, ignoreSvnPath)
	if modname[0] == "Infra" :
		shutil.copytree("../../Include/" + "Component", dst_dir + "/" + "Component", False, ignoreSvnPath)
		shutil.copytree("../../Include/" + "Memory", dst_dir + "/" + "Memory", False, ignoreSvnPath)
		shutil.copytree("../../Include/" + "Utils", dst_dir + "/" + "Utils", False, ignoreSvnPath)
	
	for prj in prjs :
		globcopy( libPath + prj + fn_d + libSuffix, dst_dir )
		globcopy( libPath + prj + fn_d + ".pdb", dst_dir )
		if libSuffix == ".dll" :
			globcopy( libPath + prj + fn_d + ".lib", dst_dir )

	####################################
	####	Custom Section End
	####################################

	globcopy( "../../Version.xml", dst_dir )
	print os.getcwd()
	shutil.make_archive( dst_dir, "zip", "./" + target, dst_dirName )
	globcopy( dst_dir + "*.zip", "../../Bin/Win32" )
	return 0


class gui_builder :
	def __init__(self) :
		top = Tk()
		self.top = top
		top.grid()

		lb1 = Label( top, text="Target Type" )
		lb1.grid( row=0, column=0 )
		self.var_target = StringVar()
		avail_targets = [ "win32-vs2005-debug", "win32-vs2005-release",
				"win64-vs2005-debug", "win64-vs2005-release" ]
		self.var_target.set( "win32-vs2005-debug" )
		om1 = OptionMenu( top, self.var_target, *avail_targets )
		om1.grid( row=0, column=1 )

		btn = Button( top, text="Build", command=self.build_pkg )
		btn.grid( row=1, column=0, columnspan=2, padx=10, pady=5 )

		self.var_info = StringVar()
		self.info = Label( top, textvariable=self.var_info )
		self.info.grid( row=2, column=0, columnspan=2, pady=5 )

	def run(self) :
		self.top.mainloop()

	def build_pkg(self) :
		self.var_info.set( "building, please wait ... " )
		self.info.update()
		ret = do_build_pkg( self.var_target.get() )
		if ret == 0 :
			self.var_info.set( "OK -- build pkg success" )
		else :
			self.var_info.set( "ERR -- build pkg failed" )

if __name__ == "__main__" :
	if len(sys.argv) >= 2 :
		ret = do_build_pkg( sys.argv[1] )
		if ret == 0 :
			print "OK -- build pkg success"
		else :
			print "ERR -- build pkg failed"
		sys.exit(ret)
	elif os.name == "nt" :
		gbd = gui_builder()
		gbd.run()
	else :
		print "Usage: build_pkg [target_type]"
		sys.exit(1)

