#!/usr/bin/env python

import os, sys, shutil, glob, stat
from xml.dom.minidom import parse
import tarfile

def on_rmtree_error( func, path, exec_info ) :
	if os.access( path, os.R_OK ) :
		os.chmod( path, stat.S_IWRITE )
		func( path )

def do_rmtree( path ) :
	shutil.rmtree( path, onerror = on_rmtree_error )
	if os.access( path, os.R_OK ) :
		return 1
	return 0

def globcopy( pattern, dst ) :
	for fn in glob.glob( pattern ) :
		shutil.copy( fn, dst )
	
def ignoreSvnPath(path, names):
	return ['.svn']
	
def ignoreDirPath(path, names):
	ignoreNames = []
	for name in names:
		filepath = path + "/" + name
		if os.path.isdir(os.path.abspath(filepath)) :		
			ignoreNames.append(name)
	return ignoreNames
	
def do_build_pkg( target ) :
	# get module name
	# parse DependInfo.xml
	try :
		dep = parse( "../../Version.xml" )
		if dep.documentElement.tagName != "Versioninfo" :
			print "bad Version.xml, no Versioninfo tag"
			return 1
	except Exception, e :
		print "parse Version.xml failed, err %s" % e
		return 1
		
	nodes = dep.documentElement.getElementsByTagName( "Module" )
	for nd in nodes :
		modname = nd.getAttribute( "name" )
		print "get module name"
		print modname
		break
	
	# <1> Set Build Option
	fn_d = "_d"
	libPath = ""
	preCommand = ""
	if target == "linux64-centos6-gcc-debug" :
		fn_d = "_d"
		libName = "m64x86"
	elif target == "linux64-centos6-gcc-release" :
		fn_d = ""
		libName = "m64x86"
	elif target == "linux32-centos6-gcc-debug" :
		fn_d = "_d"
		libName = "x86"
	elif target == "linux32-centos6-gcc-release" :
		fn_d = ""
		libName = "x86"
	else :
		print "bad target"
		return 1
	libPath = "../../Lib/" + libName
		
	dir_d = fn_d
	####################################
	####	Custom Section Begin
	####################################

	dst_dirName = modname
	dst_dirName = dst_dirName + dir_d
	dst_dir = target + "/" + dst_dirName
	if do_rmtree( dst_dir ) != 0 :
		print "rmtree failed"
		return 1
	if os.access( dst_dir + ".tar.gz", os.R_OK ) :
		os.remove( dst_dir + ".tar.gz" )
	
	# <2> Build Target From Source
	prjs = [ modname ]

	# <3> Package Target
	# TODO : do rmtree again, should not need. but mkdir may failed without it
	do_rmtree( dst_dir )
	do_rmtree( target )
	os.mkdir(target)
	
	for prj in prjs :
		shutil.copytree(libPath, dst_dir, False, ignoreDirPath)
	
	shutil.copytree("../../Include/" + modname, dst_dir + "/" + modname, False, ignoreSvnPath)
	if modname == "Infra" :
		shutil.copytree("../../Include/" + "Component", dst_dir + "/" + "Component", False, ignoreSvnPath)
		shutil.copytree("../../Include/" + "Memory", dst_dir + "/" + "Memory", False, ignoreSvnPath)
		shutil.copytree("../../Include/" + "Utils", dst_dir + "/" + "Utils", False, ignoreSvnPath)

	####################################
	####	Custom Section End
	####################################

	globcopy( "../../Version.xml", dst_dir )
	os.chdir(target)
	print os.getcwd()
	tar = tarfile.open(dst_dirName + ".tar.gz", "w:gz")
	for root,dir,files in os.walk(dst_dirName):
		for file in files:
			fullpath = os.path.join(root, file)
			tar.add(fullpath)
	tar.close()
	os.chdir("..")
	globcopy( dst_dir + "*.tar.gz", "../../Bin/" + libName )
	return 0


class gui_builder :
	def __init__(self) :
		top = Tk()
		self.top = top
		top.grid()

		lb1 = Label( top, text="Target Type" )
		lb1.grid( row=0, column=0 )
		self.var_target = StringVar()
		avail_targets = [ "win32-vs2005-debug", "win32-vs2005-release",
				"win64-vs2005-debug", "win64-vs2005-release" ]
		self.var_target.set( "win32-vs2005-debug" )
		om1 = OptionMenu( top, self.var_target, *avail_targets )
		om1.grid( row=0, column=1 )

		btn = Button( top, text="Build", command=self.build_pkg )
		btn.grid( row=1, column=0, columnspan=2, padx=10, pady=5 )

		self.var_info = StringVar()
		self.info = Label( top, textvariable=self.var_info )
		self.info.grid( row=2, column=0, columnspan=2, pady=5 )

	def run(self) :
		self.top.mainloop()

	def build_pkg(self) :
		self.var_info.set( "building, please wait ... " )
		self.info.update()
		ret = do_build_pkg( self.var_target.get() )
		if ret == 0 :
			self.var_info.set( "OK -- build pkg success" )
		else :
			self.var_info.set( "ERR -- build pkg failed" )

if __name__ == "__main__" :
	if len(sys.argv) >= 2 :
		ret = do_build_pkg( sys.argv[1] )
		if ret == 0 :
			print "OK -- build pkg success"
		else :
			print "ERR -- build pkg failed"
		sys.exit(ret)
	elif os.name == "nt" :
		gbd = gui_builder()
		gbd.run()
	else :
		print "Usage: build_pkg [target_type]"
		sys.exit(1)
