#include "openssl/ssl.h"
#include "openssl/err.h"
#include "openssl/crypto.h"
#include "ssl_thread_mutex.h"

void cxc_locking_callback(int mode, int type, char *file, int line);
unsigned long cxc_thread_id_callback(void);

static ssl_thread_mutex *lock_cxc;
static ssl_thread_rw_mutex *lock_rw;

void ssl_thread_setup(void)
{
    int i;
    lock_cxc=(ssl_thread_mutex*)OPENSSL_malloc(CRYPTO_num_locks() * sizeof(ssl_thread_mutex));
	lock_rw=(ssl_thread_rw_mutex*)OPENSSL_malloc(CRYPTO_num_locks() * sizeof(ssl_thread_rw_mutex));

	//pthread_mutexattr_t attr;
	//pthread_mutexattr_init(&attr);
	//pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE_NP);
    for (i=0; i<CRYPTO_num_locks(); i++)
    {
        ssl_thread_mutex_init(&(lock_cxc[i]));
		ssl_thread_rw_mutex_init(&(lock_rw[i]));
    }
    CRYPTO_set_id_callback((unsigned long (*)())cxc_thread_id_callback);
    CRYPTO_set_locking_callback((void (*)())cxc_locking_callback);
}

void ssl_thread_cleanup(void)
{
    int i;
    CRYPTO_set_locking_callback(NULL);
    for (i=0; i<CRYPTO_num_locks(); i++)
    {
        ssl_thread_mutex_destroy(&(lock_cxc[i]));
		ssl_thread_rw_mutex_destroy(&(lock_rw[i]));
    }
    OPENSSL_free(lock_cxc);
	OPENSSL_free(lock_rw);
    lock_cxc = NULL;
	lock_rw = NULL;
}

void cxc_locking_callback(int mode, int type, char *file, int line)
{
    if (mode & CRYPTO_LOCK)
    {
    	if( mode & CRYPTO_READ )
    	{
			ssl_thread_rw_mutex_lock(&(lock_rw[type]), SSL_READ_LOCK);
		}
		else if( mode & CRYPTO_WRITE )
		{
			ssl_thread_rw_mutex_lock(&(lock_rw[type]), SSL_WRITE_LOCK);
		}
		else
        	ssl_thread_mutex_lock(&(lock_cxc[type]));
    }
    else
    {
    	if( mode & (CRYPTO_READ|CRYPTO_WRITE) )
			ssl_thread_rw_mutex_unlock(&(lock_rw[type]));
		else
        	ssl_thread_mutex_unlock(&(lock_cxc[type]));
    }
	//printf("cxc_locking_callback>>>mode:%d,type:%d\n",mode,type);
}

unsigned long cxc_thread_id_callback(void)
{
    return (unsigned long)(pthread_self());
}


