/*
 * The poke table is a series of long words, in the format
 *
 *	opcode, address, operand, ...
 *
 * An opcode of 0 marks the table end
 */


/*
 * Only define the following if you want to use the "old"
 * poke loop table interpreter. This should *not* be
 * defined if you are now using the "romgen" tool to
 * generate contemporary poke tables. The latest generation
 * targetpacks may be incompatible with the old interpreter.
 */
#define CONFIG_SH_OLD_POKE_LOOP_PARADIGM	/* QQQ - DELETE */


#include "asm/fli7510reg.h"
#include "../../../cpu/sh/init_ram.S"


	.section .data.init, "a"

	.balign 32

__memory_setup_table:


	/*
	 * include the appropriate set of "GDB pokes", (usually) generated
	 * using the "romgen" utility, from a known good target-pack.
	 *
	 * This file may be regenerated by connecting your specific board
	 * to an STMC2 (note: currently it must be version 2) and then
	 * executing the following command (redirecting the output):
	 *
	 * host% romgen --target-connect --show-comment <stmc2>:fldb_gpd201:st40host,boot_companions=0
	 *
	 * Where "<stmc2>" should be replaced with the IP address
	 * (or the DNS name) of the STMC2 box.  Also the "fldb_gpd201" should
	 * substituted if you have a custom target-pack connect command.
	 *
	 * Note: The connect command used with "romgen", should connect
	 * only in 29-bit mode - even though U-Boot will be built for 32-bit mode.
	 * That is, do not use the "seuc=1" (or similar) option with "romgen".
	 */
#include "fli7510.romgen"

	END_MARKER

__memory_setup_table_end:

	.end
