/*
 * The poke table is a series of long words, in the format
 *
 *	opcode, address, operand, ...
 *
 * An opcode of 0 marks the table end
 */


/*
 * Only define the following if you want to use the "old"
 * poke loop table interpreter. This should *not* be
 * defined if you are now using the "romgen" tool to
 * generate contemporary poke tables. The latest generation
 * targetpacks may be incompatible with the old interpreter.
 */
#undef CONFIG_SH_OLD_POKE_LOOP_PARADIGM


#include "asm/stx7105reg.h"
#include "../../../cpu/sh/init_ram.S"


	.section .data.init, "a"

	.balign 32

__memory_setup_table:

	/*
	 * Magic sequence to configure the ClockGenA switch control to
	 * reset values.  These do not appear to be correctly reset on
	 * a WDT reset, so we explicitly do it here.
	 * For further details, please see:
	 *	https://bugzilla.stlinux.com/show_bug.cgi?id=5536#c38
	 */
		/* CLOCKGEN A CKGA_CLKOPSRC_SWITCH_CFG  reset=0 */
	POKE32(0xfe213014, 0x00000000)
		/* CLOCKGEN A CKGA_CLKOPSRC_SWITCH_CFG2 reset=0 */
	POKE32(0xfe213024, 0x00000000)

	/*
	 * include the appropriate set of "GDB pokes", (usually) generated
	 * using the "romgen" utility, from a known good target-pack.
	 *
	 * This file may be regenerated by connecting your specific board
	 * to an STMC2 (note: currently it must be version 2) and then
	 * executing the following command (redirecting the output):
	 *
	 * host% romgen --target-connect --show-comment <stmc2>:sdk7105:st40
	 *
	 * Where "<stmc2>" should be replaced with the IP address
	 * (or the DNS name) of the STMC2 box.  Also the "sdk7105" should
	 * substituted if you have a custom target-pack connect command.
	 *
	 * Note: The connect command used with "romgen", should connect
	 * only in 29-bit mode - even if U-Boot will be built for 32-bit mode.
	 * That is, do not use the "seuc=1" (or similar) option with "romgen".
	 */
#include "pdk7105.romgen"

#ifdef CONFIG_SH_SE_MODE
	/*
	 * Note that we also manually need to move the LMI base addresses to
	 * their 32-bit SE mode locations as defined in the datasheet and change the
	 * 'upper bound addresses' (in row attribute registers) for the LMIs.
	 */
	UPDATE32(STX7105_SYSCONF_SYS_CFG38, 0xFFFFFF00, 0x00000040)
	/* Change LMI upper bound addresses
	 * Upper LMI addr=0x40000000 + 512MiB=0x60000000
	 */
	UPDATE32(ST40_LMI_SDRA0_0(), 0x001FFFFF, 0x60000000)
	UPDATE32(ST40_LMI_SDRA1_0(), 0x001FFFFF, 0x60000000)
#endif	/* CONFIG_SH_SE_MODE */

	END_MARKER

__memory_setup_table_end:

	.end
