/*
 * Copyright (C) STMicroelectronics Ltd. 2008.
 *
 * All rights reserved.
 */

/*
 * This is derived from STMicroelectronics gnu toolchain example:
 *   sh-superh-elf/examples/bare/sh4reg/sti7105.h
 */


#ifndef __STX5206REG_H
#define __STX5206REG_H

#include "sh4regtype.h"

/*----------------------------------------------------------------------------*/

/*
 * Peripheral versions
 */

#ifndef ST40_LMIGP_VERSION
#define ST40_LMIGP_VERSION 1
#endif
#ifndef ST40_NAND_CONTROLLER_VERSION
#define ST40_NAND_CONTROLLER_VERSION 1
#endif

/*----------------------------------------------------------------------------*/

/*
 * Base addresses for control register banks.
 */

/* Generic SH4 control registers */
#ifndef SH4_TMU_REGS_BASE
#define SH4_TMU_REGS_BASE 0xffd80000
#endif

/* Common ST40 control registers */
#ifndef ST40_CPG_REGS_BASE
#define ST40_CPG_REGS_BASE 0xffc00000
#endif
#ifndef ST40_INTC_REGS_BASE
#define ST40_INTC_REGS_BASE 0xffd00000
#endif
#ifndef ST40_SCIF2_REGS_BASE
#define ST40_SCIF2_REGS_BASE 0xffe80000
#endif

#ifndef STX5206_COMMS_BASE
#define STX5206_COMMS_BASE 0xfd000000
#endif

#ifndef ST40_ILC_REGS_BASE
#define ST40_ILC_REGS_BASE STX5206_COMMS_BASE
#endif

/* STx5206 control registers */
#ifndef STX5206_SYSCONF_REGS_BASE
#define STX5206_SYSCONF_REGS_BASE 0xfe001000
#endif

#ifndef STX5206_CLOCKGENA_REGS_BASE
#define STX5206_CLOCKGENA_REGS_BASE 0xfe213000
#endif

#ifndef STX5206_CLOCKGENB_REGS_BASE
#define STX5206_CLOCKGENB_REGS_BASE 0xfe000000
#endif

/* System Architecture Volume 2: Bus Interfaces */
#ifndef ST40_LMI_REGS_BASE
#define ST40_LMI_REGS_BASE 0xfe901000
#endif
#ifndef ST40_EMI_REGS_BASE
#define ST40_EMI_REGS_BASE 0xfe700000
#endif

/* System Architecture Volume 4: I/O Devices */
#ifndef ST40_PIO0_REGS_BASE
#define ST40_PIO0_REGS_BASE (STX5206_COMMS_BASE + 0x00020000)
#endif
#ifndef ST40_PIO1_REGS_BASE
#define ST40_PIO1_REGS_BASE (STX5206_COMMS_BASE + 0x00021000)
#endif
#ifndef ST40_PIO2_REGS_BASE
#define ST40_PIO2_REGS_BASE (STX5206_COMMS_BASE + 0x00022000)
#endif
#ifndef ST40_PIO3_REGS_BASE
#define ST40_PIO3_REGS_BASE (STX5206_COMMS_BASE + 0x00023000)
#endif
#ifndef ST40_ASC0_REGS_BASE
#define ST40_ASC0_REGS_BASE (STX5206_COMMS_BASE + 0x00030000)
#endif
#ifndef ST40_ASC1_REGS_BASE
#define ST40_ASC1_REGS_BASE (STX5206_COMMS_BASE + 0x00031000)
#endif
#ifndef ST40_ASC2_REGS_BASE
#define ST40_ASC2_REGS_BASE (STX5206_COMMS_BASE + 0x00032000)
#endif
#ifndef ST40_ASC3_REGS_BASE
#define ST40_ASC3_REGS_BASE (STX5206_COMMS_BASE + 0x00033000)
#endif
#ifndef ST40_SSC0_REGS_BASE
#define ST40_SSC0_REGS_BASE (STX5206_COMMS_BASE + 0x00040000)
#endif
#ifndef ST40_SSC1_REGS_BASE
#define ST40_SSC1_REGS_BASE (STX5206_COMMS_BASE + 0x00041000)
#endif
#ifndef ST40_SSC2_REGS_BASE
#define ST40_SSC2_REGS_BASE (STX5206_COMMS_BASE + 0x00042000)
#endif
#ifndef ST40_SSC3_REGS_BASE
#define ST40_SSC3_REGS_BASE (STX5206_COMMS_BASE + 0x00043000)
#endif


/*----------------------------------------------------------------------------*/

#include "st40reg.h"

/*
 * STx5206 control registers
 */

/* Clock Generator control registers (STx5206 variant) */
#define STX5206_CLOCKGENA_PLL0LS_DIV13_CFG	SH4_DWORD_REG(STX5206_CLOCKGENA_REGS_BASE + 0xa34)

/* System configuration registers (STx5206 variant) */
#define STX5206_SYSCONF_DEVICEID_0		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0000)
#define STX5206_SYSCONF_DEVICEID_1		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0004)
#define STX5206_SYSCONF_DEVICEID		SH4_GWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0000)
#define STX5206_SYSCONF_SYS_STA00		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0008)
#define STX5206_SYSCONF_SYS_STA01		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x000c)
#define STX5206_SYSCONF_SYS_STA02		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0010)
#define STX5206_SYSCONF_SYS_STA03		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0014)
#define STX5206_SYSCONF_SYS_STA04		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0018)
#define STX5206_SYSCONF_SYS_STA05		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x001c)
#define STX5206_SYSCONF_SYS_STA06		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0020)
#define STX5206_SYSCONF_SYS_STA07		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0024)
#define STX5206_SYSCONF_SYS_STA08		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0028)
#define STX5206_SYSCONF_SYS_STA09		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x002c)
#define STX5206_SYSCONF_SYS_STA10		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0030)
#define STX5206_SYSCONF_SYS_STA11		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0034)
#define STX5206_SYSCONF_SYS_STA12		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0038)
#define STX5206_SYSCONF_SYS_STA13		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x003c)
#define STX5206_SYSCONF_SYS_STA14		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0040)
#define STX5206_SYSCONF_SYS_STA15		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0044)
#define STX5206_SYSCONF_SYS_CFG00		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0100)
#define STX5206_SYSCONF_SYS_CFG01		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0104)
#define STX5206_SYSCONF_SYS_CFG02		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0108)
#define STX5206_SYSCONF_SYS_CFG03		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x010c)
#define STX5206_SYSCONF_SYS_CFG04		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0110)
#define STX5206_SYSCONF_SYS_CFG05		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0114)
#define STX5206_SYSCONF_SYS_CFG06		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0118)
#define STX5206_SYSCONF_SYS_CFG07		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x011c)
#define STX5206_SYSCONF_SYS_CFG08		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0120)
#define STX5206_SYSCONF_SYS_CFG09		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0124)
#define STX5206_SYSCONF_SYS_CFG10		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0128)
#define STX5206_SYSCONF_SYS_CFG11		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x012c)
#define STX5206_SYSCONF_SYS_CFG12		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0130)
#define STX5206_SYSCONF_SYS_CFG13		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0134)
#define STX5206_SYSCONF_SYS_CFG14		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0138)
#define STX5206_SYSCONF_SYS_CFG15		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x013c)
#define STX5206_SYSCONF_SYS_CFG16		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0140)
#define STX5206_SYSCONF_SYS_CFG17		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0144)
#define STX5206_SYSCONF_SYS_CFG18		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0148)
#define STX5206_SYSCONF_SYS_CFG19		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x014c)
#define STX5206_SYSCONF_SYS_CFG20		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0150)
#define STX5206_SYSCONF_SYS_CFG21		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0154)
#define STX5206_SYSCONF_SYS_CFG22		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0158)
#define STX5206_SYSCONF_SYS_CFG23		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x015c)
#define STX5206_SYSCONF_SYS_CFG24		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0160)
#define STX5206_SYSCONF_SYS_CFG25		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0164)
#define STX5206_SYSCONF_SYS_CFG26		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0168)
#define STX5206_SYSCONF_SYS_CFG27		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x016c)
#define STX5206_SYSCONF_SYS_CFG28		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0170)
#define STX5206_SYSCONF_SYS_CFG29		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0174)
#define STX5206_SYSCONF_SYS_CFG30		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0178)
#define STX5206_SYSCONF_SYS_CFG31		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x017c)
#define STX5206_SYSCONF_SYS_CFG32		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0180)
#define STX5206_SYSCONF_SYS_CFG33		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0184)
#define STX5206_SYSCONF_SYS_CFG34		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0188)
#define STX5206_SYSCONF_SYS_CFG35		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x018c)
#define STX5206_SYSCONF_SYS_CFG36		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0190)
#define STX5206_SYSCONF_SYS_CFG37		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0194)
#define STX5206_SYSCONF_SYS_CFG38		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x0198)
#define STX5206_SYSCONF_SYS_CFG39		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x019c)
#define STX5206_SYSCONF_SYS_CFG40		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01a0)
#define STX5206_SYSCONF_SYS_CFG41		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01a4)
#define STX5206_SYSCONF_SYS_CFG42		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01a8)
#define STX5206_SYSCONF_SYS_CFG43		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01ac)
#define STX5206_SYSCONF_SYS_CFG44		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01b0)
#define STX5206_SYSCONF_SYS_CFG45		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01b4)
#define STX5206_SYSCONF_SYS_CFG46		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01b8)
#define STX5206_SYSCONF_SYS_CFG47		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01bc)
#define STX5206_SYSCONF_SYS_CFG48		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01c0)
#define STX5206_SYSCONF_SYS_CFG49		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01c4)
#define STX5206_SYSCONF_SYS_CFG50		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01c8)
#define STX5206_SYSCONF_SYS_CFG51		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01cc)
#define STX5206_SYSCONF_SYS_CFG52		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01d0)
#define STX5206_SYSCONF_SYS_CFG53		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01d4)
#define STX5206_SYSCONF_SYS_CFG54		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01d8)
#define STX5206_SYSCONF_SYS_CFG55		SH4_DWORD_REG(STX5206_SYSCONF_REGS_BASE + 0x01dc)

/* Device ID values, masks & predicates */
#define STX5206_DEVID_5206_VAL		0x042
#define STX5206_DEVID_ID_SHIFT		12
#define STX5206_DEVID_ID_MASK		0x3ff
#define STX5206_DEVID_CUT_SHIFT		28
#define STX5206_DEVID_CUT_MASK		0xf

#define STX5206_DEVICEID_5206(ID) ((((ID) >> STX5206_DEVID_ID_SHIFT) & STX5206_DEVID_ID_MASK) == STX5206_DEVID_5206_VAL)
#define STX5206_DEVICEID_CUT(ID)  ((((ID) >> STX5206_DEVID_CUT_SHIFT) & STX5206_DEVID_CUT_MASK) + 1)

#endif /* __STX5206REG_H */
