/*=======================================================================
?Copyright (C) Microsoft Corporation.?All rights reserved.
?
  THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
  PARTICULAR PURPOSE.
=======================================================================*/

using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

namespace IPSD.WebServer
{

    /// <summary>
    /// Thie class is described for write the log to EventView
    /// The Event Source: Applicaion
    /// The Event ID: 10086
    /// </summary>
    public class WebEventLog
    {

        private const string LogSource = "Web Server";
        private const string LogName = "IPSD";
        private static WebEventLog instance = null;
        private EventLog log=null;

        private WebEventLog()
        {
            try
            {

                if (!EventLog.SourceExists(LogSource))
                {

                    EventLog.CreateEventSource(LogSource, LogName);
                    log = new EventLog(LogName);
                    log.Source = LogSource;
                    log.Log = LogName;
                    log.MaximumKilobytes = 10240;
                    log.ModifyOverflowPolicy(OverflowAction.OverwriteAsNeeded, 10);
                }
                else
                {
                    log = new EventLog(LogName);
                    log.Source = LogSource;
                }
            }
            catch (Exception)
            {
            }
        }

        public static WebEventLog GetInstance()
        {
            if (instance == null)
            {
                instance = new WebEventLog();
            }
            return instance;
        }

        /// <summary>
        /// Write the exception to the event log
        /// </summary>
        /// <param name="information">The specified information</param>
        /// <param name="ex">The specified exception</param>
        public void WriteException(string information, Exception ex)
        {
            if (ex != null && !string.IsNullOrEmpty(information))
            {
                try
                {
                    log.WriteEntry(information + "\r\n Exception:" + ex.Message + "\r\n" + ex.StackTrace, EventLogEntryType.Error);
                }
                catch (Exception)
                {

                }
            }
        }

        /// <summary>
        /// Write the exception to the event log
        /// </summary>
        /// <param name="ex">The specified exception</param>
        public void WriteException(Exception ex)
        {
            if (ex != null)
            {
                try
                {
                    log.WriteEntry(ex.Message + "\r\n" + ex.StackTrace, EventLogEntryType.Error);
                }
                catch (Exception)
                { 
                  
                }
            }
        }

        /// <summary>
        /// write the specified information to event view
        /// </summary>
        /// <param name="information">the specified information</param>
        public void WriteInfomation(string information)
        {
            if (!string.IsNullOrEmpty(information))
            {
                try
                {
                  
                    log.WriteEntry("Log Information:\r\n" + information, EventLogEntryType.Information);

                }
                catch (Exception)
                {

                }
            }
        }
    }
}
