/* STARTUP(./cpu/CK510/start.o) */
ENTRY (_start)

/* INPUT(uartloader.a) */
/* INPUT(./lib/libc_new.a) */
/* INPUT(./lib/libm.a) */
INPUT(./cpu/CK510/libCK510.a)

OUTPUT(uartloader.elf)

/* Search directory for input files */
SEARCH_DIR(.)

/* No dynamic libraries */
__DYNAMIC  =  0;


MEMORY
{
 	ram	: ORIGIN = 0xc0100000, LENGTH = 0x1000000 /* 32M*/ /*0x1400000-0x100000*/	  /* 9.5M ~ 10M	*/
/*	ram	: ORIGIN = 0xc0800000, LENGTH = 0x30000	 */ /* 9.5M ~ 10M	*/
}
PROVIDE (__stack	= 0xc0a00000);		/* 1M		*/
PROVIDE (__loadaddr = 0xc0800000);		/* SDRAM END /*

/*
 * stick everything in ram (of course)
 */
SECTIONS
{
  .text :
  {
    *(.text)
    . = ALIGN(0x4);
    *(.eh_fram)
    . = ALIGN(0x4);
    *(.gcc_except_table) 
    _etext = .;
    *(.lit)
  } > ram

  .data BLOCK (0x4) :
  {
  	_data = .;
    *(.shdata)
    *(.data)
    *(.rodata)
    *(.rodata.*)
    . = ALIGN(0x4);
    *(.gcc_exc)
    _edata = .;
  } > ram

  .bss BLOCK (0x4) :
  {
    __bss_start = . ;
    *(.shbss)
    *(.bss)
    *(COMMON)
    _end =  ALIGN (0x8);
    __end = _end;
  } > ram

  .stab 0 (NOLOAD) :
  {
    *(.stab)
  }

  .stabstr 0 (NOLOAD) :
  {
    *(.stabstr)
  }
 
}
