/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Jan 11, 2005		TimYu		add support MBM29DL640E
 * Jan 19, 2005		TimYu		add support S29GL064M (MODEL R4)
 *
 * The file include more flash driver.
 * S29GL064M's datasheet : S29GLxxxM_00_A4_E_Final.pdf
 */

#include "armboot.h"
#include <config.h>
#include "w25Q64cv.h"
#define	FlashReadU16(addr)					(*((volatile unsigned short *)(addr)))
#define FlashReadU8(addr)						(*((volatile unsigned char *)(addr)))
#define	FlashWriteU16(addr, value)	(*((volatile unsigned short *)(addr)) = (value))
#define FlashWriteU8(addr,value) 		(*((volatile unsigned char *)(addr)) = (value))

#if defined (AM29LV160D) || defined (HY29LV320B)
#define FLASH_BANK_SIZE		0x200000
#define MAIN_SECT_SIZE		0x10000
#define PARAM_SECT_SIZE		0x2000
#define INIT_SECT_SIZE		0x4000		/* for AMD29LV160DB	*/
#define MIDDLE_SECT_SIZE	0x8000		/* for AMD29LV160DB	*/
#endif

#ifdef K8B1616UBA
#define FLASH_BANK_SIZE		0x200000
#define MAIN_SECT_SIZE		0x10000
#define PARAM_SECT_SIZE		0x2000
#endif

#if defined(AM29LV320D) || defined(AT49BV321)
#define FLASH_BANK_SIZE		0x400000
#define MAIN_SECT_SIZE		0x10000
#define PARAM_SECT_SIZE		0x2000
#endif

#ifdef SST39VF160
#define FLASH_BANK_SIZE		0x200000
#define MAIN_SECT_SIZE		0x10000
#define PARAM_SECT_SIZE		0x1000
#endif

#ifdef MBM29DL640E
#define FLASH_BANK_SIZE		0x800000
#define MAIN_SECT_SIZE		0x10000
#define PARAM_SECT_SIZE		0x2000
#endif

#ifdef	S29GL064M
#define FLASH_BANK_SIZE		0x800000
#define MAIN_SECT_SIZE		0x10000
#define PARAM_SECT_SIZE		0x2000
#define FLASH_PAGE_MASK 	0x1F
#define FLASH_BUFFER_SIZE 32
#endif

#ifdef	W25Q64M
#define FLASH_BANK_SIZE		0x800000
#define MAIN_SECT_SIZE		0x1000
//#define PARAM_SECT_SIZE		0x2000
//#define FLASH_PAGE_MASK 	0x1F
//#define FLASH_BUFFER_SIZE   32
#endif
flash_info_t flash_info[CFG_MAX_FLASH_BANKS];


/*-----------------------------------------------------------------------
 */

ulong
flash_init (bd_t * bd)
{
    int i, j;
    ulong size = 0;
    for (i = 0; i < CFG_MAX_FLASH_BANKS; i++)
    {

    ulong flashbase = 0;

#if defined(W25Q64M)
    flash_info[i].flash_id =
    (WBD_MANUFACT & FLASH_VENDMASK) | (WBD_ID_W25Q64M & FLASH_TYPEMASK);
#endif

    flash_info[i].size		= FLASH_BANK_SIZE;
    flash_info[i].sector_count	= CFG_MAX_FLASH_SECT;
    memset (flash_info[i].protect, 0, CFG_MAX_FLASH_SECT);

    flashbase = PHYS_FLASH_1;

    for (j = 0; j < flash_info[i].sector_count; j++)
    {
        
         flash_info[i].start[j] = flashbase + j * MAIN_SECT_SIZE;
        
    }
    size += flash_info[i].size;

    }

  /* Protect monitor and environment sectors
   */
  flash_protect (FLAG_PROTECT_SET,
		 CFG_FLASH_BASE,
		 CFG_FLASH_BASE + _armboot_end - _armboot_start,
		 &flash_info[0]);

  flash_protect (FLAG_PROTECT_SET,
		 CFG_ENV_ADDR,
		 CFG_ENV_ADDR + CFG_ENV_SIZE - 1,
		 &flash_info[0]);

  return size;

} /* end flash_init */

/*-----------------------------------------------------------------------
 */
void
flash_print_info (flash_info_t * info)
{
  int i;

  switch (info->flash_id & FLASH_VENDMASK)
    {
    case (SAMSUNG_MANUFACT & FLASH_VENDMASK):
      printf ("SAMSUNG : ");
      break;
#if (1)
    case (SPS_MANUFACT & FLASH_VENDMASK):
      printf ("SPANSION (AMD) : ");
      break;
#else
    case (AMD_MANUFACT & FLASH_VENDMASK):
      printf ("AMD : ");
      break;
#endif
    case (ATMEL_MANUFACT & FLASH_VENDMASK):
      printf ("ATMEL : ");
      break;
    case (FUJ_MANUFACT & FLASH_VENDMASK):
      printf ("FUJITSU : ");
      break;
    case (SST_MANUFACT & FLASH_VENDMASK):
      printf ("SST : ");
      break;
    case (HYNIX_MANUFACT & FLASH_VENDMASK):
      printf ("HYNIX : ");
      break;
    case (WBD_MANUFACT & FLASH_VENDMASK):
      printf ("WINBOND : ");
      break;
    default:
      printf ("Unknown Vendor ");
      break;
    }

  switch (info->flash_id & FLASH_TYPEMASK)
    {
    case (SAMSUNG_ID_K8B1616UBA & FLASH_TYPEMASK):
      printf ("K8B1616UBA\n");
      break;
    case (AMD_ID_LV320DB & FLASH_TYPEMASK):
      printf ("AM29LV320D\n");
      break;
    case (ATMEL_ID_AT49BV321 & FLASH_TYPEMASK):
      printf ("AT49BV321\n");
      break;
#if defined(MBM29LV160BE)
    case (FUJ_ID_MBM29LV160BE & FLASH_TYPEMASK):
      printf ("MBM29LV160BE\n");
      break;
#elif defined(M29W160DB)
    case (ST_ID_M29W160DB & FLASH_TYPEMASK):
      printf ("M29W160DB\n");
      break;
#elif defined(MBM29DL640E)
    case (FUJ_ID_MBM29DL640E & FLASH_TYPEMASK):
      printf ("MBM29DL640E\n");
      break;
#elif defined(S29GL064M)
    case (SPS_ID_S29GL064M & FLASH_TYPEMASK):
      printf ("S29GL064M\n");
      break;
#else
    case (AMD_ID_LV160D & FLASH_TYPEMASK):
      printf ("AM29LV160D\n");
      break;
#endif
    case (SST_ID_xF160A & FLASH_TYPEMASK):
      printf ("SST39VF160\n");
      break;
    case (HYNIX_ID_HY29LV320B & FLASH_TYPEMASK):
      printf ("HY29LV320B\n");
      break;
     case (WBD_ID_W25Q64M & FLASH_TYPEMASK):
      printf ("W25Q64CV\n");
      break;
    default:
      printf ("Unknown Chip Type\n");
      goto Done;
      break;
    }

  printf ("  Size: %ld MB in %d Sectors\n", info->size >> 20,
	  info->sector_count);

  printf ("  Sector Start Addresses:");
  for (i = 0; i < info->sector_count; i++)
    {
      if ((i % 5) == 0)
	{
	  printf ("\n   ");
	}
      printf (" %08lX%s", info->start[i],
	      info->protect[i] ? " (RO)" : "     ");
    }
  printf ("\n");

Done:
}

/*-----------------------------------------------------------------------
 */

int
flash_erase (flash_info_t * info, int s_first, int s_last)
{
  int rc = ERR_OK;

  return rc;
}

/*-----------------------------------------------------------------------
 * Copy memory to flash
 */
static int write_word(flash_info_t * info, ulong addr, ushort data)
{
	return 0;
} /* end WriteWord */


/*	addr must is sector address */
int
write_buff (flash_info_t * info, uchar * src, ulong addr, ulong cnt)
{
	return 0;

}


/*
	Read the ID of the flash
		ManID : Manufacturer ID
		DevID : Device ID
*/
void flash_ReadID(unsigned int *ManID, unsigned int *DevID)
{
	unsigned int devid = 0;
	//disable_interrupts();
    w25q64cv_read_device_id( ManID,DevID);

} /* end flash_ReadID */


int erase_flash_sector (int s_first, int s_last)
{
  int sect;
  for (sect = s_first; sect <= s_last && !ctrlc (); sect++)
    {
      unsigned long SectorAddr;
      SectorAddr = flash_info[0].start[sect];	/* total address */
      w25q64cv_erase(SectorAddr,1,flash_erase_4k_mode);
    }

  return 0;
}

int erase_flash_all (flash_info_t * info)
{
    w25q64cv_chip_erase();
}
int read_flash_byte(u8 *buf,u32 addr,u32 count)
{
     w25q64cv_read(buf,addr,count);
     return 0;
}
int write_flash_byte(u8 *buf,u32 addr,u32 count)
{
	    w25q64cv_write(buf,addr,count,little_endian);
	    return 0;
}

int write_jffs2_byte(u8 *buf,u32 addr,u32 count)
{
    w25q64cv_write(buf,addr,count,big_endian);
    return 0;
}
