/*
 * This file is only to emulate uCboot environment related functions.
 * If kernel & userland use environment supplied by uCboot methods, use this function
 */
#include <armboot.h>
#include "s3c2500.h"

#ifdef CONFIG_UCBOOTSTRAP	/* The uCbootstrap system calls use	*/

#define FEF_WEAK        0x0001

#define FEF_BOOT_MASK   0x000E
#define FEF_BOOT_READ   0x0002
#define FEF_BOOT_WRITE  0x0004
#define FEF_BOOT_WHITE  0x0008

#define FEF_SUPER_MASK  0x00E0
#define FEF_SUPER_READ  0x0020
#define FEF_SUPER_WRITE 0x0040
#define FEF_SUPER_WHITE 0x0080

#define FEF_USER_MASK   0x0E00
#define FEF_USER_READ   0x0200
#define FEF_USER_WRITE  0x0400
#define FEF_USER_WHITE  0x0800

#define FEF_FACTORY     0x1000
#define FEF_SERIAL      0x2000

#define FEV_VALID       0xffffffffUL
#define FEV_WHITEOUT    0x0000
#define FEV_PROTECT     0x0001

int pmask = FEF_BOOT_READ | FEF_BOOT_WRITE;
bd_t *bd_save;



typedef struct _memnode {
  int len;
  int *offset;
} mnode_t;

//================================================


int bsc_test(int a, int b, int c, int d, int e)
{
    printf("bsc_test(%d, %d, %d, %d, %d)\n",a,b,c,d,e);
    return (e);
}

/* find an entry in FLASH memory */
char * bsc_getenv(char *name)
{
	//unsigned long flags;
	char * fev;
	unsigned int temp;

#if 1	// hans, because of ethernet bug of kernel driver
	temp = (unsigned int)bd_save->bi_env;	//hans
	if((*name =='H')&&(*(name+1) =='W')&&(*(name+2) =='A')&&(*(name+3) =='D')&&(*(name+4) =='D')&&(*(name+5) =='R')){
		bd_save->bi_env =0;						//hans --> get data from flash
	}
#endif
	fev = getenv (bd_save, name);
#if 1	// hans, because of ethernet bug of kernel driver
	bd_save->bi_env = (env_t*)temp;			//hans
#endif

	return fev;
}
//===========================================================
//===========================================================
//===========================================================
// 02.12.~ 03.01. ARMBOOT +  uCEmulation append code section
//===========================================================
//===========================================================

//==========================================================
// append  @0 bsc_reset   code by LAPUTA
// unreachable ......?????
//===========================================================
int bsc_reset(int flags){
	//if(flags){
//		printf("LAPUTA RESET\n");
		reset_call(bd_save);
//	}


}

//============================================================
// append @17 bsc_readenv by LAPUTA
// cmd =>
// 0= start initial & return 1st name return
// 1= index name return
// 2= value of name return
// ===> ../common/cmd_nvedit.c : readenv(bd_t *bd, int cmd)
//============================================================

char * bsc_readenv(int cmd){
	char *fev;
	env_t *old_bi_env;

	old_bi_env = bd_save->bi_env;
	bd_save->bi_env =0;			// flash read

	fev =readenv(bd_save,cmd);

	bd_save->bi_env = old_bi_env;

	return fev;
}
//============================================================
// append @18 flash_chattr_range by LAPUTA
// flashptr => flash memory base address
// start => start address that we want to modify dirty bit
// end => end address that we want to modify dirty bit
//
// ../common/flash.c :flash_protect_range( start_addr,int end_addr,int protect_flag)
//  uCboot  -> 0x01 : Dirty, 0x02 : Erased, 0x04:Protect
//
// FLAG_PROTECT_SET = 0x01
// FLAG_PROTECT_CLEAR = 0x02
// cmd_flash.c: flash_protect_range -> flash_sect_protect
//============================================================


int flash_chattr_range(unsigned short *flashptr, int start, int end, char and, char or){


	//int flag = (or & PROTECT_FLAG) ?  FLAG_PROTECT_SET :  FLAG_PROTECT_CLEAR ;		// only protect set
	int flag = (or & PROTECT_FLAG) ?  1 :  0 ;		// only protect set
	//printf("\n\nflag : %x,%x\n",or,flag);

	if(flash_protect_range(flashptr,start, end, flag))// protect set info->protect[n]
		return 1;
	else
		return 0;			// SET/clear error
}

//============================================================
// append @19 flash_erase_range by LAPUTAflash_sect_erase
// start => start address that we want to erase
// end => end address that we want to erase
//start : erase start address
// end : erase end address
//
//../common/flash.c :flash_sect_erase(ulomg start_addr, ulong end_addr)
//============================================================

int flash_erase_range(unsigned short *flashptr, int start, int end){
	ulong start_addr;
	ulong end_addr;

	start_addr = flashptr;		// start address save
	start_addr += start;		// seperator calc cause address type mismatch

	end_addr = flashptr;
	end_addr += end;

	printf("\n\nflash ERASE  from:[%x]  ~  to:[%x] \n", start_addr, end_addr);

	// sector erase where sector of start & end address 
	flash_sect_erase(start_addr ,  end_addr);

	return 0;
}
//==========================================================

//===========================================================
// append @20 falsh_write_range by LAPUTA
// ../common/flash.c : flash_write(uchar *src, ulong offset, ulong len)
// src : ram start address of source
// offset : flash write start address
// len : No# write byte s
//
// ../common/flash.c :flash_write(uchar *src ,       ulong addr,         ulong cnt)
//===========================================================

int flash_write_range(unsigned short * flashptr, mnode_t *mnode, int offset){

 	printf("uCFlash write source(RAM) start address : [%x]\n",&mnode->offset);
	printf("uCFlash write dest.(FLASH) start address : [%x]\n",offset);

	flash_write((unsigned char *)mnode->offset, (unsigned long)offset, (unsigned long)mnode->len);
	           // (uchar *src ,       ulong addr,         ulong cnt)
	printf("Flash Write DONE!.......................\n");
	return 0;
}
//==========================================================

//==========================================================
// append  @21 bsc_ramload   code by LAPUTA
// unreachable.......
//
//../common/cmd_nvedit.c : go_ram(bd_t *bd,int flag)
// --->boocmd & reset  & while loop
//===========================================================
#define	DRAM_APP_START	0x40000			// application of ram start address
int bsc_ramload(mnode_t *mnode, int flag){

	void	**chain = (void **)mnode->offset;
	int	len = mnode->len;
	int	length,offset;
	int	block = 0;

	for(offset =0; offset <len ;offset+= 4096,block++){

		if((len-offset)>4096)	length = 4096;
		else				length = len - 4096;

		printf("Flash %2d block [%x] write to ram start ......\n",block,DRAM_BASE+DRAM_APP_START+offset);
		memcpy( (void *)(DRAM_BASE+DRAM_APP_START+offset),(void *)chain[block],length);
		printf("WRITE DONE ! ! ...\n");
	}

	//to cmd_nvedit.c
	go_ram(bd_save,flag);

	return 0;

}
//===========================================================

//-------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------
//-------------------------------------------------------------------------------------------------------------------
/* @15 write an entry in ram area */

int bsc_setenv(char *pair)
{
	char *p;

	if (!pair)
		return -1;

	for (p=pair; *p; p++)
	{
		if (*p == '=')
		{
			*(p++) = 0;
			break;
		}
	}

	setenv (bd_save, pair, p);
	board_env_save(bd_save, bd_save->bi_env, sizeof(env_t));		// 20030220 added by drsohn
	return 0;
}

void *bsc_getserialnum(void)
{
	int mask = pmask;
	void *ret;

	pmask = FEF_BOOT_READ | FEF_SUPER_READ | FEF_USER_READ;
	ret =(void *)bsc_getenv("SERIAL");
	pmask = mask;

	return(ret ? ret : "none");
}

/* reset:  Reset external devices and the processor */
void *bsc_gethwaddr(int ifnum)
{
	int mask = pmask;
	char *ret;
	int i;
	unsigned char tempconv[3]={0, 0, 0};
	static unsigned char hwaddr[6] = {0, 0, 0, 0, 0, 0};

	pmask = FEF_BOOT_READ | FEF_SUPER_READ | FEF_USER_READ;
	ret =(char *)bsc_getenv( ifnum? "HWADDR1" : "HWADDR0");
	pmask = mask;

	memset(hwaddr, 0, 6);
	
	if (ret && strlen(ret) == 17) {
		for (i=0; i<6; i++) {
			tempconv[0] = ret[i*3];
			tempconv[1] = ret[i*3 +1];
			tempconv[2] =0;
			hwaddr[i] = simple_strtoul(tempconv, 0, 16);
		}
	}
	return(&hwaddr);
}

int bsc_setpmask(int mask)
{
  pmask = mask;

  return 0;
}
#endif	/* CONFIG_UCBOOTSTRAP */
