/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include "armboot.h"
#include "s3c2510.h"
/* ------------------------------------------------------------------------- */


/*
 * Miscelaneous platform dependent initialisations
 */

int board_init(bd_t *bd)
{
    /* arch number of EP7111 */
    bd->bi_arch_number = 50;

    /* location of boot parameters for EP7111 */
    /* FIXUP please */
    /*bd->bi_boot_params = 0xc0020100;*/
	bd->bi_boot_params = 0x80004000;
    
    return 1;
}

int dram_init(bd_t *bd)
{
    int		tmp;

    tmp = *(int *)(0xf0020000);

    if ((tmp & 0x000000f0) == 0xf0)
    {
     bd->bi_dram[0].start = PHYS_SDRAM_1;
     bd->bi_dram[0].size  = PHYS_SDRAM_64M_SIZE;
    }
    else
    {
     bd->bi_dram[0].start = PHYS_SDRAM_1;
     bd->bi_dram[0].size  = PHYS_SDRAM_1_SIZE;
    }

    return PHYS_SDRAM_1_SIZE;
}
