/*
 * common/alm.c
 *
 * (C) Copyright 1992 to 2005 ZHEJIANG DaHua Technology Stock CO., LTD.
 *
 * Apr 12, 2005		gaoyj		File created.
 *
 * alarm api.
 */
#include <stdio.h>
#include <string.h>

/*
 * DVR series
 */
#define DVR_LB_REAL		2
#define DVR_LB_REC		3
#define DVR_LB_ATM		4
#define DVR_GBE			5
#define DVR_LB_LK		6
#define DVR_LBE 		8

#define ADDR_AIN_V1_XX		0x85000000	/* AIN - Alarm Input */
#define ADDR_AOUT_V1_22		0x82000000	/* AOUT - Alarm Output */

#define ADDR1_AOUT_V1_11	0x85000001
#define ADDR2_AOUT_V1_11	0x85000002
#define ADDR3_AOUT_V1_11	0x85000003

#define ADDR_AIN_V2_0		0x82000000
#define ADDR_AOUT_V2_0		0x82000002

/*
 * DVR board mask
 */
#define BOARD_V1_11		0x0001	/* 1.11 mother board */
#define BOARD_V1_22		0x0002	/* 1.22 mother board repaired BOARD_BUG bug */
#define BOARD_V2_0		0x0004	/* 2.0  mother board */
#define BOARD_BUG		0x0008	/*
					 * old version have design Bug
					 * 8th input trigger off all warn out
					 */
#define BOARD_AOUT_1500		0x0010

#define DVR_CH_16_8_ADDR	0x83000018
#define DVR_CH_4_ADDR		0x83000004

#define S3C2510_B2CON		0xF0010008
#define S3C2510_B3CON		0xF001000C
#define S3C2510_B5CON		0xF0010014

#define BIT8_IO			0x450FFFFF
#define BIT16_IO		0x850FFFFF
#define BIT32_IO		0xC50FFFFF

#define	MemGetU08(addr)		(*((volatile unsigned char  *)(addr)))
#define	MemGetU16(addr)		(*((volatile unsigned short *)(addr)))
#define	MemGetU32(addr)		(*((volatile unsigned int   *)(addr)))

typedef struct _dvr_id_t
{
	unsigned char product;
	unsigned char chan;

	unsigned char ver;
	unsigned char func;
} __attribute__ ((packed)) dvr_id_t;

static dvr_id_t g_dvr_id;
static int g_board_type;

static inline void
MemPutU08(unsigned int addr, unsigned char value)
{
	*((volatile unsigned char *)(addr)) = value;
}

static inline void
MemPutU16(unsigned int addr, unsigned short value)
{
	*((volatile unsigned short *)(addr)) = value;
}

static inline void
MemPutU32(unsigned int addr, unsigned int value)
{
	*((volatile unsigned int *)(addr)) = value;
}

static unsigned int __GetDVRID(unsigned int addr)
{
	unsigned int id = 0;
	int i;

	for (i = 0; i < 8; i++)
	{
		unsigned char val;

		val = MemGetU08(addr + i);

		id |= ((val & 0x03) << (2 * i));
	}

	return id;
}

static unsigned int GetDVRID(void)
{
	unsigned int id = 0;

	MemPutU32(S3C2510_B3CON, BIT8_IO);

	id = __GetDVRID(DVR_CH_16_8_ADDR);

	/*
	 * if id == 0 or id == 0xffff , 4 chanale board
	 */
	if (id == 0 || id == 0xffff)
	{
		return __GetDVRID(DVR_CH_4_ADDR);
	}

	return id;
}

static int PNX1500_AlarmWrite(unsigned int almOut)
{
	return 0;
}

static inline void AlarmWrite_1500(unsigned char output)
{
	PNX1500_AlarmWrite(output);
}

static inline void AlarmWrite_bug(unsigned char output)
{
	unsigned char value = 0;

	value = output & 0x0f;
	value |= ((output & 0xf0) << 1);
	value |= 0x80;

	MemPutU08(ADDR_AOUT_V1_22, 0x00);
	MemPutU08(ADDR_AOUT_V1_22, value);
}

static inline void AlarmWrite_V1_22(unsigned char output)
{
	unsigned char value = 0;

	value = output & 0x0f;
	value |= ((output & 0xf0) << 1);
	value |= 0x80;

	MemPutU08(ADDR_AOUT_V1_22, 0x7f);
	MemPutU08(ADDR_AOUT_V1_22, value&0x7f);
	MemPutU08(ADDR_AOUT_V1_22, 0xff);
}

static inline void AlarmWrite_V1_11(unsigned char output)
{
	if (output & 0x01)
	{
		MemPutU08(ADDR1_AOUT_V1_11, 0x01);
	}
	else
	{
		MemPutU08(ADDR1_AOUT_V1_11, 0x00);
	}

	if (output & 0x02)
	{
		MemPutU08(ADDR2_AOUT_V1_11, 0x01);
	}
	else
	{
		MemPutU08(ADDR2_AOUT_V1_11, 0x00);
	}

	if (output & 0x04)
	{
		MemPutU08(ADDR3_AOUT_V1_11, 0x01);
	}
	else
	{
		MemPutU08(ADDR3_AOUT_V1_11, 0x00);
	}
}

static inline void AlarmWrite_V2_0(unsigned char output)
{
	unsigned char value = 0;

	value = output & 0x0f;
	value |= ((output & 0xf0) << 1);

	MemPutU16(ADDR_AOUT_V2_0, value);
}

/************************************************************************
 * Write alarm status
 *
 * ret : > 0	bytes by write
 * 	<= 0	False
 *
 ************************************************************************/
static int AlarmWrite(unsigned int data)
{
	unsigned char output = data & 0xff;

        /*
	 * If use 1500 to control output, firstly use it.
	 */
	if (g_board_type & BOARD_AOUT_1500)
	{
		AlarmWrite_1500(output);
	}
	else if (g_board_type & BOARD_V1_11)
	{
		AlarmWrite_V1_11(output);
	}
	else if (g_board_type & BOARD_V1_22)
	{
		AlarmWrite_V1_22(output);
	}
	else if (g_board_type & BOARD_V2_0)
	{
		AlarmWrite_V2_0(output);
	}
	else /* BOARD_BUG */
	{
		AlarmWrite_bug(output);
	}

	return 1;
} /* end AlarmWrite */

static void  PNX1500_SetAlarmVer(int alarmVer)
{
	return;
}

static int AlarmCreate(void)
{

#if 0
	unsigned short dvr_id, chan;

	dvr_id = GetDVRID();
	printf("DVRID: 0x%04X\n", dvr_id);

	memset(&g_dvr_id, 0, sizeof(dvr_id_t));
	g_board_type = 0;

	g_dvr_id.product = (dvr_id >> (4 * 0)) & 0x0f;
	g_dvr_id.chan    = (dvr_id >> (4 * 1)) & 0x0f;
	g_dvr_id.ver     = (dvr_id >> (4 * 2)) & 0x0f;
	g_dvr_id.func    = (dvr_id >> (4 * 3)) & 0x0f;

	/*
	 * Convert chan to real chan.
	 */
	switch (g_dvr_id.chan)
	{
		case 0:  chan = 16; break;
		case 1:  chan = 12; break;
		case 2:  chan = 8;  break;
		case 3:  chan = 6;  break;
		case 4:  chan = 4;  break;
		case 5:  chan = 2;  break;
		case 6:  chan = 1;  break;
		default: chan = 16; break;
	}
	g_dvr_id.chan = chan;

	printf("Chan = %d; Product = %d; Func = %d; Ver = %d\n",
		g_dvr_id.chan,
		g_dvr_id.product,
		g_dvr_id.func,
		g_dvr_id.ver);

	/*
	 * Get board type
	 */
	switch (g_dvr_id.product)
	{
	case DVR_LB_REC:
		//printf("DVR: LB-Rec, --NOT-- ");

	case DVR_LB_REAL:
		//printf("DVR: LB-Real\n");
		switch (g_dvr_id.ver)
		{
		case 0:
			if (g_dvr_id.chan <= 4)
			{
				g_board_type = BOARD_V1_11;
			}
			else
			{
				g_board_type = BOARD_BUG;
			}
			break;
		case 1:  g_board_type = BOARD_V1_22; break;
		case 2:  g_board_type = BOARD_V1_22; break;
		case 3:  g_board_type = BOARD_V2_0;  break;
		default: g_board_type = BOARD_V2_0;  break;
		}
		break;

	case DVR_LB_ATM:
		//printf("DVR: ATM\n");
		g_board_type = BOARD_V1_11;
		break;

	case DVR_GBE:
		//printf("DVR: GBE\n");
		g_board_type = BOARD_V2_0;
		break;

	case DVR_LB_LK:
		//printf("DVR: LK\n");
		g_board_type = BOARD_V1_22;
		break;
	case DVR_LBE:
		//printf("DVR: LBE\n");
		g_board_type = BOARD_V1_11;
		break;
	default:
		//printf("Unknown product type, take as v2.0\n");
		g_board_type = BOARD_V2_0;
		break;
	}

        /*
	 * Special type, alarm output via pnx1500.
	 * LBL(GBEL) - 1 or LBC(GBEC) - 3
	 */
	if ((1 == g_dvr_id.func) || (3 == g_dvr_id.func))
	{
		g_board_type |= BOARD_AOUT_1500;
	}

	/*
	 * Init bank I/O mode
	 */
	printf("Alarm-mode: ");
	if (g_board_type & BOARD_V1_11)
	{
		printf("V1.11\n");
		MemPutU32(S3C2510_B5CON, BIT8_IO);
	}
	else if (g_board_type & BOARD_V1_22)
	{
		printf("V1.22\n");
		MemPutU32(S3C2510_B5CON, BIT16_IO);
		MemPutU32(S3C2510_B2CON, BIT8_IO);
	}
	else if (g_board_type & BOARD_V2_0)
	{
		printf("V2.0\n");
		MemPutU32(S3C2510_B2CON, BIT16_IO);
	}
	else /* BOARD_BUG */
	{
		printf("Old(bug)\n");
		MemPutU32(S3C2510_B5CON, BIT16_IO);
		MemPutU32(S3C2510_B2CON, BIT8_IO);
	}

        if (g_board_type & BOARD_AOUT_1500)
	{
		printf("Alarm output via pnx1500\n");
		PNX1500_SetAlarmVer(1);
	}
#endif

	return 0;
}

int AlarmInit(void)
{
	AlarmCreate();
	AlarmWrite(0x00);
	return 0;
} /* end AlarmInit */
