/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
  */

#include "armboot.h"
#include "command.h"
#include "devices.h"
#include "version.h"
#ifdef CONFIG_S5N8947
#include "s5n8947.h"
#endif
#ifdef CONFIG_S3C2500
#include "s3c2500.h"
#endif
#ifdef CONFIG_S3C2510
#include "s3c2510.h"
#endif
#include "log.h"
#include "spi.h"
#include "hdcvi_upgrade.h"
/*
#if defined(CONFIG_S5N8947) || defined(CONFIG_S3C2500) || defined(CONFIG_S3C2510)
extern void InitEtherApi (bd_t * bd);
#endif*/

#ifdef CONFIG_UCBOOTSTRAP	/* The uCbootstrap system calls use     */
extern bd_t *bd_save;
#endif

/*
 * Begin and End of memory area for malloc(), and current "brk"
 */
static ulong mem_malloc_start = 0;
static ulong mem_malloc_end = 0;
static ulong mem_malloc_brk = 0;

void InitEtherApi (bd_t * bd)
{
	
}

static void
mem_malloc_init (ulong dest_addr)
{
  mem_malloc_start = dest_addr;
  mem_malloc_end = dest_addr + CONFIG_MALLOC_SIZE;
  mem_malloc_brk = mem_malloc_start;
  memset ((void *) mem_malloc_start, 0, mem_malloc_end - mem_malloc_start);
}

void *
sbrk (ptrdiff_t increment)
{
  ulong old = mem_malloc_brk;
  ulong new = old + increment;

  if ((new < mem_malloc_start) || (new > mem_malloc_end))
    {
      return (NULL);
    }
  mem_malloc_brk = new;

  return ((void *) old);
}

/*
 * Breath some life into the board...
 *
 * Initialize an SMC for serial comms, and carry out some hardware
 * tests.
 *
 * The first part of initialization is running from Flash memory;
 * its main purpose is to initialize the RAM so that we
 * can relocate the monitor code to RAM.
 */
 
#if 0
	void testm(void)
	{
		unsigned int i;
		unsigned int *p = 0xC0100000;
		
		*(unsigned int *)(0x70000070) = 0x0;
		for(i=0;i<1024*1024;i++)
		{
			*p++ = i;
		}
		
		i = *(unsigned int *)(0x70000070);
		printf("i = 0x%08lx\n",i);
	}

#endif

extern void print_id(bd_t *_bd);

void
start_armboot (void)
{
  bd_t bd;
  ulong size; 
  int i;

#ifdef CONFIG_UCBOOTSTRAP	/* The uCbootstrap system calls use     */
  bd_save = &bd;
#endif

  /* set up bd strucuture */
  memset (&bd, 0, sizeof (bd));
  bd.bi_baudrate = CONFIG_BAUDRATE;


  /* basic cpu dependent setup */
  cpu_init (&bd);


  /* basic board dependent setup */
  board_init (&bd);

  /* initialize environment */
  env_init (&bd);

  /* serial communications setup */
  serial_init (&bd);


  // initialize log library
//      InitLog();

  display_banner (&bd);

  /* set up execptions */
  interrupt_init (&bd);

  /* configure available RAM banks */
  dram_init (&bd);
  display_dram_config (&bd);
  
  /* configure available FLASH banks */

#ifndef CONFIG_IS_PCI 
  size = flash_init (&bd);
//  display_flash_config (&bd, size);
#endif
  /* armboot_end is defined in the board-specific linker script */
  /* allocate heap */

  mem_malloc_init (_armboot_real_end);
  
  /* initialize Ethernet */
  //eth_init( &bd );

  spi_init();
  
  /* initialize environment */
#ifndef CONFIG_IS_PCI
  env_relocate (&bd);
#endif

#if defined(CONFIG_S3C2500) || defined(CONFIG_S3C2510)
  /* cache init       choish 20020828 */
  Cache_init (&bd);
  /* write buffer init  choish 20020828 */
  Wbuffer_init (&bd);
#endif
  /* enable exceptions */
  //enable_interrupts ();

  print_id(&bd);
  
	printf ("\n");

    
    /* prepare for hdcvi upgrade: 720P_25fps */ 
    hdcvi_upgrade_init(&bd);
    
    
	//testm();
  
  /* main_loop() can return to retry autoboot, if so just run it again. */
  for (;;)
    {
    	
      main_loop (&bd);
    }

  /* NOTREACHED - no way out of command loop except booting */
}

void
hang (void)
{
  puts ("### ERROR ### Please RESET the board ###\n");
  for (;;);
}
