/*
 * (C) Copyright 2000, 2001
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 */

#include <armboot.h>
#include <config.h>
#include <command.h>
#include <cmd_i2c.h>

#ifdef CFG_USE_I2C

extern unsigned int loadb_len;

/* IIC Register descriptors */
#define CKCORE_IIC_PRERH	0x4300001A
#define CKCORE_IIC_PRERL	0x4300001E
#define CKCORE_IIC_TXR		0x4300000A
#define CKCORE_IIC_RXR		0x4300000E
#define CKCORE_IIC_CTR		0x43000012
#define CKCORE_IIC_CR		0x43000016
#define CKCORE_IIC_SR		0x43000006

// ctr register
#define CKCORE_IIC_EN			7
#define CKCORE_IIC_IEN			6

// command register(cr)
#define CKCORE_IIC_STA			7
#define CKCORE_IIC_STP			6
#define CKCORE_IIC_WR			5
#define CKCORE_IIC_RD			4
#define CKCORE_IIC_IACK			3
#define CKCORE_IIC_ACK			2

// Status register(sr)
#define CKCORE_IIC_RXACK		7
#define CKCORE_IIC_BUSY			6
#define CKCORE_IIC_AL			5
#define CKCORE_IIC_TIP			4
#define CKCORE_IIC_IFLAG		3
#define CKCORE_IIC_IFLAGQUERY	2

// command register default value
#define CKCORE_IIC_CRDEF		0x04

#define IIC_CMD_EN				( 1 << CKCORE_IIC_EN )
#define IIC_CMD_START			( 1 << CKCORE_IIC_STA )
#define IIC_CMD_STOP			( 1 << CKCORE_IIC_STP )
#define IIC_CMD_SEND_END		( ( 1 << CKCORE_IIC_WR ) + ( 1 << CKCORE_IIC_ACK) )
#define IIC_CMD_SEND_CONTINUE	IIC_CMD_SEND_END
#define IIC_CMD_REV_END			( ( 1 << CKCORE_IIC_RD ) + ( 1 << CKCORE_IIC_ACK) )
#define IIC_CMD_REV_CONTINUE	( 1 << CKCORE_IIC_RD )


#define IIC_CMD_START_REV_END	IIC_CMD_START | IIC_CMD_REV_END

//send a start single and write the device address for write at once
#define IIC_CMD_STA_DEVADDR_W	IIC_CMD_START | IIC_CMD_SEND_CONTINUE

// send a start singke and write the device address for read at once
#define IIC_CMD_STA_DEVADDR_R	IIC_CMD_START | IIC_CMD_SEND_CONTINUE

int do_i2c_t(unsigned char op, unsigned char data)
{
	unsigned char tmp;
	unsigned int tout;
	
	*(volatile unsigned char *)CKCORE_IIC_TXR = data;
	*(volatile unsigned char *)CKCORE_IIC_CR = op;
	
	tout = 0;
	while(1)
	{
		tmp = *(volatile unsigned char *)CKCORE_IIC_CR;
		
		if( CKCORE_IIC_CRDEF == tmp )
		{
			return 0;
		}
		tout++;
		
		if( tout > 0x1fffff )
		{
			return 1;
		}
	}
}

int do_i2c_r( unsigned char addr, unsigned char sub_addr )
{
	unsigned char m_addr, s_addr;
	unsigned char reg = 0;
	
	m_addr = addr;
	s_addr = sub_addr;
	
	do_i2c_t( IIC_CMD_STA_DEVADDR_W, m_addr );
	
	do_i2c_t( IIC_CMD_SEND_CONTINUE, s_addr );
	
	do_i2c_t( IIC_CMD_STA_DEVADDR_W, m_addr | 0x01 );
	
	do_i2c_t( IIC_CMD_REV_END, m_addr | 0x01 );	
	
	reg = *(volatile unsigned char *)CKCORE_IIC_RXR;
	
	return reg;
}

void do_i2c_w( unsigned char addr, unsigned char sub_addr, unsigned char data)
{
	do_i2c_t( IIC_CMD_STA_DEVADDR_W, addr );
	do_i2c_t( IIC_CMD_SEND_CONTINUE, sub_addr );
	do_i2c_t( IIC_CMD_SEND_CONTINUE, data );
	do_i2c_t( IIC_CMD_STOP, addr );
}

void do_i2c_f( unsigned int addr )
{
	unsigned int i,cnt;
	char *p;
	char *sp;
	
	unsigned char tmp;
	unsigned char m_addr, s_addr;
	char str[256];
	int argc;
	char *argv[5];
	
	cnt = loadb_len - addr;
	
	printf ("File's address = 0x%08lx; size = %#x\n", addr, cnt);
	
	//spcae to enter
	p = (char *)addr;
	for( i = 0; i < cnt; i++ )
	{
		if ( ( 0x0d == *p ) || ( 0x0a == *p ) )
		{
			*p = 0;
		}
		p++;
	}
	
	p = (char *)addr;
	while(1)
	{
		memset( str, 0, 256 );
		sp = str;
		strcpy( sp, p );
		
		cnt = strlen( sp );
		
		if( cnt > 0 )
		{
			for( i = 0; i < cnt; i++ )
			{
				if( ( 0x09 != *sp ) && ( 0x20 != *sp ) )
					break;
					
				sp++;
			}
			
			i = cnt - i;
			
			if( i > 2 )
			{
				if( '#' == *sp )
				{
					printf("%s\n", sp);
				}
				else
				{
					//get opration
					argv[0] = strtok( sp, " " );
					for( argc = 1; argc < 5; argc++ )
					{
						argv[argc] = strtok( NULL, " ");
						if( NULL == argv[argc] )
							break;
					}
					
					if( argc > 3 )
					{
						//do i2c
						//printf("%s %s %s %s %s\n", argv[0], argv[1], argv[2], argv[3], argv[4] );
						if( 0 == strcmp(argv[0], "./i2c") )
						{
							m_addr = simple_strtoul (argv[2], NULL, 16);
							s_addr = simple_strtoul (argv[3], NULL, 16);
							
							if( 'w' == argv[1][0] )
							{
								//write to i2c
								tmp = simple_strtoul (argv[4], NULL, 16);
								do_i2c_w(m_addr, s_addr, tmp);
								printf("%s %s %s %s %s\n", argv[0], argv[1], argv[2], argv[3], argv[4] );
							}
							else
							{
								//read from i2c
								tmp = do_i2c_r( m_addr, s_addr );
								printf("m_addr = %#x; s_addr = %#x; tmp = %#x\n", m_addr, s_addr, tmp);
							}
						}
					}
					
				}
			}
		}
		
		p += cnt + 2;
		
		if( (unsigned int)p >= loadb_len )
		{
			break;
		}
	}
	
	printf("done.\n");
}

int
do_mem_i2c (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[])
{
	int op;
	unsigned char tmp;
	unsigned char m_addr, s_addr;
	unsigned int f_addr;
	
	register cache;
	
	if (argc < 2)
	{
		op = 0;	//read i2c
	}
	else
	{
		switch( argv[1][0] )
		{
			case 'w':
			{
				op = 1;
				break;
			}
			case 'f':
			{
				op = 2;
				break;
			}
			case 'c':
            {
                op = 3;
                break;
            }
			default:
			{
				op = 0;
				break;
			}
		}
	}
	
	switch( op )
	{
		case 1:
		{
			m_addr = simple_strtoul (argv[2], NULL, 16);
			s_addr = simple_strtoul (argv[3], NULL, 16);
			tmp = simple_strtoul (argv[4], NULL, 16);
			do_i2c_w(m_addr, s_addr, tmp);
			printf("m_addr = %#x; s_addr = %#x; tmp = %#x\n", m_addr, s_addr, tmp);
			break;
		}
		case 2:
		{
			if( argc < 3 )
				f_addr = 0xc0100000;
			else
				f_addr = simple_strtoul (argv[2], NULL, 16);
			do_i2c_f(f_addr);
			break;			
		}
		case 3:
        {
            __asm__ __volatile__
            (
                //get cache
                "mfcr %0, cr18\n"
                : "=r" (cache)
                : "0"(cache)
            );
            
            if ( cache & 0x08 )
            {
                printf("DCache ON = %#x\n", cache);
            }
            else
            {
                printf("DCache OFF = %#x\n", cache);
            }
            
            break;
        }
		default:
		{
			m_addr = simple_strtoul (argv[2], NULL, 16);
			s_addr = simple_strtoul (argv[3], NULL, 16);
			tmp = do_i2c_r( m_addr, s_addr );
			
			printf("m_addr = %#x; s_addr = %#x; tmp = %#x\n", m_addr, s_addr, tmp);
			break;			
		}
	}
	
	return 0;
	
}

/*-----------------------------------------------------------------------
 */
#endif /* CFG_USE_I2C */
