/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * (C) Copyright 2001 Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Andreas Heppel <aheppel@sysgo.de>

 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * Support for persistent environment data
 */

#include "armboot.h"
#include "command.h"
#include "malloc.h"
#include "cmd_nvedit.h"

#if (CONFIG_COMMANDS & CFG_CMD_NET)
#include "net.h"
#endif

/*
 * Table with supported baudrates (defined in config_xyz.h)
 */
static const unsigned long baudrate_table[] = CFG_BAUDRATE_TABLE;
#define	N_BAUDRATES (sizeof(baudrate_table) / sizeof(baudrate_table[0]))

#define MAC_ADDR_STR_LEN  17  /* length of mac address as string */
#define P_ID_LEN 18     /* plan product id length */
#define Z_ID_LEN 19
/*
 * Default settings to be used when no valid environment is found
 */
#define XMK_STR(x)	#x
#define MK_STR(x)	XMK_STR(x)

uchar default_environment[] = {

#ifdef	CONFIG_APPAUTO
  "appauto=" CONFIG_APPAUTO "\0"
#endif

#ifdef	CONFIG_HWID
  "hwid=" CONFIG_HWID "\0"
#endif

#ifdef	CONFIG_BOOTARGS
  "bootargs=" CONFIG_BOOTARGS "\0"
#endif
#ifdef	CONFIG_BOOTCOMMAND
    "bootcmd=" CONFIG_BOOTCOMMAND "\0"
#endif
#ifdef	CONFIG_RAMBOOTCOMMAND
    "ramboot=" CONFIG_RAMBOOTCOMMAND "\0"
#endif
#ifdef	CONFIG_NFSBOOTCOMMAND
    "nfsboot=" CONFIG_NFSBOOTCOMMAND "\0"
#endif
#if defined(CONFIG_BOOTDELAY) && (CONFIG_BOOTDELAY >= 0)
    "bootdelay=" MK_STR (CONFIG_BOOTDELAY) "\0"
#endif
#if defined(CONFIG_BAUDRATE) && (CONFIG_BAUDRATE >= 0)
    "baudrate=" MK_STR (CONFIG_BAUDRATE) "\0"
#endif
/* choish 20020828 */
#if defined(CONFIG_S3C2500) || defined(CONFIG_S3C2510)
#ifdef	CONFIG_ICACHE
    "icache=" MK_STR (CONFIG_ICACHE) "\0"
#endif
#ifdef	CONFIG_DCACHE
    "dcache=" MK_STR (CONFIG_DCACHE) "\0"
#endif
#ifdef	CONFIG_WBUFFER
    "wbuffer=" MK_STR (CONFIG_WBUFFER) "\0"
#endif
#endif
/* choish end */
#ifdef	CONFIG_LOADS_ECHO
    "loads_echo=" MK_STR (CONFIG_LOADS_ECHO) "\0"
#endif
#ifdef	CONFIG_ETHADDR
    "ethaddr=" MK_STR (CONFIG_ETHADDR) "\0"
#endif
#ifdef	CONFIG_ETH2ADDR
    "eth2addr=" MK_STR (CONFIG_ETH2ADDR) "\0"
#endif
#ifdef	CONFIG_ETH3ADDR
    "eth3addr=" MK_STR (CONFIG_ETH3ADDR) "\0"
#endif
#ifdef	CFG_AUTOLOAD
    "autoload=" CFG_AUTOLOAD "\0"
#endif
#ifdef	CONFIG_PREBOOT
    "preboot=" CONFIG_PREBOOT "\0"
#endif
#ifdef	CONFIG_ROOTPATH
    "rootpath=" MK_STR (CONFIG_ROOTPATH) "\0"
#endif
#ifdef	CONFIG_GATEWAYIP
    "gatewayip=" MK_STR (CONFIG_GATEWAYIP) "\0"
#endif
#ifdef	CONFIG_NETMASK
    "netmask=" MK_STR (CONFIG_NETMASK) "\0"
#endif
#ifdef	CONFIG_HOSTNAME
    "hostname=" MK_STR (CONFIG_HOSTNAME) "\0"
#endif
#ifdef	CONFIG_BOOTFILE
    "bootfile=" MK_STR (CONFIG_BOOTFILE) "\0"
#endif
#ifdef	CONFIG_LOADADDR
    "loadaddr=" MK_STR (CONFIG_LOADADDR) "\0"
#endif
#ifdef  CONFIG_CLOCKS_IN_MHZ
    "clocks_in_mhz=1\0"
#endif

/* add by zxj for vs2853 2008-06-10	*/
#if defined(CONFIG_CK510)
	#ifdef CONFIG_UPDATE_UBOOT
		"update=" CONFIG_UPDATE_UBOOT "\0"
	#endif
	
	#ifdef CONFIG_UPDATE_UBOOT_FIRST
		"fupd=" CONFIG_UPDATE_UBOOT_FIRST "\0"
	#endif
	
#endif


/* choish 20020829   for kernel */
#if defined(CONFIG_S3C2500) || defined(CONFIG_S3C2510)
#ifdef	CONFIG_HWADDR0
    "HWADDR0=" MK_STR (CONFIG_HWADDR0) "\0"
#endif
#ifdef	CONFIG_HWADDR1
    "HWADDR1=" MK_STR (CONFIG_HWADDR1) "\0"
#endif
#endif
#ifdef	CONFIG_IPADDR
    "ipaddr=" MK_STR (CONFIG_IPADDR) "\0"
#endif
#ifdef	CONFIG_SERVERIP
    "serverip=" MK_STR (CONFIG_SERVERIP) "\0"
#endif
    /* choish end */
 /* TimYu add for update	*/

#ifdef CONFIG_DH_KEYBOARD
    "dh_keyboard=" CONFIG_DH_KEYBOARD "\0"
#endif


#ifdef CONFIG_RESERVED_MEM
    "reserved_mem_version=" CONFIG_RESERVED_MEM "\0"
#endif

#ifdef CONFIG_UPDATE_DA
    "da=" CONFIG_UPDATE_DA "\0"
#endif

#ifdef CONFIG_UPDATE_DC
    "dc=" CONFIG_UPDATE_DC "\0"
#endif

#ifdef CONFIG_UPDATE_DR
    "dr=" CONFIG_UPDATE_DR "\0"
#endif

#ifdef CONFIG_UPDATE_DW
    "dw=" CONFIG_UPDATE_DW "\0"
#endif

#ifdef CONFIG_UPDATE_DL
    "dl=" CONFIG_UPDATE_DL "\0"
#endif

#ifdef CONFIG_TEST_KERNEL
    "tk=" CONFIG_TEST_KERNEL "\0"
#endif

#ifdef CONFIG_UPDATE_UP
    "up=" CONFIG_UPDATE_UP "\0"
#endif

#ifdef CONFIG_UPDATE_ALL
    "all=" CONFIG_UPDATE_ALL "\0"
#endif

#ifdef CONFIG_CLEAN_REGION
    "clean=" CONFIG_CLEAN_REGION "\0"
#endif
/* added by chencb 060905 */
#ifdef CONFIG_RESTORE_ENV
    "restore=" CONFIG_RESTORE_ENV "\0"
#endif
/* added by chencb 060908 */
#ifdef CONFIG_PRODUCT_ID
    "ID=" CONFIG_PRODUCT_ID "\0"
#endif
/*end */
  "\0"
};

void print_id(bd_t *bd)
{
	char *id;

	id = getenv(bd, "ID");
	if(id == NULL)
	{
		printf("id not set\n");
	}
	else
	{
		printf("Serial: %s\n", id);
	}
}

static int envmatch (bd_t *, uchar *, int);

int tolowercase(char *src,char *des)
{
	int i = 0 ;

	for(i=0;i<strlen(src);i++)
	{
		if(src[i]>='A'&&src[i]<='Z')
		{
			des[i] = src[i]-'A'+'a';
		}
		else
		{
			des[i] = src[i];
		}
	}
	des[i] = '\0';

	return i;
}

/*
 * return one character from env
 */
static uchar
get_env_char (bd_t * bd, int index)
{
  uchar c;

  /* use RAM copy, if possible */
  if (bd->bi_env)
    {
      if (index < sizeof (bd->bi_env_data))
	c = bd->bi_env_data[index];
      else
	panic ("bad size for get_env_char! %s[%d]\n", __FILE__, __LINE__);
    }
  else
    {
      /* try a board specific lookup */
      if (board_env_getchar (bd, index, &c) < 0)
	{
	  if (index < sizeof (default_environment))
	    c = default_environment[index];
	  else
	    panic ("bad size for get_env_char %s[%d]!\n", __FILE__, __LINE__);
	}
    }
  return c;
}

/*
 * return address into environment
 */
static uchar *
get_env_addr (bd_t * bd, int index)
{
  uchar *p = 0;

  /* use RAM copy, if possible */
  if (bd->bi_env)
    {
      if (index < sizeof (bd->bi_env_data))
	p = &bd->bi_env_data[index];
      else
	panic ("bad size for get_env_char! %s[%d]\n", __FILE__, __LINE__);
    }
  else
    {
      /* try a board specific lookup */
      if ((p = board_env_getaddr (bd, index)) == 0)
	{
	  if (index < sizeof (default_environment))
	    p = &default_environment[index];
	  else
	    panic ("bad size for get_env_char! %s[%d]\n", __FILE__, __LINE__);
	}
    }
  return p;
}

/************************************************************************
 * Command interface: print one or all environment variables
 */

int
do_printenv (cmd_tbl_t * cmdtp, bd_t * bd, int flag, int argc, char *argv[])
{
  int i, j, k, nxt;

  if (argc == 1)
    {				/* Print all env variables      */
      for (i = 0; get_env_char (bd, i) != '\0'; i = nxt + 1)
      {
	  for (nxt = i; get_env_char (bd, nxt) != '\0'; ++nxt);
          if (strncmp(bd->bi_env_data + i, "restore", 7) == 0)
	      continue;
	  for (k = i; k < nxt; ++k)
	    putc (get_env_char (bd, k));
	  putc ('\n');

	  if (ctrlc ())
	    {
	      printf ("\n ** Abort\n");
	      return 1;
	    }
      }

      printf ("\nEnvironment size: %d/%ld bytes\n", i,
	      sizeof (bd->bi_env_data));

      return 0;
    }

  for (i = 1; i < argc; ++i)
    {				/* print single env variables   */
      char *name = argv[i];

      k = -1;

      for (j = 0; get_env_char (bd, j) != '\0'; j = nxt + 1)
	{

	  for (nxt = j; get_env_char (bd, nxt) != '\0'; ++nxt)
	    ;
	  k = envmatch (bd, name, j);
	  if (k < 0)
	    {
	      continue;
	    }
	  puts (name);
	  putc ('=');
	  while (k < nxt)
	    putc (get_env_char (bd, k++));
	  putc ('\n');
	  break;
	}
      if (k < 0)
	{
	  printf ("## Error: \"%s\" not defined\n", name);
	  return 1;
	}
    }
  return 0;
}


int
_do_setenv (bd_t * bd, int flag, int argc, char *argv[])
{
  int i, len, oldval;
  uchar *env, *nxt = 0;
  uchar *name;

  /* need writable copy in RAM */
  if (!bd->bi_env_data)
    return 1;

  name = argv[1];
   tolowercase(name,name);
  /*
   * search if variable with this name already exists
   */
  oldval = -1;
  for (env = bd->bi_env_data; *env; env = nxt + 1)
    {
      for (nxt = env; *nxt; ++nxt);
      if ((oldval =
	   envmatch (bd, name, (ulong) env - (ulong) bd->bi_env_data)) >= 0)
	break;
    }

  /*
   * Delete any existing definition
   */
  if (oldval >= 0)
    {
#ifndef CONFIG_ENV_OVERWRITE

      /*
       * Ethernet Address and serial# can be set only once
       */
      if ((strcmp (name, "serial#") == 0) || ((strcmp (name, "ethaddr") == 0)
# if defined(CONFIG_OVERWRITE_ETHADDR_ONCE) && defined(CONFIG_ETHADDR)
					      &&
					      (strcmp
					       (get_env_addr (bd, oldval),
						MK_STR (CONFIG_ETHADDR)) != 0)
# endif	/* CONFIG_OVERWRITE_ETHADDR_ONCE && CONFIG_ETHADDR */
	  ))
	{
	  printf ("Can't overwrite \"%s\"\n", name);
	  return 1;
	}
#endif

      /*
       * Switch to new baudrate if new baudrate is supported
       */
      if (strcmp (argv[1], "baudrate") == 0)
	{
	  int baudrate = simple_strtoul (argv[2], NULL, 10);
	  int i;
	  for (i = 0; i < N_BAUDRATES; ++i)
	    {
	      if (baudrate == baudrate_table[i])
		break;
	    }
	  if (i == N_BAUDRATES)
	    {
	      printf ("## Baudrate %d bps not supported\n", baudrate);
	      return 1;
	    }
	  printf ("## Switch baudrate to %d bps and press ENTER ...\n",
		  baudrate);
	  udelay (50000);
	  serial_setbrg (bd, baudrate);
	  udelay (50000);
	  for (;;)
	    {
	      if (getc () == '\r')
		break;
	    }
	  bd->bi_baudrate = baudrate;
	}


      if (*++nxt == '\0')
	{
	  if ((ulong) env > (ulong) bd->bi_env_data)
	    {
	      env--;
	    }
	  else
	    {
	      *env = '\0';
	    }
	}
      else
	{
	  for (;;)
	    {
	      *env = *nxt++;
	      if ((*env == '\0') && (*nxt == '\0'))
		break;
	      ++env;
	    }
	}

      *++env = '\0';
    }
  /* Delete only ? */
  if ((argc < 3) || argv[2] == NULL)
    {
      /* Update CRC */
      bd->bi_env_crc = crc32 (0, bd->bi_env_data, sizeof (bd->bi_env_data));
      return 0;
    }

  /*
   * Append new definition at the end
   */
  for (env = bd->bi_env_data; *env || *(env + 1); ++env);

  if ((ulong) env > (ulong) bd->bi_env_data)
    ++env;
  /*
   * Overflow when:
   * "name" + "=" + "val" +"\0\0"  >
   *      sizeof(bd->bi_env_data) - (env-bd->bi_env_data)
   */
  len = strlen (name) + 2;
  /* add '=' for first arg, ' ' for all others */
  for (i = 2; i < argc; ++i)
    {
      len += strlen (argv[i]) + 1;
    }

  if (len > sizeof (bd->bi_env_data))
    {
      printf ("## Error: environment overflow, \"%s\" deleted\n", name);
      return 1;
    }

  while ((*env = *name++) != '\0')
    env++;
  for (i = 2; i < argc; ++i)
    {
      char *val = argv[i];

      *env = (i == 2) ? '=' : ' ';
      while ((*++env = *val++) != '\0');
    }

  /* end is marked with double '\0' */
  *++env = '\0';

  /* Update CRC */
  bd->bi_env_crc = crc32 (0, bd->bi_env_data, sizeof (bd->bi_env_data));

  /*
   * Some variables should be updated when the corresponding
   * entry in the enviornment is changed
   */

  if (strcmp (argv[1], "ethaddr") == 0)
    {
      char *s = argv[2];	/* always use only one arg */
      char *e;

      for (i = 0; i < 6; ++i)
	{
	  bd->bi_enetaddr[i] = s ? simple_strtoul (s, &e, 16) : 0;
	  if (s)
	    s = (*e) ? e + 1 : e;
	}
      return 0;
    }

  if (strcmp (argv[1], "ipaddr") == 0)
    {
      char *s = argv[2];	/* always use only one arg */
      char *e;
      bd->bi_ip_addr = 0;

      for (i = 0; i < 4; ++i)
	{
	  ulong val = s ? simple_strtoul (s, &e, 10) : 0;
	  bd->bi_ip_addr <<= 8;
	  bd->bi_ip_addr |= (val & 0xFF);
	  if (s)
	    s = (*e) ? e + 1 : e;
	}
      return 0;
    }

  if (strcmp (argv[1], "loadaddr") == 0)
    {
      load_addr = simple_strtoul (argv[2], NULL, 16);
      return 0;
    }


#if (CONFIG_COMMANDS & CFG_CMD_NET)
  if (strcmp (argv[1], "bootfile") == 0)
    {
      copy_filename (BootFile, argv[2], sizeof (BootFile));
      return 0;
    }
#endif /* CFG_CMD_NET */

  name = argv[1];  
  tolowercase(argv[1],name);

  if ((strcmp (name, "appauto") == 0) || (strcmp (name, "hwid") == 0)
       ||(strcmp (name, "dh_keyboard") == 0) )
  {
    volatile bootpara *pmem = (volatile bootpara *)0xc0000000;

    if (strcmp (name, "appauto") == 0)
    {         
        pmem->appauto = simple_strtoul(argv[2],NULL,10);        
    }
    else if (strcmp (name, "dh_keyboard") == 0)
    {
         pmem->dh_keyboard = simple_strtoul(argv[2],NULL,10);
    }
    else
    {
        printf("set:%s\n",argv[2]);
        memset(pmem->hwid,0,256);
        strncpy(pmem->hwid,argv[2],256);
    }
    
      return 0;
  }

  return 0;
}

void
setenv (bd_t * bd, char *varname, char *varvalue)
{
  char *argv[4] = { "setenv", varname, varvalue, NULL };
  _do_setenv (bd, 0, 3, argv);
  //board_env_save(bd, bd->bi_env, sizeof(env_t));        // added by LAPUTA
  
  
}

int
do_setenv (cmd_tbl_t * cmdtp, bd_t * bd, int flag, int argc, char *argv[])
{
  if (argc < 2)
    {
      printf ("Usage:\n%s\n", cmdtp->usage);
      return 1;
    }

  return _do_setenv (bd, flag, argc, argv);
}

/************************************************************************
 *
 *  display mac address or  set mac address and save to flash
 *  if success return 0, fail return -1
 *  added by chencb 060824
 *
 ***********************************************************************/
#if (CONFIG_COMMANDS & CFG_CMD_ENV)

static int IsValid(unsigned char *addr)
{
   int len, i, ret = 0;

   len = strlen( addr );
   if ( len != (MAC_ADDR_STR_LEN) )
   {
      return -1;
   }
   for (i = 0; i < (MAC_ADDR_STR_LEN); i++)
   {
      if ( i%3 == 2)
      {
         if ( addr[i] != ':' )
         {
             return -1;
         }
      }
      else
      {
          if( ( addr[i] >= '0' && addr[i] <= '9' ) ||
	      ( addr[i] >= 'a' && addr[i] <= 'f' ) ||
              ( addr[i] >= 'A' && addr[i] <= 'F' ) )
          {
             ret = 0;
	  }
          else
          {
	      return -1;
          }
      }
   }
   return ret;
}


int do_setmac  (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[])
{
  char *macaddr, *macname = "HWADDR0";
  char *ethname = "ethaddr";
  unsigned char tmp_macaddr[6];

  macaddr = getenv(bd, macname);
  if (argc == 1)
  {
     printf("HWADDR0: %s\n", macaddr);
     return 0;
  }
  else if (argc == 2)
  {
     if ( IsValid(argv[1]) )
     {
         printf("Format of HWADDR0 wrong!\n");
         return -1;
     }
     strncpy(tmp_macaddr, bd->bi_enetaddr, 6);
     setenv(bd, ethname, argv[1]);
     setenv(bd, macname, argv[1]);
     if(board_env_save(bd, bd->bi_env, sizeof (env_t)))
     {
        setenv(bd, ethname, tmp_macaddr);
        setenv(bd, macname, tmp_macaddr);
        printf("Save HWADDR0 to flash fail!\n");
        return -1;
     }
     macaddr = getenv(bd, macname);
     printf("Set HWADDR0 success!\nNow HWADDR0: %s\n", macaddr);
     return 0;
  }
  else
  {
     printf("Parameter error!\n");
     return -1;
  }
  return 0;
}
#endif /* CFG_CMD_ENV */

/************************************************************************
 *
 *  display server ip address or set server ip address but not
 *  save to flash
 *  if success return 0, fail return -1
 *  added by chencb 060824
 *
 ***********************************************************************/
int do_setsip  (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[])
{
  char *ipname = "serverip";
  char *sip;

  if (argc == 1)
  {
     printf("Server ip address: ");
     sip = getenv (bd, "serverip");
     printf( "%s\n", sip );
     return 0;
  }
  else if (argc == 2)
  {
     setenv(bd, ipname, argv[1]);
     printf("Set server ip address success!\nNow server ip addr: ");
     printf( "%s\n",  argv[1]);
     return 0;
  }
  else
  {
     printf("Parameter error!\n");
     return -1;
  }
  return 0;
}

/************************************************************************
 *
 *  display local ip address or set local ip address but not save
 *  to flash
 *  if success return 0, fail return -1
 *  added by chencb 060825
 *
 ***********************************************************************/

int do_setlip  (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[])
{
  char *ipname = "ipaddr";

  if (argc == 1)
  {
     printf("Local ip address: ");
     //print_IPaddr( bd->bi_ip_addr );
     printf("\n");
     return 0;
  }
  else if (argc == 2)
  {
     setenv(bd, ipname, argv[1]);
     printf("Set local address success!\nNow local ip addr: ");
     //print_IPaddr( bd->bi_ip_addr );
     printf("\n");
     return 0;
  }
  else
  {
     printf("Parameter error!\n");
     return -1;
  }
  return 0;
}

/************************************************************************
 *
 *  set product id and save to flash
 *  if success return 0, fail return -1
 *  added by chencb 060908
 *
 ***********************************************************************/
int do_set_id(cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[])
{
  char *id = NULL;

  id = getenv(bd, "ID");
  if (argc == 1)
  {
     if (id == NULL)
     {
	printf("ID not set!\n");
	return 0;
     }
     printf("ID: %s\n", id);
     return 0;
  }
  else if (argc == 2)
  {
#if 0
     int id_len;

     id_len = strlen(argv[1]);
     if ((P_ID_LEN != id_len) && (Z_ID_LEN != id_len))
     {
         printf("Set ID fail, ID length is %d or %d\n",P_ID_LEN, Z_ID_LEN);
         return -1;
     }
#endif
     setenv(bd, "ID", argv[1]);
     if(board_env_save(bd, bd->bi_env, sizeof (env_t)))
     {
	if (id == NULL)
	{
	   setenv(bd, "ID", "0000000000000000000");
	}
        else
	{
	   setenv(bd, "ID", id);
        }
        printf("Save ID to flash fail!\n");
        return -1;
     }
     id = getenv(bd, "ID");
     printf("Set ID success!\nNow ID: %s\n", id);
     return 0;
  }
  else
  {
     printf("Parameter error!\n");
     return -1;
  }
  return 0;
}

/************************************************************************
 * Prompt for environment variable
 */

#if (CONFIG_COMMANDS & CFG_CMD_ASKENV)
int
do_askenv (cmd_tbl_t * cmdtp, bd_t * bd, int flag, int argc, char *argv[])
{
  extern char console_buffer[CFG_CBSIZE];
  char message[CFG_CBSIZE];
  int size = CFG_CBSIZE - 1;
  int len;
  char *local_args[4];

  local_args[0] = argv[0];
  local_args[1] = argv[1];
  local_args[2] = NULL;
  local_args[3] = NULL;

  if (argc < 2)
    {
      printf ("Usage:\n%s\n", cmdtp->usage);
      return 1;
    }
  /* Check the syntax */
  switch (argc)
    {
    case 1:
      printf ("Usage:\n%s\n", cmdtp->usage);
      return 1;

    case 2:			/* askenv envname */
      sprintf (message, "Please enter '%s':", argv[1]);
      break;

    case 3:			/* askenv envname size */
      sprintf (message, "Please enter '%s':", argv[1]);
      size = simple_strtoul (argv[2], NULL, 10);
      break;

    default:			/* askenv envname message1 ... messagen size */
      {
	int i;
	int pos = 0;

	for (i = 2; i < argc - 1; i++)
	  {
	    if (pos)
	      {
		message[pos++] = ' ';
	      }
	    strcpy (message + pos, argv[i]);
	    pos += strlen (argv[i]);
	  }
	message[pos] = '\0';
	size = simple_strtoul (argv[argc - 1], NULL, 10);
      }
    }

  if (size >= CFG_CBSIZE)
    size = CFG_CBSIZE - 1;

  if (size <= 0)
    return 1;

  /* prompt for input */
  len = readline (message);

  if (size < len)
    console_buffer[size] = '\0';

  len = 2;
  if (console_buffer[0] != '\0')
    {
      local_args[2] = console_buffer;
      len = 3;
    }

  // Continue calling setenv code
  return _do_setenv (bd, flag, len, local_args);
}
#endif /* CFG_CMD_ASKENV */



/************************************************************************
 * Look up variable from environment,
 * return address of storage for that variable,
 * or NULL if not found
 */

char *
getenv (bd_t * bd, uchar * name)
{
    int i, nxt;

    for (i = 0; get_env_char (bd, i) != '\0'; i = nxt + 1)
    {
        int val;

        for (nxt = i; get_env_char (bd, nxt) != '\0'; ++nxt)
        {
            if (nxt >= sizeof (bd->bi_env_data))
            {
                return (NULL);
            }
        }
        if ((val = envmatch (bd, name, i)) < 0)
        continue;
        return (get_env_addr (bd, val));
    }

    return (NULL);
}


/************************************************************************
 * Match a name / name=value pair
 *
 * s1 is either a simple 'name', or a 'name=value' pair.
 * i2 is the environment index for a 'name2=value2' pair.
 * If the names match, return the index for the value2, else NULL.
 */

static int
envmatch (bd_t * bd, uchar * s1, int i2)
{

  while (*s1 == get_env_char (bd, i2++))
    if (*s1++ == '=')
      return (i2);
  if (*s1 == '\0' && get_env_char (bd, i2 - 1) == '=')
    return (i2);
  return (-1);
}


#if (CONFIG_COMMANDS & CFG_CMD_ENV)

int
do_saveenv (cmd_tbl_t * cmdtp, bd_t * bd, int flag, int argc, char *argv[])
{
  return (board_env_save (bd, bd->bi_env, sizeof (env_t))) ? 1 : 0;
}

#endif /* CFG_CMD_ENV */


void
env_init (bd_t * bd)
{
  bd->bi_env = 0;
}

/**************************************************************************
 *
 * added by chencb 060905
 * restore old environment value, which is  necessary
 *
 *************************************************************************/
typedef struct restore_data
{
     char ethaddr[18];
     char hwaddr0[18];
     char hwaddr1[18];
     char product_id[32];
     char r_flag[2];
}restore_t;

void
env_relocate (bd_t * bd)
{
  char *s, *e;
  int reg, ret;
  int use_default_env = 0;
  restore_t *restore;
  char *id = NULL;
  int id_len;

  bd->bi_env = malloc (sizeof (env_t));

#if 0
  if (board_env_copy (bd, bd->bi_env, sizeof (env_t)) < 0)
    {
      printf ("*** Using default environment\n");

      use_default_env = 1;

      memcpy (bd->bi_env_data, default_environment,
	      sizeof (default_environment));
      bd->bi_env_crc = crc32 (0, bd->bi_env_data, sizeof (bd->bi_env_data));
    }
#endif  // modified by chencb 060905
  ret = board_env_copy(bd,  bd->bi_env, sizeof (env_t));
  if (ret < 0)
  {
      printf ("*** Using default environment\n");

      use_default_env = 1;

      memcpy (bd->bi_env_data, default_environment, sizeof (default_environment));
      bd->bi_env_crc = crc32 (0, bd->bi_env_data, sizeof (bd->bi_env_data));
  }
  else
  {

      s = getenv(bd, "restore");

      if (strcmp(s, "1") == 0)   // need to restore environment
      {
	 restore = malloc(sizeof(restore_t));
         if (!restore)
         {
             printf("malloc restore_t fail\n");
             return;
         }
         memset(restore, 0, sizeof(restore_t));

         /*  data we need to restore */
	 strncpy(restore->ethaddr, getenv(bd, "ethaddr"), MAC_ADDR_STR_LEN);
         strncpy(restore->hwaddr0, getenv(bd, "HWADDR0"), MAC_ADDR_STR_LEN);
	 strncpy(restore->hwaddr1, getenv(bd, "HWADDR1"), MAC_ADDR_STR_LEN);

	 id = getenv(bd, "ID");
         if (id == NULL)
	 {
	 	strcpy(restore->product_id, "000000000000000000");
	 }
	 else
 	 {
	        id_len = strlen(id);
		if (id_len > 31)
		{
			strncpy(restore->product_id, id, 31);
		}
		else
		{
			strncpy(restore->product_id, id, id_len);
		}
	 }

         strcpy(restore->r_flag, "0");

         /* restore the data */
	 memcpy (bd->bi_env_data, default_environment, sizeof(default_environment));
         setenv(bd, "ethaddr", restore->ethaddr);
         setenv(bd, "HWADDR0", restore->hwaddr0);
	 setenv(bd, "HWADDR1", restore->hwaddr1);
	 setenv(bd, "ID", restore->product_id);
         setenv(bd, "restore", restore->r_flag);  // clear restore flag
	 bd->bi_env_crc = crc32 (0, bd->bi_env_data, sizeof (bd->bi_env_data));
         use_default_env = 1;  // will write to flash later

         free(restore);
      }
  }

  /* now initialise some variables */
  /* MAC address */
  s = getenv (bd, "ethaddr");
  for (reg = 0; reg < 6; reg++)
    {
      bd->bi_enetaddr[reg] = s ? simple_strtoul (s, &e, 16) : 0;
      if (s)
	s = (*e) ? e + 1 : e;
    }

  /* IP address */
  bd->bi_ip_addr = 0;
  s = getenv (bd, "ipaddr");
  for (reg = 0; reg < 4; ++reg)
    {
      ulong val = s ? simple_strtoul (s, &e, 10) : 0;
      bd->bi_ip_addr <<= 8;
      bd->bi_ip_addr |= (val & 0xFF);
      if (s)
	s = (*e) ? e + 1 : e;
    }

  if ((s = getenv (bd, "loadaddr")) != NULL)
    {
      load_addr = simple_strtoul (s, NULL, 16);
    }

// modified by choish
#if defined(CONFIG_S3C2500) || defined(CONFIG_S3C2510)
/* ICache, DCache, Write Buffer initialize 	*/
  s = getenv (bd, "icache");
  copy_filename (bd->bi_icache, s, sizeof (bd->bi_icache));

  s = getenv (bd, "dcache");
  copy_filename (bd->bi_dcache, s, sizeof (bd->bi_dcache));

  s = getenv (bd, "wbuffer");
  copy_filename (bd->bi_wbuffer, s, sizeof (bd->bi_wbuffer));
#endif

#if (CONFIG_COMMANDS & CFG_CMD_NET)
  if ((s = getenv (bd, "bootfile")) != NULL)
    {
      copy_filename (BootFile, s, sizeof (BootFile));
    }
#endif /* CFG_CMD_NET */

  {
    bootpara para;
    if ((s = getenv (bd, "appauto")) != NULL)
    {
      para.appauto = simple_strtoul(s,NULL,10);
    }
    if ((s = getenv (bd, "dh_keyboard")) != NULL)
    {
        para.dh_keyboard =  simple_strtoul(s,NULL,10);
    }
    if ((s = getenv (bd, "hwid")) != NULL)
    {
        memset(para.hwid,0,sizeof(para.hwid));
        strncpy(para.hwid, s, sizeof(para.hwid));
    }
    else
    {
        memset(para.hwid,0,sizeof(para.hwid));
    }
    volatile bootpara *pmem = (volatile bootpara *)(0xc0000000);
    memcpy(pmem,&para,sizeof(bootpara));
  }

  if (use_default_env)
  {
      printf("do_saveenv ...\n");
      do_saveenv(NULL, bd, 0, 0, NULL);
  }
}

#if defined(CONFIG_S3C2500) || defined(CONFIG_S3C2510)
// by laputa start
void
reset_call (bd_t * bd)
{
  disable_interrupts ();
  
  /*
  // supervisor mode
  __asm__ ("mrs r0,cpsr\n"
	   "bic r0,r0,#0x1f\n"
	   "orr r0,r0,#0x13\n"
	   "msr cpsr,r0\n" "ldr r0,=0x40000\n" "mov pc,r0");
	  */
}

void
go_ram (bd_t * bd, int flag)
{
  printf ("load... and go \n");
  run_command (getenv (bd, "bootcmd"), bd, flag);
  reset_call (bd);
  while (1);
}

int
read_name_value (bd_t * bd, int *index_start, char *name, char *value)
{
  int cnt;
  int name_save = 1;		// 1 = name save, 0 = value save
  char tmp;			// one char save buffer

  cnt = *index_start;		// index start count

  if (!(tmp = get_env_char (bd, cnt)))
    return 0;

  for (; tmp; tmp = get_env_char (bd, ++cnt))
    {
      if (name_save)
	{
	  if (tmp == '=')
	    {
	      name_save = 0;	// after "=" is value set
	      continue;
	    }
	  *(name++) = tmp;	// name save
	}
      else
	*(value++) = tmp;
    }
  *name = 0;			// end of string
  *value = 0;
  *index_start = ++cnt;		// next start index no.
  return 1;
}

char *
readenv (bd_t * bd, int cmd)
{
  char *fev = NULL;
  static int index_no;
  static char name[30];
  static char value[30];

  switch (cmd)
    {
    case 0:
      index_no = 0;
    case 1:
      if (!(read_name_value (bd, &index_no, name, value)))
	return 0;
      fev = name;
      break;
    case 2:
      fev = value;
      break;
    default:
      break;
    }
  return (char *) fev;		// return NAME or VALUE
}

void
msg_arg (int argc, char *argv[])
{
  int n;
  printf ("do_saveenv argc = [%d] \n", argc);
  for (n = 0; n < argc; n++)
    printf ("do_saveenv argv[%d] = [%s] \n", n, argv[n]);
}

// end laputa
#endif
