/* smalloc.c: simple malloc using a heap that grows down
 *
 */

#ifdef DEBUG
#define dprintf(arg...) printf(arg)
#else
#define dprintf(arg...)
#endif

/* very simple.  At the beginning of the block is the size.
   That's all.  We keep track of the bottom and the absolute
   bottom.  A zero size block marks the top, size -ve is free */

int *last_block;
int *bottom;

int
smalloc_init (void *mem, int size)
{
  bottom = (int *) (((int) mem + 3) & ~0x3);
  last_block = (int *) (((int) mem + size - 1) & ~0x3);
  *last_block = 0;
}

void *
smalloc_malloc (int size)
{
  int *p;

  for (p = last_block; *p; p += (*p < 0) ? -*p : *p)
    {

      if (*p > 0)
	continue;
      if (size > (-*p) << 1 && (size + 4) <= ((-*p) << 2))
	{			/* up to 2 times */
	  *p = -(*p);
	  dprintf ("reuse of %d(%d)\n", size, *p * 4);
	  return p + 1;
	}
    }
  /* nothing matches */

  p = last_block - ((size + 3) >> 2) - 1;
  *p = last_block - p;

  last_block = p;
  dprintf ("new of %d.  %d free\n", size, (int) (last_block - bottom) * 4);

  return p + 1;
}

int
smalloc_free (void *ptr)
{
  int *p = ptr;
  if (!ptr)
    return 0;
  p--;

  dprintf ("free %d\n", *p * 4);
  *p = -(*p);
}
