/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Alex Zuepke <azu@sysgo.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include "armboot.h"
#include <config.h>
#include "irq.h"

#ifdef CONFIG_CK510
extern void reset_cpu(ulong addr);



//define reg

//16
/*
volatile u32 * pic_mod = (volatile u32 *)0x70000004;	//timer0_data
volatile u32 * pic_ini0 = (volatile u32 *)0x70000018;	//timer0_data
volatile u32 * pic_tccw = (volatile u32 *)0x70000024;	//timer_ctrl
volatile u32 * pic_cap0 = (volatile u32 *)0x70000070;	//timer0 current value
*/

//32

volatile u32 * pic_mod = (volatile u32 *)0x70000000;	//timer0_data
volatile u32 * pic_ini0 = (volatile u32 *)0x70000044;	//timer0_data
volatile u32 * pic_tccw = (volatile u32 *)0x70000040;	//timer_ctrl
volatile u32 * pic_cap0 = (volatile u32 *)0x70000070;	//timer0 current value

//
/*
[3]	cap_enacaptureʹܣ
		1  ȡڵĵǰֵ
		0  
[2]	single趨
		1  ֻһΣȵ󣬱㲻ټȴһcs
		0  ѭͬʱʼֵʼһּ
[1]	
[0]	csƬѡźţʱʼߵƽЧ
*/

//Ƭѡ
#define pic_t0_cs		1
#define pic_t0_free	0

#define pic_t0_sing_en	(1 << 2)
#define pic_t0_sing_dis	(0 << 2)

#define pic_t0_cap_en		(1 << 3)
#define pic_t0_cap_dis	(0 << 3)



/* we always count down the max. */
#define TIMER_LOAD_VAL 0xffffffff

#ifdef CONFIG_USE_IRQ
/* enable IRQ/FIQ interrupts */
void enable_interrupts (void)
{
    unsigned long temp;
    __asm__ __volatile__("mrs %0, cpsr\n"
			 "bic %0, %0, #0x80\n"
			 "msr cpsr_c, %0"
			 : "=r" (temp)
			 :
			 : "memory");
}


/* 
 * disable IRQ/FIQ interrupts
 * returns true if interrupts had been enabled before we disabled them
 */
int disable_interrupts (void)
{
    unsigned long old,temp;
    __asm__ __volatile__("mrs %0, cpsr\n"
			 "orr %1, %0, #0x80\n"
			 "msr cpsr_c, %1"
			 : "=r" (old), "=r" (temp)
			 :
			 : "memory");
    return (old & 0x80) == 0;
}
#else
void enable_interrupts (void)
{
    return;
}
int disable_interrupts (void)
{
    return 0;
}
#endif


static irq_t pirq;

void IRQEnable(void)
{
	asm("psrset ee, ie");
}

void IRQDisable(void)
{
	asm("psrclr ee, ie");
}

/************************************************************************
 * IRQ Int Processing: Send EOI/FEOI
 * param:  vec
 * return: no
 ************************************************************************/
void IRQIntProcess(u32 vec)
{
    u32 temp;
    
    void (* handle)(void);
    
    temp = inl( IRQ_COW0_REG );
    
    temp |= ( 1 << IRQ_COW1_EOI );
    
    outl( IRQ_COW0_REG, temp );

    handle = pirq.handle[vec];
    
    if(handle != NULL)
    {
    	(*handle)();
    }
    else
    {
    	printf("irq handle not be init\n");
    }
    
    
}

/************************************************************************
 * IRQ Int Init
 * param:  no
 * return: no
 ************************************************************************/
void IRQInit(void)
{
    u32 ptmp = 0;
    u32 dtmp = 0;
    u8 irq = 0;
    u32 *ptr;
   
    
    ptr = (u32 *)readvbr();
    
    for ( irq = 0; irq < ( 0x100 >> 2 ); irq++ )
    {
    	*ptr++ = (u32)ISR_Reserved;
    }

    for(irq = 0; irq < IRQ_USER_INT_NUM; irq++) 
    {
    	pirq.handle[irq] = NULL;
    }
            
    ptmp = IRQ_MODE_REG;
    dtmp = 0xFFFFFFFF;
    outl(dtmp, ptmp); 
    
	ptmp = IRQ_PO_REG;
    dtmp = 0xFFFFFFFF;
    outl(dtmp, ptmp); 	
        
    ptmp = IRQ_MASK_REG;
    dtmp = 0xFFFFFFFF;           //All Int Off
    outl(dtmp, ptmp);
    
    *(volatile unsigned int *)(IRQ_MASK_REG) = dtmp;    
	   
	ptmp = IRQ_COW1_REG;
    dtmp = 0x42;
    outl(dtmp, ptmp); 
    
}

/************************************************************************
 * IRQ Set All Int Off
 * param:  no
 * return: no
 ************************************************************************/
void IRQSetAllIntOff(void)
{
    u32 ptmp = 0;
    u32 dtmp = 0;
    
    ptmp = IRQ_MASK_REG;
    dtmp = 0xffffffff;
    outl(dtmp, ptmp);   
}

/************************************************************************
 * IRQ Set Int On
 * param:  irq
 * return: no
 ************************************************************************/
void IRQSetIntOn(u8 irq)
{
    u32 ptmp = 0;
    u32 dtmp = 0;
    
    ptmp = IRQ_MASK_REG;
    dtmp = inl(ptmp);
    dtmp &= (~(0x1<<irq));

    outl(dtmp, ptmp);
    
}

/************************************************************************
 * IRQ Set Int Off
 * param:  irq
 * return: no
 ************************************************************************/
void IRQSetIntOff(u8 irq)
{
    u32 ptmp = 0;
    u32 dtmp = 0;
    
    ptmp = IRQ_MASK_REG;
    dtmp = inl(ptmp);
    dtmp |= (0x1<<irq);
    outl(dtmp, ptmp);   
}

/************************************************************************
 * IRQ Install Int
 * param:  irq
 *         (*handle)(void)
 *         type
 * return: no
 ************************************************************************/
void IRQRequest(u8 irq, void (*handle)(void), u8 type)
{
    u32 *ptr;
    
    ptr = (u32 *)readvbr();
    
	pirq.handle[irq] = handle; 
	
	if(type == IRQ_INT_TYPE_NORMAL)
	{
		ptr[32 + irq] = (u32)NmlIntHandler;
	}
/*
	else if(type == IRQ_INT_TYPE_FAST)
	{
		ptr[32 + irq] = (u32)FstIntHandler;
	}
*/	
	IRQSetIntOn(irq);
}

/************************************************************************
 * IRQ Release An Installed Int
 * param:  irq
 * return: no
 ************************************************************************/
void IRQRelease(u8 irq)
{
    u32 *ptr;
    
    ptr = (u32 *)readvbr();
	
    IRQSetIntOff(irq);    
    pirq.handle[irq] = NULL;
    
    ptr[32 + irq] = (u32)ISR_Reserved;
}





void bad_mode(void)
{
    panic("Resetting CPU ...\n");
    reset_cpu(0);
}

void show_regs(struct pt_regs * regs)
{
	/*
    unsigned long flags;
	const char *processor_modes[]=
	{ "USER_26", "FIQ_26" , "IRQ_26" , "SVC_26" , "UK4_26" , "UK5_26" , "UK6_26" , "UK7_26" ,
	  "UK8_26" , "UK9_26" , "UK10_26", "UK11_26", "UK12_26", "UK13_26", "UK14_26", "UK15_26",
	  "USER_32", "FIQ_32" , "IRQ_32" , "SVC_32" , "UK4_32" , "UK5_32" , "UK6_32" , "ABT_32" ,
	  "UK8_32" , "UK9_32" , "UK10_32", "UND_32" , "UK12_32", "UK13_32", "UK14_32", "SYS_32"
	};
    
    flags = condition_codes(regs);
    
    printf("pc : [<%08lx>]    lr : [<%08lx>]\n"
	   "sp : %08lx  ip : %08lx  fp : %08lx\n",
	   instruction_pointer(regs),
	   regs->ARM_lr, regs->ARM_sp,
	   regs->ARM_ip, regs->ARM_fp);
    printf("r10: %08lx  r9 : %08lx  r8 : %08lx\n",
	   regs->ARM_r10, regs->ARM_r9,
	   regs->ARM_r8);
    printf("r7 : %08lx  r6 : %08lx  r5 : %08lx  r4 : %08lx\n",
	   regs->ARM_r7, regs->ARM_r6,
	   regs->ARM_r5, regs->ARM_r4);
    printf("r3 : %08lx  r2 : %08lx  r1 : %08lx  r0 : %08lx\n",
	   regs->ARM_r3, regs->ARM_r2,
	   regs->ARM_r1, regs->ARM_r0);
    printf("Flags: %c%c%c%c",
	   flags & CC_N_BIT ? 'N' : 'n',
	   flags & CC_Z_BIT ? 'Z' : 'z',
	   flags & CC_C_BIT ? 'C' : 'c',
	   flags & CC_V_BIT ? 'V' : 'v');
    printf("  IRQs %s  FIQs %s  Mode %s%s\n",
	   interrupts_enabled(regs) ? "on" : "off",
	   fast_interrupts_enabled(regs) ? "on" : "off",
	   processor_modes[processor_mode(regs)],
	   thumb_mode(regs) ? " (T)" : "");*/
}

void do_undefined_instruction(struct pt_regs *pt_regs)
{
	/*
    printf("undefined instruction\n");
    show_regs(pt_regs);
    */
    bad_mode();
    
}

void do_software_interrupt(struct pt_regs *pt_regs)
{
	/*
    printf("software interrupt\n");
    show_regs(pt_regs);
    */
    bad_mode();
}

void do_prefetch_abort(struct pt_regs *pt_regs)
{
	/*
    printf("prefetch abort\n");
    show_regs(pt_regs);
    */    
    bad_mode();

}

void do_data_abort(struct pt_regs *pt_regs)
{
	/*
    printf("data abort\n");
    show_regs(pt_regs);
    */    
    bad_mode();

}

void do_not_used(struct pt_regs *pt_regs)
{
	/*
    printf("not used\n");
    show_regs(pt_regs);
    bad_mode();
    */
}

void do_fiq(struct pt_regs *pt_regs)
{
	/*
    printf("fast interrupt request\n");
    show_regs(pt_regs);
    */    
    bad_mode();

}

void do_irq(struct pt_regs *pt_regs)
{
	/*
    printf("interrupt request\n");
    show_regs(pt_regs);
    */    
    bad_mode();

}


static ulong timestamp;
static ulong lastdec;

extern void interrupt_init (bd_t *bd)
{
    /* disable all interrupts */
    
    /*
    REG_WRITE(INTMASK, INT_ALL_MASK);
    REG_WRITE(EXTMASK, EXT_ALL_MASK);*/
    //pic_mod[0] = 0x0000ffff;

    /* operate timer 1 in prescale mode */
    /*
		REG_WRITE(TIMER_TMOD, 0x01);
    REG_WRITE(TIMER_TDATA_0, 0xffffffff);
    REG_WRITE(TIMER_TCNT_0, TIMER_LOAD_VAL);*/
    
    pic_tccw[0] = 0x00;   
    
    //pic_ini0[0] = TIMER_LOAD_VAL;
    pic_tccw[0] = pic_t0_cs | pic_t0_cap_en;
    
    /* set timer 1 counter */
    /*lastdec = IO_TC1D = TIMER_LOAD_VAL;*/
    lastdec = pic_cap0[0];
    lastdec = TIMER_LOAD_VAL - lastdec;
    timestamp = 0;
    
    IRQEnable();

}



/*
 * timer without interrupts
 */

void reset_timer(void)
{
    reset_timer_masked();
}

ulong get_timer (ulong base)
{
    return get_timer_masked() - base;
}

void set_timer (ulong t)
{
    timestamp = t;
}

void udelay(unsigned long usec)
{
    ulong tmo;
    ulong now;

    tmo = usec / 1000;
    tmo *= CFG_HZ;
    tmo /= 1000;

    tmo += get_timer(0);
    
    while(get_timer_masked() < tmo)
		{
      ;
		}
}

void reset_timer_masked(void)
{
    /* reset time */
    /*lastdec = READ_TIMER;*/
	//REG_READ(TIMER_TDATA_0, lastdec);
		lastdec = pic_cap0[0];
		lastdec = TIMER_LOAD_VAL - lastdec;
    timestamp = 0;
}

ulong get_timer_masked(void)
{
    // ulong now = READ_TIMER;
    ulong now;
    
    //REG_READ(TIMER_TCNT_0, now);
    now = pic_cap0[0];
	now = TIMER_LOAD_VAL - now;
  
    if (lastdec >= now)
    {
        // normal mode 
        timestamp += lastdec - now;
    } 
		else 
		{
        // we have an overflow ...
        timestamp += lastdec + TIMER_LOAD_VAL - now;
    }
    
    lastdec = now;
    return timestamp;
}

void udelay_masked(unsigned long usec)
{
    ulong tmo;

    tmo = usec / 1000;
    tmo *= CFG_HZ;
    tmo /= 1000;

    reset_timer_masked();

    while(get_timer_masked() < tmo)
      /*NOP*/;
}

void intEnable(int vect)
{
	/*
	int intreg;

    if	 ( vect >= NR_EXT_IRQS ) {
    	REG_READ(INTMASK, intreg);
		intreg &= ~( 1 << (vect - NR_EXT_IRQS));
		REG_WRITE(INTMASK, intreg);
	 } 
    else {
    	REG_READ(EXTMASK, intreg);
		intreg &= ~( 1 << vect);
		REG_WRITE(EXTMASK, intreg);
	} */
}

void intDisable(int vect)
{/*
	int intreg;

    if	 ( vect >= NR_EXT_IRQS ) {
    	REG_READ(INTMASK, intreg);
		intreg |= ( 1 << (vect - NR_EXT_IRQS));
		REG_WRITE(INTMASK, intreg);
	 } 
    else {
    	REG_READ(EXTMASK, intreg);
		intreg |= ( 1 << vect);
		REG_WRITE(EXTMASK, intreg);
	} */
}

#endif

