/****************************************************************************
 * drv_irq.h     Belong to IS/DRV-II v1.0
 *
 * Irq Module defination .h file.
 *
 * (C) Copyright 2005 to 2007 ImageSilicon Tech.,ltd
 *
 * Create:  Fqh <feng_qinghua@dahuatech.com> 2006-11-14  Version: v0.1
 * Modify:  Fqh <feng_qinghua@dahuatech.com> 2006-11-30  Version: v0.2
 *    For:  Functions and APIs Test is pass!
 * Modify:  Fqh <feng_qinghua@dahuatech.com> 2006-12-06  Version: v0.3
 *    For:  Cell Test is pass! 
 * Modify:  Fqh <feng_qinghua@dahuatech.com> 2007-03-02  Version: v0.4
 *    For:  Add Int Gpio Type Select Support!  
 * Modify:  Zxj <zheng_xingjian@dahuatech.com> 2008-12-02  Version: v0.5
 *    For:  to VS28xx
 * Modify:                                               Version:
 *
 ****************************************************************************/

#ifndef _IRQ_H_
#define _IRQ_H_

/************************************************************************
 * Definition of IRQ register
 ************************************************************************/
#define IRQ_BASE_ADDR			0x70000000
                           
#define IRQ_MODE_REG			( IRQ_BASE_ADDR + 0x00 )	/* 0x7000_0000 */
#define IRQ_PO_REG				( IRQ_BASE_ADDR + 0x04 )	/* 0x7000_0004 */
#define IRQ_MASK_REG			( IRQ_BASE_ADDR + 0x08 )	/* 0x7000_0008 */
#define IRQ_VECTOR_REG			( IRQ_BASE_ADDR + 0x0C )	/* 0x7000_000C */
#define IRQ_COW0_REG			( IRQ_BASE_ADDR + 0x10 )	/* 0x7000_0010 */
#define IRQ_COW1_REG			( IRQ_BASE_ADDR + 0x34 )	/* 0x7000_0034 */

#define IRQ_PRIOR_BASE			( IRQ_BASE_ADDR + 0x14 )	/* 0x7000_0014 */

/************************************************************************
 * IRQ Interrupt Types.
 ************************************************************************/
#define   IRQ_INT_TYPE_NORMAL		0
#define   IRQ_INT_TYPE_FAST			1
#define   IRQ_INT_TYPE_UNKNOWN		2

/************************************************************************
 * Exception Source
 ************************************************************************/
#define   VECTOR_RESET    		0
#define   VECTOR_MISALIGN 		1
#define   VECTOR_ACCESS   		2
#define   VECTOR_DIV_BY_ZERO		3
#define   VECTOR_ILLEGAL  		4
#define   VECTOR_PRIVILEGE 		5
#define   VECTOR_TRACE    		6
#define   VECTOR_BREAK    		7
#define   VECTOR_UNRECOV  		8
#define   VECTOR_SOFT     		9
#define   VECTOR_INT      		10
#define   VECTOR_FINT     		11
//Reserved
#define   VECTOR_HW_ACCEL 		12
//Reserved
#define   VECTOR_TRAP0			16
#define   VECTOR_TRAP1			17
#define   VECTOR_TRAP2			18
#define   VECTOR_TRAP3			19

/************************************************************************
 * Defination of IRQ_COW1_REG Register Config Params
 ************************************************************************/
#define   IRQ_COW1_PFEOI                0x40
#define   IRQ_COW1_PEOI                 0x20
#define   IRQ_COW1_0_3_F                0x10
#define   IRQ_COW1_FEOI                 0x08
#define   IRQ_COW1_EOI                  0x04
#define   IRQ_COW1_NAVEC                0x02
#define   IRQ_COW1_PRIOR                0x01

/************************************************************************
 * Defination of IRQ Structure
 ************************************************************************/
#define IRQ_USER_INT_NUM		32	// Interrupt source Number
typedef struct
{
    void  (* handle[IRQ_USER_INT_NUM])(void);	// INT Handle Table
    u32	  intmask;
} irq_t;

/************************************************************************
 * Defination of CPU INT Directly Control 
 ************************************************************************/
#define CPU_ALL_INT_ON			__asm__("psrset fe, ie")
#define CPU_NML_INT_ON			__asm__("psrset ie")
#define CPU_FST_INT_ON			__asm__("psrset fe")
#define CPU_ALL_INT_OFF			__asm__("psrclr fe, ie")
#define CPU_NML_INT_OFF			__asm__("psrclr ie")
#define CPU_FST_INT_OFF			__asm__("psrclr fe")
#define CLI()				__asm__("psrclr fe, ie")
#define STI()				__asm__("psrset fe, ie")

/****************************************************************************
 * Definition of IRQ control Functions
 ****************************************************************************/
/* */
#define IRQ_PRV_ID			1
#define IRQ_PCI_ID			2
#define IRQ_MAC_ID			3
#define IRQ_T0_ID			4
#define IRQ_T1_ID			5
#define IRQ_T2_ID			6
#define IRQ_T3_ID			7
#define	IRQ_CRC_ID			8
#define	IRQ_DMA_ID			9
#define IRQ_I2C0_ID			10
#define IRQ_UART0_ID		11
#define IRQ_UART1_ID		12
#define IRQ_UART2_ID		13
#define IRQ_264T_ID			14
#define IRQ_OSD_ID			15
#define IRQ_JPEG_ID			16
#define IRQ_H264_ID			17
#define IRQ_GPIO_ID			18
#define IRQ_MCHK_ID			19
#define IRQ_IRDA_ID			20
#define IRQ_AUDIOE_ID		21
#define IRQ_VOICED_ID		22
#define IRQ_VOICEE_ID		23
#define IRQ_INPSRC_ID		24
#define IRQ_SPI_ID			25


/* I/O interface */

/*****************************************************
* Register one bytes read and write
******************************************************/
static inline u8 inb(u32 port)
{
    return *((volatile u8*)(port));
}

static inline void outb(u8 val, u32 port)
{
    *((volatile u8*)(port))= val;
}

/*****************************************************
* Register two bytes read and write
******************************************************/
static inline u16 inw(u32 port)
{
   return *((volatile u16*)(port));
}

static inline void outw (u16 val , u32 port)
{
  *((volatile u16*)(port))= val;
}

/*****************************************************
* Register four bytes read and write
******************************************************/
static inline u32 inl(u32 port)
{
    return *((volatile u32*)(port));
}

static inline void outl(u32 val , u32 port)
{
   *((volatile u32*)(port))= val;
}


static inline u32 readvbr(void)
{
	register u32 reg;

	__asm__ __volatile__
	(
		"mfcr %0, vbr\n"
		: "=r" (reg)
		: "0"(reg)
	);
	
	return reg;
}

/* read user stack pointer */
extern inline void InvCache(void) {
  	register unsigned long usp = 0x12;

	__asm__ __volatile__("mtcr %0, cr17" : :"r" (usp));
	
}


extern void NmlIntHandler(void);
extern void FstIntHandler(void);
extern void ISR_Reserved(void);

#endif //_DRV_IRQ_H_
