/*
 *  armboot - Startup Code for ARM940T CPU-core
 *
 *  Copyright (c) 2001	Marius Gr?er <mag@sysgo.de>
 *  Copyright (c) 2002	Alex Z?ke <azu@sysgo.de>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */



#include "config.h"
#include "version.h"

#define AMD_FLASH
#undef SAMSUNG_FLASH
#undef BDI2K

/*
 *************************************************************************
 *
 * Jump vector table as in table 3.1 in [1]
 *
 *************************************************************************
 */
.text


/******************************************************************************
 * _start
 ******************************************************************************/
.export		_start
/* .import		main */
.align		4
_start: 
	lrw	r1, 0x80000100
	mtcr	r1, psr		// S=1, EE=1, FE=IE=0

    //close watch dog
    lrw r1, 0x7000003c
    movi r2, 0x03
    stb r2,(r1, 0)
    movi r2, 0x02
    stb r2,(r1, 0)
    movi r3, 0
    stb r3,(r1, 0)
    
	psrclr fe, ie
	lrw	r7, __stack	// Init stack pointer (__stack comes from Linkcmd.ld)
	mov	r0, r7
	
	lrw r7, __loadaddr
	lrw r3, 0x200
	sub r7, r3
	mtcr r7, vbr
	
	/* Cache */
	lrw  r10,0x0f02 //priority setting,ff-read and write
	//lrw  r10,0xff06 //priority setting,ff-read and write
	mtcr r10,cr19
	                                                                              
	movi r10,0
	mtcr r10,cr21   //first block
	lrw  r10,0x3f   //4G space ,0x00 base address
	mtcr r10,cr20
	
	movi r10,1			//Second block
	mtcr r10,cr21
	//lrw  r10,0xc000002F	//16M,0xc0000000 base address
	lrw  r10,0xc0000031	//32M,0xc0000000 base address
	mtcr r10,cr20
	
	/*
    movi r10,2			//3 block
	mtcr r10,cr21
	lrw  r10,0xc000002B	//4M,0xc0000000 base address
	mtcr r10,cr20
	*/

	//Set MGU(MGU_EN) and Set MGU(BR_PREDICTION_EN)
	mfcr  r7, cr18
	bseti r7, 0
	bclri r7, 1
	bseti r7 , 6
	mtcr   r7, cr18
	
	//Enable instruction cache(INST_CACHE_INV) and  Enable Data cache(DATA_CACHE_INV)
	mfcr   r7, cr17
	bseti  r7, 0
	bseti  r7, 1
	bclri  r7, 2
	bseti  r7, 4
	mtcr   r7, cr17

	//Enable instruction cache(INST_CACHE_EN) and Enable data cache(DATA_CACHE_EN)
	mfcr   r7, cr18
	bseti  r7, 2
#ifndef CONFIG_IS_PCI
	bseti  r7, 3
#else
	bseti  r7, 3
#endif
	mtcr   r7, cr18


/*add by zxj for bbs and code dispaly */
copyrange:
	/* _armboot_start */
	lrw r2, _start
	lrw r3, _armboot_start
	stw r2, (r3,0)

	/* _armboot_end */
	lrw r2, _edata
	lrw r3, _armboot_end
	stw r2, (r3,0)
	
	/* _armboot_real_end */
	lrw r2, _end
	lrw r3, _armboot_real_end
	stw r2, (r3,0)
	
	/* _armboot_relocation */
	lrw r2, __loadaddr
	lrw r3, _armboot_relocation
	stw r2, (r3,0)
	
	jbsr	start_armboot		// Jump to main()

exit:
	bkpt			// Breakpoint if we return from main()


/******************************************************************************
 * EnableCache
 ******************************************************************************/
ENABLE_CACHE = 1
.export		EnableCache
.align		4
EnableCache:
	.if	ENABLE_CACHE		/* Init Cache & MGU			*/
	subi	r0, 8
	stw	r7, (r0, 0)

	lrw	r7, 0xFF02		/* 0xFF02=All blocks Read/Writable ...	*/
	mtcr	r7, cr19		/*    ... 2nd block cacheable only	*/

	movi	r7, 0			/* 1st block, not cacheable		*/
	mtcr	r7, cr21
	lrw	r7, 0x0000003F		/* 4G space, [0~4GM]			*/
	mtcr	r7, cr20

	movi	r7, 1			/* Select 2nd block			*/
	mtcr	r7, cr21   
	lrw	r7, 0x0000002F		/* 16M space, [0~16M]			*/
	mtcr	r7, cr20

	mfcr	r7, cr18		/* .macro MGU_EN			*/
	bseti	r7, 0
	bclri	r7, 1			/* MP=01 : Memory Protection Enable	*/
	mtcr	r7, cr18

	mfcr	r7, cr18		/* .macro BR_PREDICTION_EN		*/
	bseti	r7, 6			/* Z=1 : Jump Prediction Enable		*/
	mtcr	r7, cr18

	mfcr	r7, cr17		/* .macro INST_CACHE_INV		*/
	bseti	r7, 0
	bclri	r7, 1
	bclri	r7, 2			/* SEL=b001 : Select Instruction Cache	*/
	bseti	r7, 4			/* INV = 1: Invalidate Inst Cache	*/
	mtcr	r7, cr17

	mfcr	r7, cr18		/* .macro INST_CACHE_EN			*/
	bseti	r7, 2			/* IE = 1 : Enable Instruction Cache	*/
	mtcr	r7, cr18

	mfcr	r7, cr17		/* .macro DATA_CACHE_INV		*/
	bclri	r7, 0
	bseti	r7, 1
	bclri	r7, 2			/* SEL=b010 : Select Data Cache		*/
	bseti	r7, 4			/* INV=1 : Invalidate Data Cache	*/
	mtcr	r7, cr17

	mfcr	r7, cr18		/* .macro DATA_CACHE_EN			*/
	bseti	r7, 3			/* DE = 1 : Data Cache Enable		*/
	mtcr	r7, cr18	

	ldw		r7, (r0, 0)
	addi	r0, 8
	.endif				/* .if _CACHE_ENABLE			*/
	rts

/******************************************************************************
 * DisableCache
 ******************************************************************************/
.export		DisableCache
.align		4
DisableCache:
	.if	ENABLE_CACHE		/* Init Cache & MGU			*/
	subi	r0, 8
	stw	r7, (r0, 0)

	mfcr	r7, cr17		/* .macro CACHE_INV			*/
	bseti	r7, 0
	bseti	r7, 1
	bclri	r7, 2			/* SEL=b011 : Select Data&Inst Cache	*/
	bseti	r7, 4			/* INV = 1				*/
	mtcr	r7, cr17

	mfcr	r7, cr18		/* .macro CACHE_DISABLE			*/
	bclri	r7, 2			/* IE = 0 : Disable Instruction Cache	*/
	bclri	r7, 3			/* DE = 0 : Data Cache Disable		*/
	mtcr	r7, cr18

	ldw	r7, (r0, 0)
	addi	r0, 8
	.endif				/* .if _CACHE_ENABLE			*/
	rts
	
	
/******************************************************************************
 * DisableCache
 ******************************************************************************/
.export		Cache_Flush
.align		4
Cache_Flush:
	rts


/******************************************************************************
 * JumpToImage
 ******************************************************************************/
.export		JumpToImage
.align		4
JumpToImage:
	jmp	r2
	
//----------------------------------------------------------------------
// Initial interrupt service routines (ISRs)
//----------------------------------------------------------------------
.export	ISR_Reserved

ISR_Reserved:
  	bkpt

//Can be caused by Opened Timer Int Last time. We can close timer and pic, then restart.
ISR_Vectored:
	bkpt
	
PIC_REG_COW	= 0x70000010
.import		IRQIntProcess
.export		NmlIntHandler
NmlIntHandler:
	psrclr ee, ie
 	subi    r0, 32
	subi	r0, 28
	stm	r1-r15, (r0)
	
	mfcr	r1, EPC					// Save the PC for the current task instruction when returning
	mtcr r1, ss0

	mfcr	r1, EPSR				// Save the PSR for the current task
	mtcr r1, ss1

	lrw	r10, PIC_REG_COW			// Send EOI to PIC here
	ldw	r11, (r10)				// Get current Control Word
	movi	r9,  4					// Setup EOI bit for normal interrupt ACK
	or	r11, r9					// Set EOI bit only
	stw	r11, (r10)				// Write back Control Word

	mfcr	r2, psr					/* 1st param: Int vect, get from psr	*/
	lsri	r2, 16
	lrw	r3, 0x7F
	and	r2, r3
	subi	r2, 32					// User Interrupt: [32 ~ 48] -> [0 ~ 31]
	jsri	IRQIntProcess
	
	/*
	lrw r3, 0x42000000
	movi r2, 'i'
	stb r2, ( r3, 0x0b )
*/

	mfcr	r1, ss0
	mtcr	r1, EPC

	mfcr	r1, ss1
	mtcr	r1, EPSR

	ldm	r1-r15, (r0)
	addi    r0, 32
	addi	r0, 28
	
	psrset ee, ie
	rte

