/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Alex Zuepke <azu@sysgo.de>
 *
 * Copyright (C) 1999 2000 2001 Erik Mouw (J.A.K.Mouw@its.tudelft.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "armboot.h"
#if defined(CONFIG_S3C2500)
#include <s3c2500.h>
#endif
#if defined(CONFIG_S3C2510)
#include <s3c2510.h>
#endif
volatile unsigned int *CUART_TxBuf;
volatile unsigned int *CUART_RxBuf;

int calcUartCnt(int BaudRate, int *UartCnt)
{
	int tDIV, DivCnt0, DivCnt1;
	
    /* Set Buad Rate Divisor value. */
    /* You should select UART clock */

    tDIV = fMCLK_MHz2 / (16 * BaudRate);
    if(((tDIV%16)==0) || ((tDIV-1)>0xffff)) 
    {
		DivCnt1 = 1;
		DivCnt0 = tDIV/16 -1;
    }
	else  
	{
    	DivCnt1 = 0;
       	DivCnt0 = tDIV -1;
    }
    *UartCnt = DivCnt0*16 + DivCnt1;
    
    return 0;
}

void serial_setbrg(bd_t *bd, int baudrate)
{
    unsigned int reg = 0;
   
   	/* UART Control Regsiter */
    REG_WRITE(CUCON, (Serial_Clock | Parity_None | One_Stop_Bit | Data_Length_8 | TxModeCpu | RxModeCpu));
   	
	/* Poll Mode Set*/
	intDisable (INT_LVL_CUART_TX);
    intDisable (INT_LVL_CUART_RX);

	/* set baudrate */
    if (baudrate == 1200) 		 calcUartCnt(1200, &reg);
    else if (baudrate == 9600)   calcUartCnt(9600, &reg);
    else if (baudrate == 19200)  calcUartCnt(19200, &reg);
    else if (baudrate == 38400)  calcUartCnt(38400, &reg);
    else if (baudrate == 57600)  calcUartCnt(57600, &reg);
    else if (baudrate == 115200) calcUartCnt(115200, &reg);
    else hang();
	REG_WRITE(UBRDIV, reg);
//	REG_WRITE(UBRDIV, 0x130);

	CUART_TxBuf = &UARTTXH0;
	CUART_RxBuf = &UARTRXB0;
}

  
/*
 * Initialise the serial port with the given baudrate. The settings
 * are always 8 data bits, no parity, 1 stop bit, no start bits.
 *
 */
void serial_init(bd_t *bd)
{
    const char *baudrate;

    if ((baudrate = getenv(bd, "baudrate")) != 0)
	{
    	bd->bi_baudrate = simple_strtoul(baudrate, NULL, 10);
	}
      
 	serial_setbrg(bd, bd->bi_baudrate);
}


/*
 * Output a single byte to the serial port.
 * Wait until UART transmit buffer register empty.
 * when it is empty, tramsmit new data...
 */
#if 1
void serial_putc(const char c)
{
    while(!(UARTSTAT0 & Uart_Tx_Complete)) ;
    *CUART_TxBuf = c;

    if(c == '\n')
    {
        while(!(UARTSTAT0 & Uart_Tx_Complete)) ;
        *CUART_TxBuf = '\r';
    }

}
#else
void serial_putc(const char c)
{
	uint uiReg=0x0;

	REG_READ(USTAT, uiReg); 
	while(!(uiReg & USTAT_TX_READY)) ;
//	REG_WRITE(UTXBUF, c);	
	*CUART_TxBuf = c;

    if(c == '\n') 
	{
		REG_READ(USTAT, uiReg);
		while(!(uiReg & USTAT_TX_READY)) ;
		*CUART_TxBuf = c;
    }
}
#endif

/*
 * Read a single byte from the serial port. Returns 1 on success, 0
 * otherwise. When the function is succesfull, the character read is
 * written into its argument c.
 */
int serial_tstc(void)
{
 	ulong status;
 
    REG_READ(CUSTAT, status);
    return (status & Uart_Rx_Data_Ready);
//  return ((status & USTAT_RX_READY)>>5);
}

/*
 * Read a single byte from the serial port. Returns 1 on success, 0
 * otherwise. When the function is succesfull, the character read is
 * written into its argument c.
 */
#if (1)
int serial_getc(void)
{
    while(!(UARTSTAT0 & Uart_Rx_Data_Ready));
 
    return (UARTRXB0&0xff);
}
#else
int serial_getc(void)
{
	ulong status;
	char ch;
 
	do 
	{
		REG_READ (USTAT, status);
	} while ((status & USTAT_RX_AVAIL) == 0x00);

	/* got a character */
    REG_READ(URXBUF, ch);
	return (ch);
}
#endif
