/*
 * CAST  MAC Core
 *
 * (C) Copyright 2008
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * Copyright (C) 2008 ZhengXingjian <zheng_xingjian@dahutech.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is loaded into SRAM in bootstrap mode, where it waits
 * for commands on UART1 to read and write memory, jump to code etc.
 * A design goal for this program is to be entirely independent of the
 * target board.  Anything with a CL-PS7111 or EP7211 should be able to run
 * this code in bootstrap mode.  All the board specifics can be handled on
 * the host.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "types.h"
#include <config.h>
#include <net.h>

#ifdef CONFIG_DRIVER_IMMAC

//var a version to display
#define IMMAC_DRIVER_VERSION	"IM MAC driver for ckcore boot v1.2 26/06/2008 zxj\n"
#define IMMAC_DEVICE_NAME		"CKCore MAC"

/* bit mask for CSR5 TX/RX process state */
#define CSR5_TS	0x00700000
#define CSR5_RS	0x000e0000

/* Offsets to the Command and Status Registers, "CSRs".  All accesses
   must be longword instructions and quadword aligned. */
enum immac_offsets {
	CSR0 = 0,
	CSR1 = 0x2,
	CSR2 = 0x4,
	CSR3 = 0x6,
	CSR4 = 0x8,
	CSR5 = 0xa,
	CSR6 = 0xc,
	CSR7 = 0xe,
	CSR8 = 0x10,
	CSR9 = 0x12,
	CSR10 = 0x14,
	CSR11 = 0x16,
	CSR12 = 0x18,
	CSR13 = 0x1a,
	CSR14 = 0x1c,
	CSR15 = 0x1e,
	CSR16 = 0x20,
	CSR17 = 0x22,
};

enum immac_mode_bits {
	TxThreshold		= (1 << 22),
	FullDuplex		= (1 << 9),
	TxOn			= 0x2000,
	AcceptBroadcast		= 0x0100,
	AcceptAllMulticast	= 0x0080,
	AcceptAllPhys		= 0x0040,
	AcceptRunt		= 0x0008,
	RxOn			= 0x0002,
	RxTx			= (TxOn | RxOn),
};

enum desc_status_bits {
	DescOwned = 0x80000000,
	RxDescFatalErr = 0x8000,
	RxWholePkt = 0x0300,
};


#define CKMAC_PHY_ADDR 2

#define CKMAC_MODE   0x00  // mode register
#define CKMAC_INT    0x01  // interrupt register
#define CKMAC_IMASK  0x02  // interrupt mask register

#define CKMAC_IPGT   0x03  // inter packet gap register
#define CKMAC_NIPGT1 0x04  // non inter packet gap register
#define CKMAC_NIPGT2 0x05  // non inter packet gap register

#define CKMAC_SIZE   0x06  // packet size register
#define CKMAC_COLL   0x07  // collision and retry configure

#define CKMAC_TXBD   0x08  // transmit buffer descriptor
#define CKMAC_CTL    0x09  // control module mode register

#define CKMAC_MIIM   0x0a  // mii mode register
#define CKMAC_MIICMD 0x0b  // mii command register
#define CKMAC_MIIADD 0x0c  // mii address register
#define CKMAC_MIITX  0x0d  // mii transmit data register
#define CKMAC_MIIRX  0x0e  // mii receive data register
#define CKMAC_MIISTS 0x0e  // mii status register

#define CKMAC_ADDR0  0x10  // mac individual address of LSB
#define CKMAC_ADDR1  0x11  // mac individual address of MSB

#define CKETH_HASH0  0x12  // hash0 register
#define CKETH_HASH1  0x13  // hash1 register
#define CKETH_TXCTL  0x14  // transmit control register

#define CKMAC_DESC   0x100 // basic address of descriptor 

/////////////////////////////////////////////////////////////////////////////
//RTL8201BL physical device register
#define RTL8201_MODECTRL	0x00	// Mode control register
#define RTL8201_MODESTS		0x01	// Mode status register (read only)
#define RTL8201_PHYID1		0x02	// phy identifier register1 (read only)
#define RTL8201_PHYID2		0x03	// phy identifier register2 (read only)
#define RTL8201_ANAR		0x04	// Auto-negotiation advertisement register
#define RTL8201_ANLPAR		0x05	// Auto-negotiation link partner ability register (read only)
#define RTL8201_ANER		0x06	// Auto-negotiation expansion register (read only)
#define	RTL8201_NSR		0x16	// Nway setup register
#define RTL8201_LBREMR		0x17	// Loopback, Bypass, Receiver error mask register
#define RTL8201_REC		0x18	// Rx_er counter
#define RTL8201_10MNICR		0x19	// 10Mbps Network Interface Configuration Register
#define RTL8201_PHY1_1		0x20	// PHY 1_1 Register
#define RTL8201_PHY1_2		0x21	// PHY 1_2 Register
#define RTL8201_PHY2		0x22	// PHY 2 register
#define RTL8201_TWISTER1	0x23	// Twister_1 register
#define RTL8201_TWISTER_2	0x24	// Twister_2 register
#define RTL8201_TEST		0x25	// test register (Read only)


/////////////////////////////////////////////////////////////////////////////
//mode register
#define CKMAC_MODE_BES        (1 << 18)    //Little/Big Endian Select( =0,Little Endian, ReadOnly)
#define CKMAC_MODE_LPMD_RXEN  (1 << 17)    //Low power Mode Rx Enable
#define CKMAC_MODE_RECSMALL   (1 << 16)    //Receive small packets
#define CKMAC_MODE_PAD        (1 << 15)    //Padding enable
#define CKMAC_MODE_HUGEN      (1 << 14)    //Huge packets enable
#define CKMAC_MODE_CRCEN      (1 << 13)    //CRC enable
#define CKMAC_MODE_DLYCRCEN   (1 << 12)    //Delayed CRC Enable
#define CKMAC_MODE_FULLD      (1 << 10)    //Full Duplex
#define CKMAC_MODE_EXDFREN    (1 << 9)     //Excess Defer enable
#define CKMAC_MODE_NOBCKOF    (1 << 8)     //No Backoff
#define CKMAC_MODE_LOOPBACK   (1 << 7)     //Loop Back
#define CKMAC_MODE_IFG        (1 << 6)     //Interframe gap for incoming frames
#define CKMAC_MODE_PRO        (1 << 5)     //PROMISCUOUS
#define CKMAC_MODE_IAM        (1 << 4)     //Individual address mode
#define CKMAC_MODE_BRO        (1 << 3)     //Broadcast address
#define CKMAC_MODE_NOPRE      (1 << 2)     //No preamble
#define CKMAC_MODE_TXEN       (1 << 1)     //Transmit enable
#define CKMAC_MODE_RXEN       (0x01)       //Receive enable
//Interrupt source register
#define CKMAC_INT_BER         (1 << 7)     //Bus error
#define CKMAC_INT_RXC         (1 << 6)     //Receive control frame
#define CKMAC_INT_TXC         (1 << 5)     //Transmit control frame
#define CKMAC_INT_BUSY        (1 << 4)     //Busy
#define CKMAC_INT_RXE         (1 << 3)     //Receive error
#define CKMAC_INT_RXB         0x04         //Receive frame
#define CKMAC_INT_TXE         0x02         //Transmit error
#define CKMAC_INT_TXB         0x01         //Transmit frame
//Interrupt mask register
#define CKMAC_IMASK_BER         (1 << 7)   //Bus error interrupt mask
#define CKMAC_IMASK_RXC         (1 << 6)   //Receive control frame interrupt mask
#define CKMAC_IMASK_TXC         (1 << 5)   //Transmit control frame interrupt mask
#define CKMAC_IMASK_BUSY        (1 << 4)   //Busy interrupt mask
#define CKMAC_IMASK_RXE         (1 << 3)   //Receive error interrupt mask
#define CKMAC_IMASK_RXB         0x04       //Receive frame interrupt mask
#define CKMAC_IMASK_TXE         0x02       //Transmit error interrupt mask
#define CKMAC_IMASK_TXB         0x01       //Transmit frame interrupt mask
//MII command register
#define CKMAC_MIICMD_WCTRLDATA  0x04       //Write control data
#define CKMAC_MIICMD_RSTAT      0x02       //Read staus
#define CKMAC_MIICMD_SCANSTAT   0x01       //Scan status
//MII address register
//MII status register (read only)
#define CKMAC_MIISTS_NVALID     0x04       // Mii status register invalid ( = 0, valid; = 1, invalid)
#define CKMAC_MIISTS_BUSY       0x02       // Mii busy ( = 0, ready; = 1, busy)
#define CKMAC_MIISTS_LINKFAIL   0x01       // Link fail ( = 0, ok; = 1, fail)
/////////////////////////////////////////////////////////////////////////////




/////////////////////////////////////////////////////////////////////////////
//RTL8201 mode cnotrol register
#define RTL8201_MODECTRL_RESET		(1 << 15)	// reset
#define RTL8201_MODECTRL_LOOPBACK	(1 << 14)	// Loopback
#define RTL8201_MODECTRL_SPD100		(1 << 13)	// Sets the network speed, if auto-negotiation is disable
#define RTL8201_MODECTRL_ANE		(1 << 12)	// Nway Auto-Negotiation Enable
#define RTL8201_MODECTRL_POWERDOWN	(1 << 11)	// Turn down the power of the phy chip
#define RTL8201_MODECTRL_RESTARTAN	(1 << 9)	// re-start auto-negotiation
#define RTL8201_MODECTRL_DUPLEX		(1 << 8)	// set the duplex mode if auto negotiation is disable
//RTL8201 mode status register
#define RTL8201_MODESTS_100BT4		(1 << 15)	// enable 100base-t4 support
#define RTL8201_MODESTS_100BTXFD	(1 << 14)	// enable 100base-tx full duplex support
#define RTL8201_MODESTS_100BTXHD	(1 << 13)	// enable 100base-tx half duplex support
#define	RTL8201_MODESTS_10BTFD		(1 << 12)	// enable 10base-t full duplex support
#define RTL8201_MODESTS_10BTHD		(1 << 11)	// enable 10base-t half duplex support
#define RTL8201_MODESTS_MFPS		(1 << 6)	// the RTL8201BL will accept management frames with preamble supporessed
#define RTL8201_MODESTS_ANC		(1 << 5)	// Auto-negotiation process completed
#define RTL8201_MODESTS_AN		(1 << 4)	// Auto-negotiation link had not been experienced fail state
#define RTL8201_MODESTS_LINKSTS		(1 << 3)	// Valid link established
#define RTL8201_MODESTS_JD		(1 << 2)	// Jabber condition detected
#define RTL8201_MODESTS_EC		(0x01)		// extended register capability


#define CKMAC_DSL	2
struct immac_alldes
{
	u32 DES0;
	u32 DES1;
	u32 DES2;
	u32 DES3;
};

struct immac_descriptor
{
	//Receive descriptor
	struct immac_alldes rev_des[3];
	
	//Transmit descriptor
	struct immac_alldes mit_des[3];
	
	int rx_cur;
	
	//Receive buffer
	//u8 rbuf[3][PKTSIZE_ALIGN];
	u8 rbuf[2][PKTSIZE_ALIGN];
	
	//Transmit buffer
	//u8 tbuf[3][PKTSIZE_ALIGN];
	u8 tbuf[PKTSIZE_ALIGN];
};

#endif /* CONFIG_DRIVER_IMMAC */
