#ifndef	__MAC2500h
#define		__MAC2500h

/* Big endian or little endian big = 1, little = 0 */
#define BIG_ENDIAN			0

/*FOR VxWorks*/
/*#define PACK_RESERVED		(__attribute__((__packed__)))*/
#define PACK_RESERVED

/********** ETHERNET control registers **************/
#define BDMATXCON 				(0x0000)
#define BDMARXCON 				(0x0004)
#define BDMATXDPTR 				(0x0008)
#define BDMARXDPTR 				(0x000C)
#define BTXBDCNT				(0x0010)
#define BRXBDCNT				(0x0014)
#define BMTXINTEN				(0x0018)
#define BMRXINTEN				(0x001C)
#define BMTXSTAT				(0x0020)
#define BMRXSTAT				(0x0024)
#define BDMARXLEN				(0x0028)
#define CFTXSTAT				(0x0030)
#define MACCON					(0x10000)
#define CAMCON					(0x10004)
#define MACTXCON				(0x10008)
#define MACTXSTAT				(0x1000C)
#define MACRXCON				(0x10010)
#define MACRXSTAT				(0x10014)
#define STADATA					(0x10018)
#define STACON					(0x1001C)
#define CAMEN					(0x10028)
#define MISSCNT					(0x1003C)
#define PZCNT					(0x10040)
#define RMPZCNT					(0x10044)
#define CAM_BASE				(0x10080)

/********** Tx Buffer Descriptor **************/

struct FD_TX_STATUS_LENGTH_PACKED
{
#if BIG_ENDIAN
	ulong owner:1;				/* 31, 0 = CPU */
	ulong reserved:1;			/* 30 */
	ulong paused:1;				/* 29 */
	ulong halted:1;				/* 28 */
	ulong sqeErr:1;				/* 27 */
	ulong defer:1;				/* 26 */
	ulong coll:1;				/* 25 */
	ulong comp:1;				/* 24 */
	ulong parErr:1;				/* 23 */
	ulong lateColl:1;			/* 22 */
	ulong noCarr:1;				/* 21 */
	ulong deferErr:1;			/* 20 */
	ulong underflow:1;			/* 19 */
	ulong exColl:1;				/* 18 */
	ulong TxWidget:2;			/* 17 - 16 */
	ulong TxLength:16;			/* 15 - 0 */
#else
	ulong TxLength:16;			/* 15 - 0 */
	ulong TxWidget:2;			/* 17 - 16 */
	ulong exColl:1;				/* 18 */
	ulong underflow:1;			/* 19 */
	ulong deferErr:1;			/* 20 */
	ulong noCarr:1;				/* 21 */
	ulong lateColl:1;			/* 22 */
	ulong parErr:1;				/* 23 */
	ulong comp:1;				/* 24 */
	ulong coll:1;				/* 25 */
	ulong defer:1;				/* 26 */
	ulong sqeErr:1;				/* 27 */
	ulong halted:1;				/* 28 */
	ulong paused:1;				/* 29 */
	ulong reserved:1;			/* 30 */
	ulong owner:1;				/* 31, 0 = CPU */
#endif	
}PACK_RESERVED;
typedef struct FD_TX_STATUS_LENGTH_PACKED FD_TX_STATUS_LENGTH;

struct TRANSMIT_FRAME_DESC_PACKED
{
	ulong	txFrameData;
	FD_TX_STATUS_LENGTH txStatusLength;
}PACK_RESERVED;
typedef struct TRANSMIT_FRAME_DESC_PACKED TRANSMIT_FRAME_DESC;

/********** Rx Buffer Descriptor **************/

struct FD_RX_STATUS_LENGTH_PACKED
{
#if BIG_ENDIAN
	/* rx command */
	ulong owner:1;				/* 31, 0 = CPU */
	ulong skipBD:1;				/* 30 */
	ulong sof:1;				/* 29 */
	ulong eof:1;				/* 28 */
	ulong done:1;				/* 27 */

	/* rx status */
	ulong mso:1;				/* 26 */
	ulong halted:1;				/* 25 */
	ulong mRx10Stat:1;			/* 24 */
	ulong bRxDone:1;			/* 23 */
	ulong rxParErr:1;			/* 22 */
	ulong mufs:1;				/* 21 */
	ulong overFlow:1;			/* 20 */
	ulong crcErr:1;				/* 19 */
	ulong alignErr:1;			/* 18 */
	ulong reserved:2;			/* 17-16 */

	/* length */
	ulong RxLength:16;			/* 15-0 */
#else
	/* length */
	ulong RxLength:16;			/* 15-0 */

	/* rx status */
	ulong reserved:2;			/* 17-16 */
	ulong alignErr:1;			/* 18 */
	ulong crcErr:1;				/* 19 */
	ulong overFlow:1;			/* 20 */
	ulong mufs:1;				/* 21 */
	ulong rxParErr:1;			/* 22 */
	ulong bRxDone:1;			/* 23 */
	ulong mRx10Stat:1;			/* 24 */
	ulong halted:1;				/* 25 */
	ulong mso:1;				/* 26 */

	/* rx command */
	ulong done:1;				/* 27 */
	ulong eof:1;				/* 28 */
	ulong sof:1;				/* 29 */
	ulong skipBD:1;				/* 30 */
	ulong owner:1;				/* 31, 0 = CPU */
#endif	
}PACK_RESERVED;
typedef struct FD_RX_STATUS_LENGTH_PACKED FD_RX_STATUS_LENGTH;

struct RECEIVE_FRAME_DESC_PACKED			/* receive frame descriptor */
{
	ulong	rxFrameData;
	FD_RX_STATUS_LENGTH rxStatusLength;
}PACK_RESERVED;
typedef struct RECEIVE_FRAME_DESC_PACKED RECEIVE_FRAME_DESC;

#define	MACRXFRAMEERRMASK		0x067c0000

/* ********* Control Registers ************* */

struct BDMATXCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:20;
	ulong bTxRS:1;
	ulong bTxEn:1;
	ulong reserved_0:3;
	ulong bTxMSL:3;
	ulong bTxNBD:4;
#else
	ulong bTxNBD:4;
	ulong bTxMSL:3;
	ulong reserved_0:3;
	ulong bTxEn:1;
	ulong bTxRS:1;
	ulong reserved_1:20;
#endif
}PACK_RESERVED;
union UNION_BDMATXCON
	{
		struct BDMATXCON_PACKED	txCon_reg;
		ulong txCon_resetval;
	}PACK_RESERVED; 
typedef union UNION_BDMATXCON uBDMATXCON;

struct BDMARXCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:20;
	ulong bRxRS:1;
	ulong bRxEn:1;
	ulong reserved_0:4;
	ulong bRxWA:2;
	ulong bRxNBD:4;
#else
	ulong bRxNBD:4;
	ulong bRxWA:2;
	ulong reserved_0:4;
	ulong bRxEn:1;
	ulong bRxRS:1;
	ulong reserved_1:20;
#endif
}PACK_RESERVED;

union UNION_BDMARXCON
{
	struct BDMARXCON_PACKED	rxCon_reg;
	ulong rxCon_resetval;
}PACK_RESERVED; 
typedef union UNION_BDMARXCON uBDMARXCON;


struct BDMATXINTEN_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:13;		/* 19 - 31 */
	ulong bTxEmptyIE:1;			/* 18 */
	ulong bTxNOIE:1;			/* 17 */
	ulong txCFcompIE:1;			/* 16 */
	ulong reserved_0:9;			/* 7 - 15 */
	ulong txCompIE:1;			/* 6 */
	ulong txParErrIE:1;			/* 5 */
	ulong lateCollIE:1;			/* 4 */
	ulong noCarrIE:1;			/* 3 */
	ulong deferErrIE:1;			/* 2 */
	ulong underflowIE:1;		/* 1 */
	ulong exCollIE:1;			/* 0 */
#else
	ulong exCollIE:1;			/* 0 */
	ulong underflowIE:1;		/* 1 */
	ulong deferErrIE:1;			/* 2 */
	ulong noCarrIE:1;			/* 3 */
	ulong lateCollIE:1;			/* 4 */
	ulong txParErrIE:1;			/* 5 */
	ulong txCompIE:1;			/* 6 */
	ulong reserved_0:9;			/* 7 - 15 */
	ulong txCFcompIE:1;			/* 16 */
	ulong bTxNOIE:1;			/* 17 */
	ulong bTxEmptyIE:1;			/* 18 */
	ulong reserved_1:13;		/* 19 - 31 */
#endif	
}PACK_RESERVED;

union UNION_BDMATXINTEN
{
		struct BDMATXINTEN_PACKED	txIntEn_reg;
		ulong txIntEn_resetval;
}PACK_RESERVED; 
typedef union UNION_BDMATXINTEN uBDMATXINTEN;


struct BDMATXSTAT_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:13;	/* 19 - 31 */
	ulong bTxEmpty:1;		/* 18 */
	ulong bTxNO:1;			/* 17 */
	ulong txCFcomp:1;		/* 16 */
	ulong reserved_0:9;		/* 7 - 15 */
	ulong txComp:1;			/* 6 */
	ulong txParErr:1;		/* 5 */
	ulong lateColl:1;		/* 4 */
	ulong noCarr:1;			/* 3 */
	ulong deferErr:1;		/* 2 */
	ulong underflow:1;		/* 1 */
	ulong exColl:1;			/* 0 */
#else
	ulong exColl:1;			/* 0 */
	ulong underflow:1;		/* 1 */
	ulong deferErr:1;		/* 2 */
	ulong noCarr:1;			/* 3 */
	ulong lateColl:1;		/* 4 */
	ulong txParErr:1;		/* 5 */
	ulong txComp:1;			/* 6 */
	ulong reserved_0:9;		/* 7 - 15 */
	ulong txCFcomp:1;		/* 16 */
	ulong bTxNO:1;			/* 17 */
	ulong bTxEmpty:1;		/* 18 */
	ulong reserved_1:13;	/* 19 - 31 */
#endif	
}PACK_RESERVED;

union UNION_BDMATXSTAT
{
		struct BDMATXSTAT_PACKED	txstat_reg;
		ulong txstat_resetval;
}PACK_RESERVED; 
typedef union UNION_BDMATXSTAT uBDMATXSTAT;


struct BDMARXINTEN_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:11;		/* 21 - 31 */
	ulong bRxEarlyIE:1;			/* 20 */
	ulong bRxFullIE:1;			/* 19 */
	ulong overflowIE:1;			/* 3 */
	ulong longErrIE:1;			/* 4 */
	ulong rxParErrIE:1;			/* 5 */
	ulong reserved_0:10;		/* 6 - 15 */
	ulong bRxDoneIE:1;			/* 16 */
	ulong bRxNOIE:1;			/* 17 */
	ulong bRxMSOIE:1;			/* 18 */
	ulong crcErrIE:1;			/* 2 */
	ulong alignErrIE:1;			/* 1 */
	ulong missRollIE:1;			/* 0 */
#else
	ulong missRollIE:1;			/* 0 */
	ulong alignErrIE:1;			/* 1 */
	ulong crcErrIE:1;			/* 2 */
	ulong overflowIE:1;			/* 3 */
	ulong longErrIE:1;			/* 4 */
	ulong rxParErrIE:1;			/* 5 */
	ulong reserved_0:10;		/* 6 - 15 */
	ulong bRxDoneIE:1;			/* 16 */
	ulong bRxNOIE:1;			/* 17 */
	ulong bRxMSOIE:1;			/* 18 */
	ulong bRxFullIE:1;			/* 19 */
	ulong bRxEarlyIE:1;			/* 20 */
	ulong reserved_1:11;		/* 21 - 31 */
#endif	
}PACK_RESERVED;

union UNION_BDMARXINTEN
{
		struct BDMATXINTEN_PACKED	rxIntEn_reg;
		ulong rxIntEn_resetval;
}PACK_RESERVED; 
typedef union UNION_BDMARXINTEN uBDMARXINTEN;


struct BDMARXSTAT_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:5;			/* 27 - 31 */
	ulong noFrameInRXBUFF:5;	/* 22 - 26 */
	ulong bRxFRF:1;				/* 21 */
	ulong bRxEarly:1;			/* 20 */
	ulong bRxFull:1;			/* 19 */
	ulong bRxMSO:1;				/* 18 */
	ulong bRxNO:1;				/* 17 */
	ulong bRxDone:1;			/* 16 */
	ulong reserved_0:10;		/* 6 - 15 */
	ulong rxParErr:1;			/* 5 */
	ulong longErr:1;			/* 4 */
	ulong overflow:1;			/* 3 */
	ulong crcErr:1;				/* 2 */
	ulong alignErr:1;			/* 1 */
	ulong missRoll:1;			/* 0 */
#else
	ulong missRoll:1;			/* 0 */
	ulong alignErr:1;			/* 1 */
	ulong crcErr:1;				/* 2 */
	ulong overflow:1;			/* 3 */
	ulong longErr:1;			/* 4 */
	ulong rxParErr:1;			/* 5 */
	ulong reserved_0:10;		/* 6 - 15 */
	ulong bRxDone:1;			/* 16 */
	ulong bRxNO:1;				/* 17 */
	ulong bRxMSO:1;				/* 18 */
	ulong bRxFull:1;			/* 19 */
	ulong bRxEarly:1;			/* 20 */
	ulong bRxFRF:1;				/* 21 */
	ulong noFrameInRXBUFF:5;	/* 22 - 26 */
	ulong reserved_1:5;			/* 27 - 31 */
#endif	
}PACK_RESERVED;

union UNION_BDMARXSTAT
{
		struct BDMARXSTAT_PACKED	rxStat_reg;
		ulong rxStat_resetval;
}PACK_RESERVED; 
typedef union UNION_BDMARXSTAT uBDMARXSTAT;

struct BMTXINTEN_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:13;		/* 19 - 31 */
	ulong bTxEmptyIE:1;			/* 18 */
	ulong bTxNOIE:1;			/* 17 */
	ulong txCFcompIE:1;			/* 16 */
	ulong reserved_0:9;			/* 7 - 15 */
	ulong txCompIE:1;			/* 6 */
	ulong txParErrIE:1;			/* 5 */
	ulong lateCollIE:1;			/* 4 */
	ulong noCarrrIE:1;			/* 3 */
	ulong deferErrIE:1;			/* 2 */
	ulong underflowIE:1;		/* 1 */
	ulong exCollIE:1;			/* 0 */
#else
	ulong exCollIE:1;			/* 0 */
	ulong underflowIE:1;		/* 1 */
	ulong deferErrIE:1;			/* 2 */
	ulong noCarrrIE:1;			/* 3 */
	ulong lateCollIE:1;			/* 4 */
	ulong txParErrIE:1;			/* 5 */
	ulong txCompIE:1;			/* 6 */
	ulong reserved_0:9;			/* 7 - 15 */
	ulong txCFcompIE:1;			/* 16 */
	ulong bTxNOIE:1;			/* 17 */
	ulong bTxEmptyIE:1;			/* 18 */
	ulong reserved_1:13;		/* 19 - 31 */
#endif
}PACK_RESERVED;

union UNION_BMTXINTEN
{
	struct BMTXINTEN_PACKED	txIntEn_reg;
	ulong txIntEn_resetval;
}PACK_RESERVED; 
typedef union UNION_BMTXINTEN uBMTXINTEN;

struct BMTXSTAT_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:13;		/* 19 - 31 */
	ulong bTxEmpty:1;			/* 18 */
	ulong bTxNO:1;				/* 17 */
	ulong txCFcomp:1;			/* 16 */
	ulong reserved_0:9;			/* 7 - 15 */
	ulong tcComp:1;				/* 6 */
	ulong txParErr:1;			/* 5 */
	ulong lateColl:1;			/* 4 */
	ulong noCarrr:1;			/* 3 */
	ulong deferErr:1;			/* 2 */
	ulong underflow:1;			/* 1 */
	ulong exColl:1;				/* 0 */
#else
	ulong exColl:1;				/* 0 */
	ulong underflow:1;			/* 1 */
	ulong deferErr:1;			/* 2 */
	ulong noCarrr:1;			/* 3 */
	ulong lateColl:1;			/* 4 */
	ulong txParErr:1;			/* 5 */
	ulong txComp:1;				/* 6 */
	ulong reserved_0:9;			/* 7 - 15 */
	ulong txCFcomp:1;			/* 16 */
	ulong bTxNO:1;				/* 17 */
	ulong bTxEmpty:1;			/* 18 */
	ulong reserved_1:13;		/* 19 - 31 */
#endif
}PACK_RESERVED;

union UNION_BMTXSTAT
{
	struct BMTXSTAT_PACKED	txStat_reg;
	ulong txStat_resetval;
}PACK_RESERVED; 
typedef union UNION_BMTXSTAT uBMTXSTAT;

struct BMRXINTEN_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:11;		/* 21 - 31 */
	ulong bRxEarlyIE:1;			/* 20 */
	ulong bRxFullIE:1;			/* 19 */
	ulong bRxMSOIE:1;			/* 18 */
	ulong bRxNOIE:1;			/* 17 */
	ulong bRxDoneIE:1;			/* 16 */
	ulong reserved_0:10;		/* 6 - 15 */
	ulong rxParErrIE:1;			/* 5 */
	ulong longErrIE:1;			/* 4 */
	ulong overflowIE:1;			/* 3 */
	ulong crcErrIE:1;			/* 2 */
	ulong alignErrIE:1;			/* 1 */
	ulong missRollIE:1;			/* 0 */
#else
	ulong missRollIE:1;			/* 0 */
	ulong alignErrIE:1;			/* 1 */
	ulong crcErrIE:1;			/* 2 */
	ulong overflowIE:1;			/* 3 */
	ulong longErrIE:1;			/* 4 */
	ulong rxParErrIE:1;			/* 5 */
	ulong reserved_0:10;		/* 6 - 15 */
	ulong bRxDoneIE:1;			/* 16 */
	ulong bRxNOIE:1;			/* 17 */
	ulong bRxMSOIE:1;			/* 18 */
	ulong bRxFullIE:1;			/* 19 */
	ulong bRxEarlyIE:1;			/* 20 */
	ulong reserved_1:11;		/* 21 - 31 */
#endif
}PACK_RESERVED;

union UNION_BMRXINTEN
{
	struct BMRXINTEN_PACKED	rxIntEn_reg;
	ulong rxIntEn_resetval;
}PACK_RESERVED; 
typedef union UNION_BMRXINTEN uBMRXINTEN;

struct BMRXSTAT_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:5;			/* 27 - 31 */
	ulong bRxNFR:5;				/* 22 - 26 */
	ulong bRxFRF:1;				/* 21 */
	ulong bRxEarly:1;			/* 20 */
	ulong bRxFull:1;			/* 19 */
	ulong bRxMSO:1;				/* 18 */
	ulong bRxNO:1;				/* 17 */
	ulong bRxDone:1;			/* 16 */
	ulong reserved_0:10;		/* 6 - 15 */
	ulong rxParErr:1;			/* 5 */
	ulong longErr:1;			/* 4 */
	ulong overflow:1;			/* 3 */
	ulong crcErr:1;				/* 2 */
	ulong alignErr:1;			/* 1 */
	ulong missRoll:1;			/* 0 */
#else
	ulong missRoll:1;			/* 0 */
	ulong alignErr:1;			/* 1 */
	ulong crcErr:1;				/* 2 */
	ulong overflow:1;			/* 3 */
	ulong longErr:1;			/* 4 */
	ulong rxParErr:1;			/* 5 */
	ulong reserved_0:10;		/* 6 - 15 */
	ulong bRxDone:1;			/* 16 */
	ulong bRxNO:1;				/* 17 */
	ulong bRxMSO:1;				/* 18 */
	ulong bRxFull:1;			/* 19 */
	ulong bRxEarly:1;			/* 20 */
	ulong bRxFRF:1;				/* 21 */
	ulong bRxNFR:5;				/* 22 - 26 */
	ulong reserved_1:5;			/* 27 - 31 */
#endif
}PACK_RESERVED;

union UNION_BMRXSTAT
{
	struct BMRXSTAT_PACKED	rxStat_reg;
	ulong rxStat_resetval;
}PACK_RESERVED; 
typedef union UNION_BMRXSTAT uBMRXSTAT;

struct BDMARXLEN_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:4;			/* 28 - 31 */
	ulong bRxMFS:12;			/* 16 - 27 */
	ulong reserved_0:4;			/* 12 - 15 */
	ulong bRxBS:12;				/* 0 - 11 */
#else
	ulong bRxBS:12;				/* 0 - 11 */
	ulong reserved_0:4;			/* 12 - 15 */
	ulong bRxMFS:12;			/* 16 - 27 */
	ulong reserved_1:4;			/* 28 - 31 */
#endif	
}PACK_RESERVED;

union UNION_BDMARXLEN
{
		struct BDMARXLEN_PACKED rxLen_reg;
		ulong rxLen_resetval;
}PACK_RESERVED; 
typedef union UNION_BDMARXLEN uBDMARXLEN;



struct MACCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_3:1;			/* 16 - 31 */
	ulong mLINK10:1;			/* 15 */
	ulong reserved_2:2;			/* 13 - 14 */
	ulong mDC_OFFf:1;			/* 12 */
	ulong reserved_1:4;			/* 8 -11 */
	ulong mLOOP10:1;			/* 7 */
	ulong mII_OFF:1;			/* 6 */
	ulong reserved_0:1;			/* 5 */
	ulong mLoopBack:1;			/* 4 */
	ulong full_duplex:1;		/* 3 */
	ulong mReset:1;				/* 2 */
	ulong mHaltImm:1;			/* 1 */
	ulong mHaltReq:1;			/* 0 */
#else
	ulong mHaltReq:1;			/* 0 */
	ulong mHaltImm:1;			/* 1 */
	ulong mReset:1;				/* 2 */
	ulong full_duplex:1;		/* 3 */
	ulong mLoopBack:1;			/* 4 */
	ulong reserved_0:1;			/* 5 */
	ulong mII_OFF:1;			/* 6 */
	ulong mLOOP10:1;			/* 7 */
	ulong reserved_1:4;			/* 8 -11 */
	ulong mDC_OFFf:1;			/* 12 */
	ulong reserved_2:2;			/* 13 - 14 */
	ulong mLINK10:1;			/* 15 */
	ulong reserved_3:1;			/* 16 - 31 */
#endif	
}PACK_RESERVED;

union UNION_MACCON
{
	struct MACCON_PACKED	macCon_reg;
	ulong macCon_resetval;
}PACK_RESERVED; 
typedef union UNION_MACCON uMACCON;

struct CAMCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:27;
	ulong mCompEn:1;
	ulong mNegCAM:1;
	ulong mBroad:1;
	ulong mGroup:1;
	ulong mStation:1;
#else
	ulong mStation:1;
	ulong mGroup:1;
	ulong mBroad:1;
	ulong mNegCAM:1;
	ulong mCompEn:1;
	ulong reserved_0:27;
#endif	
}PACK_RESERVED;

union UNION_CAMCON
{
	struct CAMCON_PACKED	camCon_reg;
	ulong camCon_resetval;
}PACK_RESERVED; 
typedef union UNION_CAMCON uCAMCON;


struct MACTXCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:24;		/* 8 - 31 */
	ulong mSQEn:1;				/* 7 */
	ulong mSdPause:1;			/* 6 */
	ulong mNoDef:1;				/* 5 */
	ulong mFBack:1;				/* 4 */
	ulong mNoCRC:1;				/* 3 */
	ulong mNoPad:1;				/* 2 */
	ulong mTxHalt:1;			/* 1 */
	ulong mTxEn:1;				/* 0 */
#else
	ulong mTxEn:1;				/* 0 */
	ulong mTxHalt:1;			/* 1 */
	ulong mNoPad:1;				/* 2 */
	ulong mNoCRC:1;				/* 3 */
	ulong mFBack:1;				/* 4 */
	ulong mNoDef:1;				/* 5 */
	ulong mSdPause:1;			/* 6 */
	ulong mSQEn:1;				/* 7 */
	ulong reserved_0:24;		/* 8 - 31 */
#endif	
}PACK_RESERVED;

union UNION_MACTXCON
{
	struct MACTXCON_PACKED	macTxCon_reg;
	ulong macTxCon_resetval;
}PACK_RESERVED; 
typedef union UNION_MACTXCON uMACTXCON;



struct MACTXSTAT_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:15;			/* 16 - 31 */
	ulong mPaused:1;				/* 15 */
	ulong mTxHalted:1;				/* 14 */
	ulong sQEErr:1;					/* 13 */
	ulong mTxDefer:1;				/* 12 */
	ulong mCollCnt:4;				/* 8 - 11 */
	ulong reserved_0:8;				/* 0 - 7 */
#else
	ulong reserved_0:8;				/* 0 - 7 */
	ulong mCollCnt:4;				/* 8 - 11 */
	ulong mTxDefer:1;				/* 12 */
	ulong sQEErr:1;					/* 13 */
	ulong mTxHalted:1;				/* 14 */
	ulong mPaused:1;				/* 15 */
	ulong reserved_1:15;			/* 16 - 31 */
#endif
}PACK_RESERVED;

union UNION_MACTXSTAT
{
	struct MACTXSTAT_PACKED	macTxStat_reg;
	ulong macTxStat_resetval;
}PACK_RESERVED; 
typedef union UNION_MACTXSTAT uMACTXSTAT;


struct MACRXCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:25;		/* 7 - 31 */
	ulong mIgnoreCRC:1;			/* 6 */
	ulong mPassCtl:1;			/* 5 */
	ulong mStripCRC:1;			/* 4 */
	ulong mShortEn:1;			/* 3 */
	ulong mLongEn:1;			/* 2 */
	ulong mRxHalt:1;			/* 1 */
	ulong mRxEn:1;				/* 0 */
#else
	ulong mRxEn:1;				/* 0 */
	ulong mRxHalt:1;			/* 1 */
	ulong mLongEn:1;			/* 2 */
	ulong mShortEn:1;			/* 3 */
	ulong mStripCRC:1;			/* 4 */
	ulong mPassCtl:1;			/* 5 */
	ulong mIgnoreCRC:1;			/* 6 */
	ulong reserved_0:25;		/* 7 - 31 */
#endif
}PACK_RESERVED;

union UNION_MACRXCON
{
	struct MACRXCON_PACKED	macRxCon_reg;
	ulong macRxCon_resetval;
}PACK_RESERVED; 
typedef union UNION_MACRXCON uMACRXCON;


struct MACRXSTAT_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:16;			/* 12 - 31 */
	ulong mCtlRecd:1;				/* 11 */
	ulong mRxHalted:1;				/* 10 */
	ulong mRx10Stat:1;				/* 9 */
	ulong mRxShort:1;				/* 8 */
	ulong reserved_0:8;				/* 0 - 7 */
#else
	ulong reserved_0:8;				/* 0 - 7 */
	ulong mRxShort:1;				/* 8 */
	ulong mRx10Stat:1;				/* 9 */
	ulong mRxHalted:1;				/* 10 */
	ulong mCtlRecd:1;				/* 11 */
	ulong reserved_1:16;			/* 12 - 31 */
#endif	
}PACK_RESERVED;

union UNION_MACRXSTAT
{
	struct MACRXSTAT_PACKED	macRxCon_reg;
	ulong macRxCon_resetval;
}PACK_RESERVED; 

typedef union UNION_MACRXSTAT uMACRXSTAT;


struct STACON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:16;			/* 16 - 31 */
	ulong mMDCrate:3;				/* 13 - 15 */
	ulong reserved_0:1;				/* 12 */
	ulong mPHYbusy:1;				/* 11 */
	ulong mPHYwrite:1;				/* 10 */
	ulong mPHYaddr:5;				/* 5 - 9 */
	ulong mPHYRegAddr:5;			/* 0 - 4 */
#else
	ulong mPHYRegAddr:5;			/* 0 - 4 */
	ulong mPHYaddr:5;				/* 5 - 9 */
	ulong mPHYwrite:1;				/* 10 */
	ulong mPHYbusy:1;				/* 11 */
	ulong reserved_0:1;				/* 12 */
	ulong mMDCrate:3;				/* 13 - 15 */
	ulong reserved_1:16;			/* 16 - 31 */
#endif	
}PACK_RESERVED;

union UNION_STACON
{
	struct STACON_PACKED	staCon_reg;
	ulong staCon_resetval;
}PACK_RESERVED; 
typedef union UNION_STACON uSTACON;


struct CAMEN_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:11;
	ulong camEnable:21;
#else
	ulong camEnable:21;
	ulong reserved_0:11;
#endif
}PACK_RESERVED;

union UNION_CAMEN
{
	struct CAMEN_PACKED	camen_reg;
	ulong camen_resetval;
}PACK_RESERVED; 
typedef union UNION_CAMEN uCAMEN;


struct EMISSCNT_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:16;
	ulong missErrCnt:16;
#else
	ulong missErrCnt:16;
	ulong reserved_0:16;
#endif	
}PACK_RESERVED;

union UNION_EMISSCNT
{
	struct EMISSCNT_PACKED	emisscnt_reg;
	ulong emisscnt_resetval;
}PACK_RESERVED; 
typedef union UNION_EMISSCNT uEMISSCNT;

typedef struct etherStatistics
{
	/* Receive statistics counters from */
	ulong rxGood;
	ulong rxBad;
	ulong rxOvMaxSize;
	ulong rxCtlRecd;
	ulong rx10Stat;
	ulong rxAlignErr;
	ulong rxCRCErr;
	ulong rxOverflowErr;
	ulong rxLongErr;
	ulong rxParErr;
	ulong rxHalted;
	
	/* Transmit statistics counters */
	ulong txGood;
	ulong txUnderErr;
	ulong txCollErr;
	ulong txExCollErr;
	ulong txDeferErr;
	ulong txExDeferErr;
	ulong txPaused;
	ulong txNCarrErr;
	ulong txSQE;
	ulong txLateCollErr;
	ulong txParErr;
	ulong txHalted;
} ETHER_STATISTICS;

#ifndef IMPORT
#define IMPORT extern
#endif	/*IMPORT*/

#ifndef STATUS
#define STATUS	int
#endif	/*STATUS*/

#ifndef OK
#define	OK	0
#endif	/*OK*/

#ifndef ERROR
#define	ERROR	(-1)
#endif	/*ERROR*/

#ifndef EOS
#define EOS		'\0'	/* C string terminator */
#endif	/*EOS*/

#ifndef NULL
#define NULL		(0)
#endif	/*NULL*/

#ifndef TRUE
#define TRUE		(1)
#endif	/*TRUE*/

#ifndef FALSE
#define FALSE		(0)
#endif	/*FALSE*/

#define HALF_DUPLEX			0
#define FULL_DUPLEX			1

/** PHY definitions **/
#define PHY_CONTROL_REG 	0
#define PHY_ADDR_A 			0
#define PHY_ADDR_B 			0x01<<5
#define _AUTO_NEGOTIATE 	0x1000
#define _10_MB_HDX 			0
#define _10_MB_FDX 			0x0100
#define _100_MB_FDX 		0x2100
#define _100_MB_HDX 		0x2000

#define ETHERMTU				1500
#define ENET_HDR_REAL_SIZ 	14
#define END_BUFSIZ      		(ETHERMTU + ENET_HDR_REAL_SIZ + 86)

#define	ETHER_REG_ADDR_A		(ASIC_BASE + 0xA0000)
#define	ETHER_REG_ADDR_B		(ASIC_BASE + 0xC0000)

#ifndef REG_OUT_LONG
#   define REG_OUT_LONG(hwbase,addr,value) \
 (*(ulong *)(hwbase+addr) = (value))
#endif

#ifndef REG_IN_LONG
#   define REG_IN_LONG(hwbase,addr,pData) \
	((pData) = *(ulong *)(hwbase+addr))
#endif

#ifndef REG_OUT_SHORT
#   define REG_OUT_SHORT(hwbase,addr,value) \
	(*(ushort *)(hwbase+addr) = (value))
#endif

#ifndef REG_IN_SHORT
#   define REG_IN_SHORT(hwbase,addr,pData) \
	((pData) = *(ushort *)(hwbase+addr))
#endif

/*
 * Macros for number representation conversion.
 */
/*#if	BIG_ENDIAN*/
#if 0
/*#define	ntohl(x)	(x)*/
/*#define	ntohs(x)	(x)*/
/*#define	htonl(x)	(x)*/
/*#define	htons(x)	(x)*/

#define NTOHL(x)	(x) = ntohl((ulong)(x))
#define NTOHS(x)	(x) = ntohs((ushort)(x))
#define HTONL(x)	(x) = htonl((ulong)(x))
#define HTONS(x)	(x) = htons((ushort)(x))

#else
#define ntohl(x)	((((x) & 0x000000ff) << 24) | \
			 (((x) & 0x0000ff00) <<  8) | \
			 (((x) & 0x00ff0000) >>  8) | \
			 (((x) & 0xff000000) >> 24))

#define htonl(x)	((((x) & 0x000000ff) << 24) | \
			 (((x) & 0x0000ff00) <<  8) | \
			 (((x) & 0x00ff0000) >>  8) | \
			 (((x) & 0xff000000) >> 24))

#define ntohs(x)	((((x) & 0x00ff) << 8) | \
			 (((x) & 0xff00) >> 8))

#define htons(x)	((((x) & 0x00ff) << 8) | \
			 (((x) & 0xff00) >> 8))
#define	NTOHL(x)	(x) = ntohl((ulong)(x))
#define	NTOHS(x)	(x) = ntohs((ushort)(x))
#define	HTONL(x)	(x) = htonl((ulong)(x))
#define	HTONS(x)	(x) = htons((ushort)(x))

#endif	/* BIG_ENDIAN */

#define bcopy(s,d,c) memmove(d,s,c)

typedef struct api_Mac_device
{
    int		unit;				/* unit number */
    int		channel;			/* Channel number */

    int		ivecRx;				/* interrupt vector Rx */
	int		ivecTx;				/* interrupt vector Tx */

    ulong	EtherAddr;	/* Base address of Ethernet Register */

    long	flags;				/* Our local flags. */
	int		buffInitialized; 	/* device buffer Initialized */
	int		status;				/* device status */

	RECEIVE_FRAME_DESC 		*gpReceiveFrameDescStart;
	TRANSMIT_FRAME_DESC 	*gpTransmitFrameDescStart;
	TRANSMIT_FRAME_DESC 	*gpSWTransmitFrameDescStart;

	int			RXDONEOFFSET;		/* Current descriptor to check from gpReceiveFrameDescStart */
	int			TXOFFSET;		/* Current descriptor to transmit from gpTransmitFrameDescStart */
	int			TXDONEOFFSET;	/* Current descriptor to check from gpTransmitFrameDescStart */

	ulong		addrList[32];	/* Array for storing addresses Max = 21, i.e. 32 long words */
	ulong		mcastAddrCount;	/* Number of valid multicast addresses */

    uchar		enetAddr[6];	/* ethernet address */
	uchar		netSpeed;		/* 10 or 100 */
	uchar		duplexMode;		/* HDX = 0. FDX = 1 */
	uchar		autoNeg;		/* 1 = autoneg enabled */
	ETHER_STATISTICS	statistics;	/* Ethernet statistics counters */
} API_DEVICE;

/* MAC Api function predefinition */

/* API Sub Fuctions */
int api_MacHWReset	(API_DEVICE *api_Mac_dev);
int api_MacBuffInit(API_DEVICE *api_Mac_dev);
int api_MacBuffFree(API_DEVICE *api_Mac_dev);
int api_MacHWInit(API_DEVICE *api_Mac_dev);
int api_MacHWStart(	API_DEVICE *api_Mac_dev);
int api_MacHWStop(	API_DEVICE *api_Mac_dev);
int api_MacIntEnable	(API_DEVICE *api_Mac_dev);
int api_MacIntDisable(API_DEVICE *api_Mac_dev);
void api_MacRcv(	API_DEVICE *api_Mac_dev);
int api_MacSend(	API_DEVICE *api_Mac_dev,ulong pData,int len);
void	api_init(bd_t *bd, API_DEVICE *api_Mac_dev);
int MAC_PHY_INIT(void);

/* MII Set Sub Function */
ulong miiRead
	(
	API_DEVICE *api_Mac_dev,
	ulong phyAddr,		/* Address of the PHY chip (usually 0 for single PHY) */
	ulong phyRegAddr, 	/* Address of PHY register to be read */
	ulong *phyData		/* Data to be Read */
	);

void miiWrite
	(
	API_DEVICE *api_Mac_dev,
	ulong phyAddr,		/* Address of the PHY chip (usually 0 for single PHY) */
	ulong phyRegAddr, 	/* Address of PHY register to be written */
	ulong phyData		/* Data to be written */
	);

STATUS MII_AutoNeg
	(
	API_DEVICE *api_Mac_dev,
	unsigned long retries,
	int *isFullDuplexP,
	int *is100MbpsP
	);

void intEnable(int vect);
void intDisable(int vect);


/*
 * Our MAC address definition.  User can change this value as
 * per requirement
 */
unsigned char EnetAddrA[6] = {0x00,0x00,0xf0,0x90,0x11,0x10};
unsigned char EnetAddrB[6] = {0x00,0x00,0xf0,0x90,0x11,0x11};

/* Macro to get the ethernet address from the BSP */
#ifndef SYS_ENET_ADDR_GET
#   define SYS_ENET_ADDR_GET(pDevice, EnetAddr) \
	{ \
		bcopy ((char *)EnetAddr, (char *)(&pDevice->enetAddr), 6); \
	}
#endif

#define ETHERMTU				1500
#define ENET_HDR_REAL_SIZ 		14
#define END_BUFSIZ      		(ETHERMTU + ENET_HDR_REAL_SIZ + 86)

#ifndef RX_FD_NUM
#define	RX_FD_NUM_PWR2			(3)		/* 8 = 2^3 */
#define	RX_FD_NUM				(1<<RX_FD_NUM_PWR2)
#endif 	/*RX_FD_NUM*/

#ifndef TX_FD_NUM
#define	TX_FD_NUM_PWR2			(3)		/* 8 = 2^3 */
#define	TX_FD_NUM				(1<<TX_FD_NUM_PWR2)
#endif 	/*TX_FD_NUM*/

typedef enum
{
    HW_RESET_DONE = 0,
    BUFF_INIT_DONE = 1,
    HW_INIT_DONE = 2,
    HW_START_STATUS = 3,
    STOP_STATUS = 4,
    OPEN_CH_STATUS = 5,
    CLOSE_CH_STATUS = 6,
    INT_ENABLE_STATUS = 7,
    INT_DISABLE_STATUS = 8,
    PATH_ENABLE_STATUS = 9,
    PATH_DISABLE_STATUS = 10,
    BUFF_FREE_DONE
} API_STATUS;

#define NOT_INIT_YET			0
#define INIT_DONE				1

#if 0
#define FALSE					0
#define TRUE					1
#endif

#define ETH_PHY_SELECT		0		/*Ethernet Phy select MII = 0, 7Wire = 1*/

/* MII interface definition */
#define MII_CONTROL 0

#define MII_CTRL_RESET ((unsigned short)( 0x8000 ))
#define MII_CTRL_LOOPBACK ((unsigned short)( 0x4000 ))
#define MII_CTRL_100MBPS ((unsigned short)( 0x2000 ))
#define MII_CTRL_AUTO_NEG ((unsigned short)( 0x1000 ))
#define MII_CTRL_POWER_DOWN ((unsigned short)( 0x0800 ))
#define MII_CTRL_ISOLATE ((unsigned short)( 0x0400 ))
#define MII_CTRL_RESTART ((unsigned short)( 0x0200 ))
#define MII_CTRL_FULL_DUPLEX ((unsigned short)( 0x0100 ))
#define MII_CTRL_COLL_TEST ((unsigned short)( 0x0080 ))
#define MII_CTRL_TEST_MODE_MASK ((unsigned short)( 0x0070 ))
#define MII_CTRL_MASTER_SLAVE_EN ((unsigned short)( 0x0008 ))
#define MII_CTRL_MASTER_SLAVE_VAL ((unsigned short)( 0x0004 ))
#define MII_CTRL_RESERVED1_0 ((unsigned short)( 0x0003 ))


#define MII_STATUS 1

#define MII_STAT_T4 ((unsigned short)( 0x8000 ))
#define MII_STAT_TX_FULL_DUPLEX ((unsigned short)( 0x4000 ))
#define MII_STAT_TX ((unsigned short)( 0x2000 ))
#define MII_STAT_10_FULL_DUPLEX ((unsigned short)( 0x1000 ))
#define MII_STAT_10 ((unsigned short)( 0x0800 ))
#define MII_STAT_T2_FULL_DUPLEX ((unsigned short)( 0x0400 ))
#define MII_STAT_T2 ((unsigned short)( 0x0200 ))
#define MII_STAT_RESERVED8 ((unsigned short)( 0x0100 ))
#define MII_STAT_MASTER_SLAVE_FAULT ((unsigned short)( 0x0080 ))
#define MII_STAT_PREAMB_SUPPRESS ((unsigned short)( 0x0040 ))
#define MII_STAT_AUTO_NEG_DONE ((unsigned short)( 0x0020 ))
#define MII_STAT_REMOTE_FAULT ((unsigned short)( 0x0010 ))
#define MII_STAT_AUTO_NEG ((unsigned short)( 0x0008 ))
#define MII_STAT_LINK_UP ((unsigned short)( 0x0004 ))
#define MII_STAT_JABBER_DETECT ((unsigned short)( 0x0002 ))
#define MII_STAT_EXTENDED_CAP ((unsigned short)( 0x0001 ))


#define MII_PHY_ID_1 2

#define MII_PHY_ID_1_MASK ((unsigned short)( 0xFFFF ))


#define MII_PHY_ID_2 3

#define MII_PHY_ID_2_MASK ((unsigned short)( 0xFC00 ))
#define MII_PHY_MODEL_MASK ((unsigned short)( 0x03F0 ))
#define MII_PHY_REV_MASK ((unsigned short)( 0x000F ))

#define MII_OUI(id1, id2) \
  ((((unsigned long)(id1)) << 6) | \
   ((((unsigned long)(id2)) & (MII_PHY_ID_2_MASK)) >> 10))


#define MII_ADVERTISEMENT 4

#define MII_ADVR_NEXT_PAGE ((unsigned short)( 0x8000 ))
#define MII_ADVR_RESERVED14 ((unsigned short)( 0x4000 ))
#define MII_ADVR_REMOTE_FAULT ((unsigned short)( 0x2000 ))
#define MII_ADVR_RESERVED12_11 ((unsigned short)( 0x1800 ))
#define MII_ADVR_PAUSE ((unsigned short)( 0x0400 ))
#define MII_ADVR_T4 ((unsigned short)( 0x0200 ))
#define MII_ADVR_TX_FULL_DUPLEX ((unsigned short)( 0x0100 ))
#define MII_ADVR_TX ((unsigned short)( 0x0080 ))
#define MII_ADVR_10_FULL_DUPLEX ((unsigned short)( 0x0040 ))
#define MII_ADVR_10 ((unsigned short)( 0x0020 ))
#define MII_ADVR_SELECTOR_MASK ((unsigned short)( 0x001F ))
#define MII_ADVR_802_3 ((unsigned short)( 0x0001 ))
#define MII_ADVR_802_3_ISLAN_16T ((unsigned short)( 0x0002 ))


#define MII_LINK_PARTNER 5

#define MII_LINK_NEXT_PAGE ((unsigned short)( 0x8000 ))
#define MII_LINK_ACK ((unsigned short)( 0x4000 ))
#define MII_LINK_REMOTE_FAULT ((unsigned short)( 0x2000 ))
#define MII_LINK_RESERVED12_11 ((unsigned short)( 0x1800 ))
#define MII_LINK_PAUSE ((unsigned short)( 0x0400 ))
#define MII_LINK_T4 ((unsigned short)( 0x0200 ))
#define MII_LINK_TX_FULL_DUPLEX ((unsigned short)( 0x0100 ))
#define MII_LINK_TX ((unsigned short)( 0x0080 ))
#define MII_LINK_10_FULL_DUPLEX ((unsigned short)( 0x0040 ))
#define MII_LINK_10 ((unsigned short)( 0x0020 ))
#define MII_LINK_SELECTOR_MASK ((unsigned short)( 0x001F ))
#define MII_LINK_802_3 ((unsigned short)( 0x0001 ))
#define MII_LINK_802_3_ISLAN_16T ((unsigned short)( 0x0002 ))


#define MII_EXPANSION 6

#define MII_EXP_RESERVED15_5 ((unsigned short)( 0xFFE0 ))
#define MII_EXP_PARALLEL_FAULT ((unsigned short)( 0x0010 ))
#define MII_EXP_LINK_NEXT_PAGE ((unsigned short)( 0x0008 ))
#define MII_EXP_NEXT_PAGE_ABLE ((unsigned short)( 0x0004 ))
#define MII_EXP_PAGE_RECEIVED ((unsigned short)( 0x0002 ))
#define MII_EXP_LINK_AUTO_NEG ((unsigned short)( 0x0001 ))


#define MII_NEXT_PAGE 7


#define MII_MAX_PHY 32
#define MII_MAX_REGS 32

#endif		/*__MAC2500h*/
