#ifndef	__MAC8947h
#define		__MAC8947h

/* Big endian or little endian big = 1, little = 0 */
#define BIG_ENDIAN			0

/*FOR VxWorks*/
/*#define PACK_RESERVED		(__attribute__((__packed__)))*/
#define PACK_RESERVED

/**********BDMA control registers **************/
#define	BDMA_CHANNELA_BASE		(0x9000)
#define	MAC_CHANNELA_BASE		(0xA000)
#define	BDMA_CHANNELB_BASE		(0xE000)
#define	MAC_CHANNELB_BASE		(0xF800)

/**********BDMA control registers **************/
#define BDMATXCON 				(0x0000)
#define BDMARXCON 				(0x0004)
#define BDMATXPTR 				(0x0008)
#define BDMARXPTR 				(0x000C)
#define BDMARXLSZ 				(0x0010)
#define BDMASTAT				(0x0014)

#define	CAM_BASE				(0x0100)

/***********MAC control registers**************/
#define MACCON					(0x0000)
#define CAMCON					(0x0004)
#define MACTXCON				(0x0008)
#define MACTXSTAT				(0x000C)
#define MACRXCON				(0x0010)
#define MACRXSTAT				(0x0014)
#define STADATA					(0x0018)
#define STACON					(0x001C)
#define CAMEN					(0x0028)
#define EMISSCNT				(0x003C)
#define EPZCNT					(0x0040)
#define ERMPZCNT				(0x0044)
#define ETXSTAT					(0x0040)


struct FD_TX_CONTROL_PACKED
{
#if BIG_ENDIAN
	ulong reserved_bit:25;
	ulong wa_bit:2;
	ulong a_bit:1;
	ulong l_bit:1;
	ulong t_bit:1;
	ulong c_bit:1;
	ulong p_bit:1;
#else
	ulong p_bit:1;
	ulong c_bit:1;
	ulong t_bit:1;
	ulong l_bit:1;
	ulong a_bit:1;
	ulong wa_bit:2;
	ulong reserved_bit:25;
#endif
}PACK_RESERVED;
typedef struct FD_TX_CONTROL_PACKED FD_TX_CONTROL;

struct FD_TX_FRAMEDATA_PACKED
{
#if BIG_ENDIAN
	ulong o_bit:1;
	ulong frameDataPtr:31;
#else
	ulong frameDataPtr:31;
	ulong o_bit:1;
#endif
}PACK_RESERVED;
typedef struct FD_TX_FRAMEDATA_PACKED FD_TX_FRAME_DATA;

struct FD_TX_STATUS_LENGTH_PACKED
{
#if BIG_ENDIAN
	ulong txHalted:1;
	ulong comp:1;
	ulong txPar:1;
	ulong lateColl:1;
	ulong sqeErr:1;
	ulong ncArr:1;
	ulong deferAl:1;
	ulong underRun:1;
	ulong intTx:1;
	ulong paused:1;
	ulong txDefer:1;
	ulong exColl:1;
	ulong txCollCnt:4;
	ulong frameLength:16;
#else
	ulong frameLength:16;
	ulong txCollCnt:4;
	ulong exColl:1;
	ulong txDefer:1;
	ulong paused:1;
	ulong intTx:1;
	ulong underRun:1;
	ulong deferAl:1;
	ulong ncArr:1;
	ulong sqeErr:1;
	ulong lateColl:1;
	ulong txPar:1;
	ulong comp:1;
	ulong txHalted:1;
#endif
}PACK_RESERVED;
typedef struct FD_TX_STATUS_LENGTH_PACKED FD_TX_STATUS_LENGTH;

struct TRANSMIT_FRAME_DESC_PACKED
{
	FD_TX_FRAME_DATA txFrameData;
	FD_TX_CONTROL txControl;
	FD_TX_STATUS_LENGTH txStatusLength;
	struct TRANSMIT_FRAME_DESC_PACKED *nextTxFrameDesc;
}PACK_RESERVED;
typedef struct TRANSMIT_FRAME_DESC_PACKED TRANSMIT_FRAME_DESC;

struct FD_RX_FRAME_DATA_PACKED
{
#if BIG_ENDIAN
	ulong o_bit:1;
	ulong frameDataPtr:31;
#else
	ulong frameDataPtr:31;
	ulong o_bit:1;
#endif
}PACK_RESERVED;
typedef struct FD_RX_FRAME_DATA_PACKED FD_RX_FRAME_DATA;

struct FD_RX_STATUS_LENGTH_PACKED
{
#if BIG_ENDIAN
	ulong rxHalted:1;
	ulong good:1;
	ulong rxPar:1;
	ulong empty2:1;
	ulong longErr:1;
	ulong overFlow:1;
	ulong crcErr:1;
	ulong alignErr:1;
	ulong rx10Stat:1;
	ulong intRx:1;
	ulong ctlRcv:1;
	ulong empty1:1;
	ulong ovMax:1;
	ulong empty0:3;
	ulong frameLength:16;
#else
	ulong frameLength:16;
	ulong empty0:3;
	ulong ovMax:1;
	ulong empty1:1;
	ulong ctlRcv:1;
	ulong intRx:1;
	ulong rx10Stat:1;
	ulong alignErr:1;
	ulong crcErr:1;
	ulong overFlow:1;
	ulong longErr:1;
	ulong empty2:1;
	ulong rxPar:1;
	ulong good:1;
	ulong rxHalted:1;
#endif
}PACK_RESERVED;
typedef struct FD_RX_STATUS_LENGTH_PACKED FD_RX_STATUS_LENGTH;


struct RECEIVE_FRAME_DESC_PACKED			/* receive frame descriptor */
{
	FD_RX_FRAME_DATA rxFrameData;
	ulong reserved;
	FD_RX_STATUS_LENGTH rxStatusLength;
	struct RECEIVE_FRAME_DESC_PACKED *nextRxFrameDesc;
}PACK_RESERVED;
typedef struct RECEIVE_FRAME_DESC_PACKED RECEIVE_FRAME_DESC;

struct BDMARXCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:14;
	ulong erlyNotifyIntr:1;
	ulong buffEmptyIntr:1;
	ulong reset:1;
	ulong enable:1;
	ulong wordAlign:2;
	ulong big_LittleEndian:1;
	ulong maxSizeOverIntrEnb:1;
	ulong notOwnerIntrEnb:1;
	ulong nullListIntrEnb:1;
	ulong recvFrameIntrEnb:1;
	ulong memAddrsInc_Dec:1;
	ulong stop_skipFrame:1;
	ulong burstSize:5;
#else
	ulong burstSize:5;
	ulong stop_skipFrame:1;
	ulong memAddrsInc_Dec:1;
	ulong recvFrameIntrEnb:1;
	ulong nullListIntrEnb:1;
	ulong notOwnerIntrEnb:1;
	ulong maxSizeOverIntrEnb:1;
	ulong big_LittleEndian:1;
	ulong wordAlign:2;
	ulong enable:1;
	ulong reset:1;
	ulong buffEmptyIntr:1;
	ulong erlyNotifyIntr:1;
	ulong reserved_0:14;
#endif
}PACK_RESERVED;

union UNION_BDMARXCON
{
	struct BDMARXCON_PACKED	rxCon_reg;
	ulong rxCon_resetval;
}PACK_RESERVED;
typedef union UNION_BDMARXCON uBDMARXCON;

struct BDMATXCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_1:16;
	ulong reset:1;
	ulong enable:1;
	ulong macTxStartLevel:3;
	ulong buffEmptyIntrEnb:1;
	ulong notOwnerIntrEnb:1;
	ulong nullListIntrEnb:1;
	ulong sendCntrlPacketIntrEnb:1;
	ulong reserved_0:1;
	ulong stop_skipFrame:1;
	ulong burstSize:5;
#else
	ulong burstSize:5;
	ulong stop_skipFrame:1;
	ulong reserved_0:1;
	ulong sendCntrlPacketIntrEnb:1;
	ulong nullListIntrEnb:1;
	ulong notOwnerIntrEnb:1;
	ulong buffEmptyIntrEnb:1;
	ulong macTxStartLevel:3;
	ulong enable:1;
	ulong reset:1;
	ulong reserved_1:16;
#endif
}PACK_RESERVED;
union UNION_BDMATXCON
	{
		struct BDMATXCON_PACKED	txCon_reg;
		ulong txCon_resetval;
	}PACK_RESERVED;
typedef union UNION_BDMATXCON uBDMATXCON;


struct BDMARXLSZ_PACKED
{
#if BIG_ENDIAN
	ulong bdmaRxFrameLength:16;
	ulong bdmaRxMaxSize:16;
#else
	ulong bdmaRxMaxSize:16;
	ulong bdmaRxFrameLength:16;
#endif
}PACK_RESERVED;

union UNION_BDMARXLSZ
{
		struct BDMARXLSZ_PACKED	rxLsz_reg;
		ulong rxLsz_resetval;
}PACK_RESERVED;
typedef union UNION_BDMARXLSZ uBDMARXLSZ;


struct BDMASTAT_PACKED
{
#if BIG_ENDIAN
	ulong bdmaTxReserved_1:11;
	ulong bdmaTxBuffEmpty:1;
	ulong bdmaTxReserved_0:1;
	ulong bdmaTxNotOwner:1;
	ulong bdmaTxNullList:1;
	ulong bdmaTxCompleteToSendCntrlPacket:1;
	ulong bdmaRxNumofFrames_Buff:8;
	ulong bdmaRxOneMoreFrame:1;
	ulong bdmaRxReserved:1;
	ulong bdmaRxEarlyNotify:1;
	ulong bdmaRxBuffEmpty:1;
	ulong bdmaRxMaxSizeOver:1;
	ulong bdmaRxNotOwner:1;
	ulong bdmaRxNullList:1;
	ulong bdmaRxDoneEveryRxFrame:1;
#else
	ulong bdmaRxDoneEveryRxFrame:1;
	ulong bdmaRxNullList:1;
	ulong bdmaRxNotOwner:1;
	ulong bdmaRxMaxSizeOver:1;
	ulong bdmaRxBuffEmpty:1;
	ulong bdmaRxEarlyNotify:1;
	ulong bdmaRxReserved:1;
	ulong bdmaRxOneMoreFrame:1;
	ulong bdmaRxNumofFrames_Buff:8;
	ulong bdmaTxCompleteToSendCntrlPacket:1;
	ulong bdmaTxNullList:1;
	ulong bdmaTxNotOwner:1;
	ulong bdmaTxReserved_0:1;
	ulong bdmaTxBuffEmpty:1;
	ulong bdmaTxReserved_1:11;
#endif
}PACK_RESERVED;

union UNION_BDMASTAT
{
		struct BDMASTAT_PACKED	stat_reg;
		ulong stat_resetval;
}PACK_RESERVED;
typedef union UNION_BDMASTAT uBDMASTAT;


struct MACCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_4:16;
	ulong linkStatus:1;
	ulong reserved_3:1;
	ulong enMissRoll:1;
	ulong mdc_off:1;
	ulong reserved_2:1;
	ulong missRoll:1;
	ulong reserved_1:2;
	ulong loop10:1;
	ulong mii_off:1;
	ulong reserved_0:1;
	ulong macLoop:1;
	ulong fullDup:1;
	ulong swReset:1;
	ulong haltImm:1;
	ulong haltRequest:1;
#else
	ulong haltRequest:1;
	ulong haltImm:1;
	ulong swReset:1;
	ulong fullDup:1;
	ulong macLoop:1;
	ulong reserved_0:1;
	ulong mii_off:1;
	ulong loop10:1;
	ulong reserved_1:2;
	ulong missRoll:1;
	ulong reserved_2:1;
	ulong mdc_off:1;
	ulong enMissRoll:1;
	ulong reserved_3:1;
	ulong linkStatus:1;
	ulong reserved_4:16;
#endif
}PACK_RESERVED;

union UNION_MACCON
{
	struct MACCON_PACKED	macCon_reg;
	ulong macCon_resetval;
}PACK_RESERVED;
typedef union UNION_MACCON uMACCON;

struct CAMCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:27;
	ulong cmpEnable:1;
	ulong negCam:1;
	ulong broadcastAccept:1;
	ulong groupAccept:1;
	ulong stationAccept:1;
#else
	ulong stationAccept:1;
	ulong groupAccept:1;
	ulong broadcastAccept:1;
	ulong negCam:1;
	ulong cmpEnable:1;
	ulong reserved_0:27;
#endif
}PACK_RESERVED;

union UNION_CAMCON
{
	struct CAMCON_PACKED	camCon_reg;
	ulong camCon_resetval;
}PACK_RESERVED;
typedef union UNION_CAMCON uCAMCON;


struct MACTXCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:17;
	ulong enableCompletion:1;
	ulong enableTxParity:1;
	ulong enableLateCollison:1;
	ulong enableExcessCollision:1;
	ulong enableNoCarrier:1;
	ulong enableDeferral:1;
	ulong enableUnderRun:1;
	ulong sqeTestModeEnable:1;
	ulong sendPause:1;
	ulong noDefer:1;
	ulong fastBackOff:1;
	ulong suppressCRC:1;
	ulong suppressPadding:1;
	ulong transmitHaltReq:1;
	ulong transmitEnable:1;
#else
	ulong transmitEnable:1;
	ulong transmitHaltReq:1;
	ulong suppressPadding:1;
	ulong suppressCRC:1;
	ulong fastBackOff:1;
	ulong noDefer:1;
	ulong sendPause:1;
	ulong sqeTestModeEnable:1;
	ulong enableUnderRun:1;
	ulong enableDeferral:1;
	ulong enableNoCarrier:1;
	ulong enableExcessCollision:1;
	ulong enableLateCollison:1;
	ulong enableTxParity:1;
	ulong enableCompletion:1;
	ulong reserved_0:17;
#endif
}PACK_RESERVED;

union UNION_MACTXCON
{
	struct MACTXCON_PACKED	macTxCon_reg;
	ulong macTxCon_resetval;
}PACK_RESERVED;
typedef union UNION_MACTXCON uMACTXCON;



struct MACTXSTAT_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:16;
	ulong transmissionHalted:1;
	ulong completion:1;
	ulong transmitParityError:1;
	ulong lateCollision:1;
	ulong sqe:1;
	ulong noCarrier:1;
	ulong deferral:1;
	ulong underRun:1;
	ulong intrOnTransmit:1;
	ulong paused:1;
	ulong transmitDeferred:1;
	ulong excessiveCollision:1;
	ulong transmitCollCount:4;
#else
	ulong transmitCollCount:4;
	ulong excessiveCollision:1;
	ulong transmitDeferred:1;
	ulong paused:1;
	ulong intrOnTransmit:1;
	ulong underRun:1;
	ulong deferral:1;
	ulong noCarrier:1;
	ulong sqe:1;
	ulong lateCollision:1;
	ulong transmitParityError:1;
	ulong completion:1;
	ulong transmissionHalted:1;
	ulong reserved_0:16;
#endif
}PACK_RESERVED;

union UNION_MACTXSTAT
{
	struct MACTXSTAT_PACKED	macTxStat_reg;
	ulong macTxStat_resetval;
}PACK_RESERVED;
typedef union UNION_MACTXSTAT uMACTXSTAT;


struct MACRXCON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_2:17;
	ulong enableGood:1;
	ulong enableReceiveParity:1;
	ulong reserved_1:1;
	ulong enableLongError:1;
	ulong enableOverFlow:1;
	ulong enableCRCError:1;
	ulong enableAlignment:1;
	ulong reserved_0:1;
	ulong ignoreCRCValue:1;
	ulong passCtrlPacket:1;
	ulong stripCRCVal:1;
	ulong shortEnable:1;
	ulong longEnable:1;
	ulong receiveHaltReq:1;
	ulong receiveEnable:1;
#else
	ulong receiveEnable:1;
	ulong receiveHaltReq:1;
	ulong longEnable:1;
	ulong shortEnable:1;
	ulong stripCRCVal:1;
	ulong passCtrlPacket:1;
	ulong ignoreCRCValue:1;
	ulong reserved_0:1;
	ulong enableAlignment:1;
	ulong enableCRCError:1;
	ulong enableOverFlow:1;
	ulong enableLongError:1;
	ulong reserved_1:1;
	ulong enableReceiveParity:1;
	ulong enableGood:1;
	ulong reserved_2:17;
#endif
}PACK_RESERVED;

union UNION_MACRXCON
{
	struct MACRXCON_PACKED	macRxCon_reg;
	ulong macRxCon_resetval;
}PACK_RESERVED;
typedef union UNION_MACRXCON uMACRXCON;


struct MACRXSTAT_PACKED
{
#if BIG_ENDIAN
	ulong reserved_2:16;
	ulong receptionHalted:1;
	ulong goodReceived:1;
	ulong receiveParityError:1;
	ulong reserved_1:1;
	ulong longError:1;
	ulong overflowError:1;
	ulong crcError:1;
	ulong alignmentError:1;
	ulong receive10MbStatus:1;
	ulong intrOnReceive:1;
	ulong ctrlFrameReceived:1;
	ulong reserved_0:5;
#else
	ulong reserved_0:5;
	ulong ctrlFrameReceived:1;
	ulong intrOnReceive:1;
	ulong receive10MbStatus:1;
	ulong alignmentError:1;
	ulong crcError:1;
	ulong overflowError:1;
	ulong longError:1;
	ulong reserved_1:1;
	ulong receiveParityError:1;
	ulong goodReceived:1;
	ulong receptionHalted:1;
	ulong reserved_2:16;
#endif
}PACK_RESERVED;

union UNION_MACRXSTAT
{
	struct MACRXSTAT_PACKED	macRxCon_reg;
	ulong macRxCon_resetval;
}PACK_RESERVED;

typedef union UNION_MACRXSTAT uMACRXSTAT;


struct STACON_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:16;
	ulong mdc_Clockrating:3;
	ulong preambleSuppress:1;
	ulong busy:1;
	ulong write:1;
	ulong phyAddr:5;
	ulong phyRegisterAddr:5;
#else
	ulong phyRegisterAddr:5;
	ulong phyAddr:5;
	ulong write:1;
	ulong busy:1;
	ulong preambleSuppress:1;
	ulong mdc_Clockrating:3;
	ulong reserved_0:16;
#endif
}PACK_RESERVED;

union UNION_STACON
{
	struct STACON_PACKED	staCon_reg;
	ulong staCon_resetval;
}PACK_RESERVED;
typedef union UNION_STACON uSTACON;


struct CAMEN_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:11;
	ulong camEnable:21;
#else
	ulong camEnable:21;
	ulong reserved_0:11;
#endif
}PACK_RESERVED;

union UNION_CAMEN
{
	struct CAMEN_PACKED	camen_reg;
	ulong camen_resetval;
}PACK_RESERVED;
typedef union UNION_CAMEN uCAMEN;


struct EMISSCNT_PACKED
{
#if BIG_ENDIAN
	ulong reserved_0:16;
	ulong alignmentErrorCount:16;
#else
	ulong alignmentErrorCount:16;
	ulong reserved_0:16;
#endif
}PACK_RESERVED;

union UNION_EMISSCNT
{
	struct EMISSCNT_PACKED	emisscnt_reg;
	ulong emisscnt_resetval;
}PACK_RESERVED;
typedef union UNION_EMISSCNT uEMISSCNT;

typedef struct etherStatistics
{
	/* Receive statistics counters from */
	ulong rxGood;
	ulong rxBad;
	ulong rxOvMaxSize;
	ulong rxCtlRecd;
	ulong rx10Stat;
	ulong rxAlignErr;
	ulong rxCRCErr;
	ulong rxOverflowErr;
	ulong rxLongErr;
	ulong rxParErr;
	ulong rxHalted;
	/* Transmit statistics counters */
	ulong txGood;
	ulong txUnderErr;
	ulong txExCollErr;
	ulong txDeferredErr;
	ulong txPaused;
	ulong txDeferErr;
	ulong txNCarrErr;
	ulong txSQE;
	ulong txLateCollErr;
	ulong txParErr;
	ulong txHalted;
} ETHER_STATISTICS;


#ifndef IMPORT
#define IMPORT extern
#endif	/*IMPORT*/

#ifndef STATUS
#define STATUS	int
#endif	/*STATUS*/

#ifndef OK
#define	OK	0
#endif	/*OK*/

#ifndef ERROR
#define	ERROR	(-1)
#endif	/*ERROR*/

#ifndef EOS
#define EOS		'\0'	/* C string terminator */
#endif	/*EOS*/

#ifndef NULL
#define NULL		(0)
#endif	/*NULL*/

#ifndef TRUE
#define TRUE		(1)
#endif	/*TRUE*/

#ifndef FALSE
#define FALSE		(0)
#endif	/*FALSE*/

#ifndef NON_CACHE_REGION
#define NON_CACHE_REGION	0x4000000
#endif	/*NON_CACHE_REGION*/

#ifdef SD16BIT		//?? by maveric 2002.10.2
#ifndef RX_FD_NUM
#define	RX_FD_NUM				(16)
#endif 	/*RX_FD_NUM*/

#ifndef TX_FD_NUM
#define	TX_FD_NUM				(16)
#endif 	/*TX_FD_NUM*/
#else
#ifndef RX_FD_NUM
#define	RX_FD_NUM				(32)
#endif 	/*RX_FD_NUM*/

#ifndef TX_FD_NUM
#define	TX_FD_NUM				(32)
#endif 	/*TX_FD_NUM*/
#endif

/** PHY definitions **/
#define PHY_CONTROL_REG 	0
#define PHY_ADDR_A 			0
#define PHY_ADDR_B 			0x01<<5
#define _AUTO_NEGOTIATE 	0x1000
#define _10_MB_HDX 			0
#define _10_MB_FDX 			0x0100
#define _100_MB_FDX 		0x2100
#define _100_MB_HDX 		0x2000

#define ETHERMTU				1500
#define ENET_HDR_REAL_SIZ 	14
#define END_BUFSIZ      		(ETHERMTU + ENET_HDR_REAL_SIZ + 86)

#define BDMA_REG_ADDR_A		(ASIC_BASE+0x9000)
#define MAC_REG_ADDR_A		(ASIC_BASE+0xA000)

#define BDMA_REG_ADDR_B		(ASIC_BASE+0xE000)
#define MAC_REG_ADDR_B		(ASIC_BASE+0xF800)

#ifndef REG_OUT_LONG
#   define REG_OUT_LONG(hwbase,addr,value) \
 (*(ulong *)(hwbase+addr) = (value))
#endif

#ifndef REG_IN_LONG
#   define REG_IN_LONG(hwbase,addr,pData) \
	((pData) = *(ulong *)(hwbase+addr))
#endif

#ifndef REG_OUT_SHORT
#   define REG_OUT_SHORT(hwbase,addr,value) \
	(*(ushort *)(hwbase+addr) = (value))
#endif

#ifndef REG_IN_SHORT
#   define REG_IN_SHORT(hwbase,addr,pData) \
	((pData) = *(ushort *)(hwbase+addr))
#endif

/*
 * Macros for number representation conversion.
 */
/*#if	BIG_ENDIAN*/
#if 0
/*#define	ntohl(x)	(x)*/
/*#define	ntohs(x)	(x)*/
/*#define	htonl(x)	(x)*/
/*#define	htons(x)	(x)*/

#define NTOHL(x)	(x) = ntohl((ulong)(x))
#define NTOHS(x)	(x) = ntohs((ushort)(x))
#define HTONL(x)	(x) = htonl((ulong)(x))
#define HTONS(x)	(x) = htons((ushort)(x))

#else
#define ntohl(x)	((((x) & 0x000000ff) << 24) | \
			 (((x) & 0x0000ff00) <<  8) | \
			 (((x) & 0x00ff0000) >>  8) | \
			 (((x) & 0xff000000) >> 24))

#define htonl(x)	((((x) & 0x000000ff) << 24) | \
			 (((x) & 0x0000ff00) <<  8) | \
			 (((x) & 0x00ff0000) >>  8) | \
			 (((x) & 0xff000000) >> 24))

#define ntohs(x)	((((x) & 0x00ff) << 8) | \
			 (((x) & 0xff00) >> 8))

#define htons(x)	((((x) & 0x00ff) << 8) | \
			 (((x) & 0xff00) >> 8))
#define	NTOHL(x)	(x) = ntohl((ulong)(x))
#define	NTOHS(x)	(x) = ntohs((ushort)(x))
#define	HTONL(x)	(x) = htonl((ulong)(x))
#define	HTONS(x)	(x) = htons((ushort)(x))

#endif	/* BIG_ENDIAN */

#define bcopy(s,d,c) memmove(d,s,c)

typedef struct api_Mac_device
{
    int		unit;				/* unit number */
    int		channel;			/* Channel number */

    int		ivecRx;				/* interrupt vector Rx */
	int		ivecTx;				/* interrupt vector Tx */

    ulong	BdmaAddr;			/* Base addr of BDMA */
    ulong	MacAddr;			/* Base addr of MAC */

    long	flags;				/* Our local flags. */
	int		buffInitialized; 	/* device buffer Initialized */
	int		status;				/* device status */

	RECEIVE_FRAME_DESC 		*gpReceiveFrameDescStart;
	TRANSMIT_FRAME_DESC 	*gpTransmitFrameDescStart;

	ulong		addrList[32];	/* Array for storing addresses Max = 21, i.e. 32 long words */
	ulong		mcastAddrCount;	/* Number of valid multicast addresses */

    uchar		enetAddr[6];	/* ethernet address */
	uchar		netSpeed;		/* 10 or 100 */
	uchar		duplexMode;		/* HDX = 0. FDX = 1 */
	uchar		autoNeg;		/* 1 = autoneg enabled */
	ETHER_STATISTICS	statistics;	/* Ethernet statistics counters */
} API_DEVICE;

/* MAC Api function predefinition */

/* API Sub Fuctions */
int api_MacHWReset	(API_DEVICE *api_Mac_dev);
int api_MacBuffInit(API_DEVICE *api_Mac_dev);
int api_MacBuffFree(API_DEVICE *api_Mac_dev);
int api_MacHWInit(API_DEVICE *api_Mac_dev);
int api_MacHWStart(	API_DEVICE *api_Mac_dev);
int api_MacHWStop(	API_DEVICE *api_Mac_dev);
int api_MacIntEnable	(API_DEVICE *api_Mac_dev);
int api_MacIntDisable(API_DEVICE *api_Mac_dev);
void api_MacRcv(	API_DEVICE *api_Mac_dev);
int api_MacSend(	API_DEVICE *api_Mac_dev,ulong pData,int len);
void	api_init(bd_t *bd, API_DEVICE *api_Mac_dev);
int MAC_PHY_INIT(void);

/* MII Set Sub Function */
ulong miiRead
	(
	API_DEVICE *api_Mac_dev,
	ulong phyAddr,		/* Address of the PHY chip (usually 0 for single PHY) */
	ulong phyRegAddr, 	/* Address of PHY register to be read */
	ulong *phyData		/* Data to be Read */
	);

void miiWrite
	(
	API_DEVICE *api_Mac_dev,
	ulong phyAddr,		/* Address of the PHY chip (usually 0 for single PHY) */
	ulong phyRegAddr, 	/* Address of PHY register to be written */
	ulong phyData		/* Data to be written */
	);

STATUS MII_AutoNeg
	(
	API_DEVICE *api_Mac_dev,
	unsigned long retries,
	int *isFullDuplexP,
	int *is100MbpsP
	);

void intEnable(int vect);
void intDisable(int vect);


/*
 * Our MAC address definition.  User can change this value as
 * per requirement
 */
unsigned char EnetAddrA[6] = {0x00,0x00,0xf0,0x90,0x11,0x10};
unsigned char EnetAddrB[6] = {0x00,0x00,0xf0,0x90,0x11,0x11};

/* Macro to get the ethernet address from the BSP */
#ifndef SYS_ENET_ADDR_GET
#   define SYS_ENET_ADDR_GET(pDevice, EnetAddr) \
	{ \
		bcopy ((char *)EnetAddr, (char *)(&pDevice->enetAddr), 6); \
	}
#endif

#define ETHERMTU				1500
#define ENET_HDR_REAL_SIZ 	14
#define END_BUFSIZ      		(ETHERMTU + ENET_HDR_REAL_SIZ + 86)
#if 0		//?? by maveric
#ifndef RX_FD_NUM
#define	RX_FD_NUM				(8)
#endif 	/*RX_FD_NUM*/

#ifndef TX_FD_NUM
#define	TX_FD_NUM				(8)
#endif 	/*TX_FD_NUM*/
#endif
typedef enum
{
    HW_RESET_DONE = 0,
    BUFF_INIT_DONE = 1,
    HW_INIT_DONE = 2,
    HW_START_STATUS = 3,
    STOP_STATUS = 4,
    OPEN_CH_STATUS = 5,
    CLOSE_CH_STATUS = 6,
    INT_ENABLE_STATUS = 7,
    INT_DISABLE_STATUS = 8,
    PATH_ENABLE_STATUS = 9,
    PATH_DISABLE_STATUS = 10,
    BUFF_FREE_DONE
} API_STATUS;

#define NOT_INIT_YET			0
#define INIT_DONE				1

#if 0
#define FALSE					0
#define TRUE					1
#endif

#define ETH_PHY_SELECT		0		/*Ethernet Phy select MII = 0, 7Wire = 1*/

/* MII interface definition */
#define MII_CONTROL 0

#define MII_CTRL_RESET ((unsigned short)( 0x8000 ))
#define MII_CTRL_LOOPBACK ((unsigned short)( 0x4000 ))
#define MII_CTRL_100MBPS ((unsigned short)( 0x2000 ))
#define MII_CTRL_AUTO_NEG ((unsigned short)( 0x1000 ))
#define MII_CTRL_POWER_DOWN ((unsigned short)( 0x0800 ))
#define MII_CTRL_ISOLATE ((unsigned short)( 0x0400 ))
#define MII_CTRL_RESTART ((unsigned short)( 0x0200 ))
#define MII_CTRL_FULL_DUPLEX ((unsigned short)( 0x0100 ))
#define MII_CTRL_COLL_TEST ((unsigned short)( 0x0080 ))
#define MII_CTRL_TEST_MODE_MASK ((unsigned short)( 0x0070 ))
#define MII_CTRL_MASTER_SLAVE_EN ((unsigned short)( 0x0008 ))
#define MII_CTRL_MASTER_SLAVE_VAL ((unsigned short)( 0x0004 ))
#define MII_CTRL_RESERVED1_0 ((unsigned short)( 0x0003 ))


#define MII_STATUS 1

#define MII_STAT_T4 ((unsigned short)( 0x8000 ))
#define MII_STAT_TX_FULL_DUPLEX ((unsigned short)( 0x4000 ))
#define MII_STAT_TX ((unsigned short)( 0x2000 ))
#define MII_STAT_10_FULL_DUPLEX ((unsigned short)( 0x1000 ))
#define MII_STAT_10 ((unsigned short)( 0x0800 ))
#define MII_STAT_T2_FULL_DUPLEX ((unsigned short)( 0x0400 ))
#define MII_STAT_T2 ((unsigned short)( 0x0200 ))
#define MII_STAT_RESERVED8 ((unsigned short)( 0x0100 ))
#define MII_STAT_MASTER_SLAVE_FAULT ((unsigned short)( 0x0080 ))
#define MII_STAT_PREAMB_SUPPRESS ((unsigned short)( 0x0040 ))
#define MII_STAT_AUTO_NEG_DONE ((unsigned short)( 0x0020 ))
#define MII_STAT_REMOTE_FAULT ((unsigned short)( 0x0010 ))
#define MII_STAT_AUTO_NEG ((unsigned short)( 0x0008 ))
#define MII_STAT_LINK_UP ((unsigned short)( 0x0004 ))
#define MII_STAT_JABBER_DETECT ((unsigned short)( 0x0002 ))
#define MII_STAT_EXTENDED_CAP ((unsigned short)( 0x0001 ))


#define MII_PHY_ID_1 2

#define MII_PHY_ID_1_MASK ((unsigned short)( 0xFFFF ))


#define MII_PHY_ID_2 3

#define MII_PHY_ID_2_MASK ((unsigned short)( 0xFC00 ))
#define MII_PHY_MODEL_MASK ((unsigned short)( 0x03F0 ))
#define MII_PHY_REV_MASK ((unsigned short)( 0x000F ))

#define MII_OUI(id1, id2) \
  ((((unsigned long)(id1)) << 6) | \
   ((((unsigned long)(id2)) & (MII_PHY_ID_2_MASK)) >> 10))


#define MII_ADVERTISEMENT 4

#define MII_ADVR_NEXT_PAGE ((unsigned short)( 0x8000 ))
#define MII_ADVR_RESERVED14 ((unsigned short)( 0x4000 ))
#define MII_ADVR_REMOTE_FAULT ((unsigned short)( 0x2000 ))
#define MII_ADVR_RESERVED12_11 ((unsigned short)( 0x1800 ))
#define MII_ADVR_PAUSE ((unsigned short)( 0x0400 ))
#define MII_ADVR_T4 ((unsigned short)( 0x0200 ))
#define MII_ADVR_TX_FULL_DUPLEX ((unsigned short)( 0x0100 ))
#define MII_ADVR_TX ((unsigned short)( 0x0080 ))
#define MII_ADVR_10_FULL_DUPLEX ((unsigned short)( 0x0040 ))
#define MII_ADVR_10 ((unsigned short)( 0x0020 ))
#define MII_ADVR_SELECTOR_MASK ((unsigned short)( 0x001F ))
#define MII_ADVR_802_3 ((unsigned short)( 0x0001 ))
#define MII_ADVR_802_3_ISLAN_16T ((unsigned short)( 0x0002 ))


#define MII_LINK_PARTNER 5

#define MII_LINK_NEXT_PAGE ((unsigned short)( 0x8000 ))
#define MII_LINK_ACK ((unsigned short)( 0x4000 ))
#define MII_LINK_REMOTE_FAULT ((unsigned short)( 0x2000 ))
#define MII_LINK_RESERVED12_11 ((unsigned short)( 0x1800 ))
#define MII_LINK_PAUSE ((unsigned short)( 0x0400 ))
#define MII_LINK_T4 ((unsigned short)( 0x0200 ))
#define MII_LINK_TX_FULL_DUPLEX ((unsigned short)( 0x0100 ))
#define MII_LINK_TX ((unsigned short)( 0x0080 ))
#define MII_LINK_10_FULL_DUPLEX ((unsigned short)( 0x0040 ))
#define MII_LINK_10 ((unsigned short)( 0x0020 ))
#define MII_LINK_SELECTOR_MASK ((unsigned short)( 0x001F ))
#define MII_LINK_802_3 ((unsigned short)( 0x0001 ))
#define MII_LINK_802_3_ISLAN_16T ((unsigned short)( 0x0002 ))


#define MII_EXPANSION 6

#define MII_EXP_RESERVED15_5 ((unsigned short)( 0xFFE0 ))
#define MII_EXP_PARALLEL_FAULT ((unsigned short)( 0x0010 ))
#define MII_EXP_LINK_NEXT_PAGE ((unsigned short)( 0x0008 ))
#define MII_EXP_NEXT_PAGE_ABLE ((unsigned short)( 0x0004 ))
#define MII_EXP_PAGE_RECEIVED ((unsigned short)( 0x0002 ))
#define MII_EXP_LINK_AUTO_NEG ((unsigned short)( 0x0001 ))


#define MII_NEXT_PAGE 7


#define MII_MAX_PHY 32
#define MII_MAX_REGS 32

#endif		/*__MAC8947h*/
