/* 
 * inflate.c: expand data 
 * (c) 2002 Arcturus Networks 
 * Jongil Park <laminaz@samung.co.kr>
*/

#include "armboot.h"
#include "zlib.h"
#include "cramfs/cramfs.h"
#include "malloc.h"

#define ZALLOC_ALIGNMENT 16

void* cramfs_calloc (voidpf opaque, unsigned items, unsigned size)
{
    void *p;

    size *= items;
    size = (size + ZALLOC_ALIGNMENT - 1) & ~(ZALLOC_ALIGNMENT - 1);

    p = malloc (size);

    return (p);
}

int cramfs_free(voidpf opaque, void * ptr)
{
	free(ptr);
	return 0;
}

int cramfs_inflate (void *ptr, struct cramfs_inode *inode,
		    void *destination, int offset, int size)
{
    static unsigned char block [CRAMFS_BLOCKSIZE];
    unsigned char *p, *P, *q, *Q, *r, *R;
    int i, j, n;
	int rc=0;
    z_stream zstream;
   
    unsigned int fs_offset = CRAMFS_GET_OFFSET(inode);
    unsigned int bk_offset;
    
//	_Log(DEBUG, "inflate...\n");
    if (size <= 0)
        return 0;

    // *** CLEAR AND INITIALIZE ZSTREAM STRUCTURE ***/
    zstream.zalloc    = (alloc_func) cramfs_calloc;
    zstream.zfree     = (free_func) cramfs_free;
    zstream.opaque    = (voidpf) Z_NULL;
    zstream.next_in   = (Bytef *) Z_NULL;
    zstream.avail_in  = (uInt) 0;
    zstream.total_in  = (uLong) 0;
    zstream.next_out  = (Bytef *) Z_NULL;
    zstream.avail_out = (uInt) 0;
    zstream.total_out = (uLong) 0;
	zstream.outcb	  = Z_NULL;

//	rc = inflateInit2(&zstream, -MAX_WBITS);
	rc = inflateInit(&zstream);
    if (rc != Z_OK)
	{
		printf ("Error: inflateInit() returned %d\n", rc);
        return -1;
	}

    // *** DECOMPRESSED EACH BLOCK ONE AT A TIME ***
    q = (Bytef *) destination;
    Q = (q + size);
    n = 1 + (CRAMFS_24(inode->size) - 1) / CRAMFS_BLOCKSIZE;
    i = offset >> CRAMFS_BLOCKSHIFT;
    j = offset & CRAMFS_BLOCKMASK;

    bk_offset = *((unsigned long *) ((unsigned char *) ptr + 4 * (fs_offset + (i - 1))));
    p = (i == 0) ? ((unsigned char *) ptr + 4 * (fs_offset + n)) : ((unsigned char *) ptr + CRAMFS_32(bk_offset));
    for (; i < n && q != Q; i++)
    {
		bk_offset = *((unsigned long *) ((unsigned char *) ptr + 4 * (fs_offset + i)));
        P = ((unsigned char *) ptr + CRAMFS_32(bk_offset));
        inflateReset (&zstream);
        zstream.next_in = (Bytef *) p;
        zstream.avail_in = (uLong) (P - p);
        zstream.total_in = (uLong) 0;
        zstream.next_out = (Bytef *) block;
        zstream.avail_out = (uLong) CRAMFS_BLOCKSIZE;
        zstream.total_out = (uLong) 0;
		rc = inflate(&zstream, Z_FINISH);
        if (rc != Z_STREAM_END)
        { 
			printf ("Fail: inflate() returned [%d]\n", rc);
			inflateEnd (&zstream); 
			return -1; 
		}
        if ((int) zstream.total_out < j)
        { 
			inflateEnd (&zstream); 
			return -1; 
		}
        for (r = (block + j), R = (unsigned char *) zstream.next_out; q != Q && r != R; q++, r++)
		{
            *q = *r;
		}
        p = P; j = 0;

	/*
	 * 20060205 added by gaoyj
	 */
	if (i % 15 == 0)
	{
		printf(".");
	}
    }

    printf("\n");

    inflateEnd (&zstream);
    return (int) (q - (unsigned char *) destination);
}
