/* inode.c: maipulate cramfs inodes 
   (c) 2002 Arcturus Networks */

#include "armboot.h"
#include "cramfs/cramfs.h"

struct cramfs_super *
cramfs_get_super(void * ptr)
{
  struct cramfs_super * p = ptr;

  if (p->magic != CRAMFS_32(CRAMFS_MAGIC)) {
    return (void *)0;
  }

  return p;
}

struct cramfs_inode *
cramfs_get_root(void * ptr)
{
	if(cramfs_get_super(ptr)!=0) return &(cramfs_get_super(ptr)->root);
	return(0);
//  return &(cramfs_get_super(ptr)->root);
} 

struct cramfs_inode *
cramfs_readdir_next(void * ptr, struct cramfs_inode * dir, struct cramfs_inode * current)
{
  struct cramfs_inode * p;
  unsigned int mode = CRAMFS_16(dir->mode);
  unsigned int size = CRAMFS_24(dir->size);
  unsigned int offset = CRAMFS_GET_OFFSET(dir);
  void *e;

  p = current;
  if (!p) {
    if (!ISDIR(mode)) return (void *)0;
    return size ? (ptr + offset*4) : (void *)0;
  }

  e = ptr + offset*4 + size;
  p = (void *)p + sizeof(struct cramfs_inode) + 4*CRAMFS_GET_NAMELEN(p);

  if ((void *)p >= e) return (void *)0;
  return p;
}

char *
cramfs_get_name(void * ptr, struct cramfs_inode * inode)
{
  static char name[64];
  unsigned int namelen = CRAMFS_GET_NAMELEN(inode);

  memcpy(name,(void *)inode + sizeof(struct cramfs_inode),4*namelen);
  name[4*namelen] = 0;

  return name;
}

int
cramfs_get_size(void * ptr, struct cramfs_inode * inode)
{
  return CRAMFS_24(inode->size);
}

static char *
path_element(char * name)
{
  char *p;
  if (!name || *name == '/') return name;

  for (p=name; *p && *p != '/'; p++);
  return p;
}

struct cramfs_inode *
cramfs_lookup(void * ptr, struct cramfs_inode * cwd, char * name)
{
  char *p;
  char *e;
  int len;
  unsigned int mode;
  struct cramfs_inode * inode;

  e = name + strlen(name);

  /* if the path starts with / then path_element returns name, set cwd=root */
  if (name == path_element(name)) {
    cwd = cramfs_get_root(ptr);
    name++;
  }

  inode = cwd;
  while (cwd && name < e) {
    mode = CRAMFS_16(cwd->mode);
    if (!ISDIR(mode)) return (void *)0;

    if (name == (p = path_element(name))) {
      /* strip out the path separators */
      name++;
      continue;
    }

    len = p - name;
    inode = cramfs_readdir_next(ptr, cwd, (void *)0);
    while(inode) {
      if (strlen(cramfs_get_name(ptr, inode)) == len) {
        if (!strncmp(cramfs_get_name(ptr, inode), name, len)) {
          break;
        }
      }
      inode = cramfs_readdir_next(ptr, cwd, inode);
   }
   cwd = inode;
   name = path_element(name);
 }
 return inode;
}

