/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * EEPROM support
 */
#ifndef	_CMD_I2C_H
#define	_CMD_I2C_H

#include <armboot.h>
#include <command.h>

#define CFG_USE_I2C
#undef CFG_USE_I2C

#ifdef CFG_USE_I2C

	#define	CMD_TBL_I2C	MK_CMD_TBL_ENTRY(					\
		"i2c",	3,	5,	1,	do_mem_i2c,			\
		"i2c   - write or read i2c\n",					\
		"NULL\n"				\
	),

	int do_mem_i2c   (cmd_tbl_t *cmdtp, bd_t *bd, int flag, int argc, char *argv[]);

#else



#endif	/* CFG_USE_I2C */

#endif	/* _CMD_I2C_H */
