/*
 * (C) Copyright 2000
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * Configuation settings for the implementa impA7 board.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __CONFIG_H
#define __CONFIG_H
#include "config1.h"
/*
 * If we are developing, we might want to start armboot from ram
 * so we MUST NOT initialize critical regs like mem-timing ...
 */
#define CONFIG_INIT_CRITICAL            /* undef for developing */

/*
 * High Level Configuration Options
 * (easy to change)
 */
/*#define CONFIG_ARM7		1	*//* This is a ARM7 CPU	*/
/*#define CONFIG_IMPA7		1	*//* on an impA7 Board      */
/*#define CONFIG_ARM_THUMB	1	*//* this is an ARM720TDMI */
/*#define CONFIG_ARM7_REVD	1 	*//* enable ARM720 REV.D Workarounds */
#define CONFIG_ARM940T		1	/* this is an ARM940TDMI */

#undef CONFIG_USE_IRQ			/* don't need them anymore */

/*
 * Size of malloc() pool
 */
#define CONFIG_MALLOC_SIZE	(CFG_ENV_SIZE + (128*1024))

/*
 * Hardware drivers
 */
#define CONFIG_S3C2510   1

/*
 * select serial console configuration
 */
#define CONFIG_SERIAL1		1	/* we use Serial line 1 */

/* allow to overwrite serial and ethaddr */
#define CONFIG_ENV_OVERWRITE

#define CONFIG_BAUDRATE		115200
#define CONFIG_BOOTP_MASK	(CONFIG_BOOTP_DEFAULT|CONFIG_BOOTP_BOOTFILESIZE)
#define CONFIG_COMMANDS		(CONFIG_CMD_DFL | CFG_CMD_JFFS2)

/* this must be included AFTER the definition of CONFIG_COMMANDS (if any) */
#include <cmd_confdefs.h>

#define CONFIG_BOOTDELAY	1

#if 0
#define CONFIG_BOOTARGS    	"devfs=mount root=ramfs console=ttyS0,115200"
#else
#undef CONFIG_BOOTARGS
#endif

#define CONFIG_ETHADDR		00:09:30:28:12:22

#define CONFIG_IPADDR		10.6.199.199
#define CONFIG_SERVERIP		10.6.2.50
#define CONFIG_NETMASK   	255.255.0.0
#define CONFIG_BOOTFILE		"image.cramfs.img"
#define CONFIG_BOOTCOMMAND	"fsload; go 40000"

#define	CFG_LOAD_ADDR		0x100000	/* default load address	*/

/*
 * NOTE: tftp load addr should be equal to CFG_LOAD_ADDR
 * 20060309 added by gaoyj
 */
#if 0
#define	CONFIG_UPDATE_DA	"protect off all; tftp 100000 armboot-x.bin.img; flwrite"
#define	CONFIG_UPDATE_DC	"tftp A00000 config-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DK	"tftp A00000 kernel-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DU	"tftp A00000 user-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DV	"tftp A00000 vendor-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_UP	"run dc; run dk; run du; run dv"
#define	CONFIG_TEST_KERNEL	"tftp 40000 linux.bin; go 40000"
#endif

#define	CONFIG_UPDATE_DA	"protect off all; tftp 100000 armboot-x.bin.img; flwrite 80000000"
#define	CONFIG_UPDATE_DC	"tftp A00000 custom-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DR	"tftp A00000 romfs-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DW	"tftp A00000 web-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_DL	"tftp A00000 logo-x.cramfs.img; flwrite"
#define	CONFIG_UPDATE_UP	"tftp A00000 update.img; flwrite"
#define	CONFIG_TEST_KERNEL	"tftp 40000 linux.bin; go 40000"
/*********************************************************
 *
 * added by chencb 060914
 *
 * packet update.bin include config,kernel,user,vendor
 * and so on
 *
 ********************************************************/

#define	CONFIG_CLEAN_REGION	"erase 1:9-134"
#define	CONFIG_DH_KEYBOARD	"1"
#define	CONFIG_APPAUTO		"1"
#define	CONFIG_RESERVED_MEM	"1"
#define CONFIG_RESTORE_ENV  	"0"    // added by chencb 060905
#define CONFIG_PRODUCT_ID       "000000000000000000"     // added by chencb 060908
/* end */
/* choish 20020828 */
#define CONFIG_ICACHE		"on"
#define CONFIG_DCACHE		"on"
#define CONFIG_WBUFFER		"on"
#define CONFIG_HWADDR0		00:09:30:28:12:22 // choish 20020829 for kernel
#define CONFIG_HWADDR1		00:09:30:28:12:24 // choish 20020829 for kernel
/* choish end */
/*
#if (CONFIG_COMMANDS & CFG_CMD_KGDB) */
/*#define CONFIG_KGDB_BAUDRATE	230400		*//* speed to run kgdb serial port */
/*#define CONFIG_KGDB_SER_INDEX	2		*//* which serial port to use */
/*#endif*/

/*
 * Miscellaneous configurable options
 */
#define	CFG_LONGHELP					/* undef to save memory		*/
#define	CFG_PROMPT		"s3c2510 # "
#define	CFG_CBSIZE		256			/* Console I/O Buffer Size	*/
#define	CFG_PBSIZE 		(CFG_CBSIZE+sizeof(CFG_PROMPT)+16) /* Print Buffer Size */
#define	CFG_MAXARGS		16			/* max number of command args	*/
#define CFG_BARGSIZE		CFG_CBSIZE		/* Boot Argument Buffer Size	*/

#define CFG_MEMTEST_START	0x00040000	/* memtest works on	*/
#define CFG_MEMTEST_END		0x01ffffff	/* 4 ... 32 MB in DRAM	*/

#undef  CFG_CLKS_IN_HZ			/* everything, incl board info, in Hz */
//#define	CFG_HZ		0x7a11f		/* incrementer freq: 500 kHz */
#define	CFG_HZ			133000000	/* incrementer freq: 133 MHz */

						/* valid baudrates */
#define CFG_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200 }

#ifndef __ASSEMBLY__
/*-----------------------------------------------------------------------
 * Board specific extension for bd_info
 *
 * This structure is embedded in the global bd_info (bd_t) structure
 * and can be used by the board specific code (eg board/...)
 */

struct bd_info_ext
{
    /* helper variable for board environment handling
     *
     * env_crc_valid == 0    =>   uninitialised
     * env_crc_valid  > 0    =>   environment crc in flash is valid
     * env_crc_valid  < 0    =>   environment crc in flash is invalid
     */
     int	env_crc_valid;
};
#endif

/*-----------------------------------------------------------------------
 * Stack sizes
 *
 * The stack sizes are set up in start.S using the settings below
 */
#define CONFIG_STACKSIZE	(128*1024)/4	/* regular stack */
#ifdef	CONFIG_USE_IRQ
#define CONFIG_STACKSIZE_IRQ	(4*1024)	/* IRQ stack */
#define CONFIG_STACKSIZE_FIQ	(4*1024)	/* FIQ stack */
#endif

/*-----------------------------------------------------------------------
 * Physical Memory Map
 */
#define CONFIG_NR_DRAM_BANKS		1	/* we have 1 banks of DRAM */
#define PHYS_SDRAM_1			0x00000000 	/* SDRAM Bank #1 */
#define PHYS_SDRAM_1_SIZE		0x02000000 	/* 32 MB */
#define PHYS_SDRAM_64M_SIZE		0x04000000 	/* 64 MB */

//#define PHYS_SDRAM_1_SIZE		0x01000000 	/* 16 MB */
#define PHYS_FLASH_1			0x80000000 	/* Flash Bank #1 */
#if defined(AM29LV320D) || defined(AT49BV321) || defined(HY29LV320B)
#define PHYS_FLASH_SIZE         0x00400000	/* 4 MB */
#elif defined(MBM29DL640E)
#define PHYS_FLASH_SIZE		0x00800000	/* 8MB	*/
#elif defined(S29GL064M)
#define PHYS_FLASH_SIZE		0x00800000	/* 8MB	*/
#else
#define PHYS_FLASH_SIZE         0x00200000	/* 2 MB */
#endif

#define CFG_FLASH_BASE		PHYS_FLASH_1

/*-----------------------------------------------------------------------
 * FLASH and environment organization
 */
#define CFG_MAX_FLASH_BANKS	1	/* max number of memory banks		*/
#if defined(AM29LV320D) || defined(AT49BV321)
#define CFG_MAX_FLASH_SECT  71  /* max number of sectors on one chip    */
#elif defined(HY29LV320B)
#define CFG_MAX_FLASH_SECT  67  /* max number of sectors on one chip    */
#elif defined(AM29LV160D)
#define CFG_MAX_FLASH_SECT  35  /* max number of sectors on one chip    */
#elif defined(SST39VF160)
#define CFG_MAX_FLASH_SECT  63  /* max number of sectors on one chip    */
#elif defined(MBM29DL640E)
#define CFG_MAX_FLASH_SECT  142	/* max number of sectors on one chip    */
#elif defined(S29GL064M)
#define CFG_MAX_FLASH_SECT  135	/* max number of sectors on one chip    */
#else
#define CFG_MAX_FLASH_SECT  39  /* max number of sectors on one chip    */
#endif

/* timeout values are in ticks */
#define CFG_FLASH_ERASE_TOUT	(2*CFG_HZ) /* Timeout for Flash Erase */
#define CFG_FLASH_WRITE_TOUT	(2*CFG_HZ) /* Timeout for Flash Write */

#if defined (AM29LV160D) || defined (HY29LV320B)
#define CFG_ENV_ADDR        (PHYS_FLASH_1 + 0x4000)  /* Addr of Environment Sector   */
#define CFG_ENV_SIZE        0x2000      /* Total Size of Environment Sector */
#elif defined(SST39VF160)
#define CFG_ENV_ADDR        (PHYS_FLASH_1 + 0x800)/* Addr of Env Sector   */
#define CFG_ENV_SIZE        0x800	/* Total Size of Environment Sector */
#else
#define CFG_ENV_ADDR        (PHYS_FLASH_1 + 0x2000)  /* Addr of Environment Sector   */
#define CFG_ENV_SIZE        0x2000	/* Total Size of Environment Sector */
#endif

/* Flash banks JFFS2 should use */
#define CFG_JFFS2_FIRST_BANK    0
#define CFG_JFFS2_FIRST_SECTOR	8
#define CFG_JFFS2_NUM_BANKS     2

#endif	/* __CONFIG_H */
